/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.document;

import java.util.Date;
import org.modeshape.schematic.annotation.Immutable;

@Immutable
public final class Timestamp {
    private final Date time;
    private final int inc;

    public Timestamp() {
        this.time = null;
        this.inc = 0;
    }

    public Timestamp(Date date) {
        this((int)(date.getTime() / 1000L), 0);
    }

    public Timestamp(int timeInSeconds, int inc) {
        this.time = new Date((long)timeInSeconds * 1000L);
        this.inc = inc;
    }

    public int getTime() {
        return this.time == null ? 0 : (int)(this.time.getTime() / 1000L);
    }

    public int getInc() {
        return this.inc;
    }

    public Date getAsDate() {
        return new Date(this.time.getTime());
    }

    public int hashCode() {
        return this.getTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Timestamp) {
            Timestamp that = (Timestamp)obj;
            return this.getInc() == that.getInc() && this.getTime() == that.getTime();
        }
        return false;
    }

    public String toString() {
        return "TS(" + this.time + ':' + this.inc + ')';
    }
}

