/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import org.apache.lucene.document.Field;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.search.lucene.IndexRules;

public class IndexingRulesTest {
    private IndexRules.Builder builder;
    private IndexRules rules;

    @Before
    public void beforeEach() {
        this.builder = IndexRules.createBuilder();
        this.rules = this.builder.build();
    }

    @Test
    public void shouldBuildValidRulesFromBuilderThatIsNotInvoked() {
        this.builder = IndexRules.createBuilder();
        this.rules = this.builder.build();
    }

    @Test
    public void shouldBuildValidRulesFromBuilderAfterJustSettingDefaultRules() {
        this.builder.defaultTo(Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
        this.rules = this.builder.build();
        Assert.assertThat((Object)this.rules.getRule(null).getIndexOption(), (Matcher)Is.is((Object)Field.Index.ANALYZED_NO_NORMS));
        Assert.assertThat((Object)this.rules.getRule(null).getStoreOption(), (Matcher)Is.is((Object)Field.Store.NO));
    }
}

