/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.search.SearchEngineException;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneI18n;

public class LuceneConfigurations {
    public static final LuceneConfiguration inMemory() {
        return new RamDirectoryFactory();
    }

    public static final LuceneConfiguration using(File parent) {
        CheckArg.isNotNull((Object)parent, (String)"parent");
        return new FileSystemDirectoryFromNameFactory(parent);
    }

    public static final LuceneConfiguration using(File parent, LockFactory lockFactory) {
        CheckArg.isNotNull((Object)parent, (String)"parent");
        return new FileSystemDirectoryFromNameFactory(parent, lockFactory);
    }

    public static final LuceneConfiguration using(File parent, TextEncoder workspaceNameEncoder, TextEncoder indexNameEncoder) {
        CheckArg.isNotNull((Object)parent, (String)"parent");
        return new FileSystemDirectoryFromNameFactory(parent, workspaceNameEncoder, indexNameEncoder);
    }

    public static final LuceneConfiguration using(File parent, LockFactory lockFactory, TextEncoder workspaceNameEncoder, TextEncoder indexNameEncoder) {
        CheckArg.isNotNull((Object)parent, (String)"parent");
        return new FileSystemDirectoryFromNameFactory(parent, lockFactory, workspaceNameEncoder, indexNameEncoder);
    }

    @Immutable
    protected static final class IndexId {
        private final String workspaceName;
        private final String indexName;
        private final int hc;

        protected IndexId(String workspaceName, String indexName) {
            assert (workspaceName != null);
            this.workspaceName = workspaceName;
            this.indexName = indexName;
            this.hc = HashCode.compute((Object[])new Object[]{this.workspaceName, this.indexName});
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IndexId) {
                IndexId that = (IndexId)obj;
                if (this.hashCode() != that.hashCode()) {
                    return false;
                }
                if (!this.workspaceName.equals(that.workspaceName)) {
                    return false;
                }
                return this.indexName.equals(that.indexName);
            }
            return false;
        }

        public String toString() {
            return this.indexName != null ? this.workspaceName + "/" + this.indexName : this.workspaceName;
        }
    }

    public static class FileSystemDirectoryFromNameFactory
    extends PoolingDirectoryFactory<FSDirectory> {
        private final File parentFile;
        private final LockFactory lockFactory;
        private final TextEncoder workspaceNameEncoder;
        private final TextEncoder indexNameEncoder;

        protected FileSystemDirectoryFromNameFactory(File parent) {
            this(parent, null, null, null);
        }

        protected FileSystemDirectoryFromNameFactory(File parent, LockFactory lockFactory) {
            this(parent, lockFactory, null, null);
        }

        protected FileSystemDirectoryFromNameFactory(File parent, TextEncoder workspaceNameEncoder, TextEncoder indexNameEncoder) {
            this(parent, null, workspaceNameEncoder, indexNameEncoder);
        }

        protected FileSystemDirectoryFromNameFactory(File parent, LockFactory lockFactory, TextEncoder workspaceNameEncoder, TextEncoder indexNameEncoder) {
            CheckArg.isNotNull((Object)parent, (String)"parent");
            this.parentFile = parent;
            this.lockFactory = lockFactory;
            this.workspaceNameEncoder = workspaceNameEncoder != null ? workspaceNameEncoder : new NoOpEncoder();
            this.indexNameEncoder = indexNameEncoder != null ? indexNameEncoder : new NoOpEncoder();
        }

        @Override
        protected FSDirectory createDirectory(String workspaceName, String indexName) {
            File workspaceFile = new File(this.parentFile, this.workspaceNameEncoder.encode(workspaceName));
            if (!workspaceFile.exists()) {
                workspaceFile.mkdirs();
            } else {
                if (!workspaceFile.isDirectory()) {
                    I18n msg = LuceneI18n.locationForIndexesIsNotDirectory;
                    throw new SearchEngineException(msg.text(new Object[]{workspaceFile.getAbsolutePath(), workspaceName}));
                }
                if (!workspaceFile.canRead()) {
                    I18n msg = LuceneI18n.locationForIndexesCannotBeRead;
                    throw new SearchEngineException(msg.text(new Object[]{workspaceFile.getAbsolutePath(), workspaceName}));
                }
                if (!workspaceFile.canWrite()) {
                    I18n msg = LuceneI18n.locationForIndexesCannotBeWritten;
                    throw new SearchEngineException(msg.text(new Object[]{workspaceFile.getAbsolutePath(), workspaceName}));
                }
            }
            File directory = workspaceFile;
            if (indexName != null) {
                File indexFile = new File(workspaceFile, this.indexNameEncoder.encode(indexName));
                if (!indexFile.exists()) {
                    indexFile.mkdirs();
                } else {
                    if (!indexFile.isDirectory()) {
                        I18n msg = LuceneI18n.locationForIndexesIsNotDirectory;
                        throw new SearchEngineException(msg.text(new Object[]{indexFile.getAbsolutePath(), workspaceName}));
                    }
                    if (!indexFile.canRead()) {
                        I18n msg = LuceneI18n.locationForIndexesCannotBeRead;
                        throw new SearchEngineException(msg.text(new Object[]{indexFile.getAbsolutePath(), workspaceName}));
                    }
                    if (!indexFile.canWrite()) {
                        I18n msg = LuceneI18n.locationForIndexesCannotBeWritten;
                        throw new SearchEngineException(msg.text(new Object[]{indexFile.getAbsolutePath(), workspaceName}));
                    }
                }
                directory = indexFile;
            }
            try {
                return this.create(directory, this.lockFactory);
            }
            catch (IOException e) {
                throw new SearchEngineException((Throwable)e);
            }
        }

        @Override
        protected boolean doDestroy(FSDirectory directory) throws SearchEngineException {
            File file = directory.getFile();
            if (file.exists()) {
                return FileUtil.delete((File)file);
            }
            return false;
        }

        protected FSDirectory create(File directory, LockFactory lockFactory) throws IOException {
            return FSDirectory.open((File)directory, (LockFactory)lockFactory);
        }
    }

    @ThreadSafe
    public static class RamDirectoryFactory
    extends PoolingDirectoryFactory<RAMDirectory> {
        protected RamDirectoryFactory() {
        }

        @Override
        protected RAMDirectory createDirectory(String workspaceName, String indexName) {
            return new RAMDirectory();
        }

        @Override
        protected boolean doDestroy(RAMDirectory directory) throws SearchEngineException {
            return directory != null;
        }
    }

    @ThreadSafe
    protected static abstract class PoolingDirectoryFactory<DirectoryType extends Directory>
    implements LuceneConfiguration {
        private final ConcurrentHashMap<IndexId, DirectoryType> directories = new ConcurrentHashMap();

        protected PoolingDirectoryFactory() {
        }

        @Override
        public Directory getDirectory(String workspaceName, String indexName) throws SearchEngineException {
            DirectoryType newDirectory;
            CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
            IndexId id = new IndexId(workspaceName, indexName);
            Object result = (Directory)this.directories.get(id);
            if (result == null && (result = (Directory)this.directories.putIfAbsent(id, newDirectory = this.createDirectory(workspaceName, indexName))) == null) {
                result = newDirectory;
            }
            return result;
        }

        @Override
        public boolean destroyDirectory(String workspaceName, String indexName) throws SearchEngineException {
            CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
            IndexId id = new IndexId(workspaceName, indexName);
            Directory result = (Directory)this.directories.remove(id);
            return result != null ? this.doDestroy(result) : false;
        }

        protected abstract DirectoryType createDirectory(String var1, String var2) throws SearchEngineException;

        protected abstract boolean doDestroy(DirectoryType var1) throws SearchEngineException;
    }
}

