/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.util.UUID;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.search.AbstractSearchEngine;
import org.modeshape.graph.search.SearchEngineWorkspace;
import org.modeshape.search.lucene.AbstractLuceneSearchEngine;

public class AbstractLuceneSearchEngineTest {
    private ExecutionContext context;
    private AbstractLuceneSearchEngine.AbstractLuceneProcessor<TestWorkspace, TestSession> processor;
    private AbstractSearchEngine.Workspaces<TestWorkspace> workspaces;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.workspaces = (AbstractSearchEngine.Workspaces)Mockito.mock(AbstractSearchEngine.Workspaces.class);
        this.processor = new TestProcessor("source", this.context, this.workspaces, false);
    }

    protected Property property(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.name(name), values);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    @Test
    public void shouldSerializeSingleValuedProperty() {
        Property p1 = this.property("p1", "v1");
        String serialized = this.processor.serializeProperty(p1);
        Assert.assertThat((Object)serialized, Is.is("p1=v1"));
    }

    @Test
    public void shouldSerializeTwoValuedProperty() {
        Property p1 = this.property("p1", "v1", "v2");
        String serialized = this.processor.serializeProperty(p1);
        Assert.assertThat((Object)serialized, Is.is("p1=v1\nv2"));
    }

    @Test
    public void shouldSerializeMultiValuedProperty() {
        Property p1 = this.property("p1", "v1", "v2", "v3");
        String serialized = this.processor.serializeProperty(p1);
        Assert.assertThat((Object)serialized, Is.is("p1=v1\nv2\nv3"));
    }

    @Test
    public void shouldDeserializeSingleValuedProperty() {
        Property p1 = this.property("p1", "v1");
        Property p1a = this.processor.deserializeProperty(this.processor.serializeProperty(p1));
        Assert.assertThat((Object)p1a, Is.is(p1));
    }

    @Test
    public void shouldDeserializeTwoValuedProperty() {
        Property p1 = this.property("p1", "v1", 4L);
        Property p1a = this.processor.deserializeProperty(this.processor.serializeProperty(p1));
        Assert.assertThat((Object)p1a, Is.is(p1));
    }

    @Test
    public void shouldDeserializeMultiValuedProperty() {
        Property p1 = this.property("p1", "v1", 4L, this.name("mode:something").getString(this.context.getNamespaceRegistry()), UUID.randomUUID());
        Property p1a = this.processor.deserializeProperty(this.processor.serializeProperty(p1));
        Assert.assertThat((Object)p1a, Is.is(p1));
    }

    @Test
    public void shouldSerializeAndDeserializePropertyWithNameValues() {
        Property p1 = this.property("p1", this.name("v1"), this.name("mode:something"));
        Property p2 = this.processor.deserializeProperty(this.processor.serializeProperty(p1));
        Assert.assertThat((Object)p2.getName(), Is.is(p1.getName()));
        Object[] values1 = p1.getValuesAsArray();
        Object[] values2 = p2.getValuesAsArray();
        Assert.assertThat((Object)values1.length, Is.is(values2.length));
        NameFactory names = this.context.getValueFactories().getNameFactory();
        for (int i = 0; i != values1.length; ++i) {
            Assert.assertThat((Object)names.create(values1[i]), Is.is(names.create(values2[i])));
        }
    }

    protected static class TestWorkspace
    implements SearchEngineWorkspace {
        private final String name;
        private boolean destroyed = false;

        protected TestWorkspace(String name) {
            this.name = name;
        }

        public void destroy(ExecutionContext context) {
            this.destroyed = true;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        public String getWorkspaceName() {
            return this.name;
        }
    }

    protected static abstract class TestSession
    implements AbstractLuceneSearchEngine.WorkspaceSession {
        protected TestSession() {
        }
    }

    protected static class TestProcessor
    extends AbstractLuceneSearchEngine.AbstractLuceneProcessor<TestWorkspace, TestSession> {
        protected TestProcessor(String sourceName, ExecutionContext context, AbstractSearchEngine.Workspaces<TestWorkspace> workspaces, boolean readOnly) {
            super(sourceName, context, workspaces, null, null, readOnly);
        }

        protected TestSession createSessionFor(TestWorkspace workspace) {
            return null;
        }

        protected String fullTextFieldName(String propertyName) {
            return null;
        }

        public void process(VerifyWorkspaceRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(GetWorkspacesRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(CreateWorkspaceRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(CloneBranchRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(CloneWorkspaceRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(DestroyWorkspaceRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(CopyBranchRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(CreateNodeRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(DeleteBranchRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(MoveBranchRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(ReadAllChildrenRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(ReadAllPropertiesRequest request) {
            super.processUnknownRequest((Request)request);
        }

        public void process(UpdatePropertiesRequest request) {
            super.processUnknownRequest((Request)request);
        }
    }
}

