/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.math.Duration;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Selector;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.process.QueryResults;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineIndexer;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;
import org.modeshape.search.lucene.LuceneSearchEngine;
import org.xml.sax.SAXException;

public class LuceneSearchEngineObservationTest {
    private String sourceName;
    private String workspaceName1;
    private String workspaceName2;
    private ExecutionContext context;
    private TypeSystem typeSystem;
    private InMemoryRepositorySource source;
    private InMemoryRepositorySource unsearchedSource;
    private RepositoryConnectionFactory connectionFactory;
    private Graph content;
    private Graph unsearchedContent;
    private LuceneSearchEngine searchEngine;
    private Schemata schemata;
    private SqlQueryParser sql;
    private Map<String, Object> variables;
    private Stopwatch sw;
    private int depthToRead;
    private boolean print = false;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.typeSystem = this.context.getValueFactories().getTypeSystem();
        this.workspaceName1 = "cars";
        this.workspaceName2 = "aircraft";
        this.depthToRead = 10;
        this.sw = new Stopwatch();
        this.sourceName = "source";
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.sourceName);
        this.content = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.unsearchedSource = new InMemoryRepositorySource();
        this.unsearchedSource.setName(this.sourceName);
        this.unsearchedContent = Graph.create((RepositorySource)this.unsearchedSource, (ExecutionContext)this.context);
        this.content.createWorkspace().named(this.workspaceName1);
        this.content.createWorkspace().named(this.workspaceName2);
        this.unsearchedContent.createWorkspace().named(this.workspaceName1);
        this.unsearchedContent.createWorkspace().named(this.workspaceName2);
        this.connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String name) throws RepositorySourceException {
                Assert.assertThat((Object)LuceneSearchEngineObservationTest.this.sourceName, Is.is(name));
                return LuceneSearchEngineObservationTest.this.source.getConnection();
            }
        };
        IndexRules.Builder rulesBuilder = IndexRules.createBuilder((IndexRules)LuceneSearchEngine.DEFAULT_RULES);
        rulesBuilder.defaultTo(Field.Store.YES, Field.Index.NOT_ANALYZED, false, true);
        rulesBuilder.stringField(this.name("model"), Field.Store.YES, Field.Index.ANALYZED, false, true);
        rulesBuilder.integerField(this.name("year"), Field.Store.YES, Field.Index.NOT_ANALYZED, Integer.valueOf(1990), Integer.valueOf(2020));
        rulesBuilder.floatField(this.name("userRating"), Field.Store.YES, Field.Index.NOT_ANALYZED, Float.valueOf(0.0f), Float.valueOf(10.0f));
        rulesBuilder.integerField(this.name("mpgCity"), Field.Store.YES, Field.Index.NOT_ANALYZED, Integer.valueOf(0), Integer.valueOf(50));
        rulesBuilder.integerField(this.name("mpgHighway"), Field.Store.YES, Field.Index.NOT_ANALYZED, Integer.valueOf(0), Integer.valueOf(50));
        IndexRules rules = rulesBuilder.build();
        LuceneConfiguration luceneConfig = LuceneConfigurations.inMemory();
        Analyzer analyzer = null;
        this.searchEngine = new LuceneSearchEngine(this.sourceName, this.connectionFactory, false, this.depthToRead, luceneConfig, rules, analyzer);
        RepositoryContext repositoryContext = new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return null;
            }

            public ExecutionContext getExecutionContext() {
                return LuceneSearchEngineObservationTest.this.context;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return LuceneSearchEngineObservationTest.this.connectionFactory;
            }

            public Observer getObserver() {
                return new Observer(){

                    public void notify(Changes changes) {
                        LuceneSearchEngineObservationTest.this.searchEngine.index(LuceneSearchEngineObservationTest.this.context, (Iterable)changes.getChangeRequests());
                    }
                };
            }
        };
        this.source.initialize(repositoryContext);
        this.schemata = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem).addTable("__ALLNODES__", new String[]{"maker", "model", "year", "msrp", "mpgHighway", "mpgCity"}).makeSearchable("__ALLNODES__", "maker").build();
        this.sql = new SqlQueryParser();
        this.variables = new HashMap<String, Object>();
    }

    @After
    public void afterEach() {
        this.searchEngine = null;
        this.content = null;
        this.context = null;
        this.source = null;
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected void loadContent(Graph graph) {
        try {
            graph.useWorkspace(this.workspaceName1);
            graph.importXmlFrom(this.getClass().getClassLoader().getResourceAsStream("cars.xml")).into("/");
            graph.useWorkspace(this.workspaceName2);
            graph.importXmlFrom(this.getClass().getClassLoader().getResourceAsStream("aircraft.xml")).into("/");
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (SAXException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void assertRowCount(org.modeshape.graph.query.QueryResults results, int rowCount) {
        Assert.assertThat((Object)results.getProblems().isEmpty(), Is.is(true));
        if (this.print) {
            System.out.println(results);
        }
        Assert.assertThat((Object)results.getTuples().size(), Is.is(rowCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.modeshape.graph.query.QueryResults search(String workspaceName, String searchExpression, int maxResults, int offset) {
        SearchEngineProcessor processor = this.searchEngine.createProcessor(this.context, null, true);
        try {
            FullTextSearchRequest request = new FullTextSearchRequest(searchExpression, workspaceName, maxResults, offset);
            processor.process(request);
            if (request.hasError()) {
                Assert.fail((String)request.getError().getMessage());
                org.modeshape.graph.query.QueryResults queryResults = null;
                return queryResults;
            }
            Assert.assertThat((Object)request.getResultColumns().getColumnCount(), Is.is(0));
            Assert.assertThat((Object)request.getResultColumns().getLocationCount(), Is.is(1));
            Assert.assertThat((Object)request.getResultColumns().hasFullTextSearchScores(), Is.is(true));
            List tuples = request.getTuples();
            ArrayList<Location> results = new ArrayList<Location>(tuples.size());
            for (Object[] tuple : tuples) {
                results.add((Location)tuple[0]);
                Float score = (Float)tuple[1];
                Assert.assertThat((Object)score, Is.is(IsNull.notNullValue()));
            }
            QueryResults queryResults = new QueryResults(request.getResultColumns(), request.getStatistics(), request.getTuples());
            return queryResults;
        }
        finally {
            processor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.modeshape.graph.query.QueryResults query(String workspaceName, String sql) {
        QueryCommand command = this.sql.parseQuery(sql, this.typeSystem);
        Assert.assertThat((Object)command, Is.is(IsInstanceOf.instanceOf(Query.class)));
        Query query = (Query)command;
        Source source = query.source();
        Assert.assertThat((Object)source, Is.is(IsInstanceOf.instanceOf(Selector.class)));
        SelectorName tableName = ((Selector)source).name();
        Constraint constraint = query.constraint();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i != query.columns().size(); ++i) {
            types.add(PropertyType.STRING.getName());
        }
        QueryResultColumns resultColumns = new QueryResultColumns(query.columns(), types, QueryResultColumns.includeFullTextScores((Constraint)constraint));
        List<Constraint> andedConstraints = this.getAndedConstraint(constraint, new ArrayList<Constraint>());
        Limit limit = query.limits();
        SearchEngineProcessor processor = this.searchEngine.createProcessor(this.context, null, true);
        try {
            AccessQueryRequest request = new AccessQueryRequest(workspaceName, tableName, (QueryResults.Columns)resultColumns, andedConstraints, limit, this.schemata, this.variables);
            processor.process(request);
            if (request.hasError()) {
                request.getError().printStackTrace(System.out);
                Assert.fail((String)request.getError().getMessage());
            }
            QueryResults queryResults = new QueryResults(request.resultColumns(), request.getStatistics(), request.getTuples());
            return queryResults;
        }
        finally {
            processor.close();
        }
    }

    protected List<Constraint> getAndedConstraint(Constraint constraint, List<Constraint> andedConstraints) {
        if (constraint != null) {
            if (constraint instanceof And) {
                And and = (And)constraint;
                this.getAndedConstraint(and.left(), andedConstraints);
                this.getAndedConstraint(and.right(), andedConstraints);
            } else {
                andedConstraints.add(constraint);
            }
        }
        return andedConstraints;
    }

    @Test
    public void shouldInitializeWithoutAddingContentToSource() {
    }

    @Test
    public void shouldEstimateTimeToIndexContent() {
        InMemoryRepositorySource prime = new InMemoryRepositorySource();
        prime.setName(this.sourceName);
        Graph primeGraph = Graph.create((RepositorySource)prime, (ExecutionContext)this.context);
        primeGraph.createWorkspace().named(this.workspaceName1);
        primeGraph.createWorkspace().named(this.workspaceName2);
        this.sw.reset();
        this.sw.start();
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, (SearchEngine)this.searchEngine, this.connectionFactory, this.depthToRead);
        indexer.indexAllWorkspaces();
        indexer.close();
        this.sw.stop();
        Duration zeroth = this.sw.getTotalDuration();
        System.out.println("Time to prime search engine:                 " + zeroth);
        this.sw.reset();
        this.sw.start();
        this.loadContent(this.unsearchedContent);
        this.sw.stop();
        Duration first = this.sw.getTotalDuration();
        this.sw.reset();
        this.sw.start();
        this.loadContent(this.content);
        this.sw.stop();
        Duration second = this.sw.getTotalDuration();
        this.sw.reset();
        this.sw.start();
        indexer = new SearchEngineIndexer(this.context, (SearchEngine)this.searchEngine, this.connectionFactory, 10);
        indexer.indexAllWorkspaces();
        indexer.close();
        this.sw.stop();
        Duration third = this.sw.getTotalDuration();
        int percentOfLoading = (int)(second.floatValue() / first.floatValue() * 100.0f);
        System.out.println("Time to load content without indexing:       " + first);
        System.out.println("Time to load content and updating indexes:   " + second + "  (" + percentOfLoading + "% of loading w/o indexing)");
        Duration loadingDiff = second.subtract(first);
        System.out.println("Time to update indexes during loading:       " + loadingDiff);
        int percentChange = (int)((third.floatValue() - loadingDiff.floatValue()) / loadingDiff.floatValue() * 100.0f);
        if (percentChange >= 0) {
            System.out.println("Time to re-index all content:                " + third + "  (" + percentChange + "% more than indexing time during loading)");
        } else {
            System.out.println("Time to re-index all content:                " + third + "  (" + percentChange + "% less than indexing time during loading)");
        }
        org.modeshape.graph.query.QueryResults results = this.search(this.workspaceName1, "Toyota Prius", 10, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 2);
        Location location1 = (Location)((Object[])results.getTuples().get(0))[0];
        Location location2 = (Location)((Object[])results.getTuples().get(1))[0];
        Assert.assertThat((Object)location1.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Prius")));
        Assert.assertThat((Object)location2.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
    }

    @Test
    public void shouldUpdateIndexesWhenPropertiesAreSetOnRootInSource() {
        ((Graph.Conjunction)((Graph.SetValuesTo)this.content.set("year").on("/")).to("2009")).and();
    }

    @Test
    public void shouldUpdateIndexesWhenMultipleNodesAreAdded() {
        ((Graph.Batch)((Graph.Batch)this.content.batch().create("/TheEnzo").with("year", new Object[]{2009}).and("model", new Object[]{"Enzo"}).and()).create("/TheEsto").with("year", new Object[]{2009}).and("model", new Object[]{"Esto"}).and()).execute();
    }

    @Test
    public void shouldUpdateIndexesWhenDeletingNodesInSource() {
        this.loadContent(this.content);
        org.modeshape.graph.query.QueryResults results = this.search(this.workspaceName1, "Toyota Prius", 10, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 2);
        Location location1 = (Location)((Object[])results.getTuples().get(0))[0];
        Location location2 = (Location)((Object[])results.getTuples().get(1))[0];
        Assert.assertThat((Object)location1.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Prius")));
        Assert.assertThat((Object)location2.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[%]/Hy%/Toyota%' OR PATH() LIKE '/Cars[1]/Utility[1]/%'";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 6);
        this.content.useWorkspace(this.workspaceName1);
        this.content.delete("/Cars/Hybrid/Toyota Prius");
        results = this.search(this.workspaceName1, "Toyota Prius", 10, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 1);
        location1 = (Location)((Object[])results.getTuples().get(0))[0];
        Assert.assertThat((Object)location1.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
        query = "SELECT model, maker FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[%]/Hy%/Toyota%' OR PATH() LIKE '/Cars[1]/Utility[1]/%'";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 5);
    }

    @Test
    public void shouldUpdateIndexesWhenUpdatingPropertiesInSource() {
        this.loadContent(this.content);
        org.modeshape.graph.query.QueryResults results = this.search(this.workspaceName1, "Toyota Prius", 10, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 2);
        Location location1 = (Location)((Object[])results.getTuples().get(0))[0];
        Location location2 = (Location)((Object[])results.getTuples().get(1))[0];
        Assert.assertThat((Object)location1.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Prius")));
        Assert.assertThat((Object)location2.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
        String query = "SELECT model, maker, year FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[1]/Utility[1]/Ford F-150[1]' AND year = 2008";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 1);
        this.content.useWorkspace(this.workspaceName1);
        ((Graph.Conjunction)((Graph.SetValuesTo)this.content.set("year").on("/Cars/Utility/Ford F-150")).to(2011)).and();
        query = "SELECT model, maker, year FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[1]/Utility[1]/Ford F-150[1]' AND year = 2011";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 1);
        query = "SELECT model, maker, year FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[1]/Utility[1]/Ford F-150[1]' AND year = 2008";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 0);
        query = "SELECT model, maker, year FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[1]/Utility[1]/Ford F-150[1]' AND year >= 2010";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 1);
        query = "SELECT model, maker, year FROM __ALLNODES__ WHERE year <= 1899";
        results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 0);
    }
}

