/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.search.AbstractSearchEngine;
import org.modeshape.search.lucene.LuceneSearchProcessor;
import org.modeshape.search.lucene.LuceneSearchSession;
import org.modeshape.search.lucene.LuceneSearchWorkspace;

public class LuceneSearchSessionTest {
    private ExecutionContext context;
    private LuceneSearchProcessor processor;
    private LuceneSearchSession search;
    private Observer observer;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        DateTime now = this.context.getValueFactories().getDateFactory().create();
        AbstractSearchEngine.Workspaces workspaces = (AbstractSearchEngine.Workspaces)Mockito.mock(AbstractSearchEngine.Workspaces.class);
        LuceneSearchWorkspace workspace = (LuceneSearchWorkspace)Mockito.mock(LuceneSearchWorkspace.class);
        this.processor = new LuceneSearchProcessor("source", this.context, workspaces, this.observer, now, true);
        this.search = new LuceneSearchSession(workspace, this.processor);
    }

    @Test
    public void shouldCreateCorrectLikeExpressionsForAbolutePathsWithAnyWildcard() {
        this.assertPathLike("/", "/");
        this.assertPathLike("/a", "/a[1]");
        this.assertPathLike("/a", "/a[1]");
        this.assertPathLike("/a/b", "/a[1]/b[1]");
        this.assertPathLike("/a[2]", "/a[2]");
        this.assertPathLike("/a[2]/b", "/a[2]/b[1]");
        this.assertPathLike("/a[2]/%/b", "/a[2]/%/b[1]");
        this.assertPathLike("/a[2]/%/b%", "/a[2]/%/b%[1]");
        this.assertPathLike("/a[2]/%/b%[%]", "/a[2]/%/b%[%]");
        this.assertPathLike("/a[2]/%/b%[%]%", "/a[2]/%/b%[%]%");
        this.assertPathLike("/a[2]/%/b%[3]%", "/a[2]/%/b%[3]%");
        this.assertPathLike("/a[2]/%%%/b%[3]%%%", "/a[2]/%/b%[3]%");
        this.assertPathLike("/a[2]/%%%/b%[%%%]%%%", "/a[2]/%/b%[%]%");
    }

    @Test
    public void shouldCreateCorrectLikeExpressionsForAbolutePathsWithSingleCharacterWildcard() {
        this.assertPathLike("/", "/");
        this.assertPathLike("/a", "/a[1]");
        this.assertPathLike("/a", "/a[1]");
        this.assertPathLike("/a_", "/a_[1]");
        this.assertPathLike("/a/b", "/a[1]/b[1]");
        this.assertPathLike("/a[2]", "/a[2]");
        this.assertPathLike("/a[2]/b", "/a[2]/b[1]");
        this.assertPathLike("/a[2]/_/b", "/a[2]/_/b[1]");
        this.assertPathLike("/a[2]/_/b%", "/a[2]/_/b%[1]");
        this.assertPathLike("/a[2]/_/b%[%]", "/a[2]/_/b%[%]");
        this.assertPathLike("/a[2]/_/b%[%]%", "/a[2]/_/b%[%]%");
        this.assertPathLike("/a[2]/_/b%[3]%", "/a[2]/_/b%[3]%");
        this.assertPathLike("/a[2]/_/b_", "/a[2]/_/b_[1]");
        this.assertPathLike("/a[2]/_/b_[%]", "/a[2]/_/b_[%]");
        this.assertPathLike("/a[2]/_/b_[%]%", "/a[2]/_/b_[%]%");
        this.assertPathLike("/a[2]/_/b_[3]%", "/a[2]/_/b_[3]%");
        this.assertPathLike("/a[2]/_/b_[_]", "/a[2]/_/b_[_]");
        this.assertPathLike("/a[2]/_/b_[_]%", "/a[2]/_/b_[_]%");
        this.assertPathLike("/a[2]/_/b_[_]_", "/a[2]/_/b_[_]_");
        this.assertPathLike("/a[2]/__/b_[_]", "/a[2]/__[1]/b_[_]");
        this.assertPathLike("/a[2]/___/b_[_]", "/a[2]/___[1]/b_[_]");
        this.assertPathLike("/a[2]/___/b__[__]", "/a[2]/___[1]/b__[__]");
        this.assertPathLike("/a[2]/___/__b__[__]", "/a[2]/___[1]/__b__[__]");
        this.assertPathLike("/a[2]/___/__b__[]", "/a[2]/___[1]/__b__[]");
        this.assertPathLike("/a[2]/__/b_", "/a[2]/__[1]/b_[1]");
    }

    @Test
    public void shouldCreateCorrectLikeExpressionsForRelativePathsWithAnyWildcard() {
        this.assertPathLike("%", "%");
        this.assertPathLike("%/a", "%/a[1]");
        this.assertPathLike("%%/a", "%/a[1]");
        this.assertPathLike("%%%/a", "%/a[1]");
        this.assertPathLike("%/a/b", "%/a[1]/b[1]");
        this.assertPathLike("%/a[2]", "%/a[2]");
        this.assertPathLike("%/a[2]/b", "%/a[2]/b[1]");
        this.assertPathLike("%/a[2]/%/b", "%/a[2]/%/b[1]");
        this.assertPathLike("%/a[2]/%/b%", "%/a[2]/%/b%[1]");
        this.assertPathLike("%/a[2]/%/b%[%]", "%/a[2]/%/b%[%]");
        this.assertPathLike("%/a[2]/%/b%[%]%", "%/a[2]/%/b%[%]%");
        this.assertPathLike("%/a[2]/%/b%[3]%", "%/a[2]/%/b%[3]%");
    }

    protected void assertPathLike(String inputPath, String expectedOutputPath) {
        Assert.assertThat((Object)this.search.likeExpresionForWildcardPath(inputPath), Is.is(expectedOutputPath));
    }
}

