/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.modeshape.graph.property.ValueFactory;

public abstract class CompareQuery<ValueType>
extends Query {
    private static final long serialVersionUID = 1L;
    protected final String fieldName;
    protected final FieldSelector fieldSelector;
    protected final ValueType constraintValue;
    protected final Evaluator<ValueType> evaluator;
    protected final ValueFactory<ValueType> valueTypeFactory;
    protected final ValueFactory<String> stringFactory;

    protected CompareQuery(String fieldName, ValueType constraintValue, ValueFactory<ValueType> valueTypeFactory, ValueFactory<String> stringFactory, Evaluator<ValueType> evaluator) {
        this(fieldName, constraintValue, valueTypeFactory, stringFactory, evaluator, null);
    }

    protected CompareQuery(String fieldName, ValueType constraintValue, ValueFactory<ValueType> valueTypeFactory, ValueFactory<String> stringFactory, Evaluator<ValueType> evaluator, FieldSelector fieldSelector) {
        this.fieldName = fieldName;
        this.constraintValue = constraintValue;
        this.valueTypeFactory = valueTypeFactory;
        this.stringFactory = stringFactory;
        this.evaluator = evaluator;
        assert (this.fieldName != null);
        assert (this.constraintValue != null);
        assert (this.evaluator != null);
        this.fieldSelector = fieldSelector != null ? fieldSelector : new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                return CompareQuery.this.fieldName.equals(fieldName) ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
    }

    protected ValueType readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        return (ValueType)this.valueTypeFactory.create(valueString);
    }

    public Weight createWeight(Searcher searcher) {
        return new CompareWeight(searcher);
    }

    public String toString(String field) {
        return "(" + this.fieldName + this.evaluator.toString() + (this.stringFactory != null ? (String)this.stringFactory.create(this.constraintValue) : this.constraintValue.toString()) + ")";
    }

    protected class CompareScorer
    extends Scorer {
        private int docId;
        private final int pastMaxDocId;
        private final IndexReader reader;

        protected CompareScorer(IndexReader reader) {
            super(Similarity.getDefault());
            this.docId = -1;
            this.reader = reader;
            assert (this.reader != null);
            this.pastMaxDocId = this.reader.maxDoc();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            Object value;
            do {
                ++this.docId;
                if (this.docId != this.pastMaxDocId) continue;
                return Integer.MAX_VALUE;
            } while (this.reader.isDeleted(this.docId) || (value = CompareQuery.this.readFromDocument(this.reader, this.docId)) == null || !CompareQuery.this.evaluator.satisfiesConstraint(value, CompareQuery.this.constraintValue));
            return this.docId;
        }

        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class CompareWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        private final Searcher searcher;

        protected CompareWeight(Searcher searcher) {
            this.searcher = searcher;
            assert (this.searcher != null);
        }

        public Query getQuery() {
            return CompareQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new CompareScorer(reader);
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(this.getValue(), this.getQuery().toString());
        }
    }

    protected static interface Evaluator<ValueType>
    extends Serializable {
        public boolean satisfiesConstraint(ValueType var1, ValueType var2);
    }
}

