/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.search.lucene.FieldUtil;

public class FieldUtilTest {
    public static final String BIG_INTEGER_NUMBER = "123545678901234567890123545678901234567890";
    public static final String BIG_DECIMAL_NUMBER = "123545678901234567890123545678901234567890.123545678901234567890";
    public static final BigDecimal BIG_NEGATIVE = new BigDecimal("-123545678901234567890123545678901234567890.123545678901234567890");
    public static final BigDecimal BIG_POSITIVE = new BigDecimal("123545678901234567890123545678901234567890.123545678901234567890");
    public static final BigDecimal BIGGEST_POSITIVE = new BigDecimal(new BigInteger("123545678901234567890123545678901234567890"), Integer.MAX_VALUE);
    public static final BigDecimal BIGGEST_NEGATIVE = new BigDecimal(new BigInteger("123545678901234567890123545678901234567890"), Integer.MAX_VALUE).negate();
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal TEN = BigDecimal.TEN;
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final BigDecimal NEGATIVE_TEN = BigDecimal.TEN.negate();
    public static final BigDecimal NEGATIVE_ONE = BigDecimal.ONE.negate();

    @Test
    public void shouldSerializeBigDecimalWithValueOfZero() {
        this.assertSerializeAndDeserialize(ZERO, "0");
    }

    @Test
    public void shouldSerializeBigDecimalWithValueOfOne() {
        this.assertSerializeAndDeserialize(ONE, "101");
    }

    @Test
    public void shouldSerializeBigDecimalWithValueOfTen() {
        this.assertSerializeAndDeserialize(TEN, "111 11");
    }

    @Test
    public void shouldSerializeBigDecimalWithValueOfNegativeOne() {
        this.assertSerializeAndDeserialize(NEGATIVE_ONE, "-08A");
    }

    @Test
    public void shouldSerializeBigDecimalWithValueOfNegativeTen() {
        this.assertSerializeAndDeserialize(NEGATIVE_TEN, "--8 88A");
    }

    @Test
    public void shouldSerializeBigDecimalWithBigPositiveValue() {
        this.assertSerializeAndDeserialize(BIG_POSITIVE, "112 4112354567890123456789012354567890123456789012354567890123456789");
    }

    @Test
    public void shouldSerializeBigDecimalWithBigNegativeValue() {
        this.assertSerializeAndDeserialize(BIG_NEGATIVE, "--7 5887645432109876543210987645432109876543210987645432109876543210A");
    }

    @Test
    public void shortSerializeLargestPositiveBigDecimalValue() {
        this.assertSerializeAndDeserialize(BIGGEST_POSITIVE, "1-10 785251639312354567890123456789012354567890123456789");
    }

    @Test
    public void shortSerializeLargestNegativeBigDecimalValue() {
        this.assertSerializeAndDeserialize(BIGGEST_NEGATIVE, "-189 214748360687645432109876543210987645432109876543210A");
    }

    @Test
    public void shouldSerializeBigDecimalWithZeroAsExponents() {
        this.assertSerializeAndDeserialize(new BigDecimal("+1.2E0"), "1012");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.2E0"), "-087A");
    }

    @Test
    public void shouldSerializeBigDecimalPositiveValues() {
        this.assertSerializeAndDeserialize(new BigDecimal("+5.E-3"), "1-1 65");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.E-2"), "1-1 71");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.0E-2"), "1-1 71");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.0000E-2"), "1-1 71");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.1E-2"), "1-1 711");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.11E-2"), "1-1 7111");
        this.assertSerializeAndDeserialize(new BigDecimal("+1.2E-2"), "1-1 712");
        this.assertSerializeAndDeserialize(new BigDecimal("+5.E-2"), "1-1 75");
        this.assertSerializeAndDeserialize(new BigDecimal("+7.3E+2"), "111 273");
        this.assertSerializeAndDeserialize(new BigDecimal("+7.4E+2"), "111 274");
        this.assertSerializeAndDeserialize(new BigDecimal("+7.45E+2"), "111 2745");
        this.assertSerializeAndDeserialize(new BigDecimal("+8.7654E+3"), "111 387654");
    }

    @Test
    public void shouldSerializeBigDecimalNegativeValues() {
        this.assertSerializeAndDeserialize(new BigDecimal("-8.7654E+3"), "--8 612345A");
        this.assertSerializeAndDeserialize(new BigDecimal("-7.45E+2"), "--8 7254A");
        this.assertSerializeAndDeserialize(new BigDecimal("-7.4E+2"), "--8 725A");
        this.assertSerializeAndDeserialize(new BigDecimal("-7.3E+2"), "--8 726A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-1"), "-18 14A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-2"), "-18 24A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.2E-2"), "-18 287A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.11E-2"), "-18 2888A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.1E-2"), "-18 288A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.0000E-2"), "-18 28A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.0E-2"), "-18 28A");
        this.assertSerializeAndDeserialize(new BigDecimal("-1.E-2"), "-18 28A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-3"), "-18 34A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-4"), "-18 44A");
    }

    @Test
    public void shouldSerializeBigDecimalNegativeValuesWithNegativeExponents() {
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-1"), "-18 14A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-2"), "-18 24A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-3"), "-18 34A");
        this.assertSerializeAndDeserialize(new BigDecimal("-5.E-4"), "-18 44A");
    }

    @Test
    public void shouldSerializeBigDecimalNegativeValuesWithPositiveExponents() {
        this.assertSerializeAndDeserialize(new BigDecimal("-8.7654E+3"), "--8 612345A");
        this.assertSerializeAndDeserialize(new BigDecimal("-7.45E+2"), "--8 7254A");
        this.assertSerializeAndDeserialize(new BigDecimal("-7.4E+2"), "--8 725A");
    }

    @Test
    public void shouldSortSerializedFormSameAsBigDecimalValues2() {
        this.assertSortable("+5.E-3", "+1.E-2");
    }

    @Test
    public void shouldSortSerializedFormSameAsBigDecimalValues() {
        this.assertSortable("+5.E-3", "+1.E-2", "+1.0E-2", "+1.0000E-2", "+1.1E-2", "+1.11E-2", "+1.2E-2", "+5.E-1", "+5.E-2", "+7.3E+2", "+7.4E+2", "+7.45E+2", "+8.7654E+3", "-8.7654E+3", "-7.45E+2", "-7.4E+2", "-7.3E+2", "-5.E0", "-5.E-1", "-5.E-2", "-5.E-4", "-1.2E-2", "-1.11E-2", "-1.1E-2", "-1.0000E-2", "-1.0E-2", "-1.E-2", "-5.E-3", "-123545678901234567890123545678901234567890.123545678901234567890", BIG_DECIMAL_NUMBER, "-123545678901234567890123545678901234567890.1235456789012345678901", "123545678901234567890123545678901234567890.1235456789012345678901", BIGGEST_NEGATIVE.toString(), BIG_POSITIVE.toString());
    }

    protected void assertSortable(String ... decimals) {
        ArrayList<BigDecimal> bigDecimals = new ArrayList<BigDecimal>();
        ArrayList<String> stringValues = new ArrayList<String>();
        for (String decimal : decimals) {
            BigDecimal bigDecimal = new BigDecimal(decimal);
            bigDecimals.add(bigDecimal);
            String stringValue = FieldUtil.decimalToString((BigDecimal)bigDecimal);
            stringValues.add(stringValue);
        }
        Collections.sort(bigDecimals);
        Collections.sort(stringValues);
        for (int i = 0; i != bigDecimals.size(); ++i) {
            String ser;
            BigDecimal actual;
            BigDecimal decimal = (BigDecimal)bigDecimals.get(i);
            if (decimal.compareTo(actual = FieldUtil.stringToDecimal((String)(ser = (String)stringValues.get(i)))) == 0) continue;
            ArrayList<BigDecimal> actualDecimals = new ArrayList<BigDecimal>();
            for (String stringValue : stringValues) {
                actualDecimals.add(FieldUtil.stringToDecimal((String)stringValue));
            }
            Assert.assertThat(actualDecimals, (Matcher)Is.is(bigDecimals));
        }
    }

    protected void assertSerializeAndDeserialize(BigDecimal decimal) {
        this.assertSerializeAndDeserialize(decimal, null);
    }

    protected void assertSerializeAndDeserialize(BigDecimal decimal, String expectedSerializedForm) {
        String ser = FieldUtil.decimalToString((BigDecimal)decimal);
        BigDecimal decimal2 = FieldUtil.stringToDecimal((String)ser);
        Assert.assertThat((Object)decimal.compareTo(decimal2), (Matcher)Is.is((Object)0));
        String ser2 = FieldUtil.decimalToString((BigDecimal)decimal2);
        Assert.assertThat((Object)ser2, (Matcher)Is.is((Object)ser));
        if (expectedSerializedForm != null) {
            Assert.assertThat((Object)ser, (Matcher)Is.is((Object)expectedSerializedForm));
        }
    }
}

