/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.text.TextExtractor;
import org.modeshape.graph.text.TextExtractorContext;
import org.modeshape.graph.text.TextExtractorOutput;
import org.modeshape.graph.text.TextExtractors;
import org.modeshape.search.lucene.AbstractLuceneSearchEngine;
import org.modeshape.search.lucene.FieldUtil;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneException;
import org.modeshape.search.lucene.LuceneI18n;
import org.modeshape.search.lucene.LuceneSearchProcessor;
import org.modeshape.search.lucene.LuceneSearchWorkspace;
import org.modeshape.search.lucene.query.CaseOperations;
import org.modeshape.search.lucene.query.CompareLengthQuery;
import org.modeshape.search.lucene.query.CompareNameQuery;
import org.modeshape.search.lucene.query.ComparePathQuery;
import org.modeshape.search.lucene.query.CompareStringQuery;
import org.modeshape.search.lucene.query.MatchNoneQuery;

@NotThreadSafe
public class LuceneSearchSession
implements AbstractLuceneSearchEngine.WorkspaceSession {
    protected static final Set<Name> NON_SEARCHABLE_NAMES = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.UUID, ModeShapeLexicon.UUID, JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, ModeShapeIntLexicon.NODE_DEFINITON, new BasicName("http://www.modeshape.org/internal/1.0", "multiValuedProperties"))));
    protected static final FieldSelector LOCATION_FIELDS_SELECTOR = new FieldSelector(){
        private static final long serialVersionUID = 1L;

        public FieldSelectorResult accept(String fieldName) {
            if ("::pth".equals(fieldName) || "::idp".equals(fieldName)) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };
    protected static final int MIN_DEPTH = 0;
    protected static final int MAX_DEPTH = 100;
    protected static final int MIN_SNS_INDEX = 1;
    protected static final int MAX_SNS_INDEX = 1000;
    private static final ConcurrentHashMap<String, ReentrantLock> INDEX_WRITER_LOCKS = new ConcurrentHashMap();
    private final LuceneSearchWorkspace workspace;
    protected final LuceneSearchProcessor processor;
    private final Directory contentIndexDirectory;
    private final IndexRules indexRules;
    private IndexReader contentReader;
    private IndexWriter contentWriter;
    private IndexSearcher contentSearcher;
    private int numChanges;
    private final Logger logger = Logger.getLogger(this.getClass());

    protected LuceneSearchSession(LuceneSearchWorkspace workspace, LuceneSearchProcessor processor) {
        assert (workspace != null);
        assert (processor != null);
        this.workspace = workspace;
        this.contentIndexDirectory = workspace.contentDirectory;
        this.processor = processor;
        this.indexRules = workspace.getRules();
    }

    @Override
    public String getWorkspaceName() {
        return this.workspace.getWorkspaceName();
    }

    public LuceneSearchWorkspace getWorkspace() {
        return this.workspace;
    }

    protected IndexReader getContentReader() throws IOException {
        if (this.contentReader == null) {
            try {
                this.contentReader = IndexReader.open((Directory)this.contentIndexDirectory, (boolean)this.processor.readOnly);
            }
            catch (IOException e) {
                IndexWriterConfig config = new IndexWriterConfig(this.workspace.getVersion(), this.workspace.analyzer);
                IndexWriter writer = new IndexWriter(this.contentIndexDirectory, config);
                writer.close();
                this.contentReader = IndexReader.open((Directory)this.contentIndexDirectory, (boolean)this.processor.readOnly);
            }
        }
        return this.contentReader;
    }

    protected IndexWriter getContentWriter() throws IOException {
        assert (!this.processor.readOnly);
        if (this.contentWriter == null) {
            this.lockIndexWriterAccess();
            IndexWriterConfig config = new IndexWriterConfig(this.workspace.getVersion(), this.workspace.analyzer);
            this.contentWriter = new IndexWriter(this.contentIndexDirectory, config);
        }
        return this.contentWriter;
    }

    private void lockIndexWriterAccess() {
        String workspaceName = this.getWorkspaceName();
        if (!INDEX_WRITER_LOCKS.containsKey(workspaceName)) {
            INDEX_WRITER_LOCKS.putIfAbsent(workspaceName, new ReentrantLock(true));
        }
        INDEX_WRITER_LOCKS.get(workspaceName).lock();
    }

    private void unlockIndexWriterAccess() {
        String workspaceName = this.getWorkspaceName();
        ReentrantLock lock = INDEX_WRITER_LOCKS.get(workspaceName);
        while (lock.getHoldCount() > 0) {
            lock.unlock();
        }
    }

    @Override
    public IndexSearcher getContentSearcher() throws IOException {
        if (this.contentSearcher == null) {
            this.contentSearcher = new IndexSearcher(this.getContentReader());
        }
        return this.contentSearcher;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.workspace.analyzer;
    }

    @Override
    public Version getVersion() {
        return this.workspace.getVersion();
    }

    @Override
    public boolean hasWriters() {
        return this.contentWriter != null;
    }

    protected final void recordChange() {
        ++this.numChanges;
    }

    protected final void recordChanges(int numberOfChanges) {
        assert (numberOfChanges >= 0);
        this.numChanges += numberOfChanges;
    }

    @Override
    public final int getChangeCount() {
        return this.numChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() {
        if (this.logger.isTraceEnabled() && this.numChanges > 0) {
            this.logger.trace("index for \"{0}\" workspace: COMMIT", new Object[]{this.workspace.getWorkspaceName()});
        }
        boolean optimize = this.workspace.isOptimizationRequired(this.numChanges);
        this.numChanges = 0;
        IOException ioError = null;
        RuntimeException runtimeError = null;
        if (this.contentReader != null) {
            try {
                this.contentReader.close();
            }
            catch (IOException e) {
                ioError = e;
            }
            catch (RuntimeException e) {
                runtimeError = e;
            }
            finally {
                this.contentReader = null;
            }
        }
        if (this.contentWriter != null) {
            try {
                if (optimize) {
                    this.contentWriter.optimize();
                }
            }
            catch (IOException e) {
                if (ioError == null) {
                    ioError = e;
                }
            }
            catch (RuntimeException e) {
                if (runtimeError == null) {
                    runtimeError = e;
                }
            }
            finally {
                try {
                    this.contentWriter.close();
                }
                catch (IOException e) {
                    if (ioError == null) {
                        ioError = e;
                    }
                }
                catch (RuntimeException e) {
                    if (runtimeError == null) {
                        runtimeError = e;
                    }
                }
                finally {
                    this.contentWriter = null;
                }
                this.unlockIndexWriterAccess();
            }
        }
        if (ioError != null) {
            String msg = LuceneI18n.errorWhileCommittingIndexChanges.text(new Object[]{this.workspace.getWorkspaceName(), this.processor.getSourceName(), ioError.getMessage()});
            throw new LuceneException(msg, ioError);
        }
        if (runtimeError != null) {
            throw runtimeError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() {
        if (this.logger.isTraceEnabled() && this.numChanges > 0) {
            this.logger.trace("index for \"{0}\" workspace: ROLLBACK", new Object[]{this.workspace.getWorkspaceName()});
        }
        this.numChanges = 0;
        IOException ioError = null;
        RuntimeException runtimeError = null;
        if (this.contentReader != null) {
            try {
                this.contentReader.close();
            }
            catch (IOException e) {
                ioError = e;
            }
            catch (RuntimeException e) {
                runtimeError = e;
            }
            finally {
                this.contentReader = null;
            }
        }
        if (this.contentWriter != null) {
            try {
                this.contentWriter.rollback();
            }
            catch (IOException e) {
                if (ioError == null) {
                    ioError = e;
                }
            }
            catch (RuntimeException e) {
                if (runtimeError == null) {
                    runtimeError = e;
                }
            }
            finally {
                try {
                    this.contentWriter.close();
                }
                catch (IOException e) {
                    ioError = e;
                }
                catch (RuntimeException e) {
                    runtimeError = e;
                }
                finally {
                    this.contentWriter = null;
                }
                this.unlockIndexWriterAccess();
            }
        }
        if (ioError != null) {
            String msg = LuceneI18n.errorWhileRollingBackIndexChanges.text(new Object[]{this.workspace.getWorkspaceName(), this.processor.getSourceName(), ioError.getMessage()});
            throw new LuceneException(msg, ioError);
        }
        if (runtimeError != null) {
            throw runtimeError;
        }
    }

    protected QueryResults.Statistics search(String fullTextSearchExpression, List<Object[]> results, int maxRows, int offset) throws ParseException, IOException {
        long planningNanos = System.nanoTime();
        QueryParser parser = new QueryParser(this.workspace.getVersion(), "::fts", this.workspace.analyzer);
        Query query = parser.parse(fullTextSearchExpression);
        planningNanos = System.nanoTime() - planningNanos;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("search \"{0}\" workspace using {1}", new Object[]{this.workspace.getWorkspaceName(), query});
        }
        TopDocs docs = this.getContentSearcher().search(query, maxRows + offset);
        IndexReader contentReader = this.getContentReader();
        ScoreDoc[] scoreDocs = docs.scoreDocs;
        int numberOfResults = scoreDocs.length;
        if (numberOfResults > offset) {
            int num = scoreDocs.length;
            for (int i = offset; i != num; ++i) {
                ScoreDoc result = scoreDocs[i];
                int docId = result.doc;
                Document doc = contentReader.document(docId, LOCATION_FIELDS_SELECTOR);
                Location location = this.readLocation(doc);
                results.add(new Object[]{location, Float.valueOf(result.score)});
            }
        }
        long executionNanos = System.nanoTime() - planningNanos;
        return new QueryResults.Statistics(planningNanos, 0L, 0L, executionNanos);
    }

    protected Location readLocation(Document doc) {
        String pathString = doc.get("::pth");
        Path path = (Path)this.processor.pathFactory.create(pathString);
        String[] idProps = doc.getValues("::idp");
        if (idProps.length == 0) {
            return Location.create((Path)path);
        }
        if (idProps.length == 1) {
            Property idProp = this.processor.deserializeProperty(idProps[0]);
            if (idProp == null) {
                return Location.create((Path)path);
            }
            if (idProp.isSingle() && (idProp.getName().equals(JcrLexicon.UUID) || idProp.getName().equals(ModeShapeLexicon.UUID))) {
                return Location.create((Path)path, (UUID)((UUID)idProp.getFirstValue()));
            }
            return Location.create((Path)path, (Property)idProp);
        }
        LinkedList<Property> properties = new LinkedList<Property>();
        for (String idProp : idProps) {
            Property prop = this.processor.deserializeProperty(idProp);
            if (prop == null) continue;
            properties.add(prop);
        }
        return properties.isEmpty() ? Location.create((Path)path) : Location.create((Path)path, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOrReplaceProperties(Location location, Iterable<Property> properties) throws IOException {
        ExecutionContext execContext;
        TextExtractor extractor;
        Document doc = new Document();
        Path path = location.getPath();
        String pathStr = this.processor.pathAsString(path);
        String nameStr = path.isRoot() ? "" : (String)this.processor.stringFactory.create(path.getLastSegment().getName());
        String localNameStr = path.isRoot() ? "" : path.getLastSegment().getName().getLocalName();
        int sns = path.isRoot() ? 1 : path.getLastSegment().getIndex();
        doc.add((Fieldable)new Field("::pth", pathStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field("::nam", nameStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field("::loc", localNameStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField("::sns", Field.Store.YES, true).setIntValue(sns));
        doc.add((Fieldable)new NumericField("::dep", Field.Store.YES, true).setIntValue(path.size()));
        if (location.hasIdProperties()) {
            for (Property idProp : location.getIdProperties()) {
                String fieldValue = this.processor.serializeProperty(idProp);
                doc.add((Fieldable)new Field("::idp", fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        StringBuilder fullTextSearchValue = new StringBuilder();
        fullTextSearchValue.append(localNameStr);
        LinkedList<Property> binaryProperties = null;
        HashSet<Property> nonBinaryProperties = new HashSet<Property>();
        String stringValue = null;
        for (Property property : properties) {
            Name name = property.getName();
            IndexRules.Rule rule = this.indexRules.getRule(name);
            if (rule.isSkipped()) continue;
            String nameString = (String)this.processor.stringFactory.create(name);
            IndexRules.FieldType type = rule.getType();
            if (type == IndexRules.FieldType.DATE) {
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    DateTime dateValue = (DateTime)this.processor.dateFactory.create(value);
                    long longValue = dateValue.getMillisecondsInUtc();
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setLongValue(longValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.INT) {
                ValueFactory longFactory = this.processor.valueFactories.getLongFactory();
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    int intValue = ((Long)longFactory.create(value)).intValue();
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setIntValue(intValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.DOUBLE) {
                ValueFactory doubleFactory = this.processor.valueFactories.getDoubleFactory();
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    double dValue = (Double)doubleFactory.create(value);
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setDoubleValue(dValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.LONG) {
                ValueFactory longFactory = this.processor.valueFactories.getLongFactory();
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    long lValue = (Long)longFactory.create(value);
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setLongValue(lValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.FLOAT) {
                ValueFactory doubleFactory = this.processor.valueFactories.getDoubleFactory();
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    float fValue = ((Double)doubleFactory.create(value)).floatValue();
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setFloatValue(fValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.DECIMAL) {
                ValueFactory decimalFactory = this.processor.valueFactories.getDecimalFactory();
                for (Object value : property) {
                    if (value == null) continue;
                    BigDecimal decimal = (BigDecimal)decimalFactory.create(value);
                    value = FieldUtil.decimalToString(decimal);
                    doc.add((Fieldable)new Field(nameString, stringValue, rule.getStoreOption(), Field.Index.NOT_ANALYZED));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.BINARY) {
                if (binaryProperties == null) {
                    binaryProperties = new LinkedList<Property>();
                }
                binaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.WEAK_REFERENCE) {
                PathFactory pathFactory = this.processor.valueFactories.getPathFactory();
                for (Object value : property) {
                    if (value == null) continue;
                    String valueStr = (String)this.processor.stringFactory.create((Path)pathFactory.create(value));
                    doc.add((Fieldable)new Field(nameString, valueStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new Field("::ref", stringValue, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.REFERENCE) {
                for (Object value : property) {
                    if (value == null) continue;
                    stringValue = (String)this.processor.stringFactory.create(value);
                    doc.add((Fieldable)new Field(nameString, stringValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new Field("::ref", stringValue, Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new Field("::refInt", stringValue, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            if (type == IndexRules.FieldType.BOOLEAN) {
                ValueFactory booleanFactory = this.processor.valueFactories.getBooleanFactory();
                boolean index = rule.getIndexOption() != Field.Index.NO;
                for (Object value : property) {
                    if (value == null) continue;
                    int intValue = (Boolean)booleanFactory.create(value) != false ? 1 : 0;
                    doc.add((Fieldable)new NumericField(nameString, rule.getStoreOption(), index).setIntValue(intValue));
                }
                nonBinaryProperties.add(property);
                continue;
            }
            assert (type == IndexRules.FieldType.STRING);
            nonBinaryProperties.add(property);
            for (Object value : property) {
                if (value == null) continue;
                stringValue = (String)this.processor.stringFactory.create(value);
                doc.add((Fieldable)new Field(nameString, stringValue, rule.getStoreOption(), Field.Index.NOT_ANALYZED));
                boolean treatedAsReference = false;
                if (value instanceof Reference) {
                    Reference ref = (Reference)value;
                    doc.add((Fieldable)new Field("::ref", stringValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    if (!ref.isWeak()) {
                        doc.add((Fieldable)new Field("::refInt", stringValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                    treatedAsReference = true;
                } else if (rule.canBeReference() && stringValue.length() == 36 && stringValue.charAt(8) == '-') {
                    try {
                        UUID.fromString(stringValue);
                        treatedAsReference = true;
                        doc.add((Fieldable)new Field("::ref", stringValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (treatedAsReference || rule.getIndexOption() == Field.Index.NO || !rule.isFullTextSearchable() || NON_SEARCHABLE_NAMES.contains(name)) continue;
                fullTextSearchValue.append(' ').append(stringValue);
                String fullTextNameString = this.processor.fullTextFieldName(nameString);
                doc.add((Fieldable)new Field(fullTextNameString, stringValue, Field.Store.NO, Field.Index.ANALYZED));
            }
        }
        if (!(binaryProperties == null || (extractor = (execContext = this.processor.getExecutionContext()).getTextExtractor()) instanceof TextExtractors && ((TextExtractors)extractor).size() == 0)) {
            MimeTypeDetector detector = execContext.getMimeTypeDetector();
            String contentName = nameStr;
            if (JcrLexicon.CONTENT.equals(path.getLastSegment().getName()) && path.getParent() != null && !path.getParent().isRoot()) {
                contentName = (String)this.processor.stringFactory.create(path.getParent().getLastSegment().getName());
            }
            final StringBuilder textAccumulator = fullTextSearchValue;
            TextExtractorOutput output = new TextExtractorOutput(){

                public void recordText(String text) {
                    textAccumulator.append(' ').append(text);
                }
            };
            SimpleProblems problems = new SimpleProblems();
            for (Property binaryProp : binaryProperties) {
                BinaryFactory binaryFactory = this.processor.valueFactories.getBinaryFactory();
                for (Object value : binaryProp) {
                    Binary binary;
                    InputStream stream;
                    if (value == null || (stream = (binary = (Binary)binaryFactory.create(value)).getStream()) == null) continue;
                    try {
                        String mimeType;
                        if (stream.markSupported()) {
                            stream.mark(Integer.MAX_VALUE);
                        }
                        if (!extractor.supportsMimeType(mimeType = detector.mimeTypeOf(contentName, binary.getStream()))) continue;
                        if (stream.markSupported()) {
                            stream.reset();
                        } else {
                            stream.close();
                            stream = binary.getStream();
                        }
                        TextExtractorContext context = new TextExtractorContext(execContext, path, nonBinaryProperties, mimeType, (Problems)problems);
                        extractor.extractFrom(stream, output, context);
                    }
                    finally {
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
        }
        if (fullTextSearchValue.length() != 0) {
            doc.add((Fieldable)new Field("::fts", fullTextSearchValue.toString(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index for \"{0}\" workspace: ADD {1} {2}", new Object[]{this.workspace.getWorkspaceName(), pathStr, doc});
            if (fullTextSearchValue.length() != 0) {
                String fullTextContent = fullTextSearchValue.toString();
                TokenStream stream = this.getAnalyzer().tokenStream("::fts", (Reader)new StringReader(fullTextContent));
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                StringBuilder output = new StringBuilder();
                while (stream.incrementToken()) {
                    output.append((CharSequence)term).append(' ');
                }
                this.logger.trace("index for \"{0}\" workspace:     {1} fts terms: {2}", new Object[]{this.workspace.getWorkspaceName(), pathStr, output});
            }
        }
        this.getContentWriter().updateDocument(new Term("::pth", pathStr), doc);
    }

    @Override
    public AbstractLuceneSearchEngine.TupleCollector createTupleCollector(QueryResults.Columns columns) {
        return new DualIndexTupleCollector(this, columns);
    }

    public Location getLocationForRoot() throws IOException {
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        ArrayList<Object[]> tuples = new ArrayList<Object[]>(1);
        FullTextSearchTupleCollector collector = new FullTextSearchTupleCollector(this, tuples);
        this.getContentSearcher().search((Query)query, (Collector)collector);
        return tuples.isEmpty() ? Location.create((Path)this.processor.pathFactory.createRootPath()) : (Location)((Object[])tuples.get(0))[0];
    }

    @Override
    public Query findAllNodesBelow(Path parentPath) {
        String stringifiedPath = this.processor.pathAsString(parentPath);
        stringifiedPath = stringifiedPath + '/';
        return new PrefixQuery(new Term("::pth", stringifiedPath));
    }

    public Query findAllNodesBelow(Path parentPath, int maximumDepth) {
        String stringifiedPath = this.processor.pathAsString(parentPath);
        stringifiedPath = stringifiedPath + '/';
        PrefixQuery pathQuery = new PrefixQuery(new Term("::pth", stringifiedPath));
        if (maximumDepth == Integer.MAX_VALUE) {
            return pathQuery;
        }
        int minDepth = parentPath.size() + 1;
        NumericRangeQuery depthQuery = NumericRangeQuery.newIntRange((String)"::dep", (Integer)minDepth, (Integer)maximumDepth, (boolean)true, (boolean)true);
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add((Query)pathQuery, BooleanClause.Occur.MUST);
        combinedQuery.add((Query)depthQuery, BooleanClause.Occur.MUST);
        return combinedQuery;
    }

    @Override
    public Query findAllNodesAtOrBelow(Path parentPath) {
        if (parentPath.isRoot()) {
            return new MatchAllDocsQuery();
        }
        String stringifiedPath = this.processor.pathAsString(parentPath);
        return new PrefixQuery(new Term("::pth", stringifiedPath));
    }

    @Override
    public Query findChildNodes(Path parentPath) {
        String stringifiedPath = this.processor.pathAsString(parentPath);
        stringifiedPath = stringifiedPath + '/';
        PrefixQuery query = new PrefixQuery(new Term("::pth", stringifiedPath));
        int childrenDepth = parentPath.size() + 1;
        NumericRangeQuery depthQuery = NumericRangeQuery.newIntRange((String)"::dep", (Integer)childrenDepth, (Integer)childrenDepth, (boolean)true, (boolean)true);
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add((Query)query, BooleanClause.Occur.MUST);
        combinedQuery.add((Query)depthQuery, BooleanClause.Occur.MUST);
        return combinedQuery;
    }

    @Override
    public Query findNodeAt(Path path) {
        if (path.isRoot()) {
            return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        }
        String stringifiedPath = this.processor.pathAsString(path);
        return new TermQuery(new Term("::pth", stringifiedPath));
    }

    @Override
    public Query findNodesLike(String fieldName, String likeExpression, CaseOperations.CaseOperation caseOperation) {
        ValueFactories factories = this.processor.valueFactories;
        return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, fieldName, factories, caseOperation);
    }

    @Override
    public Query findNodesWith(Length propertyLength, Operator operator, Object value) {
        assert (propertyLength != null);
        assert (value != null);
        PropertyValue propertyValue = propertyLength.propertyValue();
        String field = (String)this.processor.stringFactory.create(propertyValue.propertyName());
        ValueFactories factories = this.processor.valueFactories;
        int length = ((Long)factories.getLongFactory().create(value)).intValue();
        switch (operator) {
            case EQUAL_TO: {
                return CompareLengthQuery.createQueryForNodesWithFieldEqualTo(length, field, factories);
            }
            case NOT_EQUAL_TO: {
                return CompareLengthQuery.createQueryForNodesWithFieldNotEqualTo(length, field, factories);
            }
            case GREATER_THAN: {
                return CompareLengthQuery.createQueryForNodesWithFieldGreaterThan(length, field, factories);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return CompareLengthQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(length, field, factories);
            }
            case LESS_THAN: {
                return CompareLengthQuery.createQueryForNodesWithFieldLessThan(length, field, factories);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return CompareLengthQuery.createQueryForNodesWithFieldLessThanOrEqualTo(length, field, factories);
            }
            case LIKE: {
                assert (false);
                break;
            }
        }
        return null;
    }

    @Override
    public Query findNodesWith(PropertyValue propertyValue, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        String stringValue;
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        ValueFactory stringFactory = this.processor.stringFactory;
        String field = (String)stringFactory.create(propertyValue.propertyName());
        Name fieldName = (Name)this.processor.nameFactory.create(field);
        ValueFactories factories = this.processor.valueFactories;
        IndexRules.Rule rule = this.indexRules.getRule(fieldName);
        if (rule == null || rule.isSkipped()) {
            return new MatchNoneQuery();
        }
        IndexRules.FieldType type = rule.getType();
        if (operator == Operator.LIKE) {
            stringValue = (String)stringFactory.create(value);
            if (stringValue.indexOf(37) != -1 || stringValue.indexOf(95) != -1 || stringValue.indexOf(92) != -1) {
                type = IndexRules.FieldType.STRING;
            } else {
                operator = Operator.EQUAL_TO;
            }
        }
        switch (type) {
            case REFERENCE: 
            case WEAK_REFERENCE: 
            case STRING: {
                stringValue = (String)stringFactory.create(value);
                if (value instanceof Path) {
                    stringValue = this.processor.pathAsString((Path)value);
                }
                switch (operator) {
                    case EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case NOT_EQUAL_TO: {
                        Query query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, caseOperation);
                        return this.not(query);
                    }
                    case GREATER_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, factories, caseOperation);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case LESS_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, factories, caseOperation);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case LIKE: {
                        return this.findNodesLike(field, stringValue, caseOperation);
                    }
                }
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)factories.getDecimalFactory().create(value);
                stringValue = FieldUtil.decimalToString(decimalValue);
                switch (operator) {
                    case EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case NOT_EQUAL_TO: {
                        Query query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, caseOperation);
                        return this.not(query);
                    }
                    case GREATER_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, factories, caseOperation);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case LESS_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, factories, caseOperation);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, factories, caseOperation);
                    }
                    case LIKE: {
                        return this.findNodesLike(field, stringValue, caseOperation);
                    }
                }
                break;
            }
            case DATE: {
                IndexRules.NumericRule longRule = (IndexRules.NumericRule)rule;
                long date = (Long)factories.getLongFactory().create(value);
                switch (operator) {
                    case EQUAL_TO: {
                        if (date < (Long)longRule.getMinimum() || date > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)date, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (date < (Long)longRule.getMinimum() || date > (Long)longRule.getMaximum()) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery query = NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)date, (boolean)true, (boolean)true);
                        return this.not((Query)query);
                    }
                    case GREATER_THAN: {
                        if (date > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)((Long)longRule.getMaximum()), (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (date > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)((Long)longRule.getMaximum()), (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (date < (Long)longRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)((Long)longRule.getMinimum()), (Long)date, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (date < (Long)longRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)((Long)longRule.getMinimum()), (Long)date, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case LONG: {
                IndexRules.NumericRule longRule = (IndexRules.NumericRule)rule;
                long longValue = (Long)factories.getLongFactory().create(value);
                switch (operator) {
                    case EQUAL_TO: {
                        if (longValue < (Long)longRule.getMinimum() || longValue > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (longValue < (Long)longRule.getMinimum() || longValue > (Long)longRule.getMaximum()) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery query = NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longValue, (boolean)true, (boolean)true);
                        return this.not((Query)query);
                    }
                    case GREATER_THAN: {
                        if (longValue > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)((Long)longRule.getMaximum()), (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (longValue > (Long)longRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)((Long)longRule.getMaximum()), (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (longValue < (Long)longRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)((Long)longRule.getMinimum()), (Long)longValue, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (longValue < (Long)longRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)((Long)longRule.getMinimum()), (Long)longValue, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = (Boolean)factories.getBooleanFactory().create(value);
                int intValue = booleanValue ? 1 : 0;
                switch (operator) {
                    case EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)intValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)intValue, (boolean)true, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)1, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)intValue, (boolean)true, (boolean)true);
                    }
                    case GREATER_THAN: {
                        if (!booleanValue) {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)1, (Integer)1, (boolean)true, (boolean)true);
                        }
                        return new MatchNoneQuery();
                    }
                    case LESS_THAN: {
                        if (booleanValue) {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)0, (boolean)true, (boolean)true);
                        }
                        return new MatchNoneQuery();
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case INT: {
                IndexRules.NumericRule intRule = (IndexRules.NumericRule)rule;
                int intValue = ((Long)factories.getLongFactory().create(value)).intValue();
                switch (operator) {
                    case EQUAL_TO: {
                        if (intValue < (Integer)intRule.getMinimum() || intValue > (Integer)intRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)intValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (intValue < (Integer)intRule.getMinimum() || intValue > (Integer)intRule.getMaximum()) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)intValue, (boolean)true, (boolean)true);
                        return this.not((Query)query);
                    }
                    case GREATER_THAN: {
                        if (intValue > (Integer)intRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)((Integer)intRule.getMaximum()), (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (intValue > (Integer)intRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newIntRange((String)field, (Integer)intValue, (Integer)((Integer)intRule.getMaximum()), (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (intValue < (Integer)intRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newIntRange((String)field, (Integer)((Integer)intRule.getMinimum()), (Integer)intValue, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (intValue < (Integer)intRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newIntRange((String)field, (Integer)((Integer)intRule.getMinimum()), (Integer)intValue, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case DOUBLE: {
                IndexRules.NumericRule dRule = (IndexRules.NumericRule)rule;
                double doubleValue = (Double)factories.getDoubleFactory().create(value);
                switch (operator) {
                    case EQUAL_TO: {
                        if (doubleValue < (Double)dRule.getMinimum() || doubleValue > (Double)dRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (doubleValue < (Double)dRule.getMinimum() || doubleValue > (Double)dRule.getMaximum()) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery query = NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true);
                        return this.not((Query)query);
                    }
                    case GREATER_THAN: {
                        if (doubleValue > (Double)dRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)((Double)dRule.getMaximum()), (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (doubleValue > (Double)dRule.getMaximum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)((Double)dRule.getMaximum()), (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (doubleValue < (Double)dRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)((Double)dRule.getMinimum()), (Double)doubleValue, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (doubleValue < (Double)dRule.getMinimum()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)((Double)dRule.getMinimum()), (Double)doubleValue, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case FLOAT: {
                IndexRules.NumericRule fRule = (IndexRules.NumericRule)rule;
                float floatValue = ((Double)factories.getDoubleFactory().create(value)).floatValue();
                switch (operator) {
                    case EQUAL_TO: {
                        if (floatValue < ((Float)fRule.getMinimum()).floatValue() || floatValue > ((Float)fRule.getMaximum()).floatValue()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(floatValue), (Float)Float.valueOf(floatValue), (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (floatValue < ((Float)fRule.getMinimum()).floatValue() || floatValue > ((Float)fRule.getMaximum()).floatValue()) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery query = NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(floatValue), (Float)Float.valueOf(floatValue), (boolean)true, (boolean)true);
                        return this.not((Query)query);
                    }
                    case GREATER_THAN: {
                        if (floatValue > ((Float)fRule.getMaximum()).floatValue()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(floatValue), (Float)((Float)fRule.getMaximum()), (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (floatValue > ((Float)fRule.getMaximum()).floatValue()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(floatValue), (Float)((Float)fRule.getMaximum()), (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (floatValue < ((Float)fRule.getMinimum()).floatValue()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newFloatRange((String)field, (Float)((Float)fRule.getMinimum()), (Float)Float.valueOf(floatValue), (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (floatValue < ((Float)fRule.getMinimum()).floatValue()) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newFloatRange((String)field, (Float)((Float)fRule.getMinimum()), (Float)Float.valueOf(floatValue), (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case BINARY: {
                assert (false);
                return null;
            }
        }
        return null;
    }

    @Override
    public Query findNodesWith(ReferenceValue referenceValue, Operator operator, Object value) {
        String field = referenceValue.propertyName();
        if (field == null) {
            field = referenceValue.includesWeakReferences() ? "::ref" : "::refInt";
        }
        ValueFactories factories = this.processor.valueFactories;
        String stringValue = (String)this.processor.stringFactory.create(value);
        switch (operator) {
            case EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, CaseOperations.AS_IS);
            }
            case NOT_EQUAL_TO: {
                return this.not(CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, factories, CaseOperations.AS_IS));
            }
            case GREATER_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, factories, CaseOperations.AS_IS);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, factories, CaseOperations.AS_IS);
            }
            case LESS_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, factories, CaseOperations.AS_IS);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, factories, CaseOperations.AS_IS);
            }
            case LIKE: {
                return this.findNodesLike(field, stringValue, CaseOperations.AS_IS);
            }
        }
        return null;
    }

    @Override
    public Query findNodesWithNumericRange(PropertyValue propertyValue, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        String field = (String)this.processor.stringFactory.create(propertyValue.propertyName());
        return this.findNodesWithNumericRange(field, lowerValue, upperValue, includesLower, includesUpper);
    }

    @Override
    public Query findNodesWithNumericRange(NodeDepth depth, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        return this.findNodesWithNumericRange("::dep", lowerValue, upperValue, includesLower, includesUpper);
    }

    protected Query findNodesWithNumericRange(String field, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        Name fieldName = (Name)this.processor.nameFactory.create(field);
        IndexRules.Rule rule = this.indexRules.getRule(fieldName);
        if (rule == null || rule.isSkipped()) {
            return new MatchNoneQuery();
        }
        IndexRules.FieldType type = rule.getType();
        ValueFactories factories = this.processor.valueFactories;
        switch (type) {
            case DATE: {
                long lowerDate = (Long)factories.getLongFactory().create(lowerValue);
                long upperDate = (Long)factories.getLongFactory().create(upperValue);
                return NumericRangeQuery.newLongRange((String)field, (Long)lowerDate, (Long)upperDate, (boolean)includesLower, (boolean)includesUpper);
            }
            case LONG: {
                long lowerLong = (Long)factories.getLongFactory().create(lowerValue);
                long upperLong = (Long)factories.getLongFactory().create(upperValue);
                return NumericRangeQuery.newLongRange((String)field, (Long)lowerLong, (Long)upperLong, (boolean)includesLower, (boolean)includesUpper);
            }
            case DOUBLE: {
                double lowerDouble = (Double)factories.getDoubleFactory().create(lowerValue);
                double upperDouble = (Double)factories.getDoubleFactory().create(upperValue);
                return NumericRangeQuery.newDoubleRange((String)field, (Double)lowerDouble, (Double)upperDouble, (boolean)includesLower, (boolean)includesUpper);
            }
            case FLOAT: {
                float lowerFloat = ((Double)factories.getDoubleFactory().create(lowerValue)).floatValue();
                float upperFloat = ((Double)factories.getDoubleFactory().create(upperValue)).floatValue();
                return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf(lowerFloat), (Float)Float.valueOf(upperFloat), (boolean)includesLower, (boolean)includesUpper);
            }
            case INT: {
                int lowerInt = ((Long)factories.getLongFactory().create(lowerValue)).intValue();
                int upperInt = ((Long)factories.getLongFactory().create(upperValue)).intValue();
                return NumericRangeQuery.newIntRange((String)field, (Integer)lowerInt, (Integer)upperInt, (boolean)includesLower, (boolean)includesUpper);
            }
            case BOOLEAN: {
                int lowerInt = (Boolean)factories.getBooleanFactory().create(lowerValue) != false ? 1 : 0;
                int upperInt = (Boolean)factories.getBooleanFactory().create(upperValue) != false ? 1 : 0;
                return NumericRangeQuery.newIntRange((String)field, (Integer)lowerInt, (Integer)upperInt, (boolean)includesLower, (boolean)includesUpper);
            }
            case DECIMAL: {
                BigDecimal lowerDecimal = (BigDecimal)factories.getDecimalFactory().create(lowerValue);
                BigDecimal upperDecimal = (BigDecimal)factories.getDecimalFactory().create(upperValue);
                String lsv = FieldUtil.decimalToString(lowerDecimal);
                String usv = FieldUtil.decimalToString(upperDecimal);
                CaseOperations.CaseOperation caseOp = CaseOperations.AS_IS;
                CompareStringQuery lower = null;
                lower = includesLower ? CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(lsv, field, factories, caseOp) : CompareStringQuery.createQueryForNodesWithFieldGreaterThan(lsv, field, factories, caseOp);
                CompareStringQuery upper = null;
                upper = includesUpper ? CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(usv, field, factories, caseOp) : CompareStringQuery.createQueryForNodesWithFieldLessThan(usv, field, factories, caseOp);
                BooleanQuery query = new BooleanQuery();
                query.add((Query)lower, BooleanClause.Occur.MUST);
                query.add((Query)upper, BooleanClause.Occur.MUST);
                return query;
            }
            case REFERENCE: 
            case WEAK_REFERENCE: 
            case STRING: 
            case BINARY: {
                assert (false);
                break;
            }
        }
        return new MatchNoneQuery();
    }

    protected String likeExpresionForWildcardPath(String path) {
        if (path.equals("/") || path.equals("%")) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        if ((path = path.replaceAll("%+", "%")).startsWith("%/")) {
            sb.append("%");
            if (path.length() == 2) {
                return sb.toString();
            }
            path = path.substring(2);
        }
        for (String segment : path.split("/")) {
            if (segment.length() == 0) continue;
            sb.append("/");
            sb.append(segment);
            if (segment.equals("%") || segment.equals("_") || segment.endsWith("]") || segment.endsWith("]%") || segment.endsWith("]_")) continue;
            sb.append("[1]");
        }
        if (path.endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    public Query findNodesWith(NodePath nodePath, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        Path pathValue = operator != Operator.LIKE ? (Path)this.processor.pathFactory.create(value) : null;
        ComparePathQuery query = null;
        switch (operator) {
            case EQUAL_TO: {
                return this.findNodeAt(pathValue);
            }
            case NOT_EQUAL_TO: {
                return this.not(this.findNodeAt(pathValue));
            }
            case LIKE: {
                String likeExpression = (String)this.processor.stringFactory.create(value);
                likeExpression = this.likeExpresionForWildcardPath(likeExpression);
                if (likeExpression.indexOf("[%]") != -1) {
                    String regex = likeExpression;
                    regex = regex.replace("[%]", "[\\d+]");
                    regex = regex.replace("[", "\\[");
                    regex = regex.replace("*", ".*").replace("?", ".");
                    regex = regex.replace("%", ".*").replace("_", ".");
                    RegexQuery regexQuery = new RegexQuery(new Term("::pth", regex));
                    int flags = caseOperation == CaseOperations.AS_IS ? 0 : 2;
                    regexQuery.setRegexImplementation((RegexCapabilities)new JavaUtilRegexCapabilities(flags));
                    query = regexQuery;
                    break;
                }
                query = this.findNodesLike("::pth", likeExpression, caseOperation);
                break;
            }
            case GREATER_THAN: {
                query = ComparePathQuery.createQueryForNodesWithPathGreaterThan(pathValue, "::pth", this.processor.valueFactories, caseOperation);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = ComparePathQuery.createQueryForNodesWithPathGreaterThanOrEqualTo(pathValue, "::pth", this.processor.valueFactories, caseOperation);
                break;
            }
            case LESS_THAN: {
                query = ComparePathQuery.createQueryForNodesWithPathLessThan(pathValue, "::pth", this.processor.valueFactories, caseOperation);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = ComparePathQuery.createQueryForNodesWithPathLessThanOrEqualTo(pathValue, "::pth", this.processor.valueFactories, caseOperation);
            }
        }
        return query;
    }

    protected Query not(Query notted) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        query.add(notted, BooleanClause.Occur.MUST_NOT);
        return query;
    }

    @Override
    public Query findNodesWith(NodeName nodeName, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        ValueFactories factories = this.processor.valueFactories;
        String stringValue = (String)this.processor.stringFactory.create(value);
        if (stringValue.startsWith("./") && stringValue.length() > 2) {
            stringValue = stringValue.substring(2);
        }
        Path.Segment segment = operator != Operator.LIKE ? this.processor.pathFactory.createSegment(stringValue) : null;
        boolean includeSns = stringValue.indexOf(91) != -1;
        int snsIndex = operator != Operator.LIKE ? segment.getIndex() : 0;
        Query query = null;
        switch (operator) {
            case EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameEqualTo(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                break;
            }
            case NOT_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameEqualTo(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                query = this.not(query);
                return query;
            }
            case GREATER_THAN: {
                query = CompareNameQuery.createQueryForNodesWithNameGreaterThan(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameGreaterThanOrEqualTo(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                break;
            }
            case LESS_THAN: {
                query = CompareNameQuery.createQueryForNodesWithNameLessThan(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameLessThanOrEqualTo(segment, "::nam", "::sns", factories, caseOperation, includeSns);
                break;
            }
            case LIKE: {
                String likeExpression = stringValue;
                int openBracketIndex = likeExpression.indexOf(91);
                if (openBracketIndex != -1) {
                    String localNameExpression = likeExpression.substring(0, openBracketIndex);
                    String snsIndexExpression = likeExpression.substring(openBracketIndex);
                    Query localNameQuery = CompareStringQuery.createQueryForNodesWithFieldLike(localNameExpression, "::nam", factories, caseOperation);
                    Query snsQuery = this.createSnsIndexQuery(snsIndexExpression);
                    if (localNameQuery == null) {
                        query = snsQuery == null ? new MatchNoneQuery() : snsQuery;
                    } else if (snsQuery == null) {
                        query = localNameQuery;
                    } else {
                        BooleanQuery booleanQuery = new BooleanQuery();
                        booleanQuery.add(localNameQuery, BooleanClause.Occur.MUST);
                        booleanQuery.add(snsQuery, BooleanClause.Occur.MUST);
                        query = booleanQuery;
                    }
                } else {
                    query = CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, "::nam", factories, caseOperation);
                }
                assert (query != null);
                break;
            }
        }
        return query;
    }

    @Override
    public Query findNodesWith(NodeLocalName nodeName, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        String nameValue = (String)this.processor.stringFactory.create(value);
        Query query = null;
        switch (operator) {
            case LIKE: {
                String likeExpression = (String)this.processor.stringFactory.create(value);
                query = this.findNodesLike("::loc", likeExpression, caseOperation);
                break;
            }
            case EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(nameValue, "::loc", this.processor.valueFactories, caseOperation);
                break;
            }
            case NOT_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(nameValue, "::loc", this.processor.valueFactories, caseOperation);
                query = this.not(query);
                break;
            }
            case GREATER_THAN: {
                query = CompareStringQuery.createQueryForNodesWithFieldGreaterThan(nameValue, "::loc", this.processor.valueFactories, caseOperation);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(nameValue, "::loc", this.processor.valueFactories, caseOperation);
                break;
            }
            case LESS_THAN: {
                query = CompareStringQuery.createQueryForNodesWithFieldLessThan(nameValue, "::loc", this.processor.valueFactories, caseOperation);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(nameValue, "::loc", this.processor.valueFactories, caseOperation);
            }
        }
        return query;
    }

    @Override
    public Query findNodesWith(NodeDepth depthConstraint, Operator operator, Object value) {
        int depth = ((Long)this.processor.valueFactories.getLongFactory().create(value)).intValue();
        switch (operator) {
            case EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)depth, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)depth, (boolean)true, (boolean)true);
                return this.not((Query)query);
            }
            case GREATER_THAN: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)100, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)100, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)depth, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)depth, (boolean)true, (boolean)true);
            }
            case LIKE: {
                return null;
            }
        }
        return null;
    }

    protected Query createLocalNameQuery(String likeExpression, CaseOperations.CaseOperation caseOperation) {
        if (likeExpression == null) {
            return null;
        }
        return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, "::loc", this.processor.valueFactories, caseOperation);
    }

    protected Query createSnsIndexQuery(String likeExpression) {
        if (likeExpression == null) {
            return null;
        }
        if ((likeExpression = likeExpression.trim()).length() == 0) {
            return null;
        }
        assert (likeExpression.charAt(0) == '[');
        int closeBracketIndex = (likeExpression = likeExpression.substring(1)).indexOf(93);
        if (closeBracketIndex != -1) {
            likeExpression = likeExpression.substring(0, closeBracketIndex);
        }
        if (likeExpression.equals("_")) {
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)1, (Integer)9, (boolean)true, (boolean)true);
        }
        if (likeExpression.equals("%")) {
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)1, (Integer)1000, (boolean)true, (boolean)true);
        }
        if (likeExpression.indexOf(95) != -1) {
            int secondWildcardChar;
            if (likeExpression.indexOf(37) != -1) {
                return this.findNodesLike("::sns", likeExpression, CaseOperations.AS_IS);
            }
            int firstWildcardChar = likeExpression.indexOf(95);
            if (firstWildcardChar + 1 < likeExpression.length() && (secondWildcardChar = likeExpression.indexOf(95, firstWildcardChar + 1)) != -1) {
                return this.findNodesLike("::sns", likeExpression, CaseOperations.AS_IS);
            }
            String lowerExpression = likeExpression.replace('_', '0');
            String upperExpression = likeExpression.replace('_', '9');
            try {
                int lowerSns = Integer.parseInt(lowerExpression);
                int upperSns = Integer.parseInt(upperExpression);
                return NumericRangeQuery.newIntRange((String)"::sns", (Integer)lowerSns, (Integer)upperSns, (boolean)true, (boolean)true);
            }
            catch (NumberFormatException e) {
                return new MatchNoneQuery();
            }
        }
        if (likeExpression.indexOf(37) != -1) {
            return this.findNodesLike("::sns", likeExpression, CaseOperations.AS_IS);
        }
        try {
            int sns = Integer.parseInt(likeExpression);
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)sns, (Integer)sns, (boolean)true, (boolean)true);
        }
        catch (NumberFormatException e) {
            return new MatchNoneQuery();
        }
    }

    protected static class FullTextSearchTupleCollector
    extends AbstractLuceneSearchEngine.TupleCollector {
        private final List<Object[]> tuples;
        private final FieldSelector fieldSelector;
        private final LuceneSearchSession session;
        private Scorer scorer;
        private IndexReader currentReader;
        private int docOffset;

        protected FullTextSearchTupleCollector(LuceneSearchSession session, List<Object[]> tuples) {
            assert (session != null);
            assert (tuples != null);
            this.session = session;
            this.tuples = tuples;
            this.fieldSelector = LOCATION_FIELDS_SELECTOR;
        }

        @Override
        public List<Object[]> getTuples() {
            return this.tuples;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.currentReader = reader;
            this.docOffset = docBase;
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            int docId = doc + this.docOffset;
            Object[] tuple = new Object[2];
            Document document = this.currentReader.document(docId, this.fieldSelector);
            tuple[0] = this.session.readLocation(document);
            tuple[1] = new Float(this.scorer.score());
            this.tuples.add(tuple);
        }
    }

    protected static class DualIndexTupleCollector
    extends AbstractLuceneSearchEngine.TupleCollector {
        private final LuceneSearchSession session;
        private final LinkedList<Object[]> tuples = new LinkedList();
        private final QueryResults.Columns columns;
        private final int numValues;
        private final boolean recordScore;
        private final int scoreIndex;
        private final FieldSelector fieldSelector;
        private final int locationIndex;
        private Scorer scorer;
        private IndexReader currentReader;
        private int docOffset;

        protected DualIndexTupleCollector(LuceneSearchSession session, QueryResults.Columns columns) {
            this.session = session;
            this.columns = columns;
            assert (this.columns != null);
            this.numValues = this.columns.getTupleSize();
            assert (this.numValues >= 0);
            assert (this.columns.getSelectorNames().size() == 1);
            String selectorName = (String)this.columns.getSelectorNames().get(0);
            this.locationIndex = this.columns.getLocationIndex(selectorName);
            this.recordScore = this.columns.hasFullTextSearchScores();
            this.scoreIndex = this.recordScore ? this.columns.getFullTextSearchScoreIndexFor(selectorName) : -1;
            List columnNames = this.columns.getColumnNames();
            final HashSet<String> fieldNames = new HashSet<String>(columnNames.size() + 2);
            for (String columnName : columnNames) {
                int index = this.columns.getColumnIndexForName(columnName);
                String propertyName = this.columns.getPropertyNameForColumn(index);
                fieldNames.add(propertyName);
            }
            fieldNames.add("::idp");
            fieldNames.add("::pth");
            this.fieldSelector = new FieldSelector(){
                private static final long serialVersionUID = 1L;

                public FieldSelectorResult accept(String fieldName) {
                    return fieldNames.contains(fieldName) ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
                }
            };
        }

        public LinkedList<Object[]> getTuples() {
            return this.tuples;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public int getLocationIndex() {
            return this.locationIndex;
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.currentReader = reader;
            this.docOffset = docBase;
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            int docId = doc + this.docOffset;
            Object[] tuple = new Object[this.numValues];
            Document document = this.currentReader.document(docId, this.fieldSelector);
            Location location = this.session.readLocation(document);
            tuple[this.locationIndex] = location;
            Float score = null;
            if (this.recordScore) {
                assert (this.scorer != null);
                score = new Float(this.scorer.score());
                tuple[this.scoreIndex] = score;
            }
            for (String columnName : this.columns.getColumnNames()) {
                int index = this.columns.getColumnIndexForName(columnName);
                Object value = document.get(columnName = this.columns.getPropertyNameForColumn(index));
                if (value == null) {
                    Path path;
                    if (columnName.equals("jcr:path")) {
                        value = this.session.processor.stringFactory.create(location.getPath());
                    } else if (columnName.equals("mode:depth")) {
                        value = new Long(location.getPath().size());
                    } else if (columnName.equals("jcr:score")) {
                        value = score == null ? new Double(this.scorer.score()) : new Double(score.doubleValue());
                    } else if (columnName.equals("jcr:name")) {
                        path = location.getPath();
                        value = path.isRoot() ? "" : this.session.processor.stringFactory.create(path.getLastSegment().getName());
                    } else if (columnName.equals("mode:localName")) {
                        path = location.getPath();
                        value = path.isRoot() ? "" : path.getLastSegment().getName().getLocalName();
                    }
                }
                tuple[index] = value;
            }
            this.tuples.add(tuple);
        }
    }
}

