/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.audio;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class AudioMetadataSequencerTest
extends AbstractSequencerTest {
    private static final double ERROR = 0.001;

    @Test
    public void shouldSequenceMp3() throws Exception {
        String filename = "sample.mp3";
        Node audioNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/audio/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "mp3", "audio/mpeg", 64L, 44100L, "2", 2.664, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
        Node sequencedNodeSameLocation = this.getOutputNode(audioNode, "audio:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "mp3", "audio/mpeg", 64L, 44100L, "2", 2.664, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
    }

    @Test
    public void shouldSequenceMp4() throws Exception {
        String filename = "sample.mp4";
        Node audioNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/audio/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "mp4", "video/mp4", 129L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
        Node sequencedNodeSameLocation = this.getOutputNode(audioNode, "audio:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "mp4", "video/mp4", 129L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
    }

    @Test
    public void shouldSequenceOggVorbis() throws Exception {
        String filename = "sample.ogg";
        Node audioNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/audio/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "ogg", "audio/vorbis", 112L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
        Node sequencedNodeSameLocation = this.getOutputNode(audioNode, "audio:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "ogg", "audio/vorbis", 112L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
    }

    @Test
    public void shouldSequenceFlac() throws Exception {
        String filename = "sample.flac";
        Node audioNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/audio/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "flac", "audio/x-flac", 426L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
        Node sequencedNodeSameLocation = this.getOutputNode(audioNode, "audio:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "flac", "audio/x-flac", 426L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
    }

    @Test
    public void shouldSequenceWma() throws Exception {
        String filename = "sample.wma";
        Node audioNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/audio/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "wma", "audio/x-ms-wma", 128L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
        Node sequencedNodeSameLocation = this.getOutputNode(audioNode, "audio:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "wma", "audio/x-ms-wma", 128L, 44100L, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg");
    }

    private void assertMetaDataProperties(Node sequencedNode, String formatName, String mimeType, Long bitrate, Long sampleRate, String channels, Double duration, String album, String artist, String comment, String title, String year, String track, String genre, String artworkMimeType) throws RepositoryException {
        Assert.assertThat((Object)sequencedNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"audio:metadata"));
        Assert.assertThat((Object)sequencedNode.getProperty("audio:formatName").getString(), (Matcher)Is.is((Object)formatName));
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)mimeType));
        Assert.assertThat((Object)sequencedNode.getProperty("audio:bitrate").getLong(), (Matcher)Is.is((Object)bitrate));
        Assert.assertThat((Object)sequencedNode.getProperty("audio:sampleRate").getLong(), (Matcher)Is.is((Object)sampleRate));
        Assert.assertThat((Object)sequencedNode.getProperty("audio:channels").getString(), (Matcher)Is.is((Object)channels));
        Assert.assertThat((Object)sequencedNode.getProperty("audio:duration").getDouble(), (Matcher)IsCloseTo.closeTo((double)duration, (double)0.001));
        Node tagNode = sequencedNode.getNode("audio:tag");
        Assert.assertThat((Object)tagNode.getProperty("audio:album").getString(), (Matcher)Is.is((Object)album));
        Assert.assertThat((Object)tagNode.getProperty("audio:artist").getString(), (Matcher)Is.is((Object)artist));
        Assert.assertThat((Object)tagNode.getProperty("audio:comment").getString(), (Matcher)Is.is((Object)comment));
        Assert.assertThat((Object)tagNode.getProperty("audio:title").getString(), (Matcher)Is.is((Object)title));
        Assert.assertThat((Object)tagNode.getProperty("audio:year").getString(), (Matcher)Is.is((Object)year));
        Assert.assertThat((Object)tagNode.getProperty("audio:track").getString(), (Matcher)Is.is((Object)track));
        Assert.assertThat((Object)tagNode.getProperty("audio:genre").getString(), (Matcher)Is.is((Object)genre));
        Node artworkNode = tagNode.getNode("audio:artwork");
        Assert.assertThat((Object)artworkNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)artworkMimeType));
        Assert.assertThat((Object)artworkNode.getProperty("jcr:data").getBinary().getSize(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

