/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.audio;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.audio.AudioMetadata;
import org.modeshape.sequencer.audio.AudioMetadataArtwork;

public class AudioMetadataTest {
    private static final double ERROR = 0.001;

    private InputStream getTestAudio(String resourcePath) {
        return this.getClass().getClassLoader().getResourceAsStream(resourcePath);
    }

    @Test
    public void shouldBeAbleToLoadMp3() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.mp3"), "audio/mpeg");
        Assert.assertTrue((boolean)metadata.check());
        this.assertMetaDataProperties(metadata, "mp3", "audio/mpeg", 64L, 44100, "2", 2.664, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg", 3);
    }

    @Test
    public void shouldBeAbleToLoadMp4() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.mp4"), "video/quicktime");
        Assert.assertTrue((boolean)metadata.check());
        this.assertMetaDataProperties(metadata, "mp4", "video/quicktime", 129L, 44100, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg", null);
    }

    @Test
    public void shouldBeAbleToLoadOggVorbis() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.ogg"), "audio/vorbis");
        Assert.assertTrue((boolean)metadata.check());
        this.assertMetaDataProperties(metadata, "ogg", "audio/vorbis", 112L, 44100, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg", 3);
    }

    @Test
    public void shouldBeAbleToLoadFlac() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.flac"), "audio/x-flac");
        Assert.assertTrue((boolean)metadata.check());
        this.assertMetaDataProperties(metadata, "flac", "audio/x-flac", 426L, 44100, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg", 3);
    }

    @Test
    public void shouldBeAbleToLoadWma() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.wma"), "audio/x-ms-wma");
        Assert.assertTrue((boolean)metadata.check());
        this.assertMetaDataProperties(metadata, "wma", "audio/x-ms-wma", 128L, 44100, "2", 2.0, "Album", "Artist", "Comment", "Title", "2015", "1", "Speech", "image/jpeg", 3);
        Assert.assertThat((Object)((AudioMetadataArtwork)metadata.getArtwork().get(0)).getType(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldBeAbleToLoadWav() throws Exception {
        AudioMetadata metadata = new AudioMetadata(this.getTestAudio("sample.wav"), "audio/x-wav");
        Assert.assertTrue((boolean)metadata.check());
        Assert.assertThat((Object)metadata.getFormatName(), (Matcher)Is.is((Object)"wav"));
        Assert.assertThat((Object)metadata.getBitrate(), (Matcher)Is.is((Object)1411L));
        Assert.assertThat((Object)metadata.getSampleRate(), (Matcher)Is.is((Object)44100));
        Assert.assertThat((Object)metadata.getChannels(), (Matcher)Is.is((Object)"2"));
        Assert.assertThat((Object)metadata.getDuration(), (Matcher)Is.is((Object)2.0));
    }

    private void assertMetaDataProperties(AudioMetadata metadata, String formatName, String mimeType, Long bitrate, Integer sampleRate, String channels, Double duration, String album, String artist, String comment, String title, String year, String track, String genre, String artworkMimeType, Integer artworkType) {
        Assert.assertThat((Object)metadata.getFormatName(), (Matcher)Is.is((Object)formatName));
        Assert.assertThat((Object)metadata.getBitrate(), (Matcher)Is.is((Object)bitrate));
        Assert.assertThat((Object)metadata.getSampleRate(), (Matcher)Is.is((Object)sampleRate));
        Assert.assertThat((Object)metadata.getChannels(), (Matcher)Is.is((Object)channels));
        Assert.assertThat((Object)metadata.getDuration(), (Matcher)IsCloseTo.closeTo((double)duration, (double)0.001));
        Assert.assertThat((Object)metadata.getAlbum(), (Matcher)Is.is((Object)album));
        Assert.assertThat((Object)metadata.getArtist(), (Matcher)Is.is((Object)artist));
        Assert.assertThat((Object)metadata.getComment(), (Matcher)Is.is((Object)comment));
        Assert.assertThat((Object)metadata.getTitle(), (Matcher)Is.is((Object)title));
        Assert.assertThat((Object)metadata.getYear(), (Matcher)Is.is((Object)year));
        Assert.assertThat((Object)metadata.getTrack(), (Matcher)Is.is((Object)track));
        Assert.assertThat((Object)metadata.getGenre(), (Matcher)Is.is((Object)genre));
        Assert.assertThat((Object)metadata.getArtwork().isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)((AudioMetadataArtwork)metadata.getArtwork().get(0)).getMimeType(), (Matcher)Is.is((Object)artworkMimeType));
        Assert.assertThat((Object)((AudioMetadataArtwork)metadata.getArtwork().get(0)).getType(), (Matcher)Is.is((Object)artworkType));
        Assert.assertThat((Object)((AudioMetadataArtwork)metadata.getArtwork().get(0)).getData().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

