/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.audio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.asf.AsfFileReader;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3FileReader;
import org.jaudiotagger.audio.mp4.Mp4AudioHeader;
import org.jaudiotagger.audio.mp4.Mp4FileReader;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.audio.wav.WavFileReader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.datatype.Artwork;
import org.modeshape.common.util.IoUtil;
import org.modeshape.sequencer.audio.AudioMetadataArtwork;

public class AudioMetadata {
    public static final int FORMAT_MP3 = 0;
    public static final int FORMAT_MP4 = 1;
    public static final int FORMAT_VORBIS = 2;
    public static final int FORMAT_FLAC = 3;
    public static final int FORMAT_WMA = 4;
    public static final int FORMAT_WAV = 5;
    public static final int FORMAT_UNSUPPORTED = -1;
    static final String[] MIME_TYPE_STRINGS = new String[]{"audio/mpeg", "audio/mp4", "video/mp4", "video/quicktime", "audio/vorbis", "audio/x-vorbis", "audio/ogg", "audio/flac", "audio/x-flac", "audio/vnd.ms-asf", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-wav", "audio/wav", "audio/wave"};
    static final String[] FORMAT_NAMES = new String[]{"mp3", "mp4", "ogg", "flac", "wma", "wav", "real"};
    private int format;
    private InputStream in;
    private AudioFile audioFile;
    private Long bitrate;
    private Integer sampleRate;
    private Double duration;
    private String channels;
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private String track;
    private String genre;
    private List<AudioMetadataArtwork> artwork;
    private String mimeType;

    public AudioMetadata(InputStream inputStream, String mimeType) {
        this.in = inputStream;
        this.mimeType = mimeType;
    }

    public boolean check() throws Exception {
        this.format = -1;
        File fileCopy = File.createTempFile("modeshape-sequencer-audio", ".tmp");
        IoUtil.write((InputStream)this.in, (OutputStream)new BufferedOutputStream(new FileOutputStream(fileCopy)));
        if (this.mimeType.startsWith("audio/mpeg")) {
            this.format = 0;
            this.audioFile = new MP3FileReader().read(fileCopy);
        } else if (this.mimeType.startsWith("audio/vorbis") || this.mimeType.startsWith("audio/x-vorbis") || this.mimeType.startsWith("audio/ogg")) {
            this.format = 2;
            this.audioFile = new OggFileReader().read(fileCopy);
        } else if (this.mimeType.startsWith("audio/flac") || this.mimeType.startsWith("audio/x-flac")) {
            this.format = 3;
            this.audioFile = new FlacFileReader().read(fileCopy);
        } else if (this.mimeType.equals("audio/mp4") || this.mimeType.equals("video/mp4") || this.mimeType.equals("video/quicktime")) {
            this.format = 1;
            this.audioFile = new Mp4FileReader().read(fileCopy);
        } else if (this.mimeType.equals("audio/x-ms-wma")) {
            this.format = 4;
            this.audioFile = new AsfFileReader().read(fileCopy);
        } else if (this.mimeType.startsWith("audio/x-wav") || this.mimeType.startsWith("audio/wav")) {
            this.format = 5;
            this.audioFile = new WavFileReader().read(fileCopy);
        }
        boolean deleted = false;
        try {
            deleted = fileCopy.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!deleted) {
            fileCopy.deleteOnExit();
        }
        return this.checkSupportedAudio();
    }

    private boolean checkSupportedAudio() {
        AudioHeader header = this.audioFile.getAudioHeader();
        this.bitrate = header.getBitRateAsNumber();
        this.sampleRate = header.getSampleRateAsNumber();
        this.channels = header.getChannels();
        if (header.getChannels().toLowerCase().contains("stereo")) {
            this.channels = "2";
        }
        this.duration = header instanceof MP3AudioHeader ? Double.valueOf(((MP3AudioHeader)header).getPreciseTrackLength()) : (header instanceof Mp4AudioHeader ? Double.valueOf(((Mp4AudioHeader)header).getPreciseLength()) : Double.valueOf(header.getTrackLength()));
        Tag tag = this.audioFile.getTag();
        this.artist = tag.getFirst(FieldKey.ARTIST);
        this.album = tag.getFirst(FieldKey.ALBUM);
        this.title = tag.getFirst(FieldKey.TITLE);
        this.comment = tag.getFirst(FieldKey.COMMENT);
        this.year = tag.getFirst(FieldKey.YEAR);
        this.track = tag.getFirst(FieldKey.TRACK);
        this.genre = tag.getFirst(FieldKey.GENRE);
        this.artwork = new ArrayList<AudioMetadataArtwork>();
        for (Artwork a : tag.getArtworkList()) {
            AudioMetadataArtwork ama = new AudioMetadataArtwork();
            ama.setMimeType(a.getMimeType());
            if (a.getPictureType() >= 0) {
                ama.setType(a.getPictureType());
            }
            ama.setData(a.getBinaryData());
            this.artwork.add(ama);
        }
        return true;
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        if (this.format >= 0 && this.format < FORMAT_NAMES.length) {
            return FORMAT_NAMES[this.format];
        }
        return "?";
    }

    public Long getBitrate() {
        return this.bitrate;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public String getChannels() {
        return this.channels;
    }

    public Double getDuration() {
        return this.duration;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTrack() {
        return this.track;
    }

    public String getGenre() {
        return this.genre;
    }

    public List<AudioMetadataArtwork> getArtwork() {
        return this.artwork;
    }
}

