/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class DdlParsers {
    private List<DdlParser> parsers = new ArrayList<DdlParser>();

    public DdlParsers() {
        this.parsers.add(new StandardDdlParser());
        this.parsers.add(new OracleDdlParser());
        this.parsers.add(new DerbyDdlParser());
        this.parsers.add(new PostgresDdlParser());
    }

    public AstNode parse(String ddl) throws ParsingException {
        assert (ddl != null);
        AstNode rootNode = new AstNode(StandardDdlLexicon.STATEMENTS_CONTAINER);
        rootNode.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
        this.parse(ddl, rootNode);
        return rootNode;
    }

    public boolean parse(String ddl, AstNode rootNode) throws ParsingException {
        assert (ddl != null);
        assert (rootNode != null);
        DdlTokenStream tokens = null;
        DdlParser validParser = null;
        DdlTokenStream validTokens = null;
        for (DdlParser parser : this.parsers) {
            if (!parser.isType(ddl)) continue;
            validParser = parser;
            break;
        }
        if (validParser == null) {
            int keywordCount = 0;
            for (DdlParser parser : this.parsers) {
                tokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(false), false);
                parser.registerWords(tokens);
                tokens.start();
                int numKeywords = parser.getNumberOfKeyWords(tokens);
                if (numKeywords <= keywordCount) continue;
                keywordCount = numKeywords;
                validParser = parser;
                validTokens = tokens;
            }
            if (validTokens != null) {
                validTokens.rewind();
            }
        } else {
            validTokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(false), false);
            validParser.registerWords(validTokens);
            validTokens.start();
        }
        if (validParser == null) {
            String msg = "NO VALID PARSER FOUND";
            throw new ParsingException(new Position(-1, 1, 0), msg);
        }
        boolean success = validParser.parse(validTokens, rootNode);
        rootNode.setProperty(StandardDdlLexicon.PARSER_ID, (Object)validParser.getId());
        return success;
    }
}

