/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.GraphSequencerOutput;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.DdlSequencer;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;

public class DdlSequencerTest {
    private DdlSequencer sequencer;
    private InputStream content;
    private GraphSequencerOutput output;
    private StreamSequencerContext context;
    private Graph graph;

    @Before
    public void beforeEach() {
        this.context = new MockSequencerContext("/a/myDdlSequencer.cnd");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.context.getNamespaceRegistry().register("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.context.getNamespaceRegistry().register("ddl", "http://www.modeshape.org/ddl/1.0");
        this.context.getNamespaceRegistry().register("derbyddl", "http://www.modeshape.org/ddl/derby/1.0");
        this.context.getNamespaceRegistry().register("oracleddl", "http://www.modeshape.org/ddl/oracle/1.0");
        this.context.getNamespaceRegistry().register("postgresddl", "http://www.modeshape.org/ddl/postgres/1.0");
        this.context.getNamespaceRegistry().register("mysqlddl", "http://www.modeshape.org/ddl/mysql/1.0");
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("actual");
        this.graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        this.output = new GraphSequencerOutput(this.graph);
        this.sequencer = new DdlSequencer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.content != null) {
            try {
                this.content.close();
            }
            finally {
                this.content = null;
            }
        }
    }

    protected Path.Segment segment(String name) {
        return this.context.getValueFactories().getPathFactory().createSegment(name);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected String value(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    private boolean verifyProperty(SubgraphNode node, String propNameStr, String expectedValue) {
        Name propName = this.name(propNameStr);
        for (Property prop : node.getProperties()) {
            if (!prop.getName().equals(propName)) continue;
            for (Object nextVal : prop.getValuesAsArray()) {
                String valueStr = this.value(nextVal);
                if (!valueStr.equals(expectedValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean verifyHasProperty(SubgraphNode node, String propNameStr) {
        Name propName = this.name(propNameStr);
        for (Property prop : node.getProperties()) {
            if (!prop.getName().equals(propName)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyPrimaryType(SubgraphNode node, String expectedValue) {
        return this.verifyProperty(node, "jcr:primaryType", expectedValue);
    }

    private boolean verifyMixinType(SubgraphNode node, String expectedValue) {
        return this.verifyProperty(node, "jcr:mixinTypes", expectedValue);
    }

    private boolean verifyExpression(SubgraphNode node, String expectedValue) {
        return this.verifyProperty(node, "ddl:expression", expectedValue);
    }

    private void verifyBaseProperties(SubgraphNode node, String primaryType, String lineNum, String colNum, String charIndex, int numChildren) {
        Assert.assertThat((Object)this.verifyPrimaryType(node, primaryType), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node, "ddl:startLineNumber", lineNum), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node, "ddl:startColumnNumber", colNum), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node, "ddl:startCharIndex", charIndex), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getChildren().size(), (Matcher)Is.is((Object)numChildren));
    }

    @Test
    public void shouldSequenceCreateSchema() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("ddl/create_schema.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "POSTGRES"), (Matcher)Is.is((Object)true));
        SubgraphNode schemaNode = statementsNode.getNode(this.path("hollywood"));
        Assert.assertNotNull((Object)schemaNode);
        this.verifyBaseProperties(schemaNode, "nt:unstructured", "1", "1", "0", 2);
        Assert.assertThat((Object)this.verifyMixinType(schemaNode, "ddl:createSchemaStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(schemaNode, "CREATE SCHEMA hollywood"), (Matcher)Is.is((Object)true));
        SubgraphNode filmsNode = schemaNode.getNode(this.path("films"));
        Assert.assertNotNull((Object)filmsNode);
        this.verifyBaseProperties(filmsNode, "nt:unstructured", "2", "5", "28", 3);
        Assert.assertThat((Object)this.verifyMixinType(filmsNode, "ddl:createTableStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(filmsNode, "CREATE TABLE films (title varchar(255), release date, producerName varchar(255))"), (Matcher)Is.is((Object)true));
        SubgraphNode winnersNode = schemaNode.getNode(this.path("winners"));
        Assert.assertNotNull((Object)winnersNode);
        this.verifyBaseProperties(winnersNode, "nt:unstructured", "3", "5", "113", 0);
        Assert.assertThat((Object)this.verifyMixinType(winnersNode, "ddl:createViewStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(winnersNode, "CREATE VIEW winners AS SELECT title, release FROM films WHERE producerName IS NOT NULL;"), (Matcher)Is.is((Object)true));
        SubgraphNode titleNode = filmsNode.getNode(this.path("title"));
        Assert.assertNotNull((Object)titleNode);
        Assert.assertThat((Object)this.verifyPrimaryType(titleNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(titleNode, "ddl:datatypeName", "VARCHAR"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(titleNode, "ddl:datatypeLength", "255"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(titleNode, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode releaseNode = filmsNode.getNode(this.path("release"));
        Assert.assertNotNull((Object)releaseNode);
        Assert.assertThat((Object)this.verifyPrimaryType(releaseNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(releaseNode, "ddl:datatypeName", "DATE"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyHasProperty(releaseNode, "ddl:datatypeLength"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.verifyMixinType(titleNode, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSequenceCreateTable() throws IOException {
        String targetExpression = "CREATE TABLE IDTABLE\n(\n  IDCONTEXT  VARCHAR(20) NOT NULL PRIMARY KEY,\n  NEXTID     NUMERIC\n);";
        URL url = this.getClass().getClassLoader().getResource("ddl/create_table.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "SQL92"), (Matcher)Is.is((Object)true));
        SubgraphNode tableNode = statementsNode.getNode(this.path("IDTABLE"));
        Assert.assertNotNull((Object)tableNode);
        this.verifyBaseProperties(tableNode, "nt:unstructured", "1", "1", "0", 3);
        Assert.assertThat((Object)this.verifyMixinType(tableNode, "ddl:createTableStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(tableNode, targetExpression), (Matcher)Is.is((Object)true));
        SubgraphNode idcontextNode = tableNode.getNode(this.path("IDCONTEXT"));
        Assert.assertNotNull((Object)idcontextNode);
        Assert.assertThat((Object)this.verifyPrimaryType(idcontextNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(idcontextNode, "ddl:datatypeName", "VARCHAR"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(idcontextNode, "ddl:datatypeLength", "20"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(idcontextNode, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode nextidNode = tableNode.getNode(this.path("NEXTID"));
        Assert.assertNotNull((Object)nextidNode);
        Assert.assertThat((Object)this.verifyPrimaryType(nextidNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(nextidNode, "ddl:datatypeName", "NUMERIC"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(nextidNode, "ddl:datatypePrecision", "0"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(nextidNode, "ddl:datatypeScale", "0"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyHasProperty(nextidNode, "ddl:datatypeLength"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.verifyMixinType(nextidNode, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode pk_1_Node = tableNode.getNode(this.path("PK_1"));
        Assert.assertNotNull((Object)pk_1_Node);
        Assert.assertThat((Object)this.verifyPrimaryType(pk_1_Node, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(pk_1_Node, "ddl:constraintType", "PRIMARY KEY"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(pk_1_Node, "ddl:tableConstraint"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pk_1_Node.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode idcontectRefNode = pk_1_Node.getNode(this.path("IDCONTEXT"));
        Assert.assertNotNull((Object)idcontectRefNode);
        Assert.assertThat((Object)this.verifyPrimaryType(idcontectRefNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(idcontectRefNode, "ddl:columnReference"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSequenceStatementsWithDoubleQuotes() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("ddl/d_quoted_statements.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "POSTGRES"), (Matcher)Is.is((Object)true));
        SubgraphNode firstNode = statementsNode.getNode(this.path("unknownStatement"));
        Assert.assertNotNull((Object)firstNode);
        this.verifyBaseProperties(firstNode, "nt:unstructured", "1", "1", "0", 0);
        Assert.assertThat((Object)this.verifyMixinType(firstNode, "ddl:unknownStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode serverNode = statementsNode.getNode(this.path("CREATE SERVER"));
        Assert.assertNotNull((Object)serverNode);
        this.verifyBaseProperties(serverNode, "nt:unstructured", "5", "1", "93", 0);
        Assert.assertThat((Object)this.verifyMixinType(serverNode, "postgresddl:createServerStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode ruleNode = statementsNode.getNode(this.path("_RETURN"));
        Assert.assertNotNull((Object)ruleNode);
        this.verifyBaseProperties(ruleNode, "nt:unstructured", "7", "1", "144", 0);
        Assert.assertThat((Object)this.verifyMixinType(ruleNode, "postgresddl:createRuleStatement"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGenerateNodeTypesForCreateTables() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("ddl/createTables.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)20));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "SQL92"), (Matcher)Is.is((Object)true));
        SubgraphNode tableNode = statementsNode.getNode(this.path("RT_MDLS"));
        Assert.assertNotNull((Object)tableNode);
        this.verifyBaseProperties(tableNode, "nt:unstructured", "80", "1", "2258", 10);
        Assert.assertThat((Object)this.verifyMixinType(tableNode, "ddl:createTableStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode node_1 = tableNode.getNode(this.path("MDL_UUID"));
        Assert.assertNotNull((Object)node_1);
        Assert.assertThat((Object)this.verifyPrimaryType(node_1, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node_1, "ddl:datatypeName", "VARCHAR"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node_1, "ddl:datatypeLength", "64"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(node_1, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode node_2 = tableNode.getNode(this.path("MDL_TYPE"));
        Assert.assertNotNull((Object)node_2);
        Assert.assertThat((Object)this.verifyPrimaryType(node_2, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node_2, "ddl:datatypeName", "NUMERIC"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node_2, "ddl:datatypePrecision", "3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(node_2, "ddl:datatypeScale", "0"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyHasProperty(node_2, "ddl:datatypeLength"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.verifyMixinType(node_2, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
    }

    @Ignore
    @Test
    public void shouldSequenceDerbyDdl() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("ddl/dialect/derby/derby_test_statements.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)64));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "DERBY"), (Matcher)Is.is((Object)true));
        SubgraphNode indexNode = statementsNode.getNode(this.path("IXSALE"));
        Assert.assertNotNull((Object)indexNode);
        this.verifyBaseProperties(indexNode, "nt:unstructured", "87", "1", "2886", 0);
        Assert.assertThat((Object)this.verifyMixinType(indexNode, "derbyddl:createIndexStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode schemaNode = statementsNode.getNode(this.path("FLIGHTS"));
        Assert.assertNotNull((Object)schemaNode);
        this.verifyBaseProperties(schemaNode, "nt:unstructured", "98", "1", "3218", 0);
        Assert.assertThat((Object)this.verifyMixinType(schemaNode, "ddl:createSchemaStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(schemaNode, "CREATE SCHEMA FLIGHTS AUTHORIZATION anita;"), (Matcher)Is.is((Object)true));
        SubgraphNode unknownNode_1 = statementsNode.getNode(this.path("some_procedure_name"));
        Assert.assertNotNull((Object)unknownNode_1);
        this.verifyBaseProperties(unknownNode_1, "nt:unstructured", "172", "1", "5438", 0);
        Assert.assertThat((Object)this.verifyMixinType(unknownNode_1, "derbyddl:dropProcedureStatement"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyExpression(unknownNode_1, "DROP PROCEDURE some_procedure_name;"), (Matcher)Is.is((Object)true));
        SubgraphNode alterTableNode = statementsNode.getNode(this.path("SAMP.DEPARTMENT"));
        Assert.assertNotNull((Object)alterTableNode);
        this.verifyBaseProperties(alterTableNode, "nt:unstructured", "16", "1", "478", 1);
        Assert.assertThat((Object)this.verifyMixinType(alterTableNode, "ddl:alterTableStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode uniqueNode = alterTableNode.getNode(this.path("NEW_UNIQUE"));
        Assert.assertNotNull((Object)uniqueNode);
        Assert.assertThat((Object)this.verifyPrimaryType(uniqueNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(uniqueNode, "ddl:constraintType", "0"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(uniqueNode, "ddl:addTableConstraintDefinition"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)uniqueNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode colRefNode = uniqueNode.getNode(this.path("DEPTNO"));
        Assert.assertNotNull((Object)colRefNode);
        Assert.assertThat((Object)this.verifyPrimaryType(colRefNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(colRefNode, "ddl:columnReference"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSequenceOracleDdl() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("ddl/dialect/oracle/oracle_test_statements_2.ddl");
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        this.output.close();
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode rootNode = (SubgraphNode)subgraph.getNode(".");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        SubgraphNode statementsNode = rootNode.getNode(this.path("ddl:statements"));
        Assert.assertNotNull((Object)statementsNode);
        Assert.assertThat((Object)statementsNode.getChildren().size(), (Matcher)Is.is((Object)50));
        Assert.assertThat((Object)this.verifyPrimaryType(statementsNode, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(statementsNode, "ddl:parserId", "ORACLE"), (Matcher)Is.is((Object)true));
        SubgraphNode createOrReplDirNode = statementsNode.getNode(this.path("CREATE OR REPLACE DIRECTORY"));
        Assert.assertNotNull((Object)createOrReplDirNode);
        this.verifyBaseProperties(createOrReplDirNode, "nt:unstructured", "164", "1", "3886", 0);
        Assert.assertThat((Object)this.verifyMixinType(createOrReplDirNode, "oracleddl:createDirectoryStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode countriesNode = statementsNode.getNode(this.path("countries"));
        Assert.assertNotNull((Object)countriesNode);
        this.verifyBaseProperties(countriesNode, "nt:unstructured", "9", "1", "89", 3);
        Assert.assertThat((Object)this.verifyMixinType(countriesNode, "ddl:alterTableStatement"), (Matcher)Is.is((Object)true));
        SubgraphNode duty_pct_node = countriesNode.getNode(this.path("duty_pct"));
        Assert.assertNotNull((Object)duty_pct_node);
        Assert.assertThat((Object)this.verifyPrimaryType(duty_pct_node, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(duty_pct_node, "ddl:datatypeName", "NUMBER"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(duty_pct_node, "ddl:datatypePrecision", "2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(duty_pct_node, "ddl:datatypeScale", "2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyHasProperty(duty_pct_node, "ddl:datatypeLength"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.verifyMixinType(duty_pct_node, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode check_1_node = countriesNode.getNode(this.path("CHECK_1"));
        Assert.assertNotNull((Object)check_1_node);
        Assert.assertThat((Object)this.verifyPrimaryType(check_1_node, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(check_1_node, "ddl:constraintType", "CHECK"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(check_1_node, "ddl:addTableConstraintDefinition"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(check_1_node, "ddl:searchCondition", "( duty_pct < 10 . 5 )"), (Matcher)Is.is((Object)true));
        SubgraphNode visa_needed_node = countriesNode.getNode(this.path("visa_needed"));
        Assert.assertNotNull((Object)visa_needed_node);
        Assert.assertThat((Object)this.verifyPrimaryType(visa_needed_node, "nt:unstructured"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(visa_needed_node, "ddl:datatypeName", "VARCHAR2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyProperty(visa_needed_node, "ddl:datatypeLength", "3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.verifyMixinType(visa_needed_node, "ddl:columnDefinition"), (Matcher)Is.is((Object)true));
        SubgraphNode app_user1Node = statementsNode.getNode(this.path("app_user1"));
        Assert.assertNotNull((Object)app_user1Node);
        this.verifyBaseProperties(app_user1Node, "nt:unstructured", "33", "1", "624", 0);
        Assert.assertThat((Object)this.verifyMixinType(app_user1Node, "oracleddl:alterUserStatement"), (Matcher)Is.is((Object)true));
    }

    protected String[] builtInGrammars() {
        ArrayList<String> builtInParserNames = new ArrayList<String>();
        for (DdlParser parser : DdlParsers.BUILTIN_PARSERS) {
            builtInParserNames.add(parser.getId().toLowerCase());
        }
        return builtInParserNames.toArray(new String[builtInParserNames.size()]);
    }

    @Test
    public void shouldHaveDefaultListOfGrammars() {
        String[] grammars = this.sequencer.getGrammars();
        Assert.assertThat((Object)grammars, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)grammars, (Matcher)Is.is((Object)this.builtInGrammars()));
    }

    @Test
    public void shouldCreateListOfDdlParserInstancesForDefaultListOfGrammars() {
        List parsers = this.sequencer.getParserList(this.context);
        Assert.assertThat((Object)parsers, (Matcher)Is.is((Object)DdlParsers.BUILTIN_PARSERS));
    }

    @Test
    public void shouldAllowSettingGrammarsWithEmptyArray() {
        this.sequencer.setGrammars(new String[0]);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)this.builtInGrammars()));
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingGrammarsWithNullArray() {
        this.sequencer.setGrammars(null);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)this.builtInGrammars()));
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingGrammarsToNonEmptyArrayOfValidBuiltInGrammars() {
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId()};
        this.sequencer.setGrammars(grammars);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingGrammarsToNonEmptyArrayOfValidAndNonExistantBuiltInGrammars() {
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), "argle"};
        this.sequencer.setGrammars(grammars);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateDdlParserInstancesForAllValidBuiltInGrammars() {
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), "argle"};
        this.sequencer.setGrammars(grammars);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        List parsers = this.sequencer.getParserList(this.context);
        Assert.assertThat(parsers.get(0), (Matcher)Is.is((Object)new OracleDdlParser()));
        Assert.assertThat(parsers.get(1), (Matcher)Is.is((Object)new StandardDdlParser()));
        Assert.assertThat((Object)parsers.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.context.getProblems().hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateDdlParserInstancesForAllValidBuiltInGrammarsAndInstantiableParser() {
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), ArgleDdlParser.class.getName()};
        this.sequencer.setGrammars(grammars);
        Assert.assertThat((Object)this.sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        List parsers = this.sequencer.getParserList(this.context);
        Assert.assertThat((Object)this.context.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat(parsers.get(0), (Matcher)Is.is((Object)new OracleDdlParser()));
        Assert.assertThat(parsers.get(1), (Matcher)Is.is((Object)new StandardDdlParser()));
        Assert.assertThat(parsers.get(2), (Matcher)Is.is((Object)((Object)new ArgleDdlParser())));
        Assert.assertThat((Object)parsers.size(), (Matcher)Is.is((Object)3));
    }

    protected static class ArgleDdlParser
    extends StandardDdlParser {
        protected ArgleDdlParser() {
        }

        public String getId() {
            return "ARGLE";
        }
    }
}

