/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.postgres;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.graph.property.Name;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlConstants;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlLexicon;
import org.modeshape.sequencer.ddl.node.AstNode;

public class PostgresDdlParser
extends StandardDdlParser
implements PostgresDdlConstants,
PostgresDdlConstants.PostgresStatementStartPhrases {
    private final String parserId = "POSTGRES";
    static List<String[]> postgresDataTypeStrings = new ArrayList<String[]>();
    private static final String TERMINATOR = ";";

    public PostgresDdlParser() {
        this.setDatatypeParser(new PostgresDataTypeParser());
        this.initialize();
    }

    private void initialize() {
        this.setDoUseTerminator(true);
        this.setTerminator(TERMINATOR);
        postgresDataTypeStrings.addAll(PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    public String getId() {
        return this.parserId;
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerKeyWords(PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_WORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(SET_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
    }

    @Override
    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        AstNode prepareNode = null;
        boolean mergeNextStatement = false;
        for (AstNode child : copyOfNodes) {
            if (prepareNode != null && mergeNextStatement) {
                this.mergeNodes(tokens, prepareNode, child);
                rootNode.removeChild(child);
                prepareNode = null;
            }
            mergeNextStatement = prepareNode != null && this.nodeFactory().hasMixinType(child, StandardDdlLexicon.TYPE_MISSING_TERMINATOR);
            if (!this.nodeFactory().hasMixinType(child, PostgresDdlLexicon.TYPE_PREPARE_STATEMENT)) continue;
            prepareNode = child;
        }
        super.rewrite(tokens, rootNode);
        copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        boolean foundComplexNode = false;
        AstNode complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (this.matchesComplexNode(child)) {
                foundComplexNode = true;
                complexNode = child;
                continue;
            }
            if (!foundComplexNode) continue;
            if (complexNode != null && this.nodeFactory().hasMixinType(child, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT)) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
                continue;
            }
            foundComplexNode = false;
            complexNode = null;
        }
    }

    private boolean matchesComplexNode(AstNode node) {
        for (Name mixin : COMPLEX_STMT_TYPES) {
            if (!this.nodeFactory().hasMixinType(node, mixin)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_ALTER_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_ALTER_AGGREGATE, parentNode, PostgresDdlLexicon.TYPE_ALTER_AGGREGATE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_CONVERSION)) {
            return this.parseStatement(tokens, STMT_ALTER_CONVERSION, parentNode, PostgresDdlLexicon.TYPE_ALTER_CONVERSION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            return this.parseStatement(tokens, STMT_ALTER_DATABASE, parentNode, PostgresDdlLexicon.TYPE_ALTER_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_FOREIGN_DATA_WRAPPER)) {
            return this.parseStatement(tokens, STMT_ALTER_FOREIGN_DATA_WRAPPER, parentNode, PostgresDdlLexicon.TYPE_ALTER_FOREIGN_DATA_WRAPPER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, PostgresDdlLexicon.TYPE_ALTER_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_GROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_GROUP, parentNode, PostgresDdlLexicon.TYPE_ALTER_GROUP_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_INDEX)) {
            return this.parseStatement(tokens, STMT_ALTER_INDEX, parentNode, PostgresDdlLexicon.TYPE_ALTER_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_ALTER_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_ALTER_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_OPERATOR)) {
            return this.parseStatement(tokens, STMT_ALTER_OPERATOR, parentNode, PostgresDdlLexicon.TYPE_ALTER_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_ROLE)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLE, parentNode, PostgresDdlLexicon.TYPE_ALTER_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SCHEMA)) {
            return this.parseStatement(tokens, STMT_ALTER_SCHEMA, parentNode, PostgresDdlLexicon.TYPE_ALTER_SCHEMA_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_ALTER_SEQUENCE, parentNode, PostgresDdlLexicon.TYPE_ALTER_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SERVER)) {
            return this.parseStatement(tokens, STMT_ALTER_SERVER, parentNode, PostgresDdlLexicon.TYPE_ALTER_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, PostgresDdlLexicon.TYPE_ALTER_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TEXT_SEARCH)) {
            return this.parseStatement(tokens, STMT_ALTER_TEXT_SEARCH, parentNode, PostgresDdlLexicon.TYPE_ALTER_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TRIGGER)) {
            return this.parseStatement(tokens, STMT_ALTER_TRIGGER, parentNode, PostgresDdlLexicon.TYPE_ALTER_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_TYPE, parentNode, PostgresDdlLexicon.TYPE_ALTER_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_ALTER_USER_MAPPING, parentNode, PostgresDdlLexicon.TYPE_ALTER_USER_MAPPING_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_USER)) {
            return this.parseStatement(tokens, STMT_ALTER_USER, parentNode, PostgresDdlLexicon.TYPE_ALTER_USER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_VIEW)) {
            return this.parseStatement(tokens, STMT_ALTER_VIEW, parentNode, PostgresDdlLexicon.TYPE_ALTER_VIEW_STATEMENT);
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume();
        tokens.consume("TABLE");
        tokens.canConsume("ONLY");
        String tableName = this.parseName(tokens);
        tokens.canConsume("*");
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES);
        do {
            this.parseAlterTableAction(tokens, alterTableNode);
        } while (tokens.canConsume(","));
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    private void parseAlterTableAction(DdlTokenStream tokens, AstNode alterTableNode) throws ParsingException {
        assert (tokens != null);
        assert (alterTableNode != null);
        if (tokens.canConsume("ADD")) {
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else {
                this.parseSingleCommaTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
        } else if (tokens.canConsume("DROP")) {
            if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, StandardDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            } else {
                tokens.canConsume("COLUMN");
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, StandardDdlLexicon.TYPE_DROP_COLUMN_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            }
        } else if (tokens.matches("ALTER")) {
            tokens.consume("ALTER");
            tokens.canConsume("COLUMN");
            String columnName = this.parseName(tokens);
            AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, StandardDdlLexicon.TYPE_ALTER_COLUMN_DEFINITION);
            if (tokens.canConsume("SET", new String[]{"STORAGE"})) {
                tokens.consume();
            } else if (tokens.canConsume("SET", new String[]{"STATISTICS"})) {
                tokens.consume();
            } else if (!tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                if (tokens.canConsume("SET", new String[]{"DATA"})) {
                    tokens.consume("TYPE");
                    DataType datatype = this.getDatatypeParser().parse(tokens);
                    this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
                    if (tokens.canConsume("USING")) {
                        this.parseUntilCommaOrTerminator(tokens);
                    }
                } else if (tokens.canConsume("TYPE")) {
                    DataType datatype = this.getDatatypeParser().parse(tokens);
                    this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
                    if (tokens.canConsume("USING")) {
                        this.parseUntilCommaOrTerminator(tokens);
                    }
                } else if (tokens.matches("SET", new String[]{"DEFAULT"})) {
                    tokens.consume("SET");
                    this.parseDefaultClause(tokens, columnNode);
                } else if (tokens.matches("SET") || tokens.matches("DROP")) {
                    tokens.consume();
                    tokens.canConsume("NOT", new String[]{"NULL"});
                    tokens.canConsume("NULL");
                } else {
                    System.out.println("  WARNING:  Option not found for ALTER TABLE - ALTER COLUMN. Check your DDL for incomplete statement.");
                }
            }
        } else if (tokens.canConsume("ENABLE")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            StringBuffer sb = new StringBuffer("ENABLE");
            if (tokens.canConsume("TRIGGER")) {
                sb.append(" ").append("TRIGGER");
                if (!tokens.matches(this.getTerminator())) {
                    sb.append(" ").append(this.parseName(tokens));
                }
            } else if (tokens.canConsume("REPLICA", new String[]{"TRIGGER"})) {
                sb.append(" ").append("REPLICA TRIGGER");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("REPLICA", new String[]{"RULE"})) {
                sb.append(" ").append("REPLICA RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("ALWAYS", new String[]{"TRIGGER"})) {
                sb.append(" ").append("ALWAYS TRIGGER");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("ALWAYS", new String[]{"RULE"})) {
                sb.append(" ").append("ALWAYS RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("RULE")) {
                sb.append(" ").append("RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else {
                System.out.println("  WARNING:  Option not found for ALTER TABLE - ENABLE XXXX. Check your DDL for incomplete statement.");
            }
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)sb.toString());
        } else if (tokens.canConsume("DISABLE")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            StringBuffer sb = new StringBuffer("DISABLE");
            if (tokens.canConsume("TRIGGER")) {
                sb.append(" ").append("TRIGGER");
                if (!tokens.matches(this.getTerminator())) {
                    sb.append(" ").append(this.parseName(tokens));
                }
            } else if (tokens.canConsume("RULE")) {
                sb.append(" ").append("RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else {
                System.out.println("  WARNING:  Option not found for ALTER TABLE - DISABLE XXXX. Check your DDL for incomplete statement.");
            }
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)sb.toString());
        } else if (tokens.canConsume("CLUSTER", new String[]{"ON"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            String indexName = this.parseName(tokens);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)("CLUSTER ON " + indexName));
        } else if (tokens.canConsume("OWNER", new String[]{"TO"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)("OWNER TO " + this.parseName(tokens)));
        } else if (tokens.canConsume("INHERIT")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)("INHERIT " + this.parseName(tokens)));
        } else if (tokens.canConsume("NO", new String[]{"INHERIT"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)("NO INHERIT " + this.parseName(tokens)));
        } else if (tokens.canConsume("SET", new String[]{"TABLESPACE"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)("SET TABLESPACE " + this.parseName(tokens)));
        } else if (tokens.canConsume("SET", new String[]{"WITHOUT", "CLUSTER"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)"SET WITHOUT CLUSTER");
        } else if (tokens.canConsume("SET", new String[]{"WITHOUT", "OIDS"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)"SET WITHOUT OIDS");
        } else if (tokens.canConsume("SET", new String[]{"WITH", "OIDS"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)"SET WITH OIDS");
        } else if (tokens.canConsume("RENAME", new String[]{"TO"})) {
            String newTableName = this.parseName(tokens);
            alterTableNode.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newTableName);
        } else if (tokens.canConsume("RENAME")) {
            tokens.canConsume("COLUMN");
            String oldColumnName = this.parseName(tokens);
            tokens.consume("TO");
            String newColumnName = this.parseName(tokens);
            AstNode renameColumnNode = this.nodeFactory().node(oldColumnName, alterTableNode, PostgresDdlLexicon.TYPE_RENAME_COLUMN);
            renameColumnNode.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newColumnName);
        } else if (tokens.canConsume("SET", new String[]{"SCHEMA"})) {
            String schemaName = this.parseName(tokens);
            alterTableNode.setProperty(PostgresDdlLexicon.SCHEMA_NAME, (Object)schemaName);
        } else {
            System.out.println("  WARNING:  Option not found for ALTER TABLE. Check your DDL for incomplete statement.");
        }
    }

    private void parseSingleCommaTerminatedColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, StandardDdlLexicon.TYPE_COLUMN_DEFINITION);
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        while (tokens.hasNext() && !tokens.matches(this.getTerminator()) && !tokens.matches(128)) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                this.parseCollateClause(tokens, columnNode);
                this.parseColumnConstraint(tokens, columnNode, isAlterTable);
            }
            this.consumeComment(tokens);
            if (!tokens.matches(",")) continue;
            break;
        }
    }

    @Override
    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateSchemaStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_TEMP_TABLE) || tokens.matches(STMT_CREATE_GLOBAL_TEMP_TABLE) || tokens.matches(STMT_CREATE_LOCAL_TEMP_TABLE)) {
            return this.parseCreateTableStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_CREATE_AGGREGATE, parentNode, PostgresDdlLexicon.TYPE_CREATE_AGGREGATE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_CAST)) {
            return this.parseStatement(tokens, STMT_CREATE_CAST, parentNode, PostgresDdlLexicon.TYPE_CREATE_CAST_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_CONSTRAINT_TRIGGER)) {
            return this.parseStatement(tokens, STMT_CREATE_CONSTRAINT_TRIGGER, parentNode, PostgresDdlLexicon.TYPE_CREATE_CONSTRAINT_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_CONVERSION)) {
            return this.parseStatement(tokens, STMT_CREATE_CONVERSION, parentNode, PostgresDdlLexicon.TYPE_CREATE_CONVERSION_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_DATABASE, parentNode, PostgresDdlLexicon.TYPE_CREATE_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_FOREIGN_DATA_WRAPPER)) {
            return this.parseStatement(tokens, STMT_CREATE_FOREIGN_DATA_WRAPPER, parentNode, PostgresDdlLexicon.TYPE_CREATE_FOREIGN_DATA_WRAPPER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_GROUP)) {
            return this.parseStatement(tokens, STMT_CREATE_GROUP, parentNode, PostgresDdlLexicon.TYPE_CREATE_GROUP_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_INDEX)) {
            return this.parseStatement(tokens, STMT_CREATE_INDEX, parentNode, PostgresDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_UNIQUE_INDEX)) {
            return this.parseStatement(tokens, STMT_CREATE_UNIQUE_INDEX, parentNode, PostgresDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_CREATE_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TRUSTED_PROCEDURAL_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_TRUSTED_PROCEDURAL_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_CREATE_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PROCEDURAL_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_PROCEDURAL_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_CREATE_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OPERATOR)) {
            return this.parseStatement(tokens, STMT_CREATE_OPERATOR, parentNode, PostgresDdlLexicon.TYPE_CREATE_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_ROLE)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLE, parentNode, PostgresDdlLexicon.TYPE_CREATE_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_RULE) || tokens.matches(STMT_CREATE_OR_REPLACE_RULE)) {
            return this.parseCreateRuleStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_CREATE_SEQUENCE, parentNode, PostgresDdlLexicon.TYPE_CREATE_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_SERVER)) {
            return this.parseStatement(tokens, STMT_CREATE_SERVER, parentNode, PostgresDdlLexicon.TYPE_CREATE_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_CREATE_TABLESPACE, parentNode, PostgresDdlLexicon.TYPE_CREATE_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TEXT_SEARCH)) {
            return this.parseStatement(tokens, STMT_CREATE_TEXT_SEARCH, parentNode, PostgresDdlLexicon.TYPE_CREATE_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseStatement(tokens, STMT_CREATE_TRIGGER, parentNode, PostgresDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_TYPE, parentNode, PostgresDdlLexicon.TYPE_CREATE_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_CREATE_USER_MAPPING, parentNode, PostgresDdlLexicon.TYPE_CREATE_USER_MAPPING_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_USER)) {
            return this.parseStatement(tokens, STMT_CREATE_USER, parentNode, PostgresDdlLexicon.TYPE_CREATE_USER_STATEMENT);
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        tokens.canConsumeAnyOf("LOCAL", new String[]{"GLOBAL"});
        tokens.canConsumeAnyOf("TEMP", new String[]{"TEMPORARY"});
        tokens.consume("TABLE");
        String tableName = this.parseName(tokens);
        AstNode tableNode = this.nodeFactory().node(tableName, parentNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        this.parseColumnsAndConstraints(tokens, tableNode);
        this.parseCreateTableOptions(tokens, tableNode);
        this.markEndOfStatement(tokens, tableNode);
        return tableNode;
    }

    @Override
    protected void parseNextCreateTableOption(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.canConsume("ON", new String[]{"COMMIT"})) {
            tokens.canConsume("PRESERVE", new String[]{"ROWS"});
            tokens.canConsume("DELETE", new String[]{"ROWS"});
            tokens.canConsume("DROP");
        } else if (tokens.canConsume("TABLESPACE")) {
            tokens.consume();
        } else if (!tokens.canConsume("WITH", new String[]{"OIDS"}) && !tokens.canConsume("WITHOUT", new String[]{"OUDS"})) {
            if (tokens.canConsume("WITH")) {
                if (tokens.matches("(")) {
                    this.consumeParenBoundedTokens(tokens, true);
                } else {
                    tokens.canConsume("NO");
                    tokens.canConsume("DATA");
                }
            } else if (tokens.canConsume("AS")) {
                this.parseUntilTerminator(tokens);
            }
        }
    }

    @Override
    protected boolean areNextTokensCreateTableOptions(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        boolean result = false;
        if (tokens.matches("ON", new String[]{"COMMIT"}) || tokens.matches("TABLESPACE") || tokens.matches("WITH") || tokens.matches("WITHOUT") || tokens.matches("AS")) {
            result = true;
        }
        return result;
    }

    @Override
    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateViewStatement(tokens, parentNode);
    }

    @Override
    protected boolean parseDefaultClause(DdlTokenStream tokens, AstNode columnNode) {
        assert (tokens != null);
        assert (columnNode != null);
        String defaultValue = "";
        if (tokens.matchesAnyOf("WITH", new String[]{"DEFAULT"})) {
            if (tokens.matches("WITH")) {
                tokens.consume();
            }
            tokens.consume("DEFAULT");
            int optionID = -1;
            int precision = -1;
            if (tokens.canConsume("CURRENT_DATE")) {
                optionID = 1;
                defaultValue = "CURRENT_DATE";
            } else if (tokens.canConsume("CURRENT_TIME")) {
                optionID = 1;
                defaultValue = "CURRENT_TIME";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("CURRENT_TIMESTAMP")) {
                optionID = 1;
                defaultValue = "CURRENT_TIMESTAMP";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("USER")) {
                optionID = 2;
                defaultValue = "USER";
            } else if (tokens.canConsume("CURRENT_USER")) {
                optionID = 3;
                defaultValue = "CURRENT_USER";
            } else if (tokens.canConsume("SESSION_USER")) {
                optionID = 4;
                defaultValue = "SESSION_USER";
            } else if (tokens.canConsume("SYSTEM_USER")) {
                optionID = 5;
                defaultValue = "SYSTEM_USER";
            } else if (tokens.canConsume("NULL")) {
                optionID = 6;
                defaultValue = "NULL";
            } else if (tokens.canConsume("(")) {
                optionID = 0;
                while (!tokens.canConsume(")")) {
                    defaultValue = defaultValue + tokens.consume();
                }
            } else if (tokens.matches("NOW")) {
                optionID = 0;
                tokens.consume("NOW");
                tokens.consume('(');
                tokens.consume(')');
                defaultValue = "NOW()";
            } else if (tokens.matches("NEXTVAL")) {
                optionID = 0;
                defaultValue = tokens.consume() + this.consumeParenBoundedTokens(tokens, true);
            } else {
                optionID = 0;
                defaultValue = tokens.consume();
                if (tokens.canConsume(".")) {
                    defaultValue = defaultValue + '.' + tokens.consume();
                }
            }
            columnNode.setProperty(StandardDdlLexicon.DEFAULT_OPTION, (Object)optionID);
            columnNode.setProperty(StandardDdlLexicon.DEFAULT_VALUE, (Object)defaultValue);
            if (precision > -1) {
                columnNode.setProperty(StandardDdlLexicon.DEFAULT_PRECISION, (Object)precision);
            }
            return true;
        }
        return false;
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_COMMENT_ON)) {
            return this.parseCommentStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_ABORT)) {
            return this.parseStatement(tokens, STMT_ABORT, parentNode, PostgresDdlLexicon.TYPE_ABORT_STATEMENT);
        }
        if (tokens.matches(STMT_ANALYZE)) {
            return this.parseStatement(tokens, STMT_ANALYZE, parentNode, PostgresDdlLexicon.TYPE_ANALYZE_STATEMENT);
        }
        if (tokens.matches(STMT_CLUSTER)) {
            return this.parseStatement(tokens, STMT_CLUSTER, parentNode, PostgresDdlLexicon.TYPE_CLUSTER_STATEMENT);
        }
        if (tokens.matches(STMT_COPY)) {
            return this.parseStatement(tokens, STMT_COPY, parentNode, PostgresDdlLexicon.TYPE_COPY_STATEMENT);
        }
        if (tokens.matches(STMT_DEALLOCATE_PREPARE)) {
            return this.parseStatement(tokens, STMT_DEALLOCATE_PREPARE, parentNode, PostgresDdlLexicon.TYPE_DEALLOCATE_STATEMENT);
        }
        if (tokens.matches(STMT_DEALLOCATE)) {
            return this.parseStatement(tokens, STMT_DEALLOCATE, parentNode, PostgresDdlLexicon.TYPE_DEALLOCATE_STATEMENT);
        }
        if (tokens.matches(STMT_DECLARE)) {
            return this.parseStatement(tokens, STMT_DECLARE, parentNode, PostgresDdlLexicon.TYPE_DECLARE_STATEMENT);
        }
        if (tokens.matches(STMT_EXPLAIN_ANALYZE)) {
            return this.parseStatement(tokens, STMT_EXPLAIN_ANALYZE, parentNode, PostgresDdlLexicon.TYPE_EXPLAIN_STATEMENT);
        }
        if (tokens.matches(STMT_EXPLAIN)) {
            return this.parseStatement(tokens, STMT_EXPLAIN, parentNode, PostgresDdlLexicon.TYPE_EXPLAIN_STATEMENT);
        }
        if (tokens.matches(STMT_FETCH)) {
            return this.parseStatement(tokens, STMT_FETCH, parentNode, PostgresDdlLexicon.TYPE_FETCH_STATEMENT);
        }
        if (tokens.matches(STMT_LISTEN)) {
            return this.parseStatement(tokens, STMT_LISTEN, parentNode, PostgresDdlLexicon.TYPE_LISTEN_STATEMENT);
        }
        if (tokens.matches(STMT_LOAD)) {
            return this.parseStatement(tokens, STMT_LOAD, parentNode, PostgresDdlLexicon.TYPE_LOAD_STATEMENT);
        }
        if (tokens.matches(STMT_LOCK_TABLE)) {
            return this.parseStatement(tokens, STMT_LOCK_TABLE, parentNode, PostgresDdlLexicon.TYPE_LOCK_TABLE_STATEMENT);
        }
        if (tokens.matches(STMT_MOVE)) {
            return this.parseStatement(tokens, STMT_MOVE, parentNode, PostgresDdlLexicon.TYPE_MOVE_STATEMENT);
        }
        if (tokens.matches(STMT_NOTIFY)) {
            return this.parseStatement(tokens, STMT_NOTIFY, parentNode, PostgresDdlLexicon.TYPE_NOTIFY_STATEMENT);
        }
        if (tokens.matches(STMT_PREPARE)) {
            return this.parseStatement(tokens, STMT_PREPARE, parentNode, PostgresDdlLexicon.TYPE_PREPARE_STATEMENT);
        }
        if (tokens.matches(STMT_REASSIGN_OWNED)) {
            return this.parseStatement(tokens, STMT_REASSIGN_OWNED, parentNode, PostgresDdlLexicon.TYPE_REASSIGN_OWNED_STATEMENT);
        }
        if (tokens.matches(STMT_REINDEX)) {
            return this.parseStatement(tokens, STMT_REINDEX, parentNode, PostgresDdlLexicon.TYPE_REINDEX_STATEMENT);
        }
        if (tokens.matches(STMT_RELEASE_SAVEPOINT)) {
            return this.parseStatement(tokens, STMT_RELEASE_SAVEPOINT, parentNode, PostgresDdlLexicon.TYPE_RELEASE_SAVEPOINT_STATEMENT);
        }
        if (tokens.matches(STMT_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_ROLLBACK, parentNode, PostgresDdlLexicon.TYPE_ROLLBACK_STATEMENT);
        }
        if (tokens.matches(STMT_SELECT_INTO)) {
            return this.parseStatement(tokens, STMT_SELECT_INTO, parentNode, PostgresDdlLexicon.TYPE_SELECT_INTO_STATEMENT);
        }
        if (tokens.matches(STMT_SHOW)) {
            return this.parseStatement(tokens, STMT_SHOW, parentNode, PostgresDdlLexicon.TYPE_SHOW_STATEMENT);
        }
        if (tokens.matches(STMT_TRUNCATE)) {
            return this.parseStatement(tokens, STMT_TRUNCATE, parentNode, PostgresDdlLexicon.TYPE_TRUNCATE_STATEMENT);
        }
        if (tokens.matches(STMT_UNLISTEN)) {
            return this.parseStatement(tokens, STMT_UNLISTEN, parentNode, PostgresDdlLexicon.TYPE_UNLISTEN_STATEMENT);
        }
        if (tokens.matches(STMT_VACUUM)) {
            return this.parseStatement(tokens, STMT_VACUUM, parentNode, PostgresDdlLexicon.TYPE_VACUUM_STATEMENT);
        }
        return super.parseCustomStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_DROP_AGGREGATE, parentNode, PostgresDdlLexicon.TYPE_DROP_AGGREGATE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_CAST)) {
            return this.parseStatement(tokens, STMT_DROP_CAST, parentNode, PostgresDdlLexicon.TYPE_DROP_CAST_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_CONSTRAINT_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_CONSTRAINT_TRIGGER, parentNode, PostgresDdlLexicon.TYPE_DROP_CONSTRAINT_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_CONVERSION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_CONVERSION, parentNode, PostgresDdlLexicon.TYPE_DROP_CONVERSION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_DATABASE, parentNode, PostgresDdlLexicon.TYPE_DROP_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_FOREIGN_DATA_WRAPPER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_FOREIGN_DATA_WRAPPER, parentNode, PostgresDdlLexicon.TYPE_DROP_FOREIGN_DATA_WRAPPER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, PostgresDdlLexicon.TYPE_DROP_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_GROUP)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_GROUP, parentNode, PostgresDdlLexicon.TYPE_DROP_GROUP_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_INDEX, parentNode, PostgresDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_LANGUAGE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_DROP_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PROCEDURAL_LANGUAGE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_PROCEDURAL_LANGUAGE, parentNode, PostgresDdlLexicon.TYPE_DROP_LANGUAGE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_OPERATOR)) {
            return this.parseStatement(tokens, STMT_DROP_OPERATOR, parentNode, PostgresDdlLexicon.TYPE_DROP_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_OWNED_BY)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_OWNED_BY, parentNode, PostgresDdlLexicon.TYPE_DROP_OWNED_BY_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_ROLE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_ROLE, parentNode, PostgresDdlLexicon.TYPE_DROP_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_RULE)) {
            return this.parseStatement(tokens, STMT_DROP_RULE, parentNode, PostgresDdlLexicon.TYPE_DROP_RULE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SEQUENCE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SEQUENCE, parentNode, PostgresDdlLexicon.TYPE_DROP_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SERVER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SERVER, parentNode, PostgresDdlLexicon.TYPE_DROP_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TABLESPACE, parentNode, PostgresDdlLexicon.TYPE_DROP_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_CONFIGURATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_CONFIGURATION, parentNode, PostgresDdlLexicon.TYPE_DROP_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_DICTIONARY)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_DICTIONARY, parentNode, PostgresDdlLexicon.TYPE_DROP_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_PARSER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_PARSER, parentNode, PostgresDdlLexicon.TYPE_DROP_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_TEMPLATE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_TEMPLATE, parentNode, PostgresDdlLexicon.TYPE_DROP_TEXT_SEARCH_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, PostgresDdlLexicon.TYPE_DROP_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TYPE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TYPE, parentNode, PostgresDdlLexicon.TYPE_DROP_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_DROP_USER_MAPPING, parentNode, PostgresDdlLexicon.TYPE_DROP_USER_MAPPING_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_USER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_USER, parentNode, PostgresDdlLexicon.TYPE_DROP_USER_STATEMENT);
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_DOMAIN)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_DOMAIN, parentNode, StandardDdlLexicon.TYPE_DROP_DOMAIN_STATEMENT);
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_TABLE)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_TABLE, parentNode, StandardDdlLexicon.TYPE_DROP_TABLE_STATEMENT);
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_VIEW)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_VIEW, parentNode, StandardDdlLexicon.TYPE_DROP_VIEW_STATEMENT);
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_SCHEMA)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_SCHEMA, parentNode, StandardDdlLexicon.TYPE_DROP_SCHEMA_STATEMENT);
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    private AstNode parseSimpleDropStatement(DdlTokenStream tokens, String[] startPhrase, AstNode parentNode, Name stmtType) throws ParsingException {
        assert (tokens != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String behavior = null;
        tokens.consume(startPhrase);
        boolean usesIfExists = tokens.canConsume("IF", new String[]{"EXISTS"});
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.parseName(tokens));
        while (tokens.matches(",")) {
            tokens.consume(",");
            nameList.add(this.parseName(tokens));
        }
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        AstNode dropNode = this.nodeFactory().node((String)nameList.get(0), parentNode, stmtType);
        if (behavior != null) {
            dropNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)behavior);
        }
        this.markEndOfStatement(tokens, dropNode);
        String originalExpression = (String)dropNode.getProperty(StandardDdlLexicon.DDL_EXPRESSION).getFirstValue();
        Object startLineNumber = dropNode.getProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER).getFirstValue();
        Object startColumnNumber = dropNode.getProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER).getFirstValue();
        Object startCharIndex = dropNode.getProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX).getFirstValue();
        if (nameList.size() > 1) {
            for (int i = 1; i < nameList.size(); ++i) {
                String nextName = (String)nameList.get(i);
                AstNode newNode = this.createSingleDropNode(nextName, startPhrase, originalExpression, usesIfExists, behavior, stmtType, parentNode);
                newNode.setProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER, startLineNumber);
                newNode.setProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER, startColumnNumber);
                newNode.setProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX, startCharIndex);
            }
            StringBuffer sb = new StringBuffer().append(this.getStatementTypeName(startPhrase));
            if (usesIfExists) {
                sb.append(" ").append("IF EXISTS");
            }
            sb.append(" ").append((String)nameList.get(0));
            if (behavior != null) {
                sb.append(" ").append(behavior);
            }
            sb.append(TERMINATOR);
            dropNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)sb.toString());
            dropNode.setProperty(StandardDdlLexicon.DDL_ORIGINAL_EXPRESSION, (Object)originalExpression);
        }
        return dropNode;
    }

    private AstNode createSingleDropNode(String name, String[] startPhrase, String originalExpression, boolean usesIfExists, String behavior, Name nodeType, AstNode parentNode) {
        assert (name != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (nodeType != null);
        assert (parentNode != null);
        AstNode newNode = this.nodeFactory().node(name, parentNode, nodeType);
        StringBuffer sb = new StringBuffer().append(this.getStatementTypeName(startPhrase));
        if (usesIfExists) {
            sb.append(" ").append("IF EXISTS");
        }
        sb.append(" ").append(name);
        if (behavior != null) {
            sb.append(" ").append(behavior);
        }
        sb.append(TERMINATOR);
        newNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)sb.toString());
        newNode.setProperty(StandardDdlLexicon.DDL_ORIGINAL_EXPRESSION, (Object)originalExpression);
        return newNode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        void var9_12;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("GRANT"));
        this.markStartOfStatement(tokens);
        List<Object> grantNodes = new ArrayList<AstNode>();
        boolean allPrivileges = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("GRANT");
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        if (allPrivileges || !privileges.isEmpty()) {
            tokens.consume("ON");
            if (tokens.canConsume("SCHEMA")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_SCHEMA_STATEMENT);
            } else if (tokens.canConsume("SEQUENCE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_SEQUENCE_STATEMENT);
            } else if (tokens.canConsume("TABLESPACE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_TABLESPACE_STATEMENT);
            } else if (tokens.canConsume("DATABASE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_DATABASE_STATEMENT);
            } else if (tokens.canConsume("FUNCTION")) {
                grantNodes = this.parseFunctionAndParameters(tokens, parentNode);
            } else if (tokens.canConsume("LANGUAGE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_LANGUAGE_STATEMENT);
            } else if (tokens.canConsume("FOREIGN", new String[]{"DATA", "WRAPPER"})) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_FOREIGN_DATA_WRAPPER_STATEMENT);
            } else if (tokens.canConsume("FOREIGN", new String[]{"SERVER"})) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_FOREIGN_SERVER_STATEMENT);
            } else {
                tokens.canConsume("TABLE");
                String name = this.parseName(tokens);
                AstNode grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_TABLE_STATEMENT);
                grantNodes.add(grantNode);
                while (tokens.canConsume(",")) {
                    name = this.parseName(tokens);
                    grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_TABLE_STATEMENT);
                    grantNodes.add(grantNode);
                }
            }
        } else {
            AstNode grantNode = this.nodeFactory().node("roles", parentNode, PostgresDdlLexicon.TYPE_GRANT_ROLES_STATEMENT);
            grantNodes.add(grantNode);
            do {
                String role = this.parseName(tokens);
                this.nodeFactory().node(role, grantNode, PostgresDdlLexicon.ROLE);
            } while (tokens.canConsume(","));
        }
        tokens.consume("TO");
        ArrayList<String> grantees = new ArrayList<String>();
        do {
            String grantee = this.parseName(tokens);
            grantees.add(grantee);
        } while (tokens.canConsume(","));
        boolean withGrantOption = false;
        if (tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"})) {
            withGrantOption = true;
        }
        for (AstNode astNode : grantNodes) {
            List<AstNode> copyOfPrivileges = this.copyOfPrivileges(privileges);
            for (AstNode node : copyOfPrivileges) {
                node.setParent(astNode);
            }
            if (allPrivileges) {
                astNode.setProperty(StandardDdlLexicon.ALL_PRIVILEGES, (Object)allPrivileges);
            }
            for (String grantee : grantees) {
                this.nodeFactory().node(grantee, astNode, StandardDdlLexicon.GRANTEE);
            }
            if (!withGrantOption) continue;
            AstNode optionNode = this.nodeFactory().node("withGrant", astNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)"WITH GRANT OPTION");
        }
        AstNode firstGrantNode = (AstNode)grantNodes.get(0);
        this.markEndOfStatement(tokens, firstGrantNode);
        boolean bl = true;
        while (var9_12 < grantNodes.size()) {
            AstNode grantNode = (AstNode)grantNodes.get((int)var9_12);
            grantNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)firstGrantNode.getProperty(StandardDdlLexicon.DDL_EXPRESSION));
            grantNode.setProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER, (Object)firstGrantNode.getProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER));
            grantNode.setProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX, (Object)firstGrantNode.getProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX));
            grantNode.setProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER, (Object)firstGrantNode.getProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER));
            ++var9_12;
        }
        return (AstNode)grantNodes.get(0);
    }

    @Override
    protected void parseGrantPrivileges(DdlTokenStream tokens, List<AstNode> privileges) throws ParsingException {
        do {
            AstNode node = null;
            if (tokens.canConsume("DELETE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"DELETE");
            } else if (tokens.canConsume("INSERT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"INSERT");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("REFERENCES")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"REFERENCES");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("SELECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"SELECT");
                this.consumeParenBoundedTokens(tokens, true);
            } else if (tokens.canConsume("USAGE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"USAGE");
            } else if (tokens.canConsume("UPDATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"UPDATE");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("TRIGGER")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"TRIGGER");
            } else if (tokens.canConsume("TRUNCATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"TRUNCATE");
            } else if (tokens.canConsume("CREATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"CREATE");
            } else if (tokens.canConsume("CONNECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"CONNECT");
            } else if (tokens.canConsume("TEMPORARY")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"TEMPORARY");
            } else if (tokens.canConsume("TEMP")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"TEMP");
            } else if (tokens.canConsume("EXECUTE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"EXECUTE");
            }
            if (node == null) break;
            this.nodeFactory().setType(node, StandardDdlLexicon.GRANT_PRIVILEGE);
            privileges.add(node);
        } while (tokens.canConsume(","));
    }

    private List<AstNode> parseMultipleGrantTargets(DdlTokenStream tokens, AstNode parentNode, Name nodeType) throws ParsingException {
        ArrayList<AstNode> grantNodes = new ArrayList<AstNode>();
        String name = this.parseName(tokens);
        AstNode grantNode = this.nodeFactory().node(name, parentNode, nodeType);
        grantNodes.add(grantNode);
        while (tokens.canConsume(",")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, nodeType);
            grantNodes.add(grantNode);
        }
        return grantNodes;
    }

    private List<AstNode> copyOfPrivileges(List<AstNode> privileges) {
        ArrayList<AstNode> copyOfPrivileges = new ArrayList<AstNode>();
        for (AstNode node : privileges) {
            copyOfPrivileges.add(node.clone());
        }
        return copyOfPrivileges;
    }

    private List<AstNode> parseFunctionAndParameters(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean isFirstFunction = true;
        ArrayList<AstNode> grantNodes = new ArrayList<AstNode>();
        do {
            String name = this.parseName(tokens);
            AstNode grantFunctionNode = this.nodeFactory().node(name, parentNode, PostgresDdlLexicon.TYPE_GRANT_ON_FUNCTION_STATEMENT);
            grantNodes.add(grantFunctionNode);
            if (tokens.matches("(")) {
                tokens.consume("(");
                if (!tokens.canConsume(")")) {
                    do {
                        String mode = null;
                        if (tokens.matchesAnyOf("IN", new String[]{"OUT", "INOUT", "VARIADIC"})) {
                            mode = tokens.consume();
                        }
                        AstNode paramNode = null;
                        DataType dType = this.getDatatypeParser().parse(tokens);
                        if (dType != null) {
                            paramNode = this.nodeFactory().node("parameter", grantFunctionNode, PostgresDdlLexicon.FUNCTION_PARAMETER);
                            if (mode != null) {
                                paramNode.setProperty(PostgresDdlLexicon.FUNCTION_PARAMETER_MODE, (Object)mode);
                            }
                            this.getDatatypeParser().setPropertiesOnNode(paramNode, dType);
                            continue;
                        }
                        String paramName = this.parseName(tokens);
                        dType = this.getDatatypeParser().parse(tokens);
                        assert (paramName != null);
                        paramNode = this.nodeFactory().node(paramName, grantFunctionNode, PostgresDdlLexicon.FUNCTION_PARAMETER);
                        if (mode != null) {
                            paramNode.setProperty(PostgresDdlLexicon.FUNCTION_PARAMETER_MODE, (Object)mode);
                        }
                        if (dType == null) continue;
                        this.getDatatypeParser().setPropertiesOnNode(paramNode, dType);
                    } while (tokens.canConsume(","));
                    tokens.consume(")");
                }
            }
            if (!isFirstFunction) continue;
            isFirstFunction = false;
        } while (tokens.canConsume(","));
        return grantNodes;
    }

    @Override
    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseSetStatement(tokens, parentNode);
    }

    private AstNode parseCommentStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("COMMENT", new String[]{"ON"});
        String objectType = null;
        String objectName = null;
        if (tokens.matches("TABLE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("COLUMN")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("AGGREGATE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("CAST")) {
            objectType = tokens.consume();
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("CONSTRAINT")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("CONVERSION")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("DATABASE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("DOMAIN")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("FUNCTION")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("INDEX")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("LARGE", new String[]{"OBJECT"})) {
            tokens.consume("LARGE", new String[]{"OBJECT"});
            objectType = "LARGE OBJECT";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("OPERATOR", new String[]{"FAMILY"})) {
            tokens.consume("OPERATOR", new String[]{"FAMILY"});
            objectType = "OPERATOR FAMILY";
            objectName = this.parseName(tokens);
            tokens.consume("USING");
            tokens.consume();
        } else if (tokens.matches("OPERATOR", new String[]{"CLASS"})) {
            tokens.consume("OPERATOR", new String[]{"CLASS"});
            objectType = "OPERATOR CLASS";
            objectName = this.parseName(tokens);
            tokens.consume("USING");
            tokens.consume();
        } else if (tokens.matches("OPERATOR")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("PROCEDURAL", new String[]{"LANGUAGE"})) {
            tokens.consume("PROCEDURAL", new String[]{"LANGUAGE"});
            objectType = "PROCEDURAL LANGUAGE";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("LANGUAGE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("ROLE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("RULE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("SCHEMA")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("SEQUENCE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TABLESPACE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "CONFIGURATION"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "CONFIGURATION"});
            objectType = "TEXT SEARCH CONFIGURATION";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "DICTIONARY"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "DICTIONARY"});
            objectType = "TEXT SEARCH DICTIONARY";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "PARSER"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "PARSER"});
            objectType = "TEXT SEARCH PARSER";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "TEMPLATE"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "TEMPLATE"});
            objectType = "TEXT SEARCH TEMPLATE";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TRIGGER")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("TYPE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("VIEW")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        }
        String commentString = null;
        tokens.consume("IS");
        if (tokens.matches("NULL")) {
            tokens.consume("NULL");
            commentString = "NULL";
        } else {
            commentString = this.parseUntilTerminator(tokens).trim();
        }
        AstNode commentNode = null;
        if (objectName != null) {
            commentNode = this.nodeFactory().node(objectName, parentNode, PostgresDdlLexicon.TYPE_COMMENT_ON_STATEMENT);
            commentNode.setProperty(PostgresDdlLexicon.TARGET_OBJECT_NAME, (Object)objectName);
        } else {
            commentNode = this.nodeFactory().node("commentOn", parentNode, PostgresDdlLexicon.TYPE_COMMENT_ON_STATEMENT);
        }
        commentNode.setProperty(PostgresDdlLexicon.COMMENT, (Object)commentString);
        commentNode.setProperty(PostgresDdlLexicon.TARGET_OBJECT_TYPE, (Object)objectType);
        this.markEndOfStatement(tokens, commentNode);
        return commentNode;
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuffer unusedTokensSB = new StringBuffer();
        do {
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, isAlterTable);
                continue;
            }
            unusedTokensSB.append(" ").append(localTokens.consume());
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getProperty(StandardDdlLexicon.NAME)});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    private AstNode parseCreateRuleStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_RULE);
        tokens.canConsume(STMT_CREATE_RULE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, PostgresDdlLexicon.TYPE_CREATE_RULE_STATEMENT);
        if (isReplace) {
            // empty if block
        }
        this.parseUntilTerminatorIgnoreEmbeddedStatements(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateFunctionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_FUNCTION);
        tokens.canConsume(STMT_CREATE_FUNCTION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, PostgresDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT);
        if (isReplace) {
            // empty if block
        }
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected Name[] getValidSchemaChildTypes() {
        return PostgresDdlConstants.PostgresStatementStartPhrases.VALID_SCHEMA_CHILD_STMTS;
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class PostgresDataTypeParser
    extends DataTypeParser {
        PostgresDataTypeParser() {
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmts : postgresDataTypeStrings) {
                if (!tokens.matches(stmts)) continue;
                return true;
            }
            return super.isCustomDataType(tokens);
        }

        @Override
        protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType result = null;
            String typeName = null;
            if (tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_FLOAT4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_FLOAT8)) {
                typeName = tokens.consume();
                result = new DataType(typeName);
                int precision = 0;
                if (tokens.matches('(')) {
                    precision = this.parseBracketedInteger(tokens, result);
                }
                result.setPrecision(precision);
            }
            if (result == null) {
                result = super.parseApproxNumericType(tokens);
            }
            return result;
        }

        @Override
        protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
            return super.parseBitStringType(tokens);
        }

        @Override
        protected int parseBracketedInteger(DdlTokenStream tokens, DataType dataType) {
            return super.parseBracketedInteger(tokens, dataType);
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType result = super.parseCharStringType(tokens);
            tokens.canConsume("FOR", new String[]{"BIT", "DATA"});
            return result;
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType result = null;
            String typeName = null;
            if (tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BIGSERIAL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL8) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT2) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT8) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOX) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOOL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOOLEAN) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BYTEA) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_CIDR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_CIRCLE) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INET) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_LINE) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_LSEG) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_MACADDR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_MONEY) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_PATH) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_POINT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_POLYGON) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TEXT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TSQUERY) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TSVECTOR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TXID_SNAPSHOT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_UUID) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_VARBIT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_XML)) {
                typeName = tokens.consume();
                result = new DataType(typeName);
            }
            if (result == null) {
                super.parseCustomType(tokens);
            }
            return result;
        }

        @Override
        protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
            DataType dtype = super.parseDateTimeType(tokens);
            tokens.canConsume("WITHOUT", new String[]{"TIME", "ZONE"});
            return dtype;
        }

        @Override
        protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
            return super.parseExactNumericType(tokens);
        }
    }
}

