/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.node.AstNode;

@NotThreadSafe
public class DdlSequencer
implements StreamSequencer {
    protected static final String[] DEFAULT_CLASSPATH = new String[0];
    protected static final List<String> DEFAULT_GRAMMARS;
    protected static final Map<String, DdlParser> STANDARD_PARSERS_BY_NAME;
    private String[] parserGrammars = DEFAULT_GRAMMARS.toArray(new String[DEFAULT_GRAMMARS.size()]);
    private String[] classpath = DEFAULT_CLASSPATH;

    public String[] getGrammars() {
        return this.parserGrammars;
    }

    public void setGrammars(String[] grammarNamesOrClasses) {
        this.parserGrammars = grammarNamesOrClasses != null && grammarNamesOrClasses.length != 0 ? grammarNamesOrClasses : DEFAULT_GRAMMARS.toArray(new String[DEFAULT_GRAMMARS.size()]);
    }

    public String[] getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String[] classpath) {
        this.classpath = classpath != null ? classpath : DEFAULT_CLASSPATH;
    }

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        try {
            String fileName = this.getNameOfDdlContent(context);
            DdlParsers parsers = this.createParsers(this.getParserList(context));
            AstNode rootNode = parsers.parse(IoUtil.read((InputStream)stream), fileName);
            LinkedList<AstNode> queue = new LinkedList<AstNode>();
            queue.add(rootNode);
            while (queue.peek() != null) {
                AstNode astNode = (AstNode)queue.poll();
                Path path = astNode.getPath((ExecutionContext)context);
                for (Property property : astNode.getProperties()) {
                    output.setProperty(path, property.getName(), property.getValuesAsArray());
                }
                for (AstNode child : astNode.getChildren()) {
                    queue.add(child);
                }
            }
        }
        catch (ParsingException e) {
            context.getProblems().addError((Throwable)e, DdlSequencerI18n.errorParsingDdlContent, new Object[]{e.getLocalizedMessage()});
        }
        catch (IOException e) {
            context.getProblems().addError((Throwable)e, DdlSequencerI18n.errorSequencingDdlContent, new Object[]{e.getLocalizedMessage()});
        }
    }

    protected DdlParsers createParsers(List<DdlParser> parsers) {
        return new DdlParsers(parsers);
    }

    protected String getNameOfDdlContent(StreamSequencerContext context) {
        Path inputPath = context.getInputPath();
        if (inputPath.isRoot()) {
            return null;
        }
        Path.Segment segment = inputPath.getLastSegment();
        if (JcrLexicon.CONTENT.equals(segment.getName()) && inputPath.size() > 1) {
            segment = inputPath.getParent().getLastSegment();
        }
        return segment.getName().getLocalName();
    }

    protected List<DdlParser> getParserList(StreamSequencerContext context) {
        LinkedList<DdlParser> parserList = new LinkedList<DdlParser>();
        for (String grammar : this.getGrammars()) {
            if (grammar == null) continue;
            String lowercaseGrammar = grammar.toLowerCase();
            DdlParser parser = STANDARD_PARSERS_BY_NAME.get(lowercaseGrammar);
            if (parser == null) {
                String[] classpath = this.getClasspath();
                try {
                    ClassLoader classloader = context.getClassLoader(classpath);
                    Class<?> componentClass = Class.forName(grammar, true, classloader);
                    parser = (DdlParser)componentClass.newInstance();
                }
                catch (Throwable e) {
                    if (classpath == null || classpath.length == 0) {
                        context.getProblems().addError(e, DdlSequencerI18n.errorInstantiatingParserForGrammarUsingDefaultClasspath, new Object[]{grammar, e.getLocalizedMessage()});
                    }
                    context.getProblems().addError(e, DdlSequencerI18n.errorInstantiatingParserForGrammarClasspath, new Object[]{grammar, classpath, e.getLocalizedMessage()});
                }
            }
            if (parser == null) continue;
            parserList.add(parser);
        }
        return parserList;
    }

    static {
        ArrayList<String> grammarNames = new ArrayList<String>();
        HashMap<String, DdlParser> parsersByName = new HashMap<String, DdlParser>();
        for (DdlParser parser : DdlParsers.BUILTIN_PARSERS) {
            String grammarName = parser.getId().toLowerCase();
            grammarNames.add(grammarName);
            parsersByName.put(grammarName, parser);
        }
        DEFAULT_GRAMMARS = Collections.unmodifiableList(grammarNames);
        STANDARD_PARSERS_BY_NAME = Collections.unmodifiableMap(parsersByName);
    }
}

