/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class DdlParserTestHelper
implements DdlConstants {
    private boolean printToConsole = false;
    public static final String NEWLINE = "\n";
    protected StandardDdlParser parser;
    protected AstNode rootNode;
    protected DdlParserScorer scorer;

    public void printTest(String value) {
        if (this.printToConsole) {
            System.out.println("TEST:  " + value);
        }
    }

    public void printResult(String value) {
        if (this.printToConsole) {
            System.out.println(value);
        }
    }

    public boolean isPrintToConsole() {
        return this.printToConsole;
    }

    public void setPrintToConsole(boolean printToConsole) {
        this.printToConsole = printToConsole;
    }

    public boolean hasMixinType(Property mixins, Name mixinType) {
        for (Object prop : mixins.getValuesAsArray()) {
            if (!(prop instanceof Name) || !prop.equals(mixinType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContent(String filePath) {
        StringBuilder sb = new StringBuilder(1000);
        if (this.isPrintToConsole()) {
            System.out.println("   Getting Content for File = " + filePath);
        }
        if (filePath != null && filePath.length() > 0) {
            FileReader fr = null;
            BufferedReader in = null;
            try {
                fr = new FileReader(filePath);
                in = new BufferedReader(fr);
                int ch = in.read();
                while (ch > -1) {
                    sb.append((char)ch);
                    ch = in.read();
                }
            }
            catch (Exception e) {
                System.out.print(e);
            }
            finally {
                try {
                    fr.close();
                }
                catch (IOException e) {}
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }

    public void printUnknownStatements(StandardDdlParser parser, AstNode rootNode) {
        this.printResult("============== UNKNOWN STATEMENTS =======================\n");
        List unknownNodes = parser.nodeFactory().getChildrenForType(rootNode, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT);
        for (AstNode node : unknownNodes) {
            this.printResult(node.toString());
        }
        this.printResult("=========================================================\n");
    }

    public void printProblems(StandardDdlParser parser, AstNode rootNode) {
        this.printResult("==================== PROBLEMS ===========================\n");
        List problems = parser.nodeFactory().getChildrenForType(rootNode, StandardDdlLexicon.TYPE_PROBLEM);
        for (AstNode node : problems) {
            this.printResult(node.toString());
        }
        this.printResult("=========================================================\n");
    }

    protected void assertScoreAndParse(String content, String filename, int childCount) {
        Object result = this.parser.score(content, filename, this.scorer);
        this.parser.parse(content, this.rootNode, result);
        Assert.assertThat((Object)(this.scorer.getScore() > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        if (childCount >= 0) {
            Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)childCount));
        }
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.parser.setRootNode(this.rootNode);
        this.parser.parse(content, this.rootNode, null);
        if (childCount >= 0) {
            Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)childCount));
        }
    }
}

