/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.oracle;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Name;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlConstants;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlLexicon;
import org.modeshape.sequencer.ddl.node.AstNode;

public class OracleDdlParser
extends StandardDdlParser
implements OracleDdlConstants,
OracleDdlConstants.OracleStatementStartPhrases {
    private final String parserId = "ORACLE";
    static List<String[]> oracleDataTypeStrings = new ArrayList<String[]>();

    public OracleDdlParser() {
        this.setDatatypeParser(new OracleDataTypeParser());
        this.initialize();
    }

    private void initialize() {
        this.setTerminator(";");
        this.setDoUseTerminator(true);
        oracleDataTypeStrings.addAll(OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    public String getId() {
        return this.parserId;
    }

    @Override
    public String[] getIdentifyingKeywords() {
        return new String[]{this.getId(), "spool.log"};
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerKeyWords(OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_WORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
        tokens.registerStatementStartPhrase(SET_PHRASES);
    }

    @Override
    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        AstNode complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (complexNode != null && this.nodeFactory().hasMixinType(child, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT) || complexNode != null && this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_BACKSLASH_TERMINATOR)) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
            } else {
                complexNode = null;
            }
            if (!this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT) && !this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT) && !this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_CREATE_LIBRARY_STATEMENT) && !this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_CREATE_PACKAGE_STATEMENT) && !this.nodeFactory().hasMixinType(child, OracleDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT)) continue;
            complexNode = child;
        }
        super.rewrite(tokens, rootNode);
        copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        boolean foundComplexNode = false;
        complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (this.matchesComplexNode(child)) {
                foundComplexNode = true;
                complexNode = child;
                continue;
            }
            if (!foundComplexNode) continue;
            if (complexNode != null && this.nodeFactory().hasMixinType(child, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT)) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
                continue;
            }
            foundComplexNode = false;
            complexNode = null;
        }
    }

    private boolean matchesComplexNode(AstNode node) {
        assert (node != null);
        for (Name mixin : COMPLEX_STMT_TYPES) {
            if (!this.nodeFactory().hasMixinType(node, mixin)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AstNode handleUnknownToken(DdlTokenStream tokens, String tokenValue) throws ParsingException {
        if (tokenValue.equals("/")) {
            return this.nodeFactory().node("backslashTerminator", this.getRootNode(), OracleDdlLexicon.TYPE_BACKSLASH_TERMINATOR);
        }
        return null;
    }

    @Override
    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateSchemaStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode result = null;
        if (tokens.matches(STMT_COMMENT_ON)) {
            result = this.parseCommentStatement(tokens, parentNode);
        } else {
            if (tokens.matches(STMT_ANALYZE)) {
                return this.parseStatement(tokens, STMT_ANALYZE, parentNode, OracleDdlLexicon.TYPE_ANALYZE_STATEMENT);
            }
            if (tokens.matches(STMT_ASSOCIATE_STATISTICS)) {
                return this.parseStatement(tokens, STMT_ASSOCIATE_STATISTICS, parentNode, OracleDdlLexicon.TYPE_ASSOCIATE_STATISTICS_STATEMENT);
            }
            if (tokens.matches(STMT_AUDIT)) {
                return this.parseStatement(tokens, STMT_AUDIT, parentNode, OracleDdlLexicon.TYPE_AUDIT_STATEMENT);
            }
            if (tokens.matches(STMT_COMMIT_FORCE) || tokens.matches(STMT_COMMIT_WORK) || tokens.matches(STMT_COMMIT_WRITE)) {
                return this.parseStatement(tokens, STMT_COMMIT, parentNode, OracleDdlLexicon.TYPE_COMMIT_STATEMENT);
            }
            if (tokens.matches(STMT_DISASSOCIATE_STATISTICS)) {
                return this.parseStatement(tokens, STMT_DISASSOCIATE_STATISTICS, parentNode, OracleDdlLexicon.TYPE_DISASSOCIATE_STATISTICS_STATEMENT);
            }
            if (tokens.matches(STMT_EXPLAIN_PLAN)) {
                return this.parseStatement(tokens, STMT_EXPLAIN_PLAN, parentNode, OracleDdlLexicon.TYPE_EXPLAIN_PLAN_STATEMENT);
            }
            if (tokens.matches(STMT_FLASHBACK)) {
                return this.parseStatement(tokens, STMT_FLASHBACK, parentNode, OracleDdlLexicon.TYPE_FLASHBACK_STATEMENT);
            }
            if (tokens.matches(STMT_LOCK_TABLE)) {
                return this.parseStatement(tokens, STMT_LOCK_TABLE, parentNode, OracleDdlLexicon.TYPE_LOCK_TABLE_STATEMENT);
            }
            if (tokens.matches(STMT_MERGE)) {
                return this.parseStatement(tokens, STMT_MERGE, parentNode, OracleDdlLexicon.TYPE_MERGE_STATEMENT);
            }
            if (tokens.matches(STMT_NOAUDIT)) {
                return this.parseStatement(tokens, STMT_NOAUDIT, parentNode, OracleDdlLexicon.TYPE_NOAUDIT_STATEMENT);
            }
            if (tokens.matches(STMT_PURGE)) {
                return this.parseStatement(tokens, STMT_PURGE, parentNode, OracleDdlLexicon.TYPE_PURGE_STATEMENT);
            }
            if (tokens.matches(STMT_RENAME)) {
                return this.parseStatement(tokens, STMT_RENAME, parentNode, OracleDdlLexicon.TYPE_RENAME_STATEMENT);
            }
            if (tokens.matches(STMT_ROLLBACK)) {
                return this.parseStatement(tokens, STMT_ROLLBACK, parentNode, OracleDdlLexicon.TYPE_ROLLBACK_STATEMENT);
            }
            if (tokens.matches(STMT_ROLLBACK_WORK)) {
                return this.parseStatement(tokens, STMT_ROLLBACK_WORK, parentNode, OracleDdlLexicon.TYPE_ROLLBACK_STATEMENT);
            }
            if (tokens.matches(STMT_ROLLBACK_TO_SAVEPOINT)) {
                return this.parseStatement(tokens, STMT_ROLLBACK_TO_SAVEPOINT, parentNode, OracleDdlLexicon.TYPE_ROLLBACK_STATEMENT);
            }
            if (tokens.matches(STMT_SAVEPOINT)) {
                return this.parseStatement(tokens, STMT_SAVEPOINT, parentNode, OracleDdlLexicon.TYPE_SAVEPOINT_STATEMENT);
            }
            if (tokens.matches(STMT_TRUNCATE)) {
                return this.parseStatement(tokens, STMT_TRUNCATE, parentNode, OracleDdlLexicon.TYPE_TRUNCATE_STATEMENT);
            }
        }
        if (result == null) {
            result = super.parseCustomStatement(tokens, parentNode);
        }
        return result;
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_INDEX) || tokens.matches(STMT_CREATE_UNIQUE_INDEX) || tokens.matches(STMT_CREATE_BITMAP_INDEX)) {
            return this.parseCreateIndex(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_CLUSTER)) {
            return this.parseCreateClusterStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_CONTEXT)) {
            return this.parseStatement(tokens, STMT_CREATE_CONTEXT, parentNode, OracleDdlLexicon.TYPE_CREATE_CONTEXT_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_CONTROLFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_CONTROLFILE, parentNode, OracleDdlLexicon.TYPE_CREATE_CONTROLFILE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_DATABASE, parentNode, OracleDdlLexicon.TYPE_CREATE_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_DATABASE, parentNode, OracleDdlLexicon.TYPE_CREATE_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_DIMENSION)) {
            return this.parseCreateDimensionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_CREATE_DIRECTORY, parentNode, OracleDdlLexicon.TYPE_CREATE_DIRECTORY_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_DIRECTORY, parentNode, OracleDdlLexicon.TYPE_CREATE_DIRECTORY_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_CREATE_DISKGROUP, parentNode, OracleDdlLexicon.TYPE_CREATE_DISKGROUP_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_INDEXTYPE, parentNode, OracleDdlLexicon.TYPE_CREATE_INDEXTYPE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_JAVA)) {
            return this.parseCreateJavaStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_LIBRARY)) {
            return this.parseStatement(tokens, STMT_CREATE_LIBRARY, parentNode, OracleDdlLexicon.TYPE_CREATE_LIBRARY_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_LIBRARY)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_LIBRARY, parentNode, OracleDdlLexicon.TYPE_CREATE_LIBRARY_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_MATERIALIZED_VIEW)) {
            return this.parseMaterializedViewStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OPERATOR)) {
            return this.parseStatement(tokens, STMT_CREATE_OPERATOR, parentNode, OracleDdlLexicon.TYPE_CREATE_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OUTLINE)) {
            return this.parseStatement(tokens, STMT_CREATE_OUTLINE, parentNode, OracleDdlLexicon.TYPE_CREATE_OUTLINE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_OUTLINE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_OUTLINE, parentNode, OracleDdlLexicon.TYPE_CREATE_OUTLINE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PACKAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_PACKAGE, parentNode, OracleDdlLexicon.TYPE_CREATE_PACKAGE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PACKAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_PACKAGE, parentNode, OracleDdlLexicon.TYPE_CREATE_PACKAGE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_PFILE, parentNode, OracleDdlLexicon.TYPE_CREATE_PFILE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PROCEDURE)) {
            return this.parseCreateProcedureStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PROCEDURE)) {
            return this.parseCreateProcedureStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_PROFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_PROFILE, parentNode, OracleDdlLexicon.TYPE_CREATE_PROFILE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_ROLE)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLE, parentNode, OracleDdlLexicon.TYPE_CREATE_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLLBACK, parentNode, OracleDdlLexicon.TYPE_CREATE_ROLLBACK_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_ROLLBACK, parentNode, OracleDdlLexicon.TYPE_CREATE_ROLLBACK_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_CREATE_SEQUENCE, parentNode, OracleDdlLexicon.TYPE_CREATE_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_SPFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_SPFILE, parentNode, OracleDdlLexicon.TYPE_CREATE_SPFILE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_SYNONYM, parentNode, OracleDdlLexicon.TYPE_CREATE_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_SYNONYM, parentNode, OracleDdlLexicon.TYPE_CREATE_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_PUBLIC_SYNONYM, parentNode, OracleDdlLexicon.TYPE_CREATE_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_SYNONYM, parentNode, OracleDdlLexicon.TYPE_CREATE_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_CREATE_TABLESPACE, parentNode, OracleDdlLexicon.TYPE_CREATE_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseSlashedStatement(tokens, STMT_CREATE_TRIGGER, parentNode, OracleDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_TRIGGER)) {
            return this.parseSlashedStatement(tokens, STMT_CREATE_OR_REPLACE_TRIGGER, parentNode, OracleDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_TYPE, parentNode, OracleDdlLexicon.TYPE_CREATE_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_TYPE, parentNode, OracleDdlLexicon.TYPE_CREATE_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_USER)) {
            return this.parseStatement(tokens, STMT_CREATE_USER, parentNode, OracleDdlLexicon.TYPE_CREATE_USER_STATEMENT);
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    private AstNode parseCreateClusterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_CLUSTER);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_CLUSTER_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateDimensionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_DIMENSION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_DIMENSION_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateFunctionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        DataType dType;
        boolean ok;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_FUNCTION);
        tokens.canConsume(STMT_CREATE_FUNCTION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT);
        if (isReplace) {
            // empty if block
        }
        if ((ok = this.parseParameters(tokens, node)) && tokens.canConsume("RETURN") && (dType = this.getDatatypeParser().parse(tokens)) != null) {
            this.getDatatypeParser().setPropertiesOnNode(node, dType);
        }
        this.parseUntilFwdSlash(tokens, false);
        tokens.canConsume("/");
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateProcedureStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean ok;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_PROCEDURE);
        tokens.canConsume(STMT_CREATE_PROCEDURE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT);
        if (isReplace) {
            // empty if block
        }
        if ((ok = this.parseParameters(tokens, node)) && tokens.canConsume("AUTHID")) {
            if (tokens.canConsume("CURRENT_USER")) {
                node.setProperty(OracleDdlLexicon.AUTHID_VALUE, (Object)"AUTHID CURRENT_USER");
            } else {
                tokens.consume("DEFINER");
                node.setProperty(OracleDdlLexicon.AUTHID_VALUE, (Object)"DEFINER");
            }
        }
        this.parseUntilFwdSlash(tokens, false);
        tokens.canConsume("/");
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private boolean parseParameters(DdlTokenStream tokens, AstNode procedureNode) throws ParsingException {
        assert (tokens != null);
        assert (procedureNode != null);
        tokens.consume("(");
        while (!tokens.canConsume(")")) {
            String paramName = this.parseName(tokens);
            String inOutStr = null;
            if (tokens.matches("IN")) {
                if (tokens.canConsume("IN", new String[]{"OUT"})) {
                    inOutStr = tokens.canConsume("NOCOPY") ? "IN OUT NOCOPY" : "IN OUT";
                } else {
                    tokens.consume("IN");
                    inOutStr = "IN";
                }
            } else if (tokens.matches("OUT")) {
                if (tokens.canConsume("OUT", new String[]{"NOCOPY"})) {
                    inOutStr = "OUT NOCOPY";
                } else {
                    tokens.consume("OUT");
                    inOutStr = "OUT";
                }
            }
            DataType datatype = this.getDatatypeParser().parse(tokens);
            AstNode paramNode = this.nodeFactory().node(paramName, procedureNode, OracleDdlLexicon.TYPE_FUNCTION_PARAMETER);
            if (datatype != null) {
                this.getDatatypeParser().setPropertiesOnNode(paramNode, datatype);
            }
            if (tokens.matchesAnyOf(":=", new String[]{"DEFAULT"}) || !tokens.matchesAnyOf(",", new String[]{")"})) {
                String msg = DdlSequencerI18n.unsupportedProcedureParameterDeclaration.text(new Object[]{procedureNode.getProperty(StandardDdlLexicon.NAME)});
                DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
                this.addProblem(problem, procedureNode);
                return false;
            }
            if (inOutStr != null) {
                paramNode.setProperty(OracleDdlLexicon.IN_OUT_NO_COPY, (Object)inOutStr);
            }
            tokens.canConsume(",");
        }
        return true;
    }

    protected AstNode parseMaterializedViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isLog = tokens.canConsume(STMT_CREATE_MATERIALIZED_VEIW_LOG);
        tokens.canConsume(STMT_CREATE_MATERIALIZED_VIEW);
        String name = this.parseName(tokens);
        AstNode node = null;
        node = isLog ? this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_MATERIALIZED_VIEW_LOG_STATEMENT) : this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_CREATE_MATERIALIZED_VIEW_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        AstNode node = null;
        this.markStartOfStatement(tokens);
        tokens.consume("GRANT");
        String name = "GRANT";
        tokens.consume();
        node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_STATEMENT);
        while (tokens.hasNext() && !this.isTerminator(tokens) && (!tokens.matches(128) || tokens.matches(128) && tokens.matches("GRANT", new String[]{"OPTION"}))) {
            tokens.consume();
        }
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected AstNode parseRevokeStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        return this.parseStatement(tokens, STMT_REVOKE, parentNode, OracleDdlLexicon.TYPE_REVOKE_STATEMENT);
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("ALTER", new String[]{"TABLE", "any value", "ADD"})) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"TABLE"});
            String tableName = this.parseName(tokens);
            AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
            tokens.consume("ADD");
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else if (tokens.matches("(", new String[]{"REF"})) {
                tokens.consume("(", new String[]{"REF", "("});
                this.parseName(tokens);
                tokens.consume(")", new String[]{"WITH", "ROWID", ")"});
            } else if (tokens.matches("(", new String[]{"SCOPE"})) {
                tokens.consume("(", new String[]{"SCOPE", "FOR", "("});
                this.parseName(tokens);
                tokens.consume(")", new String[]{"IS"});
                this.parseName(tokens);
                tokens.consume(")");
            } else if (tokens.matches("(")) {
                this.parseColumns(tokens, alterTableNode, true);
            } else {
                this.parseSingleTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, alterTableNode);
            return alterTableNode;
        }
        if (tokens.matches("ALTER", new String[]{"TABLE", "any value", "DROP"})) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"TABLE"});
            String tableName = this.parseName(tokens);
            AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
            tokens.consume("DROP");
            if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, StandardDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            } else if (tokens.canConsume("COLUMN")) {
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, StandardDdlLexicon.TYPE_DROP_COLUMN_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            } else {
                this.parseUntilTerminator(tokens);
            }
            this.markEndOfStatement(tokens, alterTableNode);
            return alterTableNode;
        }
        if (tokens.matches("ALTER", new String[]{"TABLE", "any value", "RENAME"})) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"TABLE"});
            String oldName = this.parseName(tokens);
            AstNode alterTableNode = this.nodeFactory().node(oldName, parentNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
            if (tokens.canConsume("RENAME", new String[]{"TO"})) {
                String newName = this.parseName(tokens);
                alterTableNode.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newName);
                this.parseUntilTerminator(tokens);
            } else if (tokens.canConsume("RENAME", new String[]{"COLUMN"})) {
                String oldColumnName = this.parseName(tokens);
                tokens.consume("TO");
                String newColumnName = this.parseName(tokens);
                this.parseUntilTerminator(tokens);
                AstNode renameColumnNode = this.nodeFactory().node(oldColumnName, alterTableNode, OracleDdlLexicon.TYPE_RENAME_COLUMN);
                renameColumnNode.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newColumnName);
            } else if (tokens.canConsume("RENAME", new String[]{"CONSTRAINT"})) {
                String oldConstraintName = this.parseName(tokens);
                tokens.consume("TO");
                String newConstraintName = this.parseName(tokens);
                this.parseUntilTerminator(tokens);
                AstNode renameColumnNode = this.nodeFactory().node(oldConstraintName, alterTableNode, OracleDdlLexicon.TYPE_RENAME_CONSTRAINT);
                renameColumnNode.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newConstraintName);
            }
            this.markEndOfStatement(tokens, alterTableNode);
            return alterTableNode;
        }
        if (tokens.matches("ALTER", new String[]{"TABLE", "any value", "MODIFY"})) {
            // empty if block
        }
        return super.parseAlterTableStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("ALTER", new String[]{"TABLE"})) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_ALTER_CLUSTER)) {
            return this.parseStatement(tokens, STMT_ALTER_CLUSTER, parentNode, OracleDdlLexicon.TYPE_ALTER_CLUSTER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_ALTER_DATABASE);
            AstNode result = this.nodeFactory().node("database", parentNode, OracleDdlLexicon.TYPE_ALTER_DATABASE_STATEMENT);
            tokens.canConsume("RENAME");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_DIMENSION)) {
            return this.parseStatement(tokens, STMT_ALTER_DIMENSION, parentNode, OracleDdlLexicon.TYPE_ALTER_DIMENSION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_DISKGROUP, parentNode, OracleDdlLexicon.TYPE_ALTER_DISKGROUP_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, OracleDdlLexicon.TYPE_ALTER_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_INDEX)) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"INDEX"});
            String indexName = this.parseName(tokens);
            AstNode result = this.nodeFactory().node(indexName, parentNode, OracleDdlLexicon.TYPE_ALTER_INDEX_STATEMENT);
            tokens.canConsume("RENAME");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_INDEXTYPE, parentNode, OracleDdlLexicon.TYPE_ALTER_INDEXTYPE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_JAVA)) {
            return this.parseStatement(tokens, STMT_ALTER_JAVA, parentNode, OracleDdlLexicon.TYPE_ALTER_JAVA_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_MATERIALIZED)) {
            return this.parseStatement(tokens, STMT_ALTER_MATERIALIZED, parentNode, OracleDdlLexicon.TYPE_ALTER_MATERIALIZED_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_OPERATOR)) {
            return this.parseStatement(tokens, STMT_ALTER_OPERATOR, parentNode, OracleDdlLexicon.TYPE_ALTER_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_OUTLINE)) {
            return this.parseStatement(tokens, STMT_ALTER_OUTLINE, parentNode, OracleDdlLexicon.TYPE_ALTER_OUTLINE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_PACKAGE)) {
            return this.parseStatement(tokens, STMT_ALTER_PACKAGE, parentNode, OracleDdlLexicon.TYPE_ALTER_PACKAGE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROCEDURE, parentNode, OracleDdlLexicon.TYPE_ALTER_PROCEDURE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_PROFILE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROFILE, parentNode, OracleDdlLexicon.TYPE_ALTER_PROFILE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_RESOURCE)) {
            return this.parseStatement(tokens, STMT_ALTER_RESOURCE, parentNode, OracleDdlLexicon.TYPE_ALTER_RESOURCE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_ROLE)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLE, parentNode, OracleDdlLexicon.TYPE_ALTER_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLLBACK, parentNode, OracleDdlLexicon.TYPE_ALTER_ROLLBACK_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_ALTER_SEQUENCE, parentNode, OracleDdlLexicon.TYPE_ALTER_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SESSION)) {
            return this.parseStatement(tokens, STMT_ALTER_SESSION, parentNode, OracleDdlLexicon.TYPE_ALTER_SESSION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SYSTEM)) {
            return this.parseStatement(tokens, STMT_ALTER_SYSTEM, parentNode, OracleDdlLexicon.TYPE_ALTER_SYSTEM_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, OracleDdlLexicon.TYPE_ALTER_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TRIGGER)) {
            return this.parseStatement(tokens, STMT_ALTER_TRIGGER, parentNode, OracleDdlLexicon.TYPE_ALTER_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_TYPE, parentNode, OracleDdlLexicon.TYPE_ALTER_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_USER)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_ALTER_USER);
            String name = this.parseName(tokens);
            AstNode result = this.nodeFactory().node(name, parentNode, OracleDdlLexicon.TYPE_ALTER_USER_STATEMENT);
            tokens.canConsume("GRANT");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_VIEW)) {
            return this.parseStatement(tokens, STMT_ALTER_VIEW, parentNode, OracleDdlLexicon.TYPE_ALTER_VIEW_STATEMENT);
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String stmtType = "CREATE";
        tokens.consume("CREATE");
        if (tokens.canConsume("OR", new String[]{"REPLACE"})) {
            stmtType = stmtType + " " + "OR REPLACE";
        } else if (tokens.canConsume("NO", new String[]{"FORCE"})) {
            stmtType = stmtType + " " + "NO FORCE";
        } else if (tokens.canConsume("FORCE")) {
            stmtType = stmtType + " " + "FORCE";
        }
        tokens.consume("VIEW");
        stmtType = stmtType + " " + "VIEW";
        String name = this.parseName(tokens);
        AstNode createViewNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_VIEW_STATEMENT);
        this.parseColumnNameList(tokens, createViewNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
        if (tokens.matches("OF")) {
            do {
                tokens.consume();
            } while (!tokens.matches("AS"));
        }
        tokens.consume("AS");
        String queryExpression = this.parseUntilTerminator(tokens);
        createViewNode.setProperty(StandardDdlLexicon.CREATE_VIEW_QUERY_EXPRESSION, (Object)queryExpression);
        this.markEndOfStatement(tokens, createViewNode);
        return createViewNode;
    }

    private AstNode parseCreateIndex(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return this.parseStatement(tokens, STMT_CREATE_INDEX, parentNode, OracleDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
    }

    private AstNode parseCommentStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("COMMENT");
        tokens.consume("ON");
        String obj = tokens.consume();
        String objName = this.parseName(tokens);
        String commentString = null;
        tokens.consume("IS");
        if (tokens.matches("NULL")) {
            tokens.consume("NULL");
            commentString = "NULL";
        } else {
            commentString = this.parseUntilTerminator(tokens).trim();
        }
        AstNode commentNode = this.nodeFactory().node(objName, parentNode, OracleDdlLexicon.TYPE_COMMENT_ON_STATEMENT);
        commentNode.setProperty(OracleDdlLexicon.COMMENT, (Object)commentString);
        commentNode.setProperty(OracleDdlLexicon.TARGET_OBJECT_TYPE, (Object)obj);
        this.markEndOfStatement(tokens, commentNode);
        return commentNode;
    }

    @Override
    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_SET_CONSTRAINT)) {
            return this.parseStatement(tokens, STMT_SET_CONSTRAINT, parentNode, OracleDdlLexicon.TYPE_SET_CONSTRAINT_STATEMENT);
        }
        if (tokens.matches(STMT_SET_CONSTRAINTS)) {
            return this.parseStatement(tokens, STMT_SET_CONSTRAINTS, parentNode, OracleDdlLexicon.TYPE_SET_CONSTRAINTS_STATEMENT);
        }
        if (tokens.matches(STMT_SET_ROLE)) {
            return this.parseStatement(tokens, STMT_SET_ROLE, parentNode, OracleDdlLexicon.TYPE_SET_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_SET_TRANSACTION)) {
            return this.parseStatement(tokens, STMT_SET_TRANSACTION, parentNode, OracleDdlLexicon.TYPE_SET_TRANSACTION_STATEMENT);
        }
        return super.parseSetStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode dropNode = null;
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_TABLE)) {
            this.markStartOfStatement(tokens);
            tokens.consume("DROP", new String[]{"TABLE"});
            String name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_DROP_TABLE_STATEMENT);
            dropNode.setProperty(StandardDdlLexicon.DROP_OPTION_TYPE, (Object)"TABLE");
            if (tokens.matchesAnyOf("CASCADE", new String[]{"RESTRICT"})) {
                StringBuffer sb = new StringBuffer();
                if (tokens.canConsume("CASCADE")) {
                    sb.append("CASCADE");
                    tokens.consume("CONSTRAINTS");
                    sb.append(" ").append("CONSTRAINTS");
                    AstNode optionNode = this.nodeFactory().node("OPTION", dropNode, StandardDdlLexicon.DROP_OPTION_TYPE);
                    optionNode.setProperty(StandardDdlLexicon.NAME, (Object)"CASCADE OR RESTRICT");
                    optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)sb.toString());
                } else {
                    tokens.consume("RESTRICT");
                    sb.append("RESTRICT");
                    tokens.consume("CONSTRAINTS");
                    sb.append(" ").append("CONSTRAINTS");
                    AstNode optionNode = this.nodeFactory().node("OPTION", dropNode, StandardDdlLexicon.DROP_OPTION_TYPE);
                    optionNode.setProperty(StandardDdlLexicon.NAME, (Object)"CASCADE OR RESTRICT");
                    optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)sb.toString());
                }
            }
            if (tokens.canConsume("PURGE")) {
                AstNode optionNode = this.nodeFactory().node("OPTION", dropNode, StandardDdlLexicon.DROP_OPTION_TYPE);
                optionNode.setProperty(StandardDdlLexicon.NAME, (Object)"PURGE");
                optionNode.setProperty(StandardDdlLexicon.VALUE, (Object)"PURGE");
            }
            this.markEndOfStatement(tokens, dropNode);
            return dropNode;
        }
        if (tokens.matches(STMT_DROP_CLUSTER)) {
            return this.parseStatement(tokens, STMT_DROP_CLUSTER, parentNode, OracleDdlLexicon.TYPE_DROP_CLUSTER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_CONTEXT)) {
            return this.parseStatement(tokens, STMT_DROP_CONTEXT, parentNode, OracleDdlLexicon.TYPE_DROP_CONTEXT_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_DATABASE, parentNode, OracleDdlLexicon.TYPE_DROP_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PUBLIC_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_PUBLIC_DATABASE, parentNode, OracleDdlLexicon.TYPE_DROP_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DIMENSION)) {
            return this.parseStatement(tokens, STMT_DROP_DIMENSION, parentNode, OracleDdlLexicon.TYPE_DROP_DIMENSION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_DROP_DIRECTORY, parentNode, OracleDdlLexicon.TYPE_DROP_DIRECTORY_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_DROP_DISKGROUP, parentNode, OracleDdlLexicon.TYPE_DROP_DISKGROUP_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, OracleDdlLexicon.TYPE_DROP_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_INDEX, parentNode, OracleDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_DROP_INDEXTYPE, parentNode, OracleDdlLexicon.TYPE_DROP_INDEXTYPE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_JAVA)) {
            return this.parseStatement(tokens, STMT_DROP_JAVA, parentNode, OracleDdlLexicon.TYPE_DROP_JAVA_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_LIBRARY)) {
            return this.parseStatement(tokens, STMT_DROP_LIBRARY, parentNode, OracleDdlLexicon.TYPE_DROP_LIBRARY_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_MATERIALIZED)) {
            return this.parseStatement(tokens, STMT_DROP_MATERIALIZED, parentNode, OracleDdlLexicon.TYPE_DROP_MATERIALIZED_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_OPERATOR)) {
            return this.parseStatement(tokens, STMT_DROP_OPERATOR, parentNode, OracleDdlLexicon.TYPE_DROP_OPERATOR_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_OUTLINE)) {
            return this.parseStatement(tokens, STMT_DROP_OUTLINE, parentNode, OracleDdlLexicon.TYPE_DROP_OUTLINE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PACKAGE)) {
            return this.parseStatement(tokens, STMT_DROP_PACKAGE, parentNode, OracleDdlLexicon.TYPE_DROP_PACKAGE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_DROP_PROCEDURE, parentNode, OracleDdlLexicon.TYPE_DROP_PROCEDURE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PROFILE)) {
            return this.parseStatement(tokens, STMT_DROP_PROFILE, parentNode, OracleDdlLexicon.TYPE_DROP_PROFILE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_ROLE)) {
            return this.parseStatement(tokens, STMT_DROP_ROLE, parentNode, OracleDdlLexicon.TYPE_DROP_ROLE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_DROP_ROLLBACK, parentNode, OracleDdlLexicon.TYPE_DROP_ROLLBACK_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_DROP_SEQUENCE, parentNode, OracleDdlLexicon.TYPE_DROP_SEQUENCE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SYNONYM)) {
            return this.parseStatement(tokens, STMT_DROP_SYNONYM, parentNode, OracleDdlLexicon.TYPE_DROP_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_DROP_PUBLIC_SYNONYM, parentNode, OracleDdlLexicon.TYPE_DROP_SYNONYM_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_DROP_TABLESPACE, parentNode, OracleDdlLexicon.TYPE_DROP_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, OracleDdlLexicon.TYPE_DROP_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TYPE)) {
            return this.parseStatement(tokens, STMT_DROP_TYPE, parentNode, OracleDdlLexicon.TYPE_DROP_TYPE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_USER)) {
            return this.parseStatement(tokens, STMT_DROP_USER, parentNode, OracleDdlLexicon.TYPE_DROP_USER_STATEMENT);
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    private AstNode parseCreateJavaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_JAVA);
        AstNode result = this.nodeFactory().node(this.getStatementTypeName(STMT_CREATE_JAVA), parentNode, OracleDdlLexicon.TYPE_CREATE_JAVA_STATEMENT);
        int iParen = 0;
        while (tokens.hasNext()) {
            if (tokens.matches('{')) {
                ++iParen;
            } else if (tokens.matches('}')) {
                --iParen;
            }
            tokens.consume();
            if (!this.isTerminator(tokens) || iParen != 0) continue;
        }
        this.markEndOfStatement(tokens, result);
        return result;
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuffer unusedTokensSB = new StringBuffer();
        do {
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, true);
                continue;
            }
            while (localTokens.hasNext() && !localTokens.matches(",")) {
                unusedTokensSB.append(" ").append(localTokens.consume());
            }
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getProperty(StandardDdlLexicon.NAME)});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected AstNode parseSlashedStatement(DdlTokenStream tokens, String[] stmt_start_phrase, AstNode parentNode, Name mixinType) {
        assert (tokens != null);
        assert (stmt_start_phrase != null && stmt_start_phrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(stmt_start_phrase);
        AstNode result = this.nodeFactory().node(this.getStatementTypeName(stmt_start_phrase), parentNode, mixinType);
        this.parseUntilFwdSlash(tokens, false);
        this.consumeSlash(tokens);
        this.markEndOfStatement(tokens, result);
        return result;
    }

    private String parseUntilFwdSlash(DdlTokenStream tokens, boolean stopAtStatementStart) throws ParsingException {
        StringBuffer sb = new StringBuffer();
        if (stopAtStatementStart) {
            while (tokens.hasNext() && !tokens.matches(128) && !tokens.matches('/')) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            while (tokens.hasNext() && !this.isFwdSlashedStatement(tokens) && !tokens.matches('/')) {
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    private boolean isFwdSlashedStatement(DdlTokenStream tokens) throws ParsingException {
        for (int i = 0; i < SLASHED_STMT_PHRASES.length; ++i) {
            if (!tokens.matches(SLASHED_STMT_PHRASES[i])) continue;
            return true;
        }
        return false;
    }

    private void consumeSlash(DdlTokenStream tokens) throws ParsingException {
        tokens.canConsume("/");
    }

    @Override
    protected Name[] getValidSchemaChildTypes() {
        return VALID_SCHEMA_CHILD_STMTS;
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class OracleDataTypeParser
    extends DataTypeParser {
        OracleDataTypeParser() {
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            String typeName = null;
            if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_FLOAT)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_FLOAT);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_DOUBLE)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_DOUBLE);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_LONG)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_LONG);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_LONG_RAW)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_LONG_RAW);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_CLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_CLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NCLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NCLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BFILE)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BFILE);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_VARCHAR2)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_VARCHAR2);
                this.consume(tokens, dataType, false, "(");
                long length = this.parseLong(tokens, dataType);
                this.canConsume(tokens, dataType, true, "BYTE", new String[0]);
                this.canConsume(tokens, dataType, true, "CHAR", new String[0]);
                this.consume(tokens, dataType, false, ")");
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_RAW)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_RAW);
                long length = this.parseBracketedLong(tokens, dataType);
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NVARCHAR2)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NVARCHAR2);
                long length = this.parseBracketedLong(tokens, dataType);
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NUMBER)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NUMBER);
                int precision = 0;
                int scale = 0;
                if (tokens.matches("(")) {
                    this.consume(tokens, dataType, false, "(");
                    precision = (int)this.parseLong(tokens, dataType);
                    scale = this.canConsume(tokens, dataType, false, ",", new String[0]) ? (int)this.parseLong(tokens, dataType) : this.getDefaultScale();
                    this.consume(tokens, dataType, false, ")");
                } else {
                    precision = this.getDefaultPrecision();
                    scale = this.getDefaultScale();
                }
                dataType.setName(typeName);
                dataType.setPrecision(precision);
                dataType.setScale(scale);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_INTERVAL_YEAR) || tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_INTERVAL_DAY)) {
                // empty if block
            }
            if (dataType == null) {
                dataType = super.parseCustomType(tokens);
            }
            return dataType;
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_CHAR_ORACLE)) {
                dataType = new DataType();
                String typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_CHAR_ORACLE);
                this.consume(tokens, dataType, false, "(");
                long length = this.parseLong(tokens, dataType);
                this.canConsume(tokens, dataType, true, "BYTE", new String[0]);
                this.canConsume(tokens, dataType, true, "CHAR", new String[0]);
                this.consume(tokens, dataType, false, ")");
                dataType.setName(typeName);
                dataType.setLength(length);
            } else {
                dataType = super.parseCharStringType(tokens);
            }
            return dataType;
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmt : oracleDataTypeStrings) {
                if (!tokens.matches(stmt)) continue;
                return true;
            }
            return false;
        }
    }
}

