/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicMultiValueProperty;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@NotThreadSafe
public class AstNode
implements Iterable<AstNode> {
    private AstNode parent;
    private final Name name;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private final LinkedList<AstNode> children = new LinkedList();
    private final List<AstNode> childrenView = Collections.unmodifiableList(this.children);

    public AstNode(Name name) {
        assert (name != null);
        this.name = name;
    }

    public AstNode(AstNode parent, Name name) {
        assert (name != null);
        this.name = name;
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public Name getName() {
        return this.name;
    }

    public int getSameNameSiblingIndex() {
        int snsIndex = 1;
        if (this.parent == null) {
            return snsIndex;
        }
        for (AstNode sibling : this.parent.getChildren()) {
            if (sibling == this) break;
            if (!sibling.getName().equals(this.name)) continue;
            ++snsIndex;
        }
        return snsIndex;
    }

    public Path getPath(ExecutionContext context) {
        assert (context != null);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path parentPath = this.parent != null ? this.parent.getPath(context) : pathFactory.createRelativePath();
        return pathFactory.create(parentPath, this.name, this.getSameNameSiblingIndex());
    }

    public Path getPathRelativeTo(Path rootPath, ExecutionContext context) {
        assert (rootPath != null);
        assert (context != null);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path parentPath = this.parent != null ? this.parent.getPathRelativeTo(rootPath, context) : rootPath;
        return pathFactory.create(parentPath, this.name, this.getSameNameSiblingIndex());
    }

    public Property getProperty(Name name) {
        return this.properties.get(name);
    }

    public AstNode setProperty(Name name, Object value) {
        assert (name != null);
        assert (value != null);
        this.properties.put(name, (Property)new BasicSingleValueProperty(name, value));
        return this;
    }

    public AstNode setProperty(Name name, Object ... values) {
        assert (name != null);
        assert (values != null);
        if (values.length != 0) {
            this.properties.put(name, (Property)new BasicMultiValueProperty(name, values));
        }
        return this;
    }

    public Property removeProperty(Name name) {
        return this.properties.remove(name);
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.properties.values());
    }

    public AstNode getParent() {
        return this.parent;
    }

    public void setParent(AstNode parent) {
        this.removeFromParent();
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public void insertAsParent(AstNode newParent) {
        if (newParent == null) {
            return;
        }
        newParent.removeFromParent();
        if (this.parent != null) {
            this.parent.replaceChild(this, newParent);
        }
        newParent.addLastChild(this);
    }

    public AstNode removeFromParent() {
        AstNode result = this.parent;
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
        return result;
    }

    public boolean replaceChild(AstNode child, AstNode replacement) {
        assert (child != null);
        assert (replacement != null);
        if (child.parent == this) {
            int i = this.children.indexOf(child);
            if (replacement.parent == this) {
                int j = this.children.indexOf(replacement);
                this.children.set(i, replacement);
                this.children.set(j, child);
                return true;
            }
            this.children.set(i, replacement);
            replacement.removeFromParent();
            replacement.parent = this;
            child.parent = null;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public AstNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.getFirst();
    }

    public AstNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.getLast();
    }

    public AstNode getChild(int index) {
        return this.children.isEmpty() ? null : this.children.get(index);
    }

    public void addFirstChild(AstNode child) {
        assert (child != null);
        this.children.addFirst(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addLastChild(AstNode child) {
        assert (child != null);
        this.children.addLast(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addChildren(Iterable<AstNode> otherChildren) {
        assert (otherChildren != null);
        for (AstNode planNode : otherChildren) {
            this.addLastChild(planNode);
        }
    }

    public void addChildren(AstNode first, AstNode second) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
    }

    public void addChildren(AstNode first, AstNode second, AstNode third) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
        if (third != null) {
            this.addLastChild(third);
        }
    }

    public boolean removeChild(AstNode child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.parent = null;
        }
        return result;
    }

    public void extractChild(AstNode child) {
        if (child.getChildCount() == 0) {
            this.removeChild(child);
        } else {
            AstNode grandChild = child.getFirstChild();
            this.replaceChild(child, grandChild);
        }
    }

    public void extractFromParent() {
        this.parent.extractChild(this);
    }

    public List<AstNode> getChildren() {
        return this.childrenView;
    }

    @Override
    public Iterator<AstNode> iterator() {
        return this.childrenView.iterator();
    }

    public List<AstNode> removeAllChildren() {
        if (this.children.isEmpty()) {
            return new ArrayList<AstNode>(0);
        }
        ArrayList<AstNode> copyOfChildren = new ArrayList<AstNode>(this.children);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            AstNode child = (AstNode)childIter.next();
            childIter.remove();
            child.parent = null;
        }
        return copyOfChildren;
    }

    public String toString() {
        return this.getString(ExecutionContext.DEFAULT_CONTEXT);
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public AstNode clone() {
        return this.cloneWithoutNewParent();
    }

    protected AstNode cloneWithoutNewParent() {
        AstNode result = new AstNode(this.name);
        result.properties.putAll(this.properties);
        for (AstNode child : this.children) {
            AstNode childClone = child.cloneWithoutNewParent();
            result.addLastChild(childClone);
        }
        return result;
    }

    public boolean isSameAs(AstNode other) {
        if (other == null) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!((Object)this.properties).equals(other.properties)) {
            return false;
        }
        if (this.getChildCount() != other.getChildCount()) {
            return false;
        }
        Iterator<AstNode> thisChildren = this.getChildren().iterator();
        Iterator<AstNode> thatChildren = other.getChildren().iterator();
        while (thisChildren.hasNext() && thatChildren.hasNext()) {
            if (thisChildren.next().isSameAs(thatChildren.next())) continue;
            return false;
        }
        return true;
    }

    public String getString(ExecutionContext context) {
        StringBuilder sb = new StringBuilder();
        this.getRecursiveString(context, sb, 0);
        return sb.toString();
    }

    private void getRecursiveString(ExecutionContext context, StringBuilder str, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            str.append("  ");
        }
        this.getNodeString(context, str).append('\n');
        for (AstNode child : this) {
            child.getRecursiveString(context, str, indentLevel + 1);
        }
    }

    private StringBuilder getNodeString(ExecutionContext context, StringBuilder str) {
        ValueFactory strings = context.getValueFactories().getStringFactory();
        str.append((String)strings.create(this.name));
        if (this.properties != null && !this.properties.isEmpty()) {
            str.append(" <");
            boolean first = true;
            for (Map.Entry<Name, Property> entry : this.properties.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append(entry.getValue().getString(context.getNamespaceRegistry(), null, null));
            }
            str.append('>');
        }
        return str;
    }
}

