/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.ddl.AbstractDdlSequencerTest;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.DdlSequencer;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;

public class StandardDdlSequencerTest
extends AbstractDdlSequencerTest {
    @Test
    public void shouldSequenceCreateSchema() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/create_schema.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "POSTGRES");
        Node schemaNode = statementsNode.getNode("hollywood");
        Assert.assertNotNull((Object)schemaNode);
        this.verifyBaseProperties(schemaNode, "nt:unstructured", "1", "1", "0", 2L);
        this.verifyMixinType(schemaNode, "ddl:createSchemaStatement");
        this.verifyExpression(schemaNode, "CREATE SCHEMA hollywood");
        Node filmsNode = schemaNode.getNode("films");
        Assert.assertNotNull((Object)filmsNode);
        this.verifyBaseProperties(filmsNode, "nt:unstructured", "2", "5", "28", 3L);
        this.verifyMixinType(filmsNode, "ddl:createTableStatement");
        this.verifyExpression(filmsNode, "CREATE TABLE films (title varchar(255), release date, producerName varchar(255))");
        Node winnersNode = schemaNode.getNode("winners");
        Assert.assertNotNull((Object)winnersNode);
        this.verifyBaseProperties(winnersNode, "nt:unstructured", "3", "5", "113", 0L);
        this.verifyMixinType(winnersNode, "ddl:createViewStatement");
        this.verifyExpression(winnersNode, "CREATE VIEW winners AS SELECT title, release FROM films WHERE producerName IS NOT NULL;");
        Node titleNode = filmsNode.getNode("title");
        Assert.assertNotNull((Object)titleNode);
        this.verifyPrimaryType(titleNode, "nt:unstructured");
        this.verifyProperty(titleNode, "ddl:datatypeName", "VARCHAR");
        this.verifyProperty(titleNode, "ddl:datatypeLength", "255");
        this.verifyMixinType(titleNode, "ddl:columnDefinition");
        Node releaseNode = filmsNode.getNode("release");
        Assert.assertNotNull((Object)releaseNode);
        this.verifyPrimaryType(releaseNode, "nt:unstructured");
        this.verifyProperty(releaseNode, "ddl:datatypeName", "DATE");
        this.verifyHasProperty(releaseNode, "ddl:datatypeLength");
        this.verifyMixinType(titleNode, "ddl:columnDefinition");
    }

    @Test
    public void shouldSequenceCreateTable() throws Exception {
        String targetExpression = "CREATE TABLE IDTABLE\n(\n  IDCONTEXT  VARCHAR(20) NOT NULL PRIMARY KEY,\n  NEXTID     NUMERIC\n);";
        Node statementsNode = this.sequenceDdl("ddl/create_table.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "SQL92");
        Node tableNode = statementsNode.getNode("IDTABLE");
        Assert.assertNotNull((Object)tableNode);
        this.verifyBaseProperties(tableNode, "nt:unstructured", "1", "1", "0", 3L);
        this.verifyMixinType(tableNode, "ddl:createTableStatement");
        this.verifyExpression(tableNode, targetExpression);
        Node idcontextNode = tableNode.getNode("IDCONTEXT");
        Assert.assertNotNull((Object)idcontextNode);
        this.verifyPrimaryType(idcontextNode, "nt:unstructured");
        this.verifyProperty(idcontextNode, "ddl:datatypeName", "VARCHAR");
        this.verifyProperty(idcontextNode, "ddl:datatypeLength", "20");
        this.verifyMixinType(idcontextNode, "ddl:columnDefinition");
        Node nextidNode = tableNode.getNode("NEXTID");
        Assert.assertNotNull((Object)nextidNode);
        this.verifyPrimaryType(nextidNode, "nt:unstructured");
        this.verifyProperty(nextidNode, "ddl:datatypeName", "NUMERIC");
        this.verifyProperty(nextidNode, "ddl:datatypePrecision", "0");
        this.verifyProperty(nextidNode, "ddl:datatypeScale", "0");
        this.verifyHasProperty(nextidNode, "ddl:datatypeLength");
        this.verifyMixinType(nextidNode, "ddl:columnDefinition");
        Node pk_1_Node = tableNode.getNode("PK_1");
        Assert.assertNotNull((Object)pk_1_Node);
        this.verifyPrimaryType(pk_1_Node, "nt:unstructured");
        this.verifyProperty(pk_1_Node, "ddl:constraintType", "PRIMARY KEY");
        this.verifyMixinType(pk_1_Node, "ddl:tableConstraint");
        Assert.assertThat((Object)pk_1_Node.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node idcontectRefNode = pk_1_Node.getNode("IDCONTEXT");
        Assert.assertNotNull((Object)idcontectRefNode);
        this.verifyPrimaryType(idcontectRefNode, "nt:unstructured");
        this.verifyMixinType(idcontectRefNode, "ddl:columnReference");
    }

    @Test
    public void shouldGenerateNodeTypesForCreateTables() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/createTables.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)20L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "SQL92");
        Node tableNode = statementsNode.getNode("RT_MDLS");
        Assert.assertNotNull((Object)tableNode);
        this.verifyBaseProperties(tableNode, "nt:unstructured", "81", "1", "2212", 10L);
        this.verifyMixinType(tableNode, "ddl:createTableStatement");
        Node node_1 = tableNode.getNode("MDL_UUID");
        Assert.assertNotNull((Object)node_1);
        this.verifyPrimaryType(node_1, "nt:unstructured");
        this.verifyProperty(node_1, "ddl:datatypeName", "VARCHAR");
        this.verifyProperty(node_1, "ddl:datatypeLength", "64");
        this.verifyMixinType(node_1, "ddl:columnDefinition");
        Node node_2 = tableNode.getNode("MDL_TYPE");
        Assert.assertNotNull((Object)node_2);
        this.verifyPrimaryType(node_2, "nt:unstructured");
        this.verifyProperty(node_2, "ddl:datatypeName", "NUMERIC");
        this.verifyProperty(node_2, "ddl:datatypePrecision", "3");
        this.verifyProperty(node_2, "ddl:datatypeScale", "0");
        this.verifyHasProperty(node_2, "ddl:datatypeLength");
        this.verifyMixinType(node_2, "ddl:columnDefinition");
    }

    @Test
    public void shouldSequenceStandardDdlFile() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/standard_test_statements.ddl");
        Assert.assertEquals((long)44L, (long)statementsNode.getNodes().getSize());
        Node stmtNode = this.findNode(statementsNode, "assertNotNull", "ddl:createAssertionStatement");
        Node constraintAttribute = this.findNode(stmtNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
        this.verifyProperty(constraintAttribute, "ddl:propValue", "NOT DEFERRABLE");
        stmtNode = this.findNode(statementsNode, "assertIsZero", "ddl:createAssertionStatement");
        constraintAttribute = this.findNode(stmtNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
        this.verifyProperty(constraintAttribute, "ddl:propValue", "INITIALLY DEFERRED");
        Node tableNode = this.findNode(statementsNode, "employee", "ddl:createTableStatement");
        Node columnNode = this.findNode(tableNode, "empname", "ddl:columnDefinition");
        this.verifyProperty(columnNode, "ddl:datatypeName", "CHAR");
        this.verifyProperty(columnNode, "ddl:datatypeLength", 10L);
        Node constraintNode = this.findNode(tableNode, "emp_fk1", "ddl:tableConstraint");
        constraintAttribute = this.findNode(constraintNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
        this.verifyProperty(constraintAttribute, "ddl:propValue", "INITIALLY IMMEDIATE");
        this.findNode(constraintNode, "deptno[1]", "ddl:columnReference");
        this.findNode(constraintNode, "dept", "ddl:tableReference");
        this.findNode(constraintNode, "deptno[2]", "ddl:fkColumnReference");
        Node viewNode = this.findNode(statementsNode, "view_1", "ddl:createViewStatement");
        this.findNode(viewNode, "col1", "ddl:columnReference");
        tableNode = this.findNode(statementsNode, "table_5", "ddl:createTableStatement");
        Assert.assertEquals((long)18L, (long)tableNode.getNodes().getSize());
    }

    @Test
    public void shouldSequenceStandardDdlGrantStatements() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/grant_test_statements.ddl");
        Assert.assertEquals((long)4L, (long)statementsNode.getNodes().getSize());
        Node grantNode = this.findNode(statementsNode, "purchaseOrders", "ddl:grantOnTableStatement");
        this.findNode(grantNode, "maria", "ddl:grantee");
        Node privNode = this.findNode(grantNode, "privilege", "ddl:grantPrivilege");
        this.verifyProperty(privNode, "ddl:type", "SELECT");
        grantNode = this.findNode(statementsNode, "billedOrders", "ddl:grantOnTableStatement");
        privNode = this.findNode(grantNode, "privilege", "ddl:grantPrivilege");
        this.verifyProperty(privNode, "ddl:type", "UPDATE");
        this.findNode(grantNode, "anita", "ddl:grantee");
    }

    @Test
    public void shouldSequenceStandardDdlRevokeStatements() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/revoke_test_statements.ddl");
        Assert.assertEquals((long)4L, (long)statementsNode.getNodes().getSize());
        Node revokeNode = this.findNode(statementsNode, "purchaseOrders", "ddl:revokeOnTableStatement");
        this.findNode(revokeNode, "maria", "ddl:grantee");
        Node privNode = this.findNode(revokeNode, "privilege", "ddl:grantPrivilege");
        this.verifyProperty(privNode, "ddl:type", "SELECT");
        revokeNode = this.findNode(statementsNode, "orderDetails", "ddl:revokeOnTableStatement");
        privNode = this.findNode(revokeNode, "privilege", "ddl:grantPrivilege");
        this.verifyProperty(privNode, "ddl:type", "UPDATE");
        this.findNode(revokeNode, "anita", "ddl:grantee");
    }

    protected String[] builtInGrammars() {
        ArrayList<String> builtInParserNames = new ArrayList<String>();
        for (DdlParser parser : DdlParsers.BUILTIN_PARSERS) {
            builtInParserNames.add(parser.getId().toLowerCase());
        }
        return builtInParserNames.toArray(new String[builtInParserNames.size()]);
    }

    @Test
    public void shouldHaveDefaultListOfGrammars() {
        DdlSequencer sequencer = new DdlSequencer();
        String[] grammars = sequencer.getGrammars();
        Assert.assertThat((Object)grammars, (Matcher)Is.is((Object)this.builtInGrammars()));
    }

    @Test
    public void shouldCreateListOfDdlParserInstancesForDefaultListOfGrammars() {
        DdlSequencer sequencer = new DdlSequencer();
        List parsers = sequencer.getParserList();
        Assert.assertThat((Object)parsers, (Matcher)Is.is((Object)DdlParsers.BUILTIN_PARSERS));
    }

    @Test
    public void shouldAllowSettingGrammarsWithEmptyArray() {
        DdlSequencer sequencer = new DdlSequencer();
        sequencer.setGrammars(new String[0]);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)this.builtInGrammars()));
    }

    @Test
    public void shouldAllowSettingGrammarsWithNullArray() {
        DdlSequencer sequencer = new DdlSequencer();
        sequencer.setGrammars(null);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)this.builtInGrammars()));
    }

    @Test
    public void shouldAllowSettingGrammarsToNonEmptyArrayOfValidBuiltInGrammars() {
        DdlSequencer sequencer = new DdlSequencer();
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId()};
        sequencer.setGrammars(grammars);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
    }

    @Test
    public void shouldAllowSettingGrammarsToNonEmptyArrayOfValidAndNonExistantBuiltInGrammars() {
        DdlSequencer sequencer = new DdlSequencer();
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), "argle"};
        sequencer.setGrammars(grammars);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
    }

    @Test
    public void shouldCreateDdlParserInstancesForAllValidBuiltInGrammars() {
        DdlSequencer sequencer = new DdlSequencer();
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), "argle"};
        sequencer.setGrammars(grammars);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        List parsers = sequencer.getParserList();
        Assert.assertThat(parsers.get(0), (Matcher)Is.is((Object)new OracleDdlParser()));
        Assert.assertThat(parsers.get(1), (Matcher)Is.is((Object)new StandardDdlParser()));
        Assert.assertThat((Object)parsers.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldCreateDdlParserInstancesForAllValidBuiltInGrammarsAndInstantiableParser() {
        DdlSequencer sequencer = new DdlSequencer();
        String[] grammars = new String[]{new OracleDdlParser().getId(), new StandardDdlParser().getId(), ArgleDdlParser.class.getName()};
        sequencer.setGrammars(grammars);
        Assert.assertThat((Object)sequencer.getGrammars(), (Matcher)Is.is((Object)grammars));
        List parsers = sequencer.getParserList();
        Assert.assertThat(parsers.get(0), (Matcher)Is.is((Object)new OracleDdlParser()));
        Assert.assertThat(parsers.get(1), (Matcher)Is.is((Object)new StandardDdlParser()));
        Assert.assertThat(parsers.get(2), (Matcher)Is.is((Object)((Object)new ArgleDdlParser())));
        Assert.assertThat((Object)parsers.size(), (Matcher)Is.is((Object)3));
    }

    protected static class ArgleDdlParser
    extends StandardDdlParser {
        protected ArgleDdlParser() {
        }

        public String getId() {
            return "ARGLE";
        }
    }
}

