/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.node.AstNode;

public class AstNodeTest {
    private AstNode node;
    private AstNode parent;

    @Before
    public void beforeEach() {
        this.node = new AstNode("node1");
    }

    @After
    public void afterEach() {
        this.node = null;
        this.parent = null;
    }

    @Test
    public void shouldCreatePlanNodeWithNameAndNoParent() {
        String name = "something";
        this.node = new AstNode(name);
        Assert.assertThat((Object)this.node.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreatePlanNodeWithNameAndParent() {
        String name = "something";
        this.parent = new AstNode("parent");
        this.node = new AstNode(this.parent, name);
        Assert.assertThat((Object)this.node.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithOneChild() {
        this.parent = new AstNode("parent");
        this.node = new AstNode(this.parent, "child");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithTwoChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithMoreThanTwoChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithNoChildren() {
        this.parent = new AstNode("parent");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldRemoveNodeFromExistingParentWhenSettingParentToNull() {
        this.parent = new AstNode("parent");
        this.node = new AstNode(this.parent, "child");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)1));
        this.node.setParent(null);
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldInsertNewParentNodeInBetweenExistingParentAndChild() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        this.node = new AstNode("inserted");
        child2.insertAsParent(this.node);
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldInsertNewParentNodeInAboveNodeWithoutParent() {
        AstNode child1 = new AstNode("childA");
        this.node = new AstNode("node");
        AstNode nodeChild = new AstNode(this.node, "child");
        child1.insertAsParent(this.node);
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)nodeChild)));
        Assert.assertThat((Object)this.node.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsAParent() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        AstNode grandChild21 = new AstNode(child2, "grandChild21");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild21)));
        Assert.assertThat((Object)child2.removeFromParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild21)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsNoParent() {
        this.node = new AstNode("node");
        AstNode child1 = new AstNode(this.node, "child");
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.node.removeFromParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldReturnListOfChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        List children = this.parent.getChildren();
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableListOfChildren() {
        this.parent = new AstNode("parent");
        new AstNode(this.parent, "childA");
        new AstNode(this.parent, "childB");
        new AstNode(this.parent, "childC");
        this.parent.getChildren().clear();
    }

    @Test
    public void shouldReturnIteratorOfChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Iterator children = this.parent.iterator();
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableIteratorOfChildren() {
        this.parent = new AstNode("parent");
        new AstNode(this.parent, "childA");
        new AstNode(this.parent, "childB");
        new AstNode(this.parent, "childC");
        Iterator iter = this.parent.iterator();
        iter.next();
        iter.remove();
    }

    @Test
    public void shouldRemoveAllChildrenOfParentWithNoChildrenByReturningEmptyList() {
        this.parent = new AstNode("parent");
        List children = this.parent.removeAllChildren();
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode child1a = new AstNode(this.parent, "child1A");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1a)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldRemoveAllChildrenAndReturnCopyOfListOfChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        List children = this.parent.removeAllChildren();
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode child1a = new AstNode(this.parent, "child1A");
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1a)));
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldReturnCorrectChildCount() {
        this.parent = new AstNode("parent");
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        for (int i = 0; i != 10; ++i) {
            new AstNode(this.parent, "child");
            Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)(i + 1)));
        }
    }

    @Test
    public void shouldAddChildrenAtEnd() {
        this.parent = new AstNode("parent");
        ArrayList<AstNode> children = new ArrayList<AstNode>();
        children.add(new AstNode(this.parent, "child"));
        children.add(new AstNode(this.parent, "child"));
        children.add(new AstNode(this.parent, "child"));
        this.parent.addChildren(children);
        int index = 0;
        for (AstNode child : children) {
            Assert.assertThat((Object)this.parent.getChild(index++), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child)));
        }
    }

    @Test
    public void shouldRemoveChild() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(child2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldNotRemoveChildIfNotReallyAChild() {
        this.node = new AstNode("node");
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(this.node), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldNotRemoveChildIfReferenceIsNull() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(null), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldExtractChildByRemovingIfChildHasNoChildren() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldExtractChildByReplacingWithFirstGrandchild() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        AstNode grandChild1 = new AstNode(child2, "grandchildA");
        AstNode grandChild2 = new AstNode(child2, "grandchildB");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild1)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild2)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReplaceChild() {
        AstNode parentOfReplacement = new AstNode("parentOfReplacement");
        AstNode replacement = new AstNode(parentOfReplacement, "replacement");
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, replacement), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)replacement)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)replacement.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)child3.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)parentOfReplacement.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReplaceChildWithAnotherChildToSwapPositions() {
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, child3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child3.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
    }

    @Test
    public void shouldNotReplaceChildIfChildNodeIsNotReallyAChild() {
        AstNode nonChild = new AstNode("nonChild");
        AstNode replacement = new AstNode("replacement");
        this.parent = new AstNode("parent");
        AstNode child1 = new AstNode(this.parent, "childA");
        AstNode child2 = new AstNode(this.parent, "childB");
        AstNode child3 = new AstNode(this.parent, "childC");
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(nonChild, replacement), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnPath() {
        AstNode root = new AstNode("root");
        AstNode node1 = new AstNode(root, "node1");
        AstNode node2 = new AstNode(node1, "node2");
        AstNode node3 = new AstNode(node2, "node3");
        AstNode node4 = new AstNode(node3, "node4");
        AstNode node5 = new AstNode(node4, "node5");
        node4.setProperty("prop1", (Object)"value1");
        Assert.assertThat((Object)root.getAbsolutePath(), (Matcher)Is.is((Object)"/root"));
        Assert.assertThat((Object)node1.getAbsolutePath(), (Matcher)Is.is((Object)"/root/node1"));
        Assert.assertThat((Object)node2.getAbsolutePath(), (Matcher)Is.is((Object)"/root/node1/node2"));
        Assert.assertThat((Object)node3.getAbsolutePath(), (Matcher)Is.is((Object)"/root/node1/node2/node3"));
        Assert.assertThat((Object)node4.getAbsolutePath(), (Matcher)Is.is((Object)"/root/node1/node2/node3/node4"));
        Assert.assertThat((Object)node5.getAbsolutePath(), (Matcher)Is.is((Object)"/root/node1/node2/node3/node4/node5"));
    }

    @Test
    public void shouldReplaceJcrIllegalCharacters() {
        String name = "na*me";
        AstNode node = new AstNode("na*me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na*me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf02ame"));
        name = "na/me";
        node = new AstNode("na/me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na/me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf02fme"));
        name = "na:me";
        node = new AstNode("na:me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na:me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf03ame"));
        name = "na[me";
        node = new AstNode("na[me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na[me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf05bme"));
        name = "na]me";
        node = new AstNode("na]me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na]me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf05dme"));
        name = "na|me";
        node = new AstNode("na|me");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na|me"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf07cme"));
        name = "na*/:[]|me*";
        node = new AstNode("na*/:[]|me*");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"na*/:[]|me*"));
        Assert.assertThat((Object)node.getJcrSafeName(), (Matcher)Is.is((Object)"na\uf02a\uf02f\uf03a\uf05b\uf05d\uf07cme\uf02a"));
    }
}

