/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.postgres;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlConstants;
import org.modeshape.sequencer.ddl.node.AstNode;

public class PostgresDdlParser
extends StandardDdlParser
implements PostgresDdlConstants,
PostgresDdlConstants.PostgresStatementStartPhrases {
    public static final String ID = "POSTGRES";
    static List<String[]> postgresDataTypeStrings = new ArrayList<String[]>();
    private static final String TERMINATOR = ";";

    public PostgresDdlParser() {
        this.setDatatypeParser(new PostgresDataTypeParser());
        this.initialize();
    }

    private void initialize() {
        this.setDoUseTerminator(true);
        this.setTerminator(TERMINATOR);
        postgresDataTypeStrings.addAll(PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerKeyWords(PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_WORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(SET_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
    }

    @Override
    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        AstNode prepareNode = null;
        boolean mergeNextStatement = false;
        for (AstNode child : copyOfNodes) {
            if (prepareNode != null && mergeNextStatement) {
                this.mergeNodes(tokens, prepareNode, child);
                rootNode.removeChild(child);
                prepareNode = null;
            }
            mergeNextStatement = prepareNode != null && this.nodeFactory().hasMixinType(child, "ddl:missingTerminator");
            if (!this.nodeFactory().hasMixinType(child, "postgresddl:prepareStatement")) continue;
            prepareNode = child;
        }
        super.rewrite(tokens, rootNode);
        copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        boolean foundComplexNode = false;
        AstNode complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (this.matchesComplexNode(child)) {
                foundComplexNode = true;
                complexNode = child;
                continue;
            }
            if (!foundComplexNode) continue;
            if (complexNode != null && this.nodeFactory().hasMixinType(child, "ddl:unknownStatement")) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
                continue;
            }
            foundComplexNode = false;
            complexNode = null;
        }
    }

    private boolean matchesComplexNode(AstNode node) {
        for (String mixin : COMPLEX_STMT_TYPES) {
            if (!this.nodeFactory().hasMixinType(node, mixin)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_ALTER_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_ALTER_AGGREGATE, parentNode, "postgresddl:alterAggregateStatement");
        }
        if (tokens.matches(STMT_ALTER_CONVERSION)) {
            return this.parseStatement(tokens, STMT_ALTER_CONVERSION, parentNode, "postgresddl:alterConversionStatement");
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            return this.parseStatement(tokens, STMT_ALTER_DATABASE, parentNode, "postgresddl:alterDatabaseStatement");
        }
        if (tokens.matches(STMT_ALTER_FOREIGN_DATA_WRAPPER)) {
            return this.parseStatement(tokens, STMT_ALTER_FOREIGN_DATA_WRAPPER, parentNode, "postgresddl:alterForeignDataWrapperStatement");
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, "postgresddl:alterFunctionStatement");
        }
        if (tokens.matches(STMT_ALTER_GROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_GROUP, parentNode, "postgresddl:alterGroupStatement");
        }
        if (tokens.matches(STMT_ALTER_INDEX)) {
            return this.parseStatement(tokens, STMT_ALTER_INDEX, parentNode, "postgresddl:alterIndexStatement");
        }
        if (tokens.matches(STMT_ALTER_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_ALTER_LANGUAGE, parentNode, "postgresddl:alterLanguageStatement");
        }
        if (tokens.matches(STMT_ALTER_OPERATOR)) {
            return this.parseStatement(tokens, STMT_ALTER_OPERATOR, parentNode, "postgresddl:alterOperatorStatement");
        }
        if (tokens.matches(STMT_ALTER_ROLE)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLE, parentNode, "postgresddl:alterRoleStatement");
        }
        if (tokens.matches(STMT_ALTER_SCHEMA)) {
            return this.parseStatement(tokens, STMT_ALTER_SCHEMA, parentNode, "postgresddl:alterSchemaStatement");
        }
        if (tokens.matches(STMT_ALTER_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_ALTER_SEQUENCE, parentNode, "postgresddl:alterSequenceStatement");
        }
        if (tokens.matches(STMT_ALTER_SERVER)) {
            return this.parseStatement(tokens, STMT_ALTER_SERVER, parentNode, "postgresddl:alterServerStatement");
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, "postgresddl:alterTablespaceStatement");
        }
        if (tokens.matches(STMT_ALTER_TEXT_SEARCH)) {
            return this.parseStatement(tokens, STMT_ALTER_TEXT_SEARCH, parentNode, "postgresddl:alterTextSearchStatement");
        }
        if (tokens.matches(STMT_ALTER_TRIGGER)) {
            return this.parseStatement(tokens, STMT_ALTER_TRIGGER, parentNode, "postgresddl:alterTriggerStatement");
        }
        if (tokens.matches(STMT_ALTER_TYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_TYPE, parentNode, "postgresddl:alterTypeStatement");
        }
        if (tokens.matches(STMT_ALTER_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_ALTER_USER_MAPPING, parentNode, "postgresddl:alterUserMappingStatement");
        }
        if (tokens.matches(STMT_ALTER_USER)) {
            return this.parseStatement(tokens, STMT_ALTER_USER, parentNode, "postgresddl:alterUserStatement");
        }
        if (tokens.matches(STMT_ALTER_VIEW)) {
            return this.parseStatement(tokens, STMT_ALTER_VIEW, parentNode, "postgresddl:alterViewStatement");
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume();
        tokens.consume("TABLE");
        tokens.canConsume("ONLY");
        String tableName = this.parseName(tokens);
        tokens.canConsume("*");
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, "postgresddl:alterTableStatement");
        do {
            this.parseAlterTableAction(tokens, alterTableNode);
        } while (tokens.canConsume(","));
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    private void parseAlterTableAction(DdlTokenStream tokens, AstNode alterTableNode) throws ParsingException {
        assert (tokens != null);
        assert (alterTableNode != null);
        if (tokens.canConsume("ADD")) {
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else {
                this.parseSingleCommaTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
        } else if (tokens.canConsume("DROP")) {
            if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, "ddl:dropTableConstraintDefinition");
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            } else {
                tokens.canConsume("COLUMN");
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, "ddl:dropColumnDefinition");
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            }
        } else if (tokens.matches("ALTER")) {
            tokens.consume("ALTER");
            tokens.canConsume("COLUMN");
            String columnName = this.parseName(tokens);
            AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, "ddl:alterColumnDefinition");
            if (tokens.canConsume("SET", new String[]{"STORAGE"})) {
                tokens.consume();
            } else if (tokens.canConsume("SET", new String[]{"STATISTICS"})) {
                tokens.consume();
            } else if (!tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                if (tokens.canConsume("SET", new String[]{"DATA"})) {
                    tokens.consume("TYPE");
                    DataType datatype = this.getDatatypeParser().parse(tokens);
                    this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
                    if (tokens.canConsume("USING")) {
                        this.parseUntilCommaOrTerminator(tokens);
                    }
                } else if (tokens.canConsume("TYPE")) {
                    DataType datatype = this.getDatatypeParser().parse(tokens);
                    this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
                    if (tokens.canConsume("USING")) {
                        this.parseUntilCommaOrTerminator(tokens);
                    }
                } else if (tokens.matches("SET", new String[]{"DEFAULT"})) {
                    tokens.consume("SET");
                    this.parseDefaultClause(tokens, columnNode);
                } else if (tokens.matches("SET") || tokens.matches("DROP")) {
                    tokens.consume();
                    tokens.canConsume("NOT", new String[]{"NULL"});
                    tokens.canConsume("NULL");
                } else {
                    System.out.println("  WARNING:  Option not found for ALTER TABLE - ALTER COLUMN. Check your DDL for incomplete statement.");
                }
            }
        } else if (tokens.canConsume("ENABLE")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            StringBuffer sb = new StringBuffer("ENABLE");
            if (tokens.canConsume("TRIGGER")) {
                sb.append(" ").append("TRIGGER");
                if (!tokens.matches(this.getTerminator())) {
                    sb.append(" ").append(this.parseName(tokens));
                }
            } else if (tokens.canConsume("REPLICA", new String[]{"TRIGGER"})) {
                sb.append(" ").append("REPLICA TRIGGER");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("REPLICA", new String[]{"RULE"})) {
                sb.append(" ").append("REPLICA RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("ALWAYS", new String[]{"TRIGGER"})) {
                sb.append(" ").append("ALWAYS TRIGGER");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("ALWAYS", new String[]{"RULE"})) {
                sb.append(" ").append("ALWAYS RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else if (tokens.canConsume("RULE")) {
                sb.append(" ").append("RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else {
                System.out.println("  WARNING:  Option not found for ALTER TABLE - ENABLE XXXX. Check your DDL for incomplete statement.");
            }
            optionNode.setProperty("ddl:value", (Object)sb.toString());
        } else if (tokens.canConsume("DISABLE")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            StringBuffer sb = new StringBuffer("DISABLE");
            if (tokens.canConsume("TRIGGER")) {
                sb.append(" ").append("TRIGGER");
                if (!tokens.matches(this.getTerminator())) {
                    sb.append(" ").append(this.parseName(tokens));
                }
            } else if (tokens.canConsume("RULE")) {
                sb.append(" ").append("RULE");
                sb.append(" ").append(this.parseName(tokens));
            } else {
                System.out.println("  WARNING:  Option not found for ALTER TABLE - DISABLE XXXX. Check your DDL for incomplete statement.");
            }
            optionNode.setProperty("ddl:value", (Object)sb.toString());
        } else if (tokens.canConsume("CLUSTER", new String[]{"ON"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            String indexName = this.parseName(tokens);
            optionNode.setProperty("ddl:value", (Object)("CLUSTER ON " + indexName));
        } else if (tokens.canConsume("OWNER", new String[]{"TO"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)("OWNER TO " + this.parseName(tokens)));
        } else if (tokens.canConsume("INHERIT")) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)("INHERIT " + this.parseName(tokens)));
        } else if (tokens.canConsume("NO", new String[]{"INHERIT"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)("NO INHERIT " + this.parseName(tokens)));
        } else if (tokens.canConsume("SET", new String[]{"TABLESPACE"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)("SET TABLESPACE " + this.parseName(tokens)));
        } else if (tokens.canConsume("SET", new String[]{"WITHOUT", "CLUSTER"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)"SET WITHOUT CLUSTER");
        } else if (tokens.canConsume("SET", new String[]{"WITHOUT", "OIDS"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)"SET WITHOUT OIDS");
        } else if (tokens.canConsume("SET", new String[]{"WITH", "OIDS"})) {
            AstNode optionNode = this.nodeFactory().node("action", alterTableNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)"SET WITH OIDS");
        } else if (tokens.canConsume("RENAME", new String[]{"TO"})) {
            String newTableName = this.parseName(tokens);
            alterTableNode.setProperty("ddl:newName", (Object)newTableName);
        } else if (tokens.canConsume("RENAME")) {
            tokens.canConsume("COLUMN");
            String oldColumnName = this.parseName(tokens);
            tokens.consume("TO");
            String newColumnName = this.parseName(tokens);
            AstNode renameColumnNode = this.nodeFactory().node(oldColumnName, alterTableNode, "postgresddl:renamedColumn");
            renameColumnNode.setProperty("ddl:newName", (Object)newColumnName);
        } else if (tokens.canConsume("SET", new String[]{"SCHEMA"})) {
            String schemaName = this.parseName(tokens);
            alterTableNode.setProperty("postgresddl:schemaName", (Object)schemaName);
        } else {
            System.out.println("  WARNING:  Option not found for ALTER TABLE. Check your DDL for incomplete statement.");
        }
    }

    private void parseSingleCommaTerminatedColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, "ddl:columnDefinition");
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        while (tokens.hasNext() && !tokens.matches(this.getTerminator()) && !tokens.matches(128)) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                this.parseCollateClause(tokens, columnNode);
                this.parseColumnConstraint(tokens, columnNode, isAlterTable);
            }
            this.consumeComment(tokens);
            if (!tokens.matches(",")) continue;
            break;
        }
    }

    @Override
    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateSchemaStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_TEMP_TABLE) || tokens.matches(STMT_CREATE_GLOBAL_TEMP_TABLE) || tokens.matches(STMT_CREATE_LOCAL_TEMP_TABLE)) {
            return this.parseCreateTableStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_CREATE_AGGREGATE, parentNode, "postgresddl:createAggregateStatement");
        }
        if (tokens.matches(STMT_CREATE_CAST)) {
            return this.parseStatement(tokens, STMT_CREATE_CAST, parentNode, "postgresddl:createCastStatement");
        }
        if (tokens.matches(STMT_CREATE_CONSTRAINT_TRIGGER)) {
            return this.parseStatement(tokens, STMT_CREATE_CONSTRAINT_TRIGGER, parentNode, "postgresddl:createConstraintTriggerStatement");
        }
        if (tokens.matches(STMT_CREATE_CONVERSION)) {
            return this.parseStatement(tokens, STMT_CREATE_CONVERSION, parentNode, "postgresddl:createConversionStatement");
        }
        if (tokens.matches(STMT_CREATE_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_DATABASE, parentNode, "postgresddl:createDatabaseStatement");
        }
        if (tokens.matches(STMT_CREATE_FOREIGN_DATA_WRAPPER)) {
            return this.parseStatement(tokens, STMT_CREATE_FOREIGN_DATA_WRAPPER, parentNode, "postgresddl:createForeignDataWrapperStatement");
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_GROUP)) {
            return this.parseStatement(tokens, STMT_CREATE_GROUP, parentNode, "postgresddl:createGroupStatement");
        }
        if (tokens.matches(STMT_CREATE_INDEX)) {
            return this.parseStatement(tokens, STMT_CREATE_INDEX, parentNode, "postgresddl:createIndexStatement");
        }
        if (tokens.matches(STMT_CREATE_UNIQUE_INDEX)) {
            return this.parseStatement(tokens, STMT_CREATE_UNIQUE_INDEX, parentNode, "postgresddl:createIndexStatement");
        }
        if (tokens.matches(STMT_CREATE_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_LANGUAGE, parentNode, "postgresddl:createLanguageStatement");
        }
        if (tokens.matches(STMT_CREATE_TRUSTED_PROCEDURAL_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_TRUSTED_PROCEDURAL_LANGUAGE, parentNode, "postgresddl:createLanguageStatement");
        }
        if (tokens.matches(STMT_CREATE_PROCEDURAL_LANGUAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_PROCEDURAL_LANGUAGE, parentNode, "postgresddl:createLanguageStatement");
        }
        if (tokens.matches(STMT_CREATE_OPERATOR)) {
            return this.parseStatement(tokens, STMT_CREATE_OPERATOR, parentNode, "postgresddl:createOperatorStatement");
        }
        if (tokens.matches(STMT_CREATE_ROLE)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLE, parentNode, "postgresddl:createRoleStatement");
        }
        if (tokens.matches(STMT_CREATE_RULE) || tokens.matches(STMT_CREATE_OR_REPLACE_RULE)) {
            return this.parseCreateRuleStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_CREATE_SEQUENCE, parentNode, "postgresddl:createSequenceStatement");
        }
        if (tokens.matches(STMT_CREATE_SERVER)) {
            return this.parseStatement(tokens, STMT_CREATE_SERVER, parentNode, "postgresddl:createServerStatement");
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_CREATE_TABLESPACE, parentNode, "postgresddl:createTablespaceStatement");
        }
        if (tokens.matches(STMT_CREATE_TEXT_SEARCH)) {
            return this.parseStatement(tokens, STMT_CREATE_TEXT_SEARCH, parentNode, "postgresddl:createTextSearchStatement");
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseStatement(tokens, STMT_CREATE_TRIGGER, parentNode, "postgresddl:createTriggerStatement");
        }
        if (tokens.matches(STMT_CREATE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_TYPE, parentNode, "postgresddl:createTypeStatement");
        }
        if (tokens.matches(STMT_CREATE_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_CREATE_USER_MAPPING, parentNode, "postgresddl:createUserMappingStatement");
        }
        if (tokens.matches(STMT_CREATE_USER)) {
            return this.parseStatement(tokens, STMT_CREATE_USER, parentNode, "postgresddl:createUserStatement");
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        tokens.canConsumeAnyOf("LOCAL", new String[]{"GLOBAL"});
        tokens.canConsumeAnyOf("TEMP", new String[]{"TEMPORARY"});
        tokens.consume("TABLE");
        String tableName = this.parseName(tokens);
        AstNode tableNode = this.nodeFactory().node(tableName, parentNode, "ddl:createTableStatement");
        this.parseColumnsAndConstraints(tokens, tableNode);
        this.parseCreateTableOptions(tokens, tableNode);
        this.markEndOfStatement(tokens, tableNode);
        return tableNode;
    }

    @Override
    protected void parseNextCreateTableOption(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.canConsume("ON", new String[]{"COMMIT"})) {
            tokens.canConsume("PRESERVE", new String[]{"ROWS"});
            tokens.canConsume("DELETE", new String[]{"ROWS"});
            tokens.canConsume("DROP");
        } else if (tokens.canConsume("TABLESPACE")) {
            tokens.consume();
        } else if (!tokens.canConsume("WITH", new String[]{"OIDS"}) && !tokens.canConsume("WITHOUT", new String[]{"OUDS"})) {
            if (tokens.canConsume("WITH")) {
                if (tokens.matches("(")) {
                    this.consumeParenBoundedTokens(tokens, true);
                } else {
                    tokens.canConsume("NO");
                    tokens.canConsume("DATA");
                }
            } else if (tokens.canConsume("AS")) {
                this.parseUntilTerminator(tokens);
            }
        }
    }

    @Override
    protected boolean areNextTokensCreateTableOptions(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        boolean result = false;
        if (tokens.matches("ON", new String[]{"COMMIT"}) || tokens.matches("TABLESPACE") || tokens.matches("WITH") || tokens.matches("WITHOUT") || tokens.matches("AS")) {
            result = true;
        }
        return result;
    }

    @Override
    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateViewStatement(tokens, parentNode);
    }

    @Override
    protected boolean parseDefaultClause(DdlTokenStream tokens, AstNode columnNode) {
        assert (tokens != null);
        assert (columnNode != null);
        String defaultValue = "";
        if (tokens.matchesAnyOf("WITH", new String[]{"DEFAULT"})) {
            String optionID;
            if (tokens.matches("WITH")) {
                tokens.consume();
            }
            tokens.consume("DEFAULT");
            int precision = -1;
            if (tokens.canConsume("CURRENT_DATE")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_DATE";
            } else if (tokens.canConsume("CURRENT_TIME")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_TIME";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("CURRENT_TIMESTAMP")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_TIMESTAMP";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("USER")) {
                optionID = "USER";
                defaultValue = "USER";
            } else if (tokens.canConsume("CURRENT_USER")) {
                optionID = "CURRENT_USER";
                defaultValue = "CURRENT_USER";
            } else if (tokens.canConsume("SESSION_USER")) {
                optionID = "SESSION_USER";
                defaultValue = "SESSION_USER";
            } else if (tokens.canConsume("SYSTEM_USER")) {
                optionID = "SYSTEM_USER";
                defaultValue = "SYSTEM_USER";
            } else if (tokens.canConsume("NULL")) {
                optionID = "NULL";
                defaultValue = "NULL";
            } else if (tokens.canConsume("(")) {
                optionID = "LITERAL";
                while (!tokens.canConsume(")")) {
                    defaultValue = defaultValue + tokens.consume();
                }
            } else if (tokens.matches("NOW")) {
                optionID = "LITERAL";
                tokens.consume("NOW");
                tokens.consume('(');
                tokens.consume(')');
                defaultValue = "NOW()";
            } else if (tokens.matches("NEXTVAL")) {
                optionID = "LITERAL";
                defaultValue = tokens.consume() + this.consumeParenBoundedTokens(tokens, true);
            } else {
                optionID = "LITERAL";
                defaultValue = tokens.consume();
                if (tokens.canConsume(".")) {
                    defaultValue = defaultValue + '.' + tokens.consume();
                }
            }
            columnNode.setProperty("ddl:defaultOption", (Object)optionID);
            columnNode.setProperty("ddl:defaultValue", (Object)defaultValue);
            if (precision > -1) {
                columnNode.setProperty("ddl:defaultprecision", (Object)precision);
            }
            return true;
        }
        return false;
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_COMMENT_ON)) {
            return this.parseCommentStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_ABORT)) {
            return this.parseStatement(tokens, STMT_ABORT, parentNode, "postgresddl:abortStatement");
        }
        if (tokens.matches(STMT_ANALYZE)) {
            return this.parseStatement(tokens, STMT_ANALYZE, parentNode, "postgresddl:analyzeStatement");
        }
        if (tokens.matches(STMT_CLUSTER)) {
            return this.parseStatement(tokens, STMT_CLUSTER, parentNode, "postgresddl:clusterStatement");
        }
        if (tokens.matches(STMT_COPY)) {
            return this.parseStatement(tokens, STMT_COPY, parentNode, "postgresddl:copyStatement");
        }
        if (tokens.matches(STMT_DEALLOCATE_PREPARE)) {
            return this.parseStatement(tokens, STMT_DEALLOCATE_PREPARE, parentNode, "postgresddl:deallocateStatement");
        }
        if (tokens.matches(STMT_DEALLOCATE)) {
            return this.parseStatement(tokens, STMT_DEALLOCATE, parentNode, "postgresddl:deallocateStatement");
        }
        if (tokens.matches(STMT_DECLARE)) {
            return this.parseStatement(tokens, STMT_DECLARE, parentNode, "postgresddl:declareStatement");
        }
        if (tokens.matches(STMT_EXPLAIN_ANALYZE)) {
            return this.parseStatement(tokens, STMT_EXPLAIN_ANALYZE, parentNode, "postgresddl:explainStatement");
        }
        if (tokens.matches(STMT_EXPLAIN)) {
            return this.parseStatement(tokens, STMT_EXPLAIN, parentNode, "postgresddl:explainStatement");
        }
        if (tokens.matches(STMT_FETCH)) {
            return this.parseStatement(tokens, STMT_FETCH, parentNode, "postgresddl:fetchStatement");
        }
        if (tokens.matches(STMT_LISTEN)) {
            return this.parseStatement(tokens, STMT_LISTEN, parentNode, "postgresddl:listenStatement");
        }
        if (tokens.matches(STMT_LOAD)) {
            return this.parseStatement(tokens, STMT_LOAD, parentNode, "postgresddl:loadStatement");
        }
        if (tokens.matches(STMT_LOCK_TABLE)) {
            return this.parseStatement(tokens, STMT_LOCK_TABLE, parentNode, "postgresddl:lockStatement");
        }
        if (tokens.matches(STMT_MOVE)) {
            return this.parseStatement(tokens, STMT_MOVE, parentNode, "postgresddl:moveStatement");
        }
        if (tokens.matches(STMT_NOTIFY)) {
            return this.parseStatement(tokens, STMT_NOTIFY, parentNode, "postgresddl:notifyStatement");
        }
        if (tokens.matches(STMT_PREPARE)) {
            return this.parseStatement(tokens, STMT_PREPARE, parentNode, "postgresddl:prepareStatement");
        }
        if (tokens.matches(STMT_REASSIGN_OWNED)) {
            return this.parseStatement(tokens, STMT_REASSIGN_OWNED, parentNode, "postgresddl:reassignOwnedStatement");
        }
        if (tokens.matches(STMT_REINDEX)) {
            return this.parseStatement(tokens, STMT_REINDEX, parentNode, "postgresddl:reindexStatement");
        }
        if (tokens.matches(STMT_RELEASE_SAVEPOINT)) {
            return this.parseStatement(tokens, STMT_RELEASE_SAVEPOINT, parentNode, "postgresddl:releaseSavepointStatement");
        }
        if (tokens.matches(STMT_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_ROLLBACK, parentNode, "postgresddl:rollbackStatement");
        }
        if (tokens.matches(STMT_SELECT_INTO)) {
            return this.parseStatement(tokens, STMT_SELECT_INTO, parentNode, "postgresddl:selectIntoStatement");
        }
        if (tokens.matches(STMT_SHOW)) {
            return this.parseStatement(tokens, STMT_SHOW, parentNode, "postgresddl:showStatement");
        }
        if (tokens.matches(STMT_TRUNCATE)) {
            return this.parseStatement(tokens, STMT_TRUNCATE, parentNode, "postgresddl:truncateStatement");
        }
        if (tokens.matches(STMT_UNLISTEN)) {
            return this.parseStatement(tokens, STMT_UNLISTEN, parentNode, "postgresddl:unlistenStatement");
        }
        if (tokens.matches(STMT_VACUUM)) {
            return this.parseStatement(tokens, STMT_VACUUM, parentNode, "postgresddl:vacuumStatement");
        }
        if (tokens.matches(STMT_COMMIT)) {
            return this.parseStatement(tokens, STMT_COMMIT, parentNode, "postgresddl:commitStatement");
        }
        return super.parseCustomStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_AGGREGATE)) {
            return this.parseStatement(tokens, STMT_DROP_AGGREGATE, parentNode, "postgresddl:dropAggregateStatement");
        }
        if (tokens.matches(STMT_DROP_CAST)) {
            return this.parseStatement(tokens, STMT_DROP_CAST, parentNode, "postgresddl:dropCastStatement");
        }
        if (tokens.matches(STMT_DROP_CONSTRAINT_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_CONSTRAINT_TRIGGER, parentNode, "postgresddl:dropConstraintTriggerStatement");
        }
        if (tokens.matches(STMT_DROP_CONVERSION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_CONVERSION, parentNode, "postgresddl:dropConversionStatement");
        }
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_DATABASE, parentNode, "postgresddl:dropDatabaseStatement");
        }
        if (tokens.matches(STMT_DROP_FOREIGN_DATA_WRAPPER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_FOREIGN_DATA_WRAPPER, parentNode, "postgresddl:dropForeignDataWrapperStatement");
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, "postgresddl:dropFunctionStatement");
        }
        if (tokens.matches(STMT_DROP_GROUP)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_GROUP, parentNode, "postgresddl:dropGroupStatement");
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_INDEX, parentNode, "postgresddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_LANGUAGE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_LANGUAGE, parentNode, "postgresddl:dropLanguageStatement");
        }
        if (tokens.matches(STMT_DROP_PROCEDURAL_LANGUAGE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_PROCEDURAL_LANGUAGE, parentNode, "postgresddl:dropLanguageStatement");
        }
        if (tokens.matches(STMT_DROP_OPERATOR)) {
            return this.parseStatement(tokens, STMT_DROP_OPERATOR, parentNode, "postgresddl:dropOperatorStatement");
        }
        if (tokens.matches(STMT_DROP_OWNED_BY)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_OWNED_BY, parentNode, "postgresddl:dropOwnedByStatement");
        }
        if (tokens.matches(STMT_DROP_ROLE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_ROLE, parentNode, "postgresddl:dropRoleStatement");
        }
        if (tokens.matches(STMT_DROP_RULE)) {
            return this.parseStatement(tokens, STMT_DROP_RULE, parentNode, "postgresddl:dropRuleStatement");
        }
        if (tokens.matches(STMT_DROP_SEQUENCE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SEQUENCE, parentNode, "postgresddl:dropSequenceStatement");
        }
        if (tokens.matches(STMT_DROP_SERVER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SERVER, parentNode, "postgresddl:dropServerStatement");
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TABLESPACE, parentNode, "postgresddl:dropTablespaceStatement");
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_CONFIGURATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_CONFIGURATION, parentNode, "postgresddl:dropTextSearchStatement");
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_DICTIONARY)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_DICTIONARY, parentNode, "postgresddl:dropTextSearchStatement");
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_PARSER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_PARSER, parentNode, "postgresddl:dropTextSearchStatement");
        }
        if (tokens.matches(STMT_DROP_TEXT_SEARCH_TEMPLATE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TEXT_SEARCH_TEMPLATE, parentNode, "postgresddl:dropTextSearchStatement");
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, "postgresddl:dropTriggerStatement");
        }
        if (tokens.matches(STMT_DROP_TYPE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TYPE, parentNode, "postgresddl:dropTypeStatement");
        }
        if (tokens.matches(STMT_DROP_USER_MAPPING)) {
            return this.parseStatement(tokens, STMT_DROP_USER_MAPPING, parentNode, "postgresddl:dropUserMappingStatement");
        }
        if (tokens.matches(STMT_DROP_USER)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_USER, parentNode, "postgresddl:dropUserStatement");
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_DOMAIN)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_DOMAIN, parentNode, "ddl:dropDomainStatement");
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_TABLE)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_TABLE, parentNode, "ddl:dropTableStatement");
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_VIEW)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_VIEW, parentNode, "ddl:dropViewStatement");
        }
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_SCHEMA)) {
            return this.parseSimpleDropStatement(tokens, DdlConstants.StatementStartPhrases.STMT_DROP_SCHEMA, parentNode, "ddl:dropSchemaStatement");
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    private AstNode parseSimpleDropStatement(DdlTokenStream tokens, String[] startPhrase, AstNode parentNode, String stmtType) throws ParsingException {
        assert (tokens != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String behavior = null;
        tokens.consume(startPhrase);
        boolean usesIfExists = tokens.canConsume("IF", new String[]{"EXISTS"});
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.parseName(tokens));
        while (tokens.matches(",")) {
            tokens.consume(",");
            nameList.add(this.parseName(tokens));
        }
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        AstNode dropNode = this.nodeFactory().node((String)nameList.get(0), parentNode, stmtType);
        if (behavior != null) {
            dropNode.setProperty("ddl:dropBehavior", (Object)behavior);
        }
        this.markEndOfStatement(tokens, dropNode);
        String originalExpression = (String)dropNode.getProperty("ddl:expression");
        Object startLineNumber = dropNode.getProperty("ddl:startLineNumber");
        Object startColumnNumber = dropNode.getProperty("ddl:startColumnNumber");
        Object startCharIndex = dropNode.getProperty("ddl:startCharIndex");
        if (nameList.size() > 1) {
            for (int i = 1; i < nameList.size(); ++i) {
                String nextName = (String)nameList.get(i);
                AstNode newNode = this.createSingleDropNode(nextName, startPhrase, originalExpression, usesIfExists, behavior, stmtType, parentNode);
                newNode.setProperty("ddl:startLineNumber", startLineNumber);
                newNode.setProperty("ddl:startColumnNumber", startColumnNumber);
                newNode.setProperty("ddl:startCharIndex", startCharIndex);
            }
            StringBuffer sb = new StringBuffer().append(this.getStatementTypeName(startPhrase));
            if (usesIfExists) {
                sb.append(" ").append("IF EXISTS");
            }
            sb.append(" ").append((String)nameList.get(0));
            if (behavior != null) {
                sb.append(" ").append(behavior);
            }
            sb.append(TERMINATOR);
            dropNode.setProperty("ddl:expression", (Object)sb.toString());
            dropNode.setProperty("ddl:length", (Object)sb.length());
            dropNode.setProperty("ddl:originalExpression", (Object)originalExpression);
        }
        return dropNode;
    }

    private AstNode createSingleDropNode(String name, String[] startPhrase, String originalExpression, boolean usesIfExists, String behavior, String nodeType, AstNode parentNode) {
        assert (name != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (nodeType != null);
        assert (parentNode != null);
        AstNode newNode = this.nodeFactory().node(name, parentNode, nodeType);
        StringBuffer sb = new StringBuffer().append(this.getStatementTypeName(startPhrase));
        if (usesIfExists) {
            sb.append(" ").append("IF EXISTS");
        }
        sb.append(" ").append(name);
        if (behavior != null) {
            sb.append(" ").append(behavior);
        }
        sb.append(TERMINATOR);
        newNode.setProperty("ddl:expression", (Object)sb.toString());
        newNode.setProperty("ddl:length", (Object)sb.length());
        newNode.setProperty("ddl:originalExpression", (Object)originalExpression);
        return newNode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        void var9_12;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("GRANT"));
        this.markStartOfStatement(tokens);
        List<Object> grantNodes = new ArrayList<AstNode>();
        boolean allPrivileges = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("GRANT");
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        if (allPrivileges || !privileges.isEmpty()) {
            tokens.consume("ON");
            if (tokens.canConsume("SCHEMA")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnSchemaStatement");
            } else if (tokens.canConsume("SEQUENCE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnSequenceStatement");
            } else if (tokens.canConsume("TABLESPACE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnTablespaceStatement");
            } else if (tokens.canConsume("DATABASE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnDatabaseStatement");
            } else if (tokens.canConsume("FUNCTION")) {
                grantNodes = this.parseFunctionAndParameters(tokens, parentNode);
            } else if (tokens.canConsume("LANGUAGE")) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnLanguageStatement");
            } else if (tokens.canConsume("FOREIGN", new String[]{"DATA", "WRAPPER"})) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnForeignDataWrapperStatement");
            } else if (tokens.canConsume("FOREIGN", new String[]{"SERVER"})) {
                grantNodes = this.parseMultipleGrantTargets(tokens, parentNode, "postgresddl:grantOnForeignServerStatement");
            } else {
                tokens.canConsume("TABLE");
                String name = this.parseName(tokens);
                AstNode grantNode = this.nodeFactory().node(name, parentNode, "ddl:grantOnTableStatement");
                grantNodes.add(grantNode);
                while (tokens.canConsume(",")) {
                    name = this.parseName(tokens);
                    grantNode = this.nodeFactory().node(name, parentNode, "ddl:grantOnTableStatement");
                    grantNodes.add(grantNode);
                }
            }
        } else {
            AstNode grantNode = this.nodeFactory().node("roles", parentNode, "postgresddl:grantRolesStatement");
            grantNodes.add(grantNode);
            do {
                String role = this.parseName(tokens);
                this.nodeFactory().node(role, grantNode, "postgresddl:role");
            } while (tokens.canConsume(","));
        }
        tokens.consume("TO");
        ArrayList<String> grantees = new ArrayList<String>();
        do {
            String grantee = this.parseName(tokens);
            grantees.add(grantee);
        } while (tokens.canConsume(","));
        boolean withGrantOption = false;
        if (tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"})) {
            withGrantOption = true;
        }
        for (AstNode astNode : grantNodes) {
            List<AstNode> copyOfPrivileges = this.copyOfPrivileges(privileges);
            for (AstNode node : copyOfPrivileges) {
                node.setParent(astNode);
            }
            if (allPrivileges) {
                astNode.setProperty("ddl:allPrivileges", (Object)allPrivileges);
            }
            for (String grantee : grantees) {
                this.nodeFactory().node(grantee, astNode, "ddl:grantee");
            }
            if (!withGrantOption) continue;
            AstNode optionNode = this.nodeFactory().node("withGrant", astNode, "ddl:statementOption");
            optionNode.setProperty("ddl:value", (Object)"WITH GRANT OPTION");
        }
        AstNode firstGrantNode = (AstNode)grantNodes.get(0);
        this.markEndOfStatement(tokens, firstGrantNode);
        boolean bl = true;
        while (var9_12 < grantNodes.size()) {
            AstNode grantNode = (AstNode)grantNodes.get((int)var9_12);
            grantNode.setProperty("ddl:expression", firstGrantNode.getProperty("ddl:expression"));
            grantNode.setProperty("ddl:length", firstGrantNode.getProperty("ddl:length"));
            grantNode.setProperty("ddl:startLineNumber", firstGrantNode.getProperty("ddl:startLineNumber"));
            grantNode.setProperty("ddl:startCharIndex", firstGrantNode.getProperty("ddl:startCharIndex"));
            grantNode.setProperty("ddl:startColumnNumber", firstGrantNode.getProperty("ddl:startColumnNumber"));
            ++var9_12;
        }
        return (AstNode)grantNodes.get(0);
    }

    @Override
    protected void parseGrantPrivileges(DdlTokenStream tokens, List<AstNode> privileges) throws ParsingException {
        do {
            AstNode node = null;
            if (tokens.canConsume("DELETE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"DELETE");
            } else if (tokens.canConsume("INSERT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"INSERT");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            } else if (tokens.canConsume("REFERENCES")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"REFERENCES");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            } else if (tokens.canConsume("SELECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"SELECT");
                this.consumeParenBoundedTokens(tokens, true);
            } else if (tokens.canConsume("USAGE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"USAGE");
            } else if (tokens.canConsume("UPDATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"UPDATE");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            } else if (tokens.canConsume("TRIGGER")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"TRIGGER");
            } else if (tokens.canConsume("TRUNCATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"TRUNCATE");
            } else if (tokens.canConsume("CREATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"CREATE");
            } else if (tokens.canConsume("CONNECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"CONNECT");
            } else if (tokens.canConsume("TEMPORARY")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"TEMPORARY");
            } else if (tokens.canConsume("TEMP")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"TEMP");
            } else if (tokens.canConsume("EXECUTE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"EXECUTE");
            }
            if (node == null) break;
            this.nodeFactory().setType(node, "ddl:grantPrivilege");
            privileges.add(node);
        } while (tokens.canConsume(","));
    }

    private List<AstNode> parseMultipleGrantTargets(DdlTokenStream tokens, AstNode parentNode, String nodeType) throws ParsingException {
        ArrayList<AstNode> grantNodes = new ArrayList<AstNode>();
        String name = this.parseName(tokens);
        AstNode grantNode = this.nodeFactory().node(name, parentNode, nodeType);
        grantNodes.add(grantNode);
        while (tokens.canConsume(",")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, nodeType);
            grantNodes.add(grantNode);
        }
        return grantNodes;
    }

    private List<AstNode> copyOfPrivileges(List<AstNode> privileges) {
        ArrayList<AstNode> copyOfPrivileges = new ArrayList<AstNode>();
        for (AstNode node : privileges) {
            copyOfPrivileges.add(node.clone());
        }
        return copyOfPrivileges;
    }

    private List<AstNode> parseFunctionAndParameters(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean isFirstFunction = true;
        ArrayList<AstNode> grantNodes = new ArrayList<AstNode>();
        do {
            String name = this.parseName(tokens);
            AstNode grantFunctionNode = this.nodeFactory().node(name, parentNode, "postgresddl:grantOnFunctionStatement");
            grantNodes.add(grantFunctionNode);
            if (tokens.matches("(")) {
                tokens.consume("(");
                if (!tokens.canConsume(")")) {
                    do {
                        String mode = null;
                        if (tokens.matchesAnyOf("IN", new String[]{"OUT", "INOUT", "VARIADIC"})) {
                            mode = tokens.consume();
                        }
                        AstNode paramNode = null;
                        DataType dType = this.getDatatypeParser().parse(tokens);
                        if (dType != null) {
                            paramNode = this.nodeFactory().node("parameter", grantFunctionNode, "postgresddl:functionParameter");
                            if (mode != null) {
                                paramNode.setProperty("postgresddl:mode", (Object)mode);
                            }
                            this.getDatatypeParser().setPropertiesOnNode(paramNode, dType);
                            continue;
                        }
                        String paramName = this.parseName(tokens);
                        dType = this.getDatatypeParser().parse(tokens);
                        assert (paramName != null);
                        paramNode = this.nodeFactory().node(paramName, grantFunctionNode, "postgresddl:functionParameter");
                        if (mode != null) {
                            paramNode.setProperty("postgresddl:mode", (Object)mode);
                        }
                        if (dType == null) continue;
                        this.getDatatypeParser().setPropertiesOnNode(paramNode, dType);
                    } while (tokens.canConsume(","));
                    tokens.consume(")");
                }
            }
            if (!isFirstFunction) continue;
            isFirstFunction = false;
        } while (tokens.canConsume(","));
        return grantNodes;
    }

    @Override
    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseSetStatement(tokens, parentNode);
    }

    private AstNode parseCommentStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("COMMENT", new String[]{"ON"});
        String objectType = null;
        String objectName = null;
        if (tokens.matches("TABLE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("COLUMN")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("AGGREGATE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("CAST")) {
            objectType = tokens.consume();
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("CONSTRAINT")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("CONVERSION")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("DATABASE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("DOMAIN")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("FUNCTION")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("INDEX")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("LARGE", new String[]{"OBJECT"})) {
            tokens.consume("LARGE", new String[]{"OBJECT"});
            objectType = "LARGE OBJECT";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("OPERATOR", new String[]{"FAMILY"})) {
            tokens.consume("OPERATOR", new String[]{"FAMILY"});
            objectType = "OPERATOR FAMILY";
            objectName = this.parseName(tokens);
            tokens.consume("USING");
            tokens.consume();
        } else if (tokens.matches("OPERATOR", new String[]{"CLASS"})) {
            tokens.consume("OPERATOR", new String[]{"CLASS"});
            objectType = "OPERATOR CLASS";
            objectName = this.parseName(tokens);
            tokens.consume("USING");
            tokens.consume();
        } else if (tokens.matches("OPERATOR")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            this.consumeParenBoundedTokens(tokens, true);
        } else if (tokens.matches("PROCEDURAL", new String[]{"LANGUAGE"})) {
            tokens.consume("PROCEDURAL", new String[]{"LANGUAGE"});
            objectType = "PROCEDURAL LANGUAGE";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("LANGUAGE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("ROLE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("RULE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("SCHEMA")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("SEQUENCE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TABLESPACE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "CONFIGURATION"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "CONFIGURATION"});
            objectType = "TEXT SEARCH CONFIGURATION";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "DICTIONARY"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "DICTIONARY"});
            objectType = "TEXT SEARCH DICTIONARY";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "PARSER"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "PARSER"});
            objectType = "TEXT SEARCH PARSER";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TEXT", new String[]{"SEARCH", "TEMPLATE"})) {
            tokens.consume("TEXT", new String[]{"SEARCH", "TEMPLATE"});
            objectType = "TEXT SEARCH TEMPLATE";
            objectName = this.parseName(tokens);
        } else if (tokens.matches("TRIGGER")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
            tokens.consume("ON");
            tokens.consume();
        } else if (tokens.matches("TYPE")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        } else if (tokens.matches("VIEW")) {
            objectType = tokens.consume();
            objectName = this.parseName(tokens);
        }
        String commentString = null;
        tokens.consume("IS");
        if (tokens.matches("NULL")) {
            tokens.consume("NULL");
            commentString = "NULL";
        } else {
            commentString = this.parseUntilTerminator(tokens).trim();
        }
        AstNode commentNode = null;
        if (objectName != null) {
            commentNode = this.nodeFactory().node(objectName, parentNode, "postgresddl:commentOnStatement");
            commentNode.setProperty("postgresddl:targetObjectName", (Object)objectName);
        } else {
            commentNode = this.nodeFactory().node("commentOn", parentNode, "postgresddl:commentOnStatement");
        }
        commentNode.setProperty("postgresddl:comment", (Object)commentString);
        commentNode.setProperty("postgresddl:targetObjectType", (Object)objectType);
        this.markEndOfStatement(tokens, commentNode);
        return commentNode;
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuffer unusedTokensSB = new StringBuffer();
        do {
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, isAlterTable);
                continue;
            }
            unusedTokensSB.append(" ").append(localTokens.consume());
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    private AstNode parseCreateRuleStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_RULE);
        tokens.canConsume(STMT_CREATE_RULE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "postgresddl:createRuleStatement");
        if (isReplace) {
            // empty if block
        }
        this.parseUntilTerminatorIgnoreEmbeddedStatements(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateFunctionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_FUNCTION);
        tokens.canConsume(STMT_CREATE_FUNCTION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "postgresddl:createFunctionStatement");
        if (isReplace) {
            // empty if block
        }
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected String[] getValidSchemaChildTypes() {
        return PostgresDdlConstants.PostgresStatementStartPhrases.VALID_SCHEMA_CHILD_STMTS;
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return PostgresDdlConstants.PostgresDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class PostgresDataTypeParser
    extends DataTypeParser {
        PostgresDataTypeParser() {
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmts : postgresDataTypeStrings) {
                if (!tokens.matches(stmts)) continue;
                return true;
            }
            return super.isCustomDataType(tokens);
        }

        @Override
        protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType result = null;
            String typeName = null;
            if (tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_FLOAT4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_FLOAT8)) {
                typeName = tokens.consume();
                result = new DataType(typeName);
                int precision = 0;
                if (tokens.matches('(')) {
                    precision = (int)this.parseBracketedLong(tokens, result);
                }
                result.setPrecision(precision);
            }
            if (result == null) {
                result = super.parseApproxNumericType(tokens);
            }
            return result;
        }

        @Override
        protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
            return super.parseBitStringType(tokens);
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType result = super.parseCharStringType(tokens);
            tokens.canConsume("FOR", new String[]{"BIT", "DATA"});
            return result;
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType result = null;
            String typeName = null;
            if (tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BIGSERIAL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_SERIAL8) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT2) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT4) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INT8) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOX) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOOL) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BOOLEAN) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_BYTEA) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_CIDR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_CIRCLE) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_INET) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_LINE) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_LSEG) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_MACADDR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_MONEY) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_PATH) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_POINT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_POLYGON) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TEXT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TSQUERY) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TSVECTOR) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_TXID_SNAPSHOT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_UUID) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_VARBIT) || tokens.matches(PostgresDdlConstants.PostgresDataTypes.DTYPE_XML)) {
                typeName = tokens.consume();
                result = new DataType(typeName);
            }
            if (result == null) {
                super.parseCustomType(tokens);
            }
            return result;
        }

        @Override
        protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
            DataType dtype = super.parseDateTimeType(tokens);
            tokens.canConsume("WITHOUT", new String[]{"TIME", "ZONE"});
            return dtype;
        }

        @Override
        protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
            return super.parseExactNumericType(tokens);
        }
    }
}

