/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;

@NotThreadSafe
public final class AstNode
implements Iterable<AstNode>,
Cloneable {
    private AstNode parent;
    private final String name;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final LinkedList<AstNode> children = new LinkedList();
    private final List<AstNode> childrenView = Collections.unmodifiableList(this.children);

    AstNode(String name) {
        this(null, name);
    }

    public AstNode(AstNode parent, String name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.name = name;
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public boolean addMixin(String mixin) {
        CheckArg.isNotEmpty((String)mixin, (String)"mixin");
        List<String> mixins = this.getMixins();
        if (!mixins.contains(mixin) && mixins.add(mixin)) {
            this.setProperty("jcr:mixinTypes", (Object)mixins);
        }
        return false;
    }

    public boolean hasMixin(String mixin) {
        CheckArg.isNotEmpty((String)mixin, (String)"mixin");
        return this.getMixins().contains(mixin);
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryType() {
        return (String)this.properties.get("jcr:primaryType");
    }

    public int getSameNameSiblingIndex() {
        int snsIndex = 1;
        if (this.parent == null) {
            return snsIndex;
        }
        for (AstNode sibling : this.parent.getChildren()) {
            if (sibling == this) break;
            if (!sibling.getName().equals(this.name)) continue;
            ++snsIndex;
        }
        return snsIndex;
    }

    public String getAbsolutePath() {
        StringBuilder pathBuilder = new StringBuilder("/").append(this.getName());
        for (AstNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            pathBuilder.insert(0, "/" + parent.getName());
        }
        return pathBuilder.toString();
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public AstNode setProperty(String name, Object value) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)value, (String)"value");
        this.properties.put(name, value);
        return this;
    }

    public AstNode setProperty(String name, Object ... values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)values, (String)"value");
        if (values.length != 0) {
            this.properties.put(name, Arrays.asList(values));
        }
        return this;
    }

    public Object removeProperty(String name) {
        return this.properties.remove(name);
    }

    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public List<String> getMixins() {
        Object mixinValues = this.getProperty("jcr:mixinTypes");
        ArrayList<String> result = new ArrayList<String>();
        if (mixinValues instanceof Collection) {
            result.addAll((Collection)mixinValues);
        } else if (mixinValues != null) {
            result.add(mixinValues.toString());
        }
        return result;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public void setParent(AstNode parent) {
        this.removeFromParent();
        if (parent != null) {
            this.parent = parent;
            this.parent.children.add(this);
        }
    }

    public void insertAsParent(AstNode newParent) {
        if (newParent == null) {
            return;
        }
        newParent.removeFromParent();
        if (this.parent != null) {
            this.parent.replaceChild(this, newParent);
        }
        newParent.addLastChild(this);
    }

    public AstNode removeFromParent() {
        AstNode result = this.parent;
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
        return result;
    }

    public boolean replaceChild(AstNode child, AstNode replacement) {
        assert (child != null);
        assert (replacement != null);
        if (child.parent == this) {
            int i = this.children.indexOf(child);
            if (replacement.parent == this) {
                int j = this.children.indexOf(replacement);
                this.children.set(i, replacement);
                this.children.set(j, child);
                return true;
            }
            this.children.set(i, replacement);
            replacement.removeFromParent();
            replacement.parent = this;
            child.parent = null;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public AstNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.getFirst();
    }

    public AstNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.getLast();
    }

    public List<AstNode> childrenWithName(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AstNode> matches = new ArrayList<AstNode>();
        for (AstNode kid : this.children) {
            if (!name.equals(kid.getName())) continue;
            matches.add(kid);
        }
        return matches;
    }

    public AstNode getChild(int index) {
        return this.children.isEmpty() ? null : this.children.get(index);
    }

    public void addFirstChild(AstNode child) {
        assert (child != null);
        this.children.addFirst(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addLastChild(AstNode child) {
        assert (child != null);
        this.children.addLast(child);
        child.removeFromParent();
        child.parent = this;
    }

    public void addChildren(Iterable<AstNode> otherChildren) {
        assert (otherChildren != null);
        for (AstNode planNode : otherChildren) {
            this.addLastChild(planNode);
        }
    }

    public void addChildren(AstNode first, AstNode second) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
    }

    public void addChildren(AstNode first, AstNode second, AstNode third) {
        if (first != null) {
            this.addLastChild(first);
        }
        if (second != null) {
            this.addLastChild(second);
        }
        if (third != null) {
            this.addLastChild(third);
        }
    }

    public boolean removeChild(AstNode child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.parent = null;
        }
        return result;
    }

    public void extractChild(AstNode child) {
        if (child.getChildCount() == 0) {
            this.removeChild(child);
        } else {
            AstNode grandChild = child.getFirstChild();
            this.replaceChild(child, grandChild);
        }
    }

    public void extractFromParent() {
        this.parent.extractChild(this);
    }

    public List<AstNode> getChildren() {
        return this.childrenView;
    }

    public List<AstNode> getChildren(String mixin) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        for (AstNode kid : this.getChildren()) {
            if (!kid.getMixins().contains(mixin)) continue;
            result.add(kid);
        }
        return result;
    }

    @Override
    public Iterator<AstNode> iterator() {
        return this.childrenView.iterator();
    }

    public List<AstNode> removeAllChildren() {
        if (this.children.isEmpty()) {
            return new ArrayList<AstNode>(0);
        }
        ArrayList<AstNode> copyOfChildren = new ArrayList<AstNode>(this.children);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            AstNode child = (AstNode)childIter.next();
            childIter.remove();
            child.parent = null;
        }
        return copyOfChildren;
    }

    public boolean isSameAs(AstNode other) {
        if (other == null) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!((Object)this.properties).equals(other.properties)) {
            return false;
        }
        if (this.getChildCount() != other.getChildCount()) {
            return false;
        }
        Iterator<AstNode> thisChildren = this.getChildren().iterator();
        Iterator<AstNode> thatChildren = other.getChildren().iterator();
        while (thisChildren.hasNext() && thatChildren.hasNext()) {
            if (thisChildren.next().isSameAs(thatChildren.next())) continue;
            return false;
        }
        return true;
    }

    public AstNode clone() {
        return this.cloneWithoutNewParent();
    }

    protected AstNode cloneWithoutNewParent() {
        AstNode result = new AstNode(this.name);
        result.properties.putAll(this.properties);
        for (AstNode child : this.children) {
            AstNode childClone = child.cloneWithoutNewParent();
            result.addLastChild(childClone);
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAbsolutePath());
        stringBuilder.append("[");
        Iterator<String> propertyIt = this.properties.keySet().iterator();
        while (propertyIt.hasNext()) {
            String propertyName = propertyIt.next();
            stringBuilder.append(propertyName).append(":").append(this.properties.get(propertyName));
            if (!propertyIt.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

