/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.AlterOptionsParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateProcedureParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTableParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTriggerParser;
import org.modeshape.sequencer.ddl.dialect.teiid.OptionNamespaceParser;
import org.modeshape.sequencer.ddl.dialect.teiid.StatementParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDataTypeParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlLexicon;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;
import org.modeshape.sequencer.ddl.node.AstNode;

public final class TeiidDdlParser
extends StandardDdlParser
implements TeiidDdlConstants {
    public static final String ID = "TEIID";
    private final Map<String, String> namespaceAliases;
    private final Collection<StatementParser> parsers;

    public TeiidDdlParser() {
        this.setDatatypeParser(new TeiidDataTypeParser());
        this.namespaceAliases = new HashMap<String, String>();
        ArrayList<StatementParser> temp = new ArrayList<StatementParser>(5);
        temp.add(new CreateTableParser(this));
        temp.add(new CreateProcedureParser(this));
        temp.add(new CreateTriggerParser(this));
        temp.add(new AlterOptionsParser(this));
        temp.add(new OptionNamespaceParser(this));
        this.parsers = Collections.unmodifiableCollection(temp);
    }

    boolean accessParseDefaultClause(DdlTokenStream tokens, AstNode columnNode) {
        return super.parseDefaultClause(tokens, columnNode);
    }

    String accessParseUntilTerminator(DdlTokenStream tokens) {
        return super.parseUntilTerminator(tokens);
    }

    String accessParseUntilTerminatorIgnoreEmbeddedStatements(DdlTokenStream tokens) {
        return super.parseUntilTerminatorIgnoreEmbeddedStatements(tokens);
    }

    void addNamespaceAlias(String alias, String identifier) {
        this.namespaceAliases.put(alias, identifier);
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return TeiidDdlConstants.TeiidDataType.getStartWords();
    }

    @Override
    public String getId() {
        return ID;
    }

    String getNamespaceUri(String alias) {
        return this.namespaceAliases.get(alias);
    }

    @Override
    protected String[] getValidSchemaChildTypes() {
        return TeiidDdlLexicon.getValidSchemaChildTypes();
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(TeiidDdlConstants.TeiidReservedWord.asList());
        tokens.registerKeyWords(TeiidDdlConstants.TeiidNonReservedWord.asList());
        for (TeiidDdlConstants.DdlStatement stmt : TeiidDdlConstants.DdlStatement.values()) {
            tokens.registerStatementStartPhrase(stmt.tokens());
        }
    }

    @Override
    protected AstNode parseNextStatement(DdlTokenStream tokens, AstNode parentNode) {
        for (StatementParser parser : this.parsers) {
            if (!parser.matches(tokens)) continue;
            this.markStartOfStatement(tokens);
            AstNode statementNode = parser.parse(tokens, parentNode);
            this.markEndOfStatement(tokens, statementNode);
            return statementNode;
        }
        throw new TeiidDdlParsingException(tokens, "Unparsable DDL statement");
    }

    @Override
    public void postProcess(AstNode rootNode) {
        super.postProcess(rootNode);
        for (StatementParser parser : this.parsers) {
            parser.postProcess(rootNode);
        }
    }
}

