/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.dialect.teiid.AlterOptionsParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateProcedureParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTableParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class AlterOptionsParserTest
extends TeiidDdlTest {
    private AstNode alterOptionsNodeTable;
    private AstNode tableRefNode;
    private AstNode alterOptionsNodeProcedure;
    private AstNode procedureRefNode;
    private AstNode alterOptionsNodeView;
    private AstNode viewRefNode;
    private AlterOptionsParser parser;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new AlterOptionsParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
        String tableContent = "CREATE FOREIGN TABLE foo(bar string, sledge string)";
        CreateTableParser tableParser = new CreateTableParser(teiidDdlParser);
        this.tableRefNode = tableParser.parse(this.getTokens("CREATE FOREIGN TABLE foo(bar string, sledge string)"), this.rootNode);
        this.alterOptionsNodeTable = teiidDdlParser.nodeFactory().node("alterOptionsNodeTable", this.rootNode, "teiidddl:alterOptionsList");
        this.alterOptionsNodeTable.setProperty("teiidddl:reference", (Object)this.tableRefNode);
        String procedureContent = "CREATE PROCEDURE myProc(p1 integer) RETURNS integer";
        CreateProcedureParser procedureParser = new CreateProcedureParser(teiidDdlParser);
        this.procedureRefNode = procedureParser.parse(this.getTokens("CREATE PROCEDURE myProc(p1 integer) RETURNS integer"), this.rootNode);
        this.alterOptionsNodeProcedure = teiidDdlParser.nodeFactory().node("alterOptionsNodeProcedure", this.rootNode, "teiidddl:alterOptionsList");
        this.alterOptionsNodeProcedure.setProperty("teiidddl:reference", (Object)this.procedureRefNode);
        String viewContent = "CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar";
        CreateTableParser viewParser = new CreateTableParser(teiidDdlParser);
        this.viewRefNode = viewParser.parse(this.getTokens("CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar"), this.rootNode);
        this.alterOptionsNodeView = teiidDdlParser.nodeFactory().node("alterOptionsNodeView", this.rootNode, "teiidddl:alterOptionsList");
        this.alterOptionsNodeView.setProperty("teiidddl:reference", (Object)this.viewRefNode);
    }

    @Test
    public void shouldParseAlterForeignProcedureWithColumnOptions() {
        String content = "ALTER FOREIGN PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("p1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterForeignProcedureWithOptionsList() {
        String content = "ALTER FOREIGN PROCEDURE myProc OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN PROCEDURE myProc OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterForeignTableWithColumnOptions() {
        String content = "ALTER FOREIGN TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("bar").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterForeignTableWithOptionsList() {
        String content = "ALTER FOREIGN TABLE foo OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN TABLE foo OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterForeignViewWithColumnOptions() {
        String content = "ALTER FOREIGN VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterForeignViewWithOptionsList() {
        String content = "ALTER FOREIGN VIEW G1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER FOREIGN VIEW G1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitProcedureWithColumnOptions() {
        String content = "ALTER PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("p1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitProcedureWithOptionsList() {
        String content = "ALTER PROCEDURE myProc OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER PROCEDURE myProc OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitTableWithColumnOptions() {
        String content = "ALTER TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("bar").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitTableWithOptionsList() {
        String content = "ALTER TABLE foo OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER TABLE foo OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitViewWithColumnOptions() {
        String content = "ALTER VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterImplicitViewWithOptionsList() {
        String content = "ALTER VIEW G1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIEW G1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualProcedureWithColumnOptions() {
        String content = "ALTER VIRTUAL PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL PROCEDURE myProc ALTER PARAMETER p1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("p1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualProcedureWithOptionsList() {
        String content = "ALTER VIRTUAL PROCEDURE myProc OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL PROCEDURE myProc OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"myProc"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterProcedure");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.procedureRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualTableWithColumnOptions() {
        String content = "ALTER VIRTUAL TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL TABLE foo ALTER COLUMN bar OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("bar").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualTableWithOptionsList() {
        String content = "ALTER VIRTUAL TABLE foo OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL TABLE foo OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterTable");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.tableRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualViewWithColumnOptions() {
        String content = "ALTER VIRTUAL VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL VIEW G1 ALTER COLUMN e1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterVirtualViewWithOptionsList() {
        String content = "ALTER VIRTUAL VIEW G1 OPTIONS (ADD cardinality 100)";
        AstNode alterOptionsNode = this.parser.parse(this.getTokens("ALTER VIRTUAL VIEW G1 OPTIONS (ADD cardinality 100)"), this.rootNode);
        Assert.assertThat((Object)alterOptionsNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(alterOptionsNode, "teiidddl:alterView");
        this.assertProperty(alterOptionsNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        this.assertProperty(alterOptionsNode, "teiidddl:reference", this.viewRefNode);
        Assert.assertThat((Object)alterOptionsNode.childrenWithName("alters").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseAlterAddOption() {
        String content = "OPTIONS (ADD updatable 'true')";
        Assert.assertThat((Object)this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (ADD updatable 'true')"), this.rootNode), (Matcher)Is.is((Object)true));
        List nodes = this.rootNode.childrenWithName("alters");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode optionsListNode = (AstNode)nodes.get(0);
        this.assertMixinType(optionsListNode, "teiidddl:alterOptionsList");
        List options = optionsListNode.childrenWithName("updatable");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "true");
    }

    @Test
    public void shouldParseAlterSetOption() {
        String content = "OPTIONS (SET updatable 'true')";
        Assert.assertThat((Object)this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (SET updatable 'true')"), this.rootNode), (Matcher)Is.is((Object)true));
        List nodes = this.rootNode.childrenWithName("alters");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode optionsListNode = (AstNode)nodes.get(0);
        this.assertMixinType(optionsListNode, "teiidddl:alterOptionsList");
        List options = optionsListNode.childrenWithName("updatable");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "true");
    }

    @Test
    public void shouldParseAlterDropOption() {
        String content = "OPTIONS (DROP updatable)";
        Assert.assertThat((Object)this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (DROP updatable)"), this.rootNode), (Matcher)Is.is((Object)true));
        List nodes = this.rootNode.childrenWithName("alters");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode optionsListNode = (AstNode)nodes.get(0);
        this.assertMixinType(optionsListNode, "teiidddl:alterOptionsList");
        Object value = optionsListNode.getProperty("teiidddl:dropped");
        Assert.assertThat((Object)value, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List dropped = (List)value;
        Assert.assertThat((Object)dropped.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(dropped.get(0), (Matcher)Is.is((Object)"updatable"));
    }

    @Test
    public void shouldParseAlterOptionList() {
        String content = "OPTIONS (ADD sledge 'foo', SET hammer 'bar', DROP elvis, DROP ringo)";
        Assert.assertThat((Object)this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (ADD sledge 'foo', SET hammer 'bar', DROP elvis, DROP ringo)"), this.rootNode), (Matcher)Is.is((Object)true));
        List nodes = this.rootNode.childrenWithName("alters");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode optionsListNode = (AstNode)nodes.get(0);
        this.assertMixinType(optionsListNode, "teiidddl:alterOptionsList");
        List options = optionsListNode.childrenWithName("sledge");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "foo");
        options = optionsListNode.childrenWithName("hammer");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "bar");
        Object value = optionsListNode.getProperty("teiidddl:dropped");
        Assert.assertThat((Object)value, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List dropped = (List)value;
        Assert.assertThat((Object)dropped.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)dropped, (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"elvis", "ringo"}));
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseEmptyOptionsList() {
        String content = "OPTIONS ()";
        this.parser.parseAlterOptionsList(this.getTokens("OPTIONS ()"), this.rootNode);
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseOptionsListWithBeginningComma() {
        String content = "OPTIONS (, SET updatable 'true')";
        this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (, SET updatable 'true')"), this.rootNode);
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseOptionsListWithEndingComma() {
        String content = "OPTIONS (SET updatable 'true',)";
        this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (SET updatable 'true',)"), this.rootNode);
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseOptionsListWithExtraComma() {
        String content = "OPTIONS (SET updatable 'true',, ADD sledge 'foo')";
        this.parser.parseAlterOptionsList(this.getTokens("OPTIONS (SET updatable 'true',, ADD sledge 'foo')"), this.rootNode);
    }

    @Test
    public void shouldNotParseOptionsListWithColumnOptions() {
        String content = "ALTER COLUMN mycolumn OPTIONS (ADD updatable true)";
        Assert.assertThat((Object)this.parser.parseAlterOptionsList(this.getTokens("ALTER COLUMN mycolumn OPTIONS (ADD updatable true)"), this.rootNode), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldParseAlterColumnOption() {
        String content = "ALTER COLUMN bar OPTIONS( ADD x 'y')";
        Assert.assertThat((Object)this.parser.parseAlterColumnOptions(this.getTokens("ALTER COLUMN bar OPTIONS( ADD x 'y')"), this.alterOptionsNodeTable), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.alterOptionsNodeTable.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode alterColumnNode = this.alterOptionsNodeTable.getFirstChild();
        Assert.assertThat((Object)alterColumnNode.getName(), (Matcher)Is.is((Object)"bar"));
        this.assertMixinType(alterColumnNode, "teiidddl:alterColumn");
        Assert.assertThat((Object)alterColumnNode.getProperty("teiidddl:reference"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        List options = alterColumnNode.childrenWithName("x");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "y");
    }

    @Test
    public void shouldParseImplicitAlterColumnOption() {
        String content = "ALTER bar OPTIONS( ADD x 'y')";
        Assert.assertThat((Object)this.parser.parseAlterColumnOptions(this.getTokens("ALTER bar OPTIONS( ADD x 'y')"), this.alterOptionsNodeTable), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.alterOptionsNodeTable.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode alterColumnNode = this.alterOptionsNodeTable.getFirstChild();
        Assert.assertThat((Object)alterColumnNode.getName(), (Matcher)Is.is((Object)"bar"));
        this.assertMixinType(alterColumnNode, "teiidddl:alterColumn");
        Assert.assertThat((Object)alterColumnNode.getProperty("teiidddl:reference"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        List options = alterColumnNode.childrenWithName("x");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "y");
    }

    @Test
    public void shouldParseAlterParameterOption() {
        String content = "ALTER PARAMETER p1 OPTIONS (ADD x 'y')";
        Assert.assertThat((Object)this.parser.parseAlterColumnOptions(this.getTokens("ALTER PARAMETER p1 OPTIONS (ADD x 'y')"), this.alterOptionsNodeProcedure), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.alterOptionsNodeProcedure.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode alterParamNode = this.alterOptionsNodeProcedure.getFirstChild();
        Assert.assertThat((Object)alterParamNode.getName(), (Matcher)Is.is((Object)"p1"));
        this.assertMixinType(alterParamNode, "teiidddl:alterParameter");
        Assert.assertThat((Object)alterParamNode.getProperty("teiidddl:reference"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        List options = alterParamNode.childrenWithName("x");
        Assert.assertThat((Object)options.size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)options.get(0), "ddl:value", "y");
    }
}

