/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;

class TeiidDataTypeParser
extends DataTypeParser {
    static final int[] DEFAULT_PRECISION_SCALE = new int[]{-1, -1};

    TeiidDataTypeParser() {
    }

    @Override
    protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
        throw new TeiidDdlParsingException(tokens, "isCustomDataType(DdlTokenStream) should not be called");
    }

    @Override
    public DataType parse(DdlTokenStream tokens) throws ParsingException {
        TeiidDdlConstants.TeiidDataType teiidType = null;
        long length = -1L;
        int[] precisionScale = DEFAULT_PRECISION_SCALE;
        for (TeiidDdlConstants.TeiidDataType teiidDataType : TeiidDdlConstants.TeiidDataType.values()) {
            if (!tokens.canConsume(teiidDataType.toDdl())) continue;
            teiidType = teiidDataType;
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.BIGDECIMAL) {
                precisionScale = this.parseDecimal(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.BIGINTEGER) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.BLOB) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.CHAR) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.CLOB) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.DECIMAL) {
                precisionScale = this.parseDecimal(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.STRING) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.VARBINARY) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType == TeiidDdlConstants.TeiidDataType.VARCHAR) {
                length = this.parseLength(tokens);
                break;
            }
            if (teiidDataType != TeiidDdlConstants.TeiidDataType.OBJECT) break;
            length = this.parseLength(tokens);
            break;
        }
        if (teiidType != null) {
            DataType type = new DataType(teiidType.toDdl());
            if (length != -1L) {
                type.setLength(length);
            }
            assert (precisionScale != null && precisionScale.length > 0);
            if (precisionScale != DEFAULT_PRECISION_SCALE) {
                if (precisionScale[0] != -1) {
                    type.setPrecision(precisionScale[0]);
                }
                if (precisionScale.length == 2 && precisionScale[1] != -1) {
                    type.setScale(precisionScale[1]);
                }
            }
            return type;
        }
        throw new TeiidDdlParsingException(tokens, "Unparsable data type");
    }

    private int[] parseDecimal(DdlTokenStream tokens) {
        if (tokens.canConsume("(")) {
            int precision = Integer.parseInt(tokens.consume());
            int scale = -1;
            if (tokens.canConsume(",")) {
                scale = Integer.parseInt(tokens.consume());
            }
            tokens.consume(")");
            if (scale == -1) {
                return new int[]{precision};
            }
            return new int[]{precision, scale};
        }
        return DEFAULT_PRECISION_SCALE;
    }

    private long parseLength(DdlTokenStream tokens) {
        if (tokens.canConsume("(")) {
            String value = tokens.consume();
            tokens.consume(")");
            return this.parseLong(value);
        }
        return -1L;
    }
}

