/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.dialect.teiid.StatementParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;
import org.modeshape.sequencer.ddl.node.AstNode;

final class CreateTableParser
extends StatementParser {
    protected static final String PRIMARY_KEY_PREFIX = "PK_";
    protected static final String FOREIGN_KEY_PREFIX = "FK_";
    protected static final String UNIQUE_CONSTRAINT_PREFIX = "UC_";
    protected static final String INDEX_PREFIX = "NDX_";
    protected static final String ACCESS_PATTERN_PREFIX = "AP_";
    private static final String REGEX = ".*\\b(?i)%s(?-i)\\b.*";
    private List<UnresolvedTableReferenceNode> unresolvedTableReferences = new ArrayList<UnresolvedTableReferenceNode>(10);

    static boolean contains(String expression, String columnName) {
        return expression.matches(String.format(REGEX, columnName));
    }

    CreateTableParser(TeiidDdlParser teiidDdlParser) {
        super(teiidDdlParser);
    }

    private String createConstraintName(String constraintType, AstNode tableNode) {
        String prefix = null;
        if ("PRIMARY KEY".equals(constraintType)) {
            prefix = PRIMARY_KEY_PREFIX;
        } else if ("FOREIGN KEY".equals(constraintType)) {
            prefix = FOREIGN_KEY_PREFIX;
        } else if (TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl().equals(constraintType)) {
            prefix = UNIQUE_CONSTRAINT_PREFIX;
        } else if (TeiidDdlConstants.TeiidNonReservedWord.INDEX.toDdl().equals(constraintType)) {
            prefix = INDEX_PREFIX;
        } else if (TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl().equals(constraintType)) {
            prefix = ACCESS_PATTERN_PREFIX;
        }
        int index = 1;
        String name;
        List<AstNode> kids;
        while (!(kids = tableNode.childrenWithName(name = prefix + index)).isEmpty()) {
            ++index;
        }
        return name;
    }

    private AstNode getColumnNode(AstNode tableNode, String columnName) {
        assert (tableNode != null);
        assert (columnName != null);
        List<AstNode> kids = tableNode.childrenWithName(columnName);
        if (kids.isEmpty()) {
            return null;
        }
        if (kids.size() == 1) {
            return kids.get(0);
        }
        for (AstNode kid : kids) {
            if (!kid.getMixins().contains("ddl:columnDefinition")) continue;
            return kid;
        }
        return null;
    }

    @Override
    boolean matches(DdlTokenStream tokens) {
        return tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_TABLE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_VIEW.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_VIEW.tokens());
    }

    @Override
    AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean view = true;
        TeiidDdlConstants.DdlStatement stmt = null;
        TeiidDdlConstants.SchemaElementType schemaElementType = null;
        if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_TABLE.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_TABLE;
            view = false;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_VIEW.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_VIEW;
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_VIEW.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_VIEW;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
        } else {
            throw new TeiidDdlParsingException(tokens, "Unparsable create table statement");
        }
        assert (stmt != null) : "Create table statement is null";
        String id = this.parseIdentifier(tokens);
        AstNode tableNode = this.getNodeFactory().node(id, parentNode, view ? "teiidddl:createView" : "teiidddl:createTable");
        tableNode.setProperty("teiidddl:schemaElementType", (Object)schemaElementType.toDdl());
        this.parseTableBody(tokens, tableNode);
        if (tokens.hasNext() && tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.AS.toDdl()) && !this.parseQueryExpression(tokens, tableNode)) {
            throw new TeiidDdlParsingException(tokens, "Unparsable create table statement");
        }
        return tableNode;
    }

    private String parseExpression(DdlTokenStream tokens) throws ParsingException {
        if (!tokens.hasNext() || !tokens.matches("(")) {
            throw new TeiidDdlParsingException(tokens, "Unparsable expression list");
        }
        Position prevPosition = tokens.nextPosition();
        String prevValue = tokens.consume();
        int numLeft = 1;
        int numRight = 0;
        StringBuilder text = new StringBuilder();
        while (tokens.hasNext()) {
            Position currPosition = tokens.nextPosition();
            if (tokens.matches("(")) {
                ++numLeft;
            } else if (tokens.matches(")") && numLeft == ++numRight) {
                tokens.consume(")");
                if (currPosition.getIndexInContent() - prevValue.length() + 1 - prevPosition.getIndexInContent() <= 1) break;
                text.append(" ");
                break;
            }
            String value = tokens.consume();
            text.append(this.getWhitespace(currPosition, prevPosition, prevValue));
            text.append(value);
            prevValue = value;
            prevPosition = currPosition;
        }
        if (numLeft != numRight) {
            throw new TeiidDdlParsingException(tokens, "Unparsable expression list");
        }
        return text.toString();
    }

    List<String> parseIdentifierList(DdlTokenStream tokens) throws ParsingException {
        if (tokens.canConsume("(")) {
            ArrayList<String> identifiers = new ArrayList<String>();
            String firstId = this.parseIdentifier(tokens);
            identifiers.add(firstId);
            while (tokens.canConsume(",")) {
                String nextId = this.parseIdentifier(tokens);
                identifiers.add(nextId);
            }
            if (tokens.canConsume(")")) {
                return identifiers;
            }
        }
        throw new TeiidDdlParsingException(tokens, "Unparsable identifier list");
    }

    boolean parseQueryExpression(DdlTokenStream tokens, AstNode tableNode) {
        String queryExpression = this.parseUntilTerminator(tokens);
        if (StringUtil.isBlank((String)queryExpression)) {
            return false;
        }
        tableNode.setProperty("teiidddl:queryExpression", (Object)queryExpression);
        return true;
    }

    private List<AstNode> parseReferenceList(DdlTokenStream tokens, AstNode tableNode, UnresolvedTableReferenceNode unresolvedReferencedTableNode) throws ParsingException {
        List<String> columns = this.parseIdentifierList(tokens);
        ArrayList<AstNode> references = new ArrayList<AstNode>(columns.size());
        for (String columnName : columns) {
            if (unresolvedReferencedTableNode != null) {
                unresolvedReferencedTableNode.addColumnReferenceName(columnName);
                continue;
            }
            AstNode referencedColumnNode = this.getColumnNode(tableNode, columnName);
            if (referencedColumnNode == null) {
                this.logger.debug("Create table statement node of column reference '{0}' was not found", new Object[]{columnName});
                continue;
            }
            references.add(referencedColumnNode);
        }
        return references;
    }

    void parseTableBody(DdlTokenStream tokens, AstNode tableNode) {
        if (tokens.canConsume("(")) {
            this.parseTableElement(tokens, tableNode);
            while (tokens.canConsume(",")) {
                if (this.parseTableBodyConstraint(tokens, tableNode)) continue;
                this.parseTableElement(tokens, tableNode);
            }
            if (!tokens.canConsume(")")) {
                throw new TeiidDdlParsingException(tokens, "Unparsable table body");
            }
        }
        this.parseOptionsClause(tokens, tableNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean parseTableBodyConstraint(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        if (!tokens.hasNext()) {
            return false;
        }
        if (!tokens.matches("CONSTRAINT") && !tokens.matches("PRIMARY", new String[]{"KEY"}) && !tokens.matches("FOREIGN", new String[]{"KEY"}) && !tokens.matches("UNIQUE") && !tokens.matches(TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl()) && !tokens.matches(TeiidDdlConstants.TeiidNonReservedWord.INDEX.toDdl())) return false;
        String constraintType = null;
        String constraintId = tokens.canConsume("CONSTRAINT") ? this.parseIdentifier(tokens) : null;
        AstNode constraintNode = null;
        String nodeType = null;
        if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches("FOREIGN", new String[]{"KEY"}) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl())) {
            if (tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
                constraintType = "PRIMARY KEY";
                nodeType = "teiidddl:tableElementConstraint";
            } else if (tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
                constraintType = "FOREIGN KEY";
                nodeType = "teiidddl:foreignKeyConstraint";
            } else if (tokens.matchesAnyOf(TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl(), new String[]{TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl()})) {
                constraintType = tokens.consume();
                nodeType = "teiidddl:tableElementConstraint";
            }
            assert (constraintType != null);
            assert (nodeType != null);
            List<AstNode> references = this.parseReferenceList(tokens, tableNode, null);
            if (StringUtil.isBlank((String)constraintId)) {
                constraintId = this.createConstraintName(constraintType, tableNode);
            }
            constraintNode = this.getNodeFactory().node(constraintId, tableNode, nodeType);
            constraintNode.setProperty("teiidddl:constraintType", (Object)constraintType);
            constraintNode.setProperty("teiidddl:tableElementRefs", (Object)references);
            if ("FOREIGN KEY".equals(constraintType)) {
                List<AstNode> constraintReferences;
                if (!tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.REFERENCES.toDdl())) throw new TeiidDdlParsingException(tokens, "Unparsable table body foreign key constraint (missing REFERENCES keyword)");
                String referencesTableName = this.parseIdentifier(tokens);
                AstNode referencesTableNode = this.getNode(tableNode.getParent(), referencesTableName, "teiidddl:createTable", "teiidddl:createView");
                UnresolvedTableReferenceNode unresolvedTableReferenceNode = null;
                if (referencesTableNode == null) {
                    unresolvedTableReferenceNode = new UnresolvedTableReferenceNode(constraintNode, referencesTableName);
                    this.unresolvedTableReferences.add(unresolvedTableReferenceNode);
                } else {
                    constraintNode.setProperty("teiidddl:tableRef", (Object)referencesTableNode);
                }
                if (tokens.matches("(") && !(constraintReferences = this.parseReferenceList(tokens, referencesTableNode, unresolvedTableReferenceNode)).isEmpty()) {
                    constraintNode.setProperty("teiidddl:tableRefElementRefs", (Object)constraintReferences);
                }
            }
        } else {
            if (!tokens.matches(TeiidDdlConstants.TeiidNonReservedWord.INDEX.toDdl(), new String[]{"("})) throw new TeiidDdlParsingException(tokens, "Unparsable table body constraint");
            tokens.consume(TeiidDdlConstants.TeiidNonReservedWord.INDEX.toDdl());
            constraintType = TeiidDdlConstants.TeiidNonReservedWord.INDEX.toDdl();
            if (StringUtil.isBlank((String)constraintId)) {
                constraintId = this.createConstraintName(constraintType, tableNode);
            }
            constraintNode = this.getNodeFactory().node(constraintId, tableNode, "teiidddl:indexConstraint");
            constraintNode.setProperty("teiidddl:constraintType", (Object)constraintType);
            String expression = this.parseExpression(tokens);
            constraintNode.setProperty("teiidddl:expression", (Object)expression);
            List<AstNode> columns = tableNode.getChildren("teiidddl:tableElement");
            HashSet<AstNode> referencedColumns = new HashSet<AstNode>(columns.size());
            for (AstNode column : columns) {
                if (!CreateTableParser.contains(expression, column.getName())) continue;
                referencedColumns.add(column);
            }
            if (!referencedColumns.isEmpty()) {
                constraintNode.setProperty("teiidddl:tableElementRefs", (Object)new ArrayList(referencedColumns));
            }
        }
        this.parseOptionsClause(tokens, constraintNode);
        return true;
    }

    AstNode parseTableElement(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        String id = this.parseIdentifier(tokens);
        DataType datatype = this.getDataTypeParser().parse(tokens);
        AstNode columnNode = this.getNodeFactory().node(id, tableNode, "teiidddl:tableElement");
        this.getDataTypeParser().setPropertiesOnNode(columnNode, datatype);
        boolean foundNotNull = false;
        boolean foundDefaultClause = false;
        boolean foundOptionsClause = false;
        boolean foundConstraintType = false;
        boolean foundAutoIncrement = false;
        while (!(!tokens.hasNext() || foundNotNull && foundDefaultClause && foundOptionsClause && foundConstraintType && foundAutoIncrement)) {
            if (!foundNotNull && tokens.canConsume(NOT_NULL)) {
                foundNotNull = true;
                continue;
            }
            if (!foundAutoIncrement && tokens.canConsume(TeiidDdlConstants.TeiidNonReservedWord.AUTO_INCREMENT.toDdl())) {
                foundAutoIncrement = true;
                continue;
            }
            if (!foundConstraintType && (tokens.matches(TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl()) || tokens.matches("INDEX") || tokens.matches("PRIMARY", new String[]{"KEY"}))) {
                AstNode constraintNode;
                foundConstraintType = true;
                String constraintType = null;
                if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl())) {
                    if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl())) {
                        constraintType = TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl();
                    } else {
                        tokens.consume("PRIMARY", new String[]{"KEY"});
                        constraintType = "PRIMARY KEY";
                    }
                    constraintNode = this.getNodeFactory().node(constraintType, tableNode, "teiidddl:tableElementConstraint");
                    constraintNode.setProperty("teiidddl:constraintType", (Object)constraintType);
                    constraintNode.setProperty("teiidddl:tableElementRefs", (Object)Collections.singletonList(columnNode));
                    continue;
                }
                if (tokens.canConsume("INDEX")) {
                    constraintType = "INDEX";
                    constraintNode = this.getNodeFactory().node(constraintType, tableNode, "teiidddl:indexConstraint");
                    constraintNode.setProperty("teiidddl:constraintType", (Object)constraintType);
                    constraintNode.setProperty("teiidddl:tableElementRefs", (Object)Collections.singletonList(columnNode));
                    continue;
                }
                throw new TeiidDdlParsingException(tokens, "Unparsable table body unnamed constraint");
            }
            if (!foundDefaultClause && this.parseDefaultClause(tokens, columnNode)) {
                foundDefaultClause = true;
                continue;
            }
            if (foundOptionsClause || !this.parseOptionsClause(tokens, columnNode)) break;
            foundOptionsClause = true;
        }
        columnNode.setProperty("teiidddl:autoIncrement", (Object)foundAutoIncrement);
        columnNode.setProperty("ddl:nullable", (Object)(foundNotNull ? "NOT NULL" : "NULL"));
        return columnNode;
    }

    @Override
    protected void postProcess(AstNode rootNode) {
        for (UnresolvedTableReferenceNode node : this.unresolvedTableReferences) {
            AstNode constraintNode = node.getContraintNode();
            String referencesTableName = node.getTableReferenceName();
            AstNode referencesTableNode = this.getNode(constraintNode.getParent().getParent(), referencesTableName, "teiidddl:createTable", "teiidddl:createView");
            if (referencesTableNode == null) {
                this.logger.debug("Create table statment foreign key reference table '{0}' was not found", new Object[]{referencesTableName});
                continue;
            }
            constraintNode.setProperty("teiidddl:tableRef", (Object)referencesTableNode);
            ArrayList<AstNode> references = new ArrayList<AstNode>(node.getColumnReferenceNames().size());
            for (String columnName : node.getColumnReferenceNames()) {
                AstNode referencedColumnNode = this.getColumnNode(referencesTableNode, columnName);
                if (referencedColumnNode == null) {
                    this.logger.debug("Create table statement node of column reference '{0}' was not found", new Object[]{columnName});
                    continue;
                }
                references.add(referencedColumnNode);
            }
            if (references.isEmpty()) continue;
            constraintNode.setProperty("teiidddl:tableRefElementRefs", (Object)references);
        }
        this.unresolvedTableReferences.clear();
    }

    class UnresolvedTableReferenceNode {
        AstNode contraintNode;
        String tableReferenceName;
        Set<String> columnReferenceNames;

        public UnresolvedTableReferenceNode(AstNode node, String name) {
            this.contraintNode = node;
            this.tableReferenceName = name;
            this.columnReferenceNames = new HashSet<String>();
        }

        public AstNode getContraintNode() {
            return this.contraintNode;
        }

        public String getTableReferenceName() {
            return this.tableReferenceName;
        }

        public void addColumnReferenceName(String name) {
            this.columnReferenceNames.add(name);
        }

        public Set<String> getColumnReferenceNames() {
            return this.columnReferenceNames;
        }
    }
}

