/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.oracle;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class OracleDdlParserTest
extends DdlParserTestHelper {
    public static final String DDL_FILE_PATH = "ddl/dialect/oracle/";

    @Before
    public void beforeEach() {
        this.parser = new OracleDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.scorer = new DdlParserScorer();
    }

    @Test
    public void shouldParseCreateOrReplaceTrigger() {
        this.printTest("shouldParseCreateOrReplaceTrigger()");
        String content = "CREATE OR REPLACE TRIGGER drop_trigger BEFORE DROP ON hr.SCHEMA BEGIN RAISE_APPLICATION_ERROR ( num => -20000,msg => 'Cannot drop object'); END; /";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createTriggerStatement"));
    }

    @Test
    public void shouldParseAnalyze() {
        this.printTest("shouldParseAnalyze()");
        String content = "ANALYZE TABLE customers VALIDATE STRUCTURE ONLINE;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:analyzeStatement"));
    }

    @Test
    public void shouldParseRollbackToSavepoint() {
        this.printTest("shouldParseRollbackToSavepoint()");
        String content = "ROLLBACK TO SAVEPOINT banda_sal;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:rollbackStatement"));
    }

    @Test
    public void shouldParseAlterTableAddREF() {
        this.printTest("shouldParseAlterTableAddREF()");
        String content = "ALTER TABLE staff ADD (REF(dept) WITH ROWID);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:alterTableStatement"));
    }

    @Test
    public void shouldParseAlterTableADDWithNESTED_TABLE() {
        this.printTest("shouldParseAlterTableADDWithNESTED_TABLE()");
        String content = "ALTER TABLE employees ADD (skills skill_table_type) NESTED TABLE skills STORE AS nested_skill_table;";
        this.assertScoreAndParse(content, null, 2);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:alterTableStatement"));
    }

    @Test
    public void shouldParseAlterIndexRename() {
        this.printTest("shouldParseAlterIndexRename()");
        String content = "ALTER INDEX upper_ix RENAME TO upper_name_ix;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:alterIndexStatement"));
    }

    @Test
    public void shouldParseAlterIndexMODIFY() {
        this.printTest("shouldParseAlterIndexMODIFY()");
        String content = "ALTER INDEX cost_ix MODIFY PARTITION p3 STORAGE(MAXEXTENTS 30) LOGGING;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:alterIndexStatement"));
    }

    @Test
    public void shouldParseAlterIndexDROP() {
        this.printTest("shouldParseAlterIndexDROP()");
        String content = "ALTER INDEX cost_ix DROP PARTITION p1;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:alterIndexStatement"));
    }

    @Test
    public void shouldParseAlterIndexTypeADD() {
        this.printTest("shouldParseAlterIndexTypeADD()");
        String content = "ALTER INDEXTYPE position_indextype ADD lob_contains(CLOB, CLOB);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:alterIndextypeStatement"));
    }

    @Test
    public void shouldParseTEMP_TEST() {
        this.printTest("shouldParseTEMP_TEST()");
        String content = "COMMENT ON COLUMN employees.job_id IS 'abbreviated job title';";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:commentOnStatement"));
    }

    @Test
    public void shouldParseGrantAllOn() {
        this.printTest("shouldParseGrant()");
        String content = "GRANT ALL ON bonuses TO hr WITH GRANT OPTION;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:grantStatement"));
    }

    @Test
    public void shouldParseCreateTable() {
        this.printTest("shouldParseCreateTable()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID BLOB (255) NOT NULL DEFAULT (100),  -- COLUMN 1 COMMENT with comma \nPARTCOLOR INTEGER NOT NULL) ON COMMIT DELETE ROWS;";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseCreateTableWithKilobyteInSize() {
        this.printTest("shouldParseCreateTableWithKilobyteInSize()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID BLOB (2K) NOT NULL,  -- COLUMN 1 COMMENT with comma \nPARTCOLOR CHAR(4M) NOT NULL) ON COMMIT DELETE ROWS;";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    public void shouldParseAlterTableWithModifyClause() {
        this.printTest("shouldParseAlterTableWithModifyClause()");
        String content = "ALTER TABLE employees MODIFY LOB (resume) (CACHE);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:alterTableStatement"));
    }

    @Test
    public void shouldParseAlterTableWithAddColumns() {
        this.printTest("shouldParseAlterTableWithModifyClause()");
        String content = "ALTER TABLE countries \n     ADD (duty_pct     NUMBER(2,2)  CHECK (duty_pct < 10.5),\n     visa_needed  VARCHAR2(3));";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:alterTableStatement"));
        Assert.assertEquals((long)3L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParseJava() {
        this.printTest("shouldParseJava()");
        String content = "CREATE JAVA SOURCE NAMED \"Hello\" AS public class Hello { public static String hello() {return \"Hello World\";   } };";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createJavaStatement"));
    }

    @Test
    public void shouldParseCreateOrReplaceTriggerWithEmbeddedStatements() {
        this.printTest("shouldParseCreateOrReplaceTriggerWithEmbeddedStatements()");
        String content = "CREATE OR REPLACE TRIGGER order_info_insert INSTEAD OF INSERT ON order_info DECLARE   duplicate_info EXCEPTION;   PRAGMA EXCEPTION_INIT (duplicate_info, -00001); BEGIN   INSERT INTO customers     (customer_id, cust_last_name, cust_first_name)   VALUES (   :new.customer_id,    :new.cust_last_name,   :new.cust_first_name); INSERT INTO orders (order_id, order_date, customer_id) VALUES (   :new.order_id,   :new.order_date,   :new.customer_id); EXCEPTION   WHEN duplicate_info THEN    RAISE_APPLICATION_ERROR (       num=> -20107,       msg=> 'Duplicate customer or order ID'); END order_info_insert; /";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createTriggerStatement"));
    }

    @Test
    public void shouldParseGrantReadOnDirectory() {
        this.printTest("shouldParseGrantReadOnDirectory()");
        String content = "GRANT READ ON DIRECTORY bfile_dir TO hr \n     WITH GRANT OPTION;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "ddl:grantStatement"));
    }

    @Test
    public void shouldParseCreateFunction_1() {
        this.printTest("shouldParseCreateFunction_1()");
        String content = "CREATE OR REPLACE FUNCTION text_length(a CLOB) RETURN NUMBER DETERMINISTIC IS BEGIN RETURN DBMS_LOB.GETLENGTH(a); END; /";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createFunctionStatement"));
    }

    @Test
    public void shouldParseCreateProcedure_1() {
        this.printTest("shouldParseCreateProcedure_1()");
        String content = "CREATE PROCEDURE remove_emp (employee_id NUMBER) AS tot_emps NUMBER;\nBEGIN\n   DELETE FROM employees\n   WHERE employees.employee_id = remove_emp.employee_id;\ntot_emps := tot_emps - 1;\nEND;\n/";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createProcedureStatement"));
    }

    @Test
    public void shouldParseCreateProcedure_2() {
        this.printTest("shouldParseCreateProcedure_2()");
        String content = "CREATE OR REPLACE PROCEDURE add_emp (employee_id NUMBER, employee_age NUMBER) AS tot_emps NUMBER;\nBEGIN\n   INSERT INTO employees\n   WHERE employees.employee_id = remove_emp.employee_id;\ntot_emps := tot_emps + 1;\nEND;\n/";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createProcedureStatement"));
        Assert.assertEquals((long)2L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParseOracleProceduresAndFunctions() {
        this.printTest("shouldParseOracleProceduresAndFunctions()");
        String content = this.getFileContent("ddl/dialect/oracle/create_procedure_statements.ddl");
        this.assertScoreAndParse(content, "create_procedure_statements.ddl", 4);
    }

    @Test
    public void shouldParseCreateMaterializedView() {
        this.printTest("shouldParseCreateMaterializedView()");
        String content = " CREATE MATERIALIZED VIEW sales_mv\nBUILD IMMEDIATE\nREFRESH FAST ON COMMIT\nAS SELECT t.calendar_year, p.prod_id, \n   SUM(s.amount_sold) AS sum_sales\n   FROM times t, products p, sales s\n   WHERE t.time_id = s.time_id AND p.prod_id = s.prod_id\n   GROUP BY t.calendar_year, p.prod_id;\n";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createMaterializedViewStatement"));
    }

    @Test
    public void shouldParseCreateMaterializedViewLog() {
        this.printTest("shouldParseCreateMaterializedViewLog()");
        String content = "CREATE MATERIALIZED VIEW LOG ON products\nWITH ROWID, SEQUENCE (prod_id)\nINCLUDING NEW VALUES;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode, "oracleddl:createMaterializedViewLogStatement"));
    }

    @Test
    public void shouldParseOracleStatements_1() {
        this.printTest("shouldParseOracleStatements_1()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_1.ddl");
        this.assertScoreAndParse(content, "oracle_test_statements_1", 50);
    }

    @Test
    public void shouldParseOracleStatements_2() {
        this.printTest("shouldParseOracleStatements_2()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_2.ddl");
        this.assertScoreAndParse(content, "oracle_test_statements_2", 50);
    }

    @Test
    public void shouldParseOracleStatements_3() {
        this.printTest("shouldParseOracleStatements_3()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        this.assertScoreAndParse(content, "oracle_test_statements_3", 50);
    }

    @Test
    public void shouldParseOracleStatements_4() {
        this.printTest("shouldParseOracleStatements_4()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_4.ddl");
        this.assertScoreAndParse(content, "oracle_test_statements_4", 48);
    }

    @Test
    @FixFor(value={"MODE-1326"})
    public void shouldSequenceCreateIndexStatements() throws Exception {
        String content = this.getFileContent("ddl/dialect/oracle/mode_1326.ddl");
        this.assertScoreAndParse(content, "mode_1326", 477);
    }

    @Test
    public void shouldParseCreateTableIndexStatementOrderedWithVariations() {
        String content = "CREATE TABLE BB_TEST_GROUP\n(\nBB_TEST_GROUP_ID NUMBER DEFAULT 0 NOT NULL,\nTEST_GROUP_DISPLAY CHAR(15 BYTE) DEFAULT ' ' NOT NULL,\nTEST_GROUP_DESCRIPTION  VARCHAR2(50 BYTE),\nACTIVE_IND NUMBER DEFAULT 0 NOT NULL,\nACTIVE_STATUS_CD NUMBER DEFAULT 0 NOT NULL,\nACTIVE_STATUS_PRSNL_ID NUMBER DEFAULT 0 NOT NULL,\nUPDT_CNT NUMBER DEFAULT 0 NOT NULL,\nUPDT_DT_TM DATE DEFAULT SYSDATE NOT NULL,\nUPDT_ID NUMBER DEFAULT 0 NOT NULL,\nUPDT_TASK NUMBER DEFAULT 0 NOT NULL,\nUPDT_APPLCTX NUMBER DEFAULT 0 NOT NULL\n)\nLOGGING \nNOCOMPRESS \nNOCACHE\nNOPARALLEL\nMONITORING;\nCREATE UNIQUE INDEX XAK1BB_TEST_GROUP ON BB_TEST_GROUP\n(TEST_GROUP_DISPLAY ASC, UPDT_CNT DESC)\nLOGGING\nCOMPRESS 4\nNOPARALLEL\nUNUSABLE;";
        this.parser.parse("CREATE TABLE BB_TEST_GROUP\n(\nBB_TEST_GROUP_ID NUMBER DEFAULT 0 NOT NULL,\nTEST_GROUP_DISPLAY CHAR(15 BYTE) DEFAULT ' ' NOT NULL,\nTEST_GROUP_DESCRIPTION  VARCHAR2(50 BYTE),\nACTIVE_IND NUMBER DEFAULT 0 NOT NULL,\nACTIVE_STATUS_CD NUMBER DEFAULT 0 NOT NULL,\nACTIVE_STATUS_PRSNL_ID NUMBER DEFAULT 0 NOT NULL,\nUPDT_CNT NUMBER DEFAULT 0 NOT NULL,\nUPDT_DT_TM DATE DEFAULT SYSDATE NOT NULL,\nUPDT_ID NUMBER DEFAULT 0 NOT NULL,\nUPDT_TASK NUMBER DEFAULT 0 NOT NULL,\nUPDT_APPLCTX NUMBER DEFAULT 0 NOT NULL\n)\nLOGGING \nNOCOMPRESS \nNOCACHE\nNOPARALLEL\nMONITORING;\nCREATE UNIQUE INDEX XAK1BB_TEST_GROUP ON BB_TEST_GROUP\n(TEST_GROUP_DISPLAY ASC, UPDT_CNT DESC)\nLOGGING\nCOMPRESS 4\nNOPARALLEL\nUNUSABLE;", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)2));
        List nodes = this.rootNode.childrenWithName("XAK1BB_TEST_GROUP");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)nodes.get(0);
        this.assertMixinType(indexNode, "oracleddl:createTableIndexStatement");
        this.assertProperty(indexNode, "oracleddl:indexType", "TABLE");
        this.assertProperty(indexNode, "oracleddl:tableName", "BB_TEST_GROUP");
        this.assertProperty(indexNode, "oracleddl:unique", true);
        this.assertProperty(indexNode, "oracleddl:bitmap", false);
        this.assertProperty(indexNode, "oracleddl:unusable", true);
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableAlias"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:otherRefs"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:whereClause"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        List indexAtributes = (List)indexNode.getProperty("oracleddl:indexAttributes");
        Assert.assertThat((Object)indexAtributes.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)indexAtributes, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"LOGGING", "COMPRESS 4", "NOPARALLEL"}));
        Assert.assertThat((Object)indexNode.getChildCount(), (Matcher)Is.is((Object)2));
        AstNode colRefNode = indexNode.getChild(0);
        Assert.assertThat((Object)colRefNode.getName(), (Matcher)Is.is((Object)"TEST_GROUP_DISPLAY"));
        this.assertProperty(colRefNode, "oracleddl:order", "ASC");
        this.assertMixinType(colRefNode, "ddl:columnReference");
        colRefNode = indexNode.getChild(1);
        Assert.assertThat((Object)colRefNode.getName(), (Matcher)Is.is((Object)"UPDT_CNT"));
        this.assertProperty(colRefNode, "oracleddl:order", "DESC");
        this.assertMixinType(colRefNode, "ddl:columnReference");
    }

    @Test
    public void shouldParseCreateTableIndexStatement() throws Exception {
        String content = "CREATE TABLE CUST_MPAGE(\nMPAGE_ID INTEGER,\nNAME VARCHAR2(50 BYTE),\nDESCRIPTION VARCHAR2(200 BYTE)\n)\nLOGGING\nNOCOMPRESS\nNOCACHE\nNOPARALLEL\nMONITORING;\nCREATE INDEX CUST_MPAGE_PK ON CUST_MPAGE (MPAGE_ID) LOGGING NOPARALLEL;";
        this.parser.parse("CREATE TABLE CUST_MPAGE(\nMPAGE_ID INTEGER,\nNAME VARCHAR2(50 BYTE),\nDESCRIPTION VARCHAR2(200 BYTE)\n)\nLOGGING\nNOCOMPRESS\nNOCACHE\nNOPARALLEL\nMONITORING;\nCREATE INDEX CUST_MPAGE_PK ON CUST_MPAGE (MPAGE_ID) LOGGING NOPARALLEL;", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)2));
        List nodes = this.rootNode.childrenWithName("CUST_MPAGE_PK");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)nodes.get(0);
        this.assertMixinType(indexNode, "oracleddl:createTableIndexStatement");
        this.assertProperty(indexNode, "oracleddl:indexType", "TABLE");
        this.assertProperty(indexNode, "oracleddl:tableName", "CUST_MPAGE");
        this.assertProperty(indexNode, "oracleddl:unique", false);
        this.assertProperty(indexNode, "oracleddl:bitmap", false);
        this.assertProperty(indexNode, "oracleddl:unusable", false);
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableAlias"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:otherRefs"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:whereClause"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        List indexAtributes = (List)indexNode.getProperty("oracleddl:indexAttributes");
        Assert.assertThat((Object)indexAtributes.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)indexAtributes, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"LOGGING", "NOPARALLEL"}));
        Assert.assertThat((Object)indexNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)indexNode.getFirstChild().getName(), (Matcher)Is.is((Object)"MPAGE_ID"));
        this.assertMixinType(indexNode.getFirstChild(), "ddl:columnReference");
    }

    @Test
    public void shouleParseCreateTableIndexWithFunctions() {
        String content = "CREATE TABLE Weatherdata_tab(\nMaxtemp INTEGER,\nMintemp INTEGER\n);\nCREATE BITMAP INDEX Compare_index\nON Weatherdata_tab ((Maxtemp - Mintemp) DESC, Maxtemp);";
        this.parser.parse("CREATE TABLE Weatherdata_tab(\nMaxtemp INTEGER,\nMintemp INTEGER\n);\nCREATE BITMAP INDEX Compare_index\nON Weatherdata_tab ((Maxtemp - Mintemp) DESC, Maxtemp);", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)2));
        List nodes = this.rootNode.childrenWithName("Compare_index");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)nodes.get(0);
        this.assertMixinType(indexNode, "oracleddl:createTableIndexStatement");
        this.assertProperty(indexNode, "oracleddl:indexType", "TABLE");
        this.assertProperty(indexNode, "oracleddl:tableName", "Weatherdata_tab");
        this.assertProperty(indexNode, "oracleddl:unique", false);
        this.assertProperty(indexNode, "oracleddl:bitmap", true);
        this.assertProperty(indexNode, "oracleddl:unusable", false);
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableAlias"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:whereClause"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        List functionRefs = (List)indexNode.getProperty("oracleddl:otherRefs");
        Assert.assertThat((Object)functionRefs.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)functionRefs, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"(Maxtemp-Mintemp) DESC"}));
        Assert.assertThat((Object)indexNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)indexNode.getFirstChild().getName(), (Matcher)Is.is((Object)"Maxtemp"));
        this.assertMixinType(indexNode.getFirstChild(), "ddl:columnReference");
    }

    @Test
    public void shouldParseCreateClusterIndexStatement() throws Exception {
        String content = "CREATE INDEX idx_personnel ON CLUSTER personnel;";
        this.parser.parse("CREATE INDEX idx_personnel ON CLUSTER personnel;", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        List nodes = this.rootNode.childrenWithName("idx_personnel");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)nodes.get(0);
        this.assertMixinType(indexNode, "oracleddl:createClusterIndexStatement");
        this.assertProperty(indexNode, "oracleddl:indexType", "CLUSTER");
        this.assertProperty(indexNode, "oracleddl:clustereName", "personnel");
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableName"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.assertProperty(indexNode, "oracleddl:unique", false);
        this.assertProperty(indexNode, "oracleddl:bitmap", false);
        this.assertProperty(indexNode, "oracleddl:unusable", false);
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableAlias"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:otherRefs"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:indexAttributes"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:whereClause"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseCreateBitmapJoinIndexStatement() throws Exception {
        String content = "CREATE TABLE sales(\ncust_id INTEGER,\ncust_name VARCHAR2(50 BYTE)\n);\nCREATE TABLE customers(\ncust_id INTEGER,\ncust_name VARCHAR2(50 BYTE)\n);\nCREATE BITMAP INDEX sales_cust_gender_bjix\nON sales(customers.cust_gender)\nFROM sales, customers\nWHERE sales.cust_id = customers.cust_id\nLOCAL;";
        this.parser.parse("CREATE TABLE sales(\ncust_id INTEGER,\ncust_name VARCHAR2(50 BYTE)\n);\nCREATE TABLE customers(\ncust_id INTEGER,\ncust_name VARCHAR2(50 BYTE)\n);\nCREATE BITMAP INDEX sales_cust_gender_bjix\nON sales(customers.cust_gender)\nFROM sales, customers\nWHERE sales.cust_id = customers.cust_id\nLOCAL;", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)3));
        List nodes = this.rootNode.childrenWithName("sales_cust_gender_bjix");
        Assert.assertThat((Object)nodes.size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)nodes.get(0);
        this.assertMixinType(indexNode, "oracleddl:createBitmapIndexStatement");
        this.assertProperty(indexNode, "oracleddl:indexType", "BITMAP");
        this.assertProperty(indexNode, "oracleddl:tableName", "sales");
        this.assertProperty(indexNode, "oracleddl:unique", false);
        this.assertProperty(indexNode, "oracleddl:bitmap", true);
        this.assertProperty(indexNode, "oracleddl:unusable", false);
        this.assertProperty(indexNode, "oracleddl:whereClause", "sales.cust_id = customers.cust_id LOCAL");
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:indexAttributes"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getProperty("oracleddl:tableAlias"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)indexNode.getChildCount(), (Matcher)Is.is((Object)3));
        List colRefs = indexNode.getChildren("ddl:columnReference");
        Assert.assertThat((Object)colRefs.size(), (Matcher)Is.is((Object)1));
        AstNode colRefNode = (AstNode)colRefs.get(0);
        Assert.assertThat((Object)colRefNode.getName(), (Matcher)Is.is((Object)"customers.cust_gender"));
        List tableRefs = indexNode.getChildren("ddl:tableReference");
        Assert.assertThat((Object)tableRefs.size(), (Matcher)Is.is((Object)2));
        AstNode tableRefNode = (AstNode)tableRefs.get(0);
        Assert.assertThat((Object)tableRefNode.getName(), (Matcher)Is.is((Object)"sales"));
        tableRefNode = (AstNode)tableRefs.get(1);
        Assert.assertThat((Object)tableRefNode.getName(), (Matcher)Is.is((Object)"customers"));
    }

    @Test
    public void shouldParseDbObjectNameWithValidSymbols() {
        String content = "CREATE TABLE EL$VIS (\nCOL_A VARCHAR2(20) NOT NULL,\nCOL@B VARCHAR2(10) NOT NULL,\nCOL#C NUMBER(10));";
        this.parser.parse("CREATE TABLE EL$VIS (\nCOL_A VARCHAR2(20) NOT NULL,\nCOL@B VARCHAR2(10) NOT NULL,\nCOL#C NUMBER(10));", this.rootNode, null);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"EL$VIS"));
        Assert.assertThat((Object)tableNode.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("COL_A").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.childrenWithName("COL@B").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.childrenWithName("COL#C").size(), (Matcher)Is.is((Object)1));
    }
}

