/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.oracle;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlConstants;
import org.modeshape.sequencer.ddl.node.AstNode;

public class OracleDdlParser
extends StandardDdlParser
implements OracleDdlConstants,
OracleDdlConstants.OracleStatementStartPhrases {
    public static final String ID = "ORACLE";
    static List<String[]> oracleDataTypeStrings = new ArrayList<String[]>();

    public OracleDdlParser() {
        this.setDatatypeParser(new OracleDataTypeParser());
        this.initialize();
    }

    @Override
    protected boolean areNextTokensCreateTableOptions(DdlTokenStream tokens) throws ParsingException {
        return tokens.hasNext() && !this.isTerminator(tokens) && tokens.computeNextStatementStartKeywordCount() == 0;
    }

    @Override
    protected void parseNextCreateTableOption(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        List<AstNode> options;
        String tableProperty = tokens.consume();
        boolean processed = false;
        if (tableProperty.matches("\\b\\d+\\b") && !(options = tableNode.getChildren("ddl:statementOption")).isEmpty()) {
            AstNode option = options.get(options.size() - 1);
            String currValue = (String)option.getProperty("ddl:value");
            option.setProperty("ddl:value", (Object)(currValue + " " + tableProperty));
            processed = true;
        }
        if (!processed) {
            AstNode tableOption = this.nodeFactory().node("option", tableNode, "ddl:statementOption");
            tableOption.setProperty("ddl:value", (Object)tableProperty);
        }
    }

    private void initialize() {
        this.setTerminator(";");
        this.setDoUseTerminator(true);
        oracleDataTypeStrings.addAll(OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String[] getIdentifyingKeywords() {
        return new String[]{this.getId(), "spool.log"};
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerKeyWords(OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_WORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
        tokens.registerStatementStartPhrase(SET_PHRASES);
    }

    @Override
    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        AstNode complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (complexNode != null && this.nodeFactory().hasMixinType(child, "ddl:unknownStatement") || complexNode != null && this.nodeFactory().hasMixinType(child, "oracleddl:backslashTerminator")) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
            } else {
                complexNode = null;
            }
            if (!this.nodeFactory().hasMixinType(child, "oracleddl:createFunctionStatement") && !this.nodeFactory().hasMixinType(child, "oracleddl:createTriggerStatement") && !this.nodeFactory().hasMixinType(child, "oracleddl:createLibraryStatement") && !this.nodeFactory().hasMixinType(child, "oracleddl:createPackageStatement") && !this.nodeFactory().hasMixinType(child, "oracleddl:createProcedureStatement")) continue;
            complexNode = child;
        }
        super.rewrite(tokens, rootNode);
        copyOfNodes = new ArrayList<AstNode>(rootNode.getChildren());
        boolean foundComplexNode = false;
        complexNode = null;
        for (AstNode child : copyOfNodes) {
            if (this.matchesComplexNode(child)) {
                foundComplexNode = true;
                complexNode = child;
                continue;
            }
            if (!foundComplexNode) continue;
            if (complexNode != null && this.nodeFactory().hasMixinType(child, "ddl:unknownStatement")) {
                this.mergeNodes(tokens, complexNode, child);
                rootNode.removeChild(child);
                continue;
            }
            foundComplexNode = false;
            complexNode = null;
        }
    }

    @Override
    protected String consumeIdentifier(DdlTokenStream tokens) throws ParsingException {
        Position startPosition = tokens.nextPosition();
        String id = super.consumeIdentifier(tokens);
        if (!tokens.hasNext()) {
            return id;
        }
        Position nextPosition = tokens.nextPosition();
        while (nextPosition.getIndexInContent() - startPosition.getIndexInContent() - id.length() == 0) {
            if (tokens.matches(2)) {
                if (!tokens.matches('$') && !tokens.matches('#') && !tokens.matches('@')) break;
                id = id + tokens.consume();
            } else {
                id = id + tokens.consume();
            }
            nextPosition = tokens.nextPosition();
        }
        return id;
    }

    private boolean matchesComplexNode(AstNode node) {
        assert (node != null);
        for (String mixin : COMPLEX_STMT_TYPES) {
            if (!this.nodeFactory().hasMixinType(node, mixin)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AstNode handleUnknownToken(DdlTokenStream tokens, String tokenValue) throws ParsingException {
        if (tokenValue.equals("/")) {
            return this.nodeFactory().node("backslashTerminator", this.getRootNode(), "oracleddl:backslashTerminator");
        }
        return null;
    }

    @Override
    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseCreateSchemaStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode result = null;
        if (tokens.matches(STMT_COMMENT_ON)) {
            result = this.parseCommentStatement(tokens, parentNode);
        } else {
            if (tokens.matches(STMT_ANALYZE)) {
                return this.parseStatement(tokens, STMT_ANALYZE, parentNode, "oracleddl:analyzeStatement");
            }
            if (tokens.matches(STMT_ASSOCIATE_STATISTICS)) {
                return this.parseStatement(tokens, STMT_ASSOCIATE_STATISTICS, parentNode, "oracleddl:associateStatisticsStatement");
            }
            if (tokens.matches(STMT_AUDIT)) {
                return this.parseStatement(tokens, STMT_AUDIT, parentNode, "oracleddl:auditStatement");
            }
            if (tokens.matches(STMT_COMMIT_FORCE) || tokens.matches(STMT_COMMIT_WORK) || tokens.matches(STMT_COMMIT_WRITE)) {
                return this.parseStatement(tokens, STMT_COMMIT, parentNode, "oracleddl:commitStatement");
            }
            if (tokens.matches(STMT_DISASSOCIATE_STATISTICS)) {
                return this.parseStatement(tokens, STMT_DISASSOCIATE_STATISTICS, parentNode, "oracleddl:disassociateStatisticsStatement");
            }
            if (tokens.matches(STMT_EXPLAIN_PLAN)) {
                return this.parseStatement(tokens, STMT_EXPLAIN_PLAN, parentNode, "oracleddl:explainPlanStatement");
            }
            if (tokens.matches(STMT_FLASHBACK)) {
                return this.parseStatement(tokens, STMT_FLASHBACK, parentNode, "oracleddl:flashbackStatement");
            }
            if (tokens.matches(STMT_LOCK_TABLE)) {
                return this.parseStatement(tokens, STMT_LOCK_TABLE, parentNode, "oracleddl:lockTableStatement");
            }
            if (tokens.matches(STMT_MERGE)) {
                return this.parseStatement(tokens, STMT_MERGE, parentNode, "oracleddl:mergeStatement");
            }
            if (tokens.matches(STMT_NOAUDIT)) {
                return this.parseStatement(tokens, STMT_NOAUDIT, parentNode, "oracleddl:noAuditStatement");
            }
            if (tokens.matches(STMT_PURGE)) {
                return this.parseStatement(tokens, STMT_PURGE, parentNode, "oracleddl:purgeStatement");
            }
            if (tokens.matches(STMT_RENAME)) {
                return this.parseStatement(tokens, STMT_RENAME, parentNode, "oracleddl:renameStatement");
            }
            if (tokens.matches(STMT_ROLLBACK)) {
                return this.parseStatement(tokens, STMT_ROLLBACK, parentNode, "oracleddl:rollbackStatement");
            }
            if (tokens.matches(STMT_ROLLBACK_WORK)) {
                return this.parseStatement(tokens, STMT_ROLLBACK_WORK, parentNode, "oracleddl:rollbackStatement");
            }
            if (tokens.matches(STMT_ROLLBACK_TO_SAVEPOINT)) {
                return this.parseStatement(tokens, STMT_ROLLBACK_TO_SAVEPOINT, parentNode, "oracleddl:rollbackStatement");
            }
            if (tokens.matches(STMT_SAVEPOINT)) {
                return this.parseStatement(tokens, STMT_SAVEPOINT, parentNode, "oracleddl:savepointStatement");
            }
            if (tokens.matches(STMT_TRUNCATE)) {
                return this.parseStatement(tokens, STMT_TRUNCATE, parentNode, "oracleddl:truncateStatement");
            }
        }
        if (result == null) {
            result = super.parseCustomStatement(tokens, parentNode);
        }
        return result;
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_INDEX) || tokens.matches(STMT_CREATE_UNIQUE_INDEX) || tokens.matches(STMT_CREATE_BITMAP_INDEX)) {
            return this.parseCreateIndex(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_CLUSTER)) {
            return this.parseCreateClusterStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_CONTEXT)) {
            return this.parseStatement(tokens, STMT_CREATE_CONTEXT, parentNode, "oracleddl:createContextStatement");
        }
        if (tokens.matches(STMT_CREATE_CONTROLFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_CONTROLFILE, parentNode, "oracleddl:createControlfileStatement");
        }
        if (tokens.matches(STMT_CREATE_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_DATABASE, parentNode, "oracleddl:createDatabaseStatement");
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_DATABASE)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_DATABASE, parentNode, "oracleddl:createDatabaseStatement");
        }
        if (tokens.matches(STMT_CREATE_DIMENSION)) {
            return this.parseCreateDimensionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_CREATE_DIRECTORY, parentNode, "oracleddl:createDirectoryStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_DIRECTORY, parentNode, "oracleddl:createDirectoryStatement");
        }
        if (tokens.matches(STMT_CREATE_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_CREATE_DISKGROUP, parentNode, "oracleddl:createDiskgroupStatement");
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_FUNCTION)) {
            return this.parseCreateFunctionStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_INDEXTYPE, parentNode, "oracleddl:createIndexTypeStatement");
        }
        if (tokens.matches(STMT_CREATE_JAVA)) {
            return this.parseCreateJavaStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_LIBRARY)) {
            return this.parseStatement(tokens, STMT_CREATE_LIBRARY, parentNode, "oracleddl:createLibraryStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_LIBRARY)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_LIBRARY, parentNode, "oracleddl:createLibraryStatement");
        }
        if (tokens.matches(STMT_CREATE_MATERIALIZED_VIEW)) {
            return this.parseMaterializedViewStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OPERATOR)) {
            return this.parseStatement(tokens, STMT_CREATE_OPERATOR, parentNode, "oracleddl:createOperatorStatement");
        }
        if (tokens.matches(STMT_CREATE_OUTLINE)) {
            return this.parseStatement(tokens, STMT_CREATE_OUTLINE, parentNode, "oracleddl:createOutlineStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_OUTLINE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_OUTLINE, parentNode, "oracleddl:createOutlineStatement");
        }
        if (tokens.matches(STMT_CREATE_PACKAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_PACKAGE, parentNode, "oracleddl:createPackageStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PACKAGE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_PACKAGE, parentNode, "oracleddl:createPackageStatement");
        }
        if (tokens.matches(STMT_CREATE_PFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_PFILE, parentNode, "oracleddl:createPfileStatement");
        }
        if (tokens.matches(STMT_CREATE_PROCEDURE)) {
            return this.parseCreateProcedureStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PROCEDURE)) {
            return this.parseCreateProcedureStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_PROFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_PROFILE, parentNode, "oracleddl:createProfileStatement");
        }
        if (tokens.matches(STMT_CREATE_ROLE)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLE, parentNode, "oracleddl:createRoleStatement");
        }
        if (tokens.matches(STMT_CREATE_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_CREATE_ROLLBACK, parentNode, "oracleddl:createRollbackStatement");
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_ROLLBACK, parentNode, "oracleddl:createRollbackStatement");
        }
        if (tokens.matches(STMT_CREATE_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_CREATE_SEQUENCE, parentNode, "oracleddl:createSequenceStatement");
        }
        if (tokens.matches(STMT_CREATE_SPFILE)) {
            return this.parseStatement(tokens, STMT_CREATE_SPFILE, parentNode, "oracleddl:createSpfileStatement");
        }
        if (tokens.matches(STMT_CREATE_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_SYNONYM, parentNode, "oracleddl:createSynonymStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_SYNONYM, parentNode, "oracleddl:createSynonymStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_PUBLIC_SYNONYM, parentNode, "oracleddl:createSynonymStatement");
        }
        if (tokens.matches(STMT_CREATE_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_CREATE_PUBLIC_SYNONYM, parentNode, "oracleddl:createSynonymStatement");
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_CREATE_TABLESPACE, parentNode, "oracleddl:createTablespaceStatement");
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseSlashedStatement(tokens, STMT_CREATE_TRIGGER, parentNode, "oracleddl:createTriggerStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_TRIGGER)) {
            return this.parseSlashedStatement(tokens, STMT_CREATE_OR_REPLACE_TRIGGER, parentNode, "oracleddl:createTriggerStatement");
        }
        if (tokens.matches(STMT_CREATE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_TYPE, parentNode, "oracleddl:createTypeStatement");
        }
        if (tokens.matches(STMT_CREATE_OR_REPLACE_TYPE)) {
            return this.parseStatement(tokens, STMT_CREATE_OR_REPLACE_TYPE, parentNode, "oracleddl:createTypeStatement");
        }
        if (tokens.matches(STMT_CREATE_USER)) {
            return this.parseStatement(tokens, STMT_CREATE_USER, parentNode, "oracleddl:createUserStatement");
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    private AstNode parseCreateClusterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_CLUSTER);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "oracleddl:createClusterStatement");
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateDimensionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_DIMENSION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "oracleddl:createDimensionStatement");
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateFunctionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        DataType dType;
        boolean ok;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_FUNCTION);
        tokens.canConsume(STMT_CREATE_FUNCTION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "oracleddl:createFunctionStatement");
        if (isReplace) {
            // empty if block
        }
        if ((ok = this.parseParameters(tokens, node)) && tokens.canConsume("RETURN") && (dType = this.getDatatypeParser().parse(tokens)) != null) {
            this.getDatatypeParser().setPropertiesOnNode(node, dType);
        }
        this.parseUntilFwdSlash(tokens, false);
        tokens.canConsume("/");
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateProcedureStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean ok;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isReplace = tokens.canConsume(STMT_CREATE_OR_REPLACE_PROCEDURE);
        tokens.canConsume(STMT_CREATE_PROCEDURE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "oracleddl:createProcedureStatement");
        if (isReplace) {
            // empty if block
        }
        if ((ok = this.parseParameters(tokens, node)) && tokens.canConsume("AUTHID")) {
            if (tokens.canConsume("CURRENT_USER")) {
                node.setProperty("oracleddl:authIdValue", (Object)"AUTHID CURRENT_USER");
            } else {
                tokens.consume("DEFINER");
                node.setProperty("oracleddl:authIdValue", (Object)"DEFINER");
            }
        }
        this.parseUntilFwdSlash(tokens, false);
        tokens.canConsume("/");
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private boolean parseParameters(DdlTokenStream tokens, AstNode procedureNode) throws ParsingException {
        assert (tokens != null);
        assert (procedureNode != null);
        tokens.consume("(");
        while (!tokens.canConsume(")")) {
            String paramName = this.parseName(tokens);
            String inOutStr = null;
            if (tokens.matches("IN")) {
                if (tokens.canConsume("IN", new String[]{"OUT"})) {
                    inOutStr = tokens.canConsume("NOCOPY") ? "IN OUT NOCOPY" : "IN OUT";
                } else {
                    tokens.consume("IN");
                    inOutStr = "IN";
                }
            } else if (tokens.matches("OUT")) {
                if (tokens.canConsume("OUT", new String[]{"NOCOPY"})) {
                    inOutStr = "OUT NOCOPY";
                } else {
                    tokens.consume("OUT");
                    inOutStr = "OUT";
                }
            }
            DataType datatype = this.getDatatypeParser().parse(tokens);
            AstNode paramNode = this.nodeFactory().node(paramName, procedureNode, "oracleddl:functionParameter");
            if (datatype != null) {
                this.getDatatypeParser().setPropertiesOnNode(paramNode, datatype);
            }
            if (tokens.matchesAnyOf(":=", new String[]{"DEFAULT"}) || !tokens.matchesAnyOf(",", new String[]{")"})) {
                String msg = DdlSequencerI18n.unsupportedProcedureParameterDeclaration.text(new Object[]{procedureNode.getName()});
                DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
                this.addProblem(problem, procedureNode);
                return false;
            }
            if (inOutStr != null) {
                paramNode.setProperty("oracleddl:inOutNoCopy", (Object)inOutStr);
            }
            tokens.canConsume(",");
        }
        return true;
    }

    protected AstNode parseMaterializedViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        boolean isLog = tokens.canConsume(STMT_CREATE_MATERIALIZED_VEIW_LOG);
        tokens.canConsume(STMT_CREATE_MATERIALIZED_VIEW);
        String name = this.parseName(tokens);
        AstNode node = null;
        node = isLog ? this.nodeFactory().node(name, parentNode, "oracleddl:createMaterializedViewLogStatement") : this.nodeFactory().node(name, parentNode, "oracleddl:createMaterializedViewStatement");
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        AstNode node = null;
        this.markStartOfStatement(tokens);
        tokens.consume("GRANT");
        String name = "GRANT";
        tokens.consume();
        node = this.nodeFactory().node(name, parentNode, "ddl:grantStatement");
        while (tokens.hasNext() && !this.isTerminator(tokens) && (!tokens.matches(128) || tokens.matches(128) && tokens.matches("GRANT", new String[]{"OPTION"}))) {
            tokens.consume();
        }
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected AstNode parseRevokeStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        return this.parseStatement(tokens, STMT_REVOKE, parentNode, "oracleddl:revokeStatement");
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("ALTER", new String[]{"TABLE"});
        String tableName = this.parseName(tokens);
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, "ddl:alterTableStatement");
        if (tokens.canConsume("RENAME")) {
            if (tokens.matches("COLUMN", new String[]{"any value", "TO", "any value"})) {
                tokens.consume("COLUMN");
                String oldColumnName = this.parseName(tokens);
                tokens.consume("TO");
                String newColumnName = this.parseName(tokens);
                AstNode renameColumn = this.nodeFactory().node(oldColumnName, alterTableNode, "oracleddl:renameColumn");
                renameColumn.setProperty("ddl:newName", (Object)newColumnName);
            } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "TO", "any value"})) {
                tokens.consume("CONSTRAINT");
                String oldConstraintName = this.parseName(tokens);
                tokens.consume("TO");
                String newConstraintName = this.parseName(tokens);
                AstNode renameColumn = this.nodeFactory().node(oldConstraintName, alterTableNode, "oracleddl:renameConstraint");
                renameColumn.setProperty("ddl:newName", (Object)newConstraintName);
            } else if (tokens.canConsume("TO")) {
                alterTableNode.setProperty("ddl:newName", (Object)this.parseName(tokens));
            }
            this.parseUntilTerminator(tokens);
        } else if (tokens.canConsume("DROP")) {
            if (tokens.matches("(")) {
                this.parseColumnNameList(tokens, alterTableNode, "ddl:dropColumnDefinition");
            } else if (tokens.canConsume("COLUMN")) {
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, "ddl:dropColumnDefinition");
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            } else if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, "ddl:dropTableConstraintDefinition");
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            }
            this.parseUntilTerminator(tokens);
        } else {
            while (tokens.hasNext() && !tokens.matches(128) && (this.doUseTerminator() && !this.isTerminator(tokens) || !this.doUseTerminator())) {
                while (tokens.hasNext() && !tokens.matchesAnyOf(new String[]{"ADD", "MODIFY"}) && (this.doUseTerminator() && !this.isTerminator(tokens) || !this.doUseTerminator())) {
                    tokens.consume();
                }
                if (!tokens.hasNext()) break;
                if (tokens.canConsume("ADD")) {
                    if (this.isTableConstraint(tokens)) {
                        this.parseTableConstraint(tokens, alterTableNode, true);
                        continue;
                    }
                    if (tokens.matches("(", new String[]{"REF"})) {
                        tokens.consume("(", new String[]{"REF", "("});
                        this.parseName(tokens);
                        tokens.consume(")", new String[]{"WITH", "ROWID", ")"});
                        continue;
                    }
                    if (tokens.matches("(", new String[]{"SCOPE"})) {
                        tokens.consume("(", new String[]{"SCOPE", "FOR", "("});
                        this.parseName(tokens);
                        tokens.consume(")", new String[]{"IS"});
                        this.parseName(tokens);
                        tokens.consume(")");
                        continue;
                    }
                    if (tokens.matches("(")) {
                        this.parseColumns(tokens, alterTableNode, "ddl:addColumnDefinition");
                        continue;
                    }
                    this.parseColumnDefinition(tokens, alterTableNode, "ddl:addColumnDefinition");
                    continue;
                }
                if (!tokens.canConsume("MODIFY")) continue;
                if (tokens.matches("(")) {
                    this.parseColumns(tokens, alterTableNode, "ddl:alterColumnDefinition");
                    continue;
                }
                if (tokens.matchesAnyOf("COLUMN", new String[]{"LOB", "NESTED", "DEFAULT", "PARTITION", "SUBPARTITION"})) continue;
                this.parseColumnDefinition(tokens, alterTableNode, "ddl:alterColumnDefinition");
            }
        }
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("ALTER", new String[]{"TABLE"})) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        if (tokens.matches(STMT_ALTER_CLUSTER)) {
            return this.parseStatement(tokens, STMT_ALTER_CLUSTER, parentNode, "oracleddl:alterIndexStatement");
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_ALTER_DATABASE);
            AstNode result = this.nodeFactory().node("database", parentNode, "oracleddl:alterDatabaseStatement");
            tokens.canConsume("RENAME");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_DIMENSION)) {
            return this.parseStatement(tokens, STMT_ALTER_DIMENSION, parentNode, "oracleddl:alterDimensionStatement");
        }
        if (tokens.matches(STMT_ALTER_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_DISKGROUP, parentNode, "oracleddl:alterDiskgroupStatement");
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, "oracleddl:alterFunctionStatement");
        }
        if (tokens.matches(STMT_ALTER_INDEX)) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"INDEX"});
            String indexName = this.parseName(tokens);
            AstNode result = this.nodeFactory().node(indexName, parentNode, "oracleddl:alterIndexStatement");
            tokens.canConsume("RENAME");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_INDEXTYPE, parentNode, "oracleddl:alterIndextypeStatement");
        }
        if (tokens.matches(STMT_ALTER_JAVA)) {
            return this.parseStatement(tokens, STMT_ALTER_JAVA, parentNode, "oracleddl:alterJavaStatement");
        }
        if (tokens.matches(STMT_ALTER_MATERIALIZED)) {
            return this.parseStatement(tokens, STMT_ALTER_MATERIALIZED, parentNode, "oracleddl:alterMaterializedStatement");
        }
        if (tokens.matches(STMT_ALTER_OPERATOR)) {
            return this.parseStatement(tokens, STMT_ALTER_OPERATOR, parentNode, "oracleddl:alterOperatorStatement");
        }
        if (tokens.matches(STMT_ALTER_OUTLINE)) {
            return this.parseStatement(tokens, STMT_ALTER_OUTLINE, parentNode, "oracleddl:alterOutlineStatement");
        }
        if (tokens.matches(STMT_ALTER_PACKAGE)) {
            return this.parseStatement(tokens, STMT_ALTER_PACKAGE, parentNode, "oracleddl:alterPackageStatement");
        }
        if (tokens.matches(STMT_ALTER_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROCEDURE, parentNode, "oracleddl:alterProcedureStatement");
        }
        if (tokens.matches(STMT_ALTER_PROFILE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROFILE, parentNode, "oracleddl:alterProfileStatement");
        }
        if (tokens.matches(STMT_ALTER_RESOURCE)) {
            return this.parseStatement(tokens, STMT_ALTER_RESOURCE, parentNode, "oracleddl:alterResourceStatement");
        }
        if (tokens.matches(STMT_ALTER_ROLE)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLE, parentNode, "oracleddl:alterRoleStatement");
        }
        if (tokens.matches(STMT_ALTER_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_ALTER_ROLLBACK, parentNode, "oracleddl:alterRollbackStatement");
        }
        if (tokens.matches(STMT_ALTER_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_ALTER_SEQUENCE, parentNode, "oracleddl:alterSequenceStatement");
        }
        if (tokens.matches(STMT_ALTER_SESSION)) {
            return this.parseStatement(tokens, STMT_ALTER_SESSION, parentNode, "oracleddl:alterSessionStatement");
        }
        if (tokens.matches(STMT_ALTER_SYSTEM)) {
            return this.parseStatement(tokens, STMT_ALTER_SYSTEM, parentNode, "oracleddl:alterSystemStatement");
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, "oracleddl:alterTablespaceStatement");
        }
        if (tokens.matches(STMT_ALTER_TRIGGER)) {
            return this.parseStatement(tokens, STMT_ALTER_TRIGGER, parentNode, "oracleddl:alterTriggerStatement");
        }
        if (tokens.matches(STMT_ALTER_TYPE)) {
            return this.parseStatement(tokens, STMT_ALTER_TYPE, parentNode, "oracleddl:alterTypeStatement");
        }
        if (tokens.matches(STMT_ALTER_USER)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_ALTER_USER);
            String name = this.parseName(tokens);
            AstNode result = this.nodeFactory().node(name, parentNode, "oracleddl:alterUserStatement");
            tokens.canConsume("GRANT");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, result);
            return result;
        }
        if (tokens.matches(STMT_ALTER_VIEW)) {
            return this.parseStatement(tokens, STMT_ALTER_VIEW, parentNode, "oracleddl:alterViewStatement");
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String stmtType = "CREATE";
        tokens.consume("CREATE");
        if (tokens.canConsume("OR", new String[]{"REPLACE"})) {
            stmtType = stmtType + " " + "OR REPLACE";
        } else if (tokens.canConsume("NO", new String[]{"FORCE"})) {
            stmtType = stmtType + " " + "NO FORCE";
        } else if (tokens.canConsume("FORCE")) {
            stmtType = stmtType + " " + "FORCE";
        }
        tokens.consume("VIEW");
        stmtType = stmtType + " " + "VIEW";
        String name = this.parseName(tokens);
        AstNode createViewNode = this.nodeFactory().node(name, parentNode, "ddl:createViewStatement");
        this.parseColumnNameList(tokens, createViewNode, "ddl:columnReference");
        if (tokens.matches("OF")) {
            do {
                tokens.consume();
            } while (!tokens.matches("AS"));
        }
        tokens.consume("AS");
        String queryExpression = this.parseUntilTerminator(tokens);
        createViewNode.setProperty("ddl:queryExpression", (Object)queryExpression);
        this.markEndOfStatement(tokens, createViewNode);
        return createViewNode;
    }

    private String parseContentBetweenParens(DdlTokenStream tokens) throws ParsingException {
        tokens.consume("(");
        int numLeft = 1;
        int numRight = 0;
        StringBuilder text = new StringBuilder();
        while (tokens.hasNext()) {
            if (tokens.matches("(")) {
                ++numLeft;
            } else if (tokens.matches(")") && numLeft == ++numRight) {
                tokens.consume(")");
                break;
            }
            String token = tokens.consume();
            if (!".".equals(token) && text.length() != 0 && ".".charAt(0) != text.charAt(text.length() - 1)) {
                text.append(" ");
            }
            text.append(token);
        }
        if (numLeft != numRight || text.length() == 0) {
            throw new ParsingException(tokens.nextPosition());
        }
        return text.toString();
    }

    private void parseIndexColumnExpressionList(String columnExpressionList, AstNode indexNode) {
        DdlTokenStream tokens = new DdlTokenStream(columnExpressionList, DdlTokenStream.ddlTokenizer(false), false);
        tokens.start();
        tokens.consume("(");
        int numLeft = 1;
        int numRight = 0;
        if (!tokens.matches(")")) {
            ArrayList<String> possibleColumns = new ArrayList<String>();
            ArrayList<String> functions = new ArrayList<String>();
            StringBuilder text = new StringBuilder();
            boolean isFunction = false;
            while (tokens.hasNext()) {
                if (tokens.canConsume(",")) {
                    if (isFunction) {
                        functions.add(text.toString());
                    } else {
                        possibleColumns.add(text.toString());
                    }
                    text.setLength(0);
                    isFunction = false;
                    continue;
                }
                if (tokens.matches("(")) {
                    isFunction = true;
                    ++numLeft;
                } else if (tokens.matches("ASC") || tokens.matches("DESC")) {
                    text.append(" ");
                } else if (tokens.matches(")") && numLeft == ++numRight) {
                    if (isFunction) {
                        functions.add(text.toString());
                        break;
                    }
                    possibleColumns.add(text.toString());
                    break;
                }
                text.append(tokens.consume());
            }
            if (!possibleColumns.isEmpty()) {
                List<AstNode> tableNodes = null;
                boolean tableIndex = indexNode.hasMixin("oracleddl:createTableIndexStatement");
                if (tableIndex) {
                    String tableName = (String)indexNode.getProperty("oracleddl:tableName");
                    AstNode parent = indexNode.getParent();
                    List<AstNode> nodes = parent.childrenWithName(tableName);
                    if (!nodes.isEmpty()) {
                        if (nodes.size() == 1) {
                            tableNodes = nodes;
                        } else {
                            for (AstNode node : nodes) {
                                if (!node.hasMixin("ddl:createTableStatement")) continue;
                                tableNodes = new ArrayList<AstNode>(1);
                                tableNodes.add(node);
                                break;
                            }
                        }
                    }
                } else {
                    tableNodes = indexNode.getChildren("ddl:tableReference");
                }
                if (tableNodes != null && !tableNodes.isEmpty()) {
                    boolean processed = false;
                    for (String possibleColumn : possibleColumns) {
                        boolean desc;
                        int ascIndex = possibleColumn.toUpperCase().indexOf(" ASC");
                        boolean asc = ascIndex != -1;
                        int descIndex = possibleColumn.toUpperCase().indexOf(" DESC");
                        boolean bl = desc = descIndex != -1;
                        if (asc) {
                            possibleColumn = possibleColumn.substring(0, ascIndex);
                        } else if (desc) {
                            possibleColumn = possibleColumn.substring(0, descIndex);
                        }
                        if (tableIndex) {
                            if (tableNodes.isEmpty()) {
                                if (asc) {
                                    functions.add(possibleColumn + " " + "ASC");
                                    continue;
                                }
                                if (desc) {
                                    functions.add(possibleColumn + " " + "DESC");
                                    continue;
                                }
                                functions.add(possibleColumn);
                                continue;
                            }
                            AstNode tableNode = tableNodes.get(0);
                            List<AstNode> columnNodes = tableNode.getChildren("ddl:columnDefinition");
                            if (!columnNodes.isEmpty()) {
                                for (AstNode colNode : columnNodes) {
                                    if (!colNode.getName().toUpperCase().equals(possibleColumn.toUpperCase())) continue;
                                    AstNode colRef = this.nodeFactory().node(possibleColumn, indexNode, "ddl:columnReference");
                                    if (asc || desc) {
                                        colRef.addMixin("oracleddl:indexOrderable");
                                        if (asc) {
                                            colRef.setProperty("oracleddl:order", (Object)"ASC");
                                        } else {
                                            colRef.setProperty("oracleddl:order", (Object)"DESC");
                                        }
                                    }
                                    processed = true;
                                    break;
                                }
                            }
                            if (processed) continue;
                            if (asc) {
                                functions.add(possibleColumn + " " + "ASC");
                            } else if (desc) {
                                functions.add(possibleColumn + " " + "DESC");
                            } else {
                                functions.add(possibleColumn);
                            }
                            processed = true;
                            continue;
                        }
                        for (AstNode dimensionTableNode : tableNodes) {
                            if (!possibleColumn.toUpperCase().startsWith(dimensionTableNode.getName().toUpperCase() + ".")) continue;
                            AstNode colRef = this.nodeFactory().node(possibleColumn, indexNode, "ddl:columnReference");
                            if (asc || desc) {
                                colRef.addMixin("oracleddl:indexOrderable");
                                if (asc) {
                                    colRef.setProperty("oracleddl:order", (Object)"ASC");
                                } else {
                                    colRef.setProperty("oracleddl:order", (Object)"DESC");
                                }
                            }
                            processed = true;
                            break;
                        }
                        if (processed) continue;
                        if (asc) {
                            functions.add(possibleColumn + " " + "ASC");
                        } else if (desc) {
                            functions.add(possibleColumn + " " + "DESC");
                        } else {
                            functions.add(possibleColumn);
                        }
                        processed = true;
                    }
                }
            }
            if (!functions.isEmpty()) {
                indexNode.setProperty("oracleddl:otherRefs", (Object)functions);
            }
        }
        if (numLeft != numRight) {
            throw new ParsingException(tokens.nextPosition());
        }
        tokens.consume(")");
    }

    private AstNode parseCreateIndex(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches(STMT_CREATE_INDEX) || tokens.matches(STMT_CREATE_UNIQUE_INDEX) || tokens.matches(STMT_CREATE_BITMAP_INDEX));
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        boolean isUnique = tokens.canConsume("UNIQUE");
        boolean isBitmap = tokens.canConsume("BITMAP");
        tokens.consume("INDEX");
        String indexName = this.parseName(tokens);
        tokens.consume("ON");
        AstNode indexNode = null;
        if (tokens.canConsume("CLUSTER")) {
            indexNode = this.nodeFactory().node(indexName, parentNode, "oracleddl:createClusterIndexStatement");
            indexNode.setProperty("oracleddl:indexType", (Object)"CLUSTER");
            String clusterName = this.parseName(tokens);
            indexNode.setProperty("oracleddl:clustereName", (Object)clusterName);
        } else {
            String tableName = this.parseName(tokens);
            if (!tokens.matches('(')) {
                String tableAlias = tokens.consume();
                indexNode = this.nodeFactory().node(indexName, parentNode, "oracleddl:createTableIndexStatement");
                indexNode.setProperty("oracleddl:indexType", (Object)"TABLE");
                indexNode.setProperty("oracleddl:tableAlias", (Object)tableAlias);
            }
            String columnExpressionList = this.parseContentBetweenParens(tokens);
            if (tokens.canConsume("FROM")) {
                indexNode = this.nodeFactory().node(indexName, parentNode, "oracleddl:createBitmapIndexStatement");
                indexNode.setProperty("oracleddl:indexType", (Object)"BITMAP");
                this.parseTableReferenceList(tokens, indexNode);
                tokens.consume("WHERE");
                String whereClause = this.parseUntilTerminator(tokens);
                indexNode.setProperty("oracleddl:whereClause", (Object)whereClause);
            } else {
                indexNode = this.nodeFactory().node(indexName, parentNode, "oracleddl:createTableIndexStatement");
                indexNode.setProperty("oracleddl:indexType", (Object)"TABLE");
            }
            indexNode.setProperty("oracleddl:tableName", (Object)tableName);
            this.parseIndexColumnExpressionList('(' + columnExpressionList + ')', indexNode);
        }
        indexNode.setProperty("oracleddl:unique", (Object)isUnique);
        indexNode.setProperty("oracleddl:bitmap", (Object)isBitmap);
        if (tokens.hasNext()) {
            boolean unusable = false;
            ArrayList<String> indexAttributes = new ArrayList<String>();
            while (tokens.hasNext() && !this.isTerminator(tokens)) {
                String token = tokens.consume();
                if ("UNUSABLE".equals(token.toUpperCase())) {
                    unusable = true;
                    break;
                }
                boolean processed = false;
                if (token.matches("\\b\\d+\\b") && !indexAttributes.isEmpty()) {
                    int index = indexAttributes.size() - 1;
                    String value = (String)indexAttributes.get(index);
                    String newValue = value + " " + token;
                    indexAttributes.set(index, newValue);
                    processed = true;
                }
                if (processed) continue;
                indexAttributes.add(token);
            }
            if (!indexAttributes.isEmpty()) {
                indexNode.setProperty("oracleddl:indexAttributes", (Object)indexAttributes);
            }
            indexNode.setProperty("oracleddl:unusable", (Object)unusable);
        }
        this.markEndOfStatement(tokens, indexNode);
        return indexNode;
    }

    private void parseTableReferenceList(DdlTokenStream tokens, AstNode parentNode) {
        List<String> tableRefs = this.parseNameList(tokens);
        if (!tableRefs.isEmpty()) {
            for (String tableName : tableRefs) {
                this.nodeFactory().node(tableName, parentNode, "ddl:tableReference");
            }
        }
    }

    private AstNode parseCommentStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("COMMENT");
        tokens.consume("ON");
        String obj = tokens.consume();
        String objName = this.parseName(tokens);
        String commentString = null;
        tokens.consume("IS");
        if (tokens.matches("NULL")) {
            tokens.consume("NULL");
            commentString = "NULL";
        } else {
            commentString = this.parseUntilTerminator(tokens).trim();
        }
        AstNode commentNode = this.nodeFactory().node(objName, parentNode, "oracleddl:commentOnStatement");
        commentNode.setProperty("oracleddl:comment", (Object)commentString);
        commentNode.setProperty("oracleddl:targetObjectType", (Object)obj);
        this.markEndOfStatement(tokens, commentNode);
        return commentNode;
    }

    @Override
    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_SET_CONSTRAINT)) {
            return this.parseStatement(tokens, STMT_SET_CONSTRAINT, parentNode, "oracleddl:setConstraintStatement");
        }
        if (tokens.matches(STMT_SET_CONSTRAINTS)) {
            return this.parseStatement(tokens, STMT_SET_CONSTRAINTS, parentNode, "oracleddl:setConstraintsStatement");
        }
        if (tokens.matches(STMT_SET_ROLE)) {
            return this.parseStatement(tokens, STMT_SET_ROLE, parentNode, "oracleddl:setRoleStatement");
        }
        if (tokens.matches(STMT_SET_TRANSACTION)) {
            return this.parseStatement(tokens, STMT_SET_TRANSACTION, parentNode, "oracleddl:setTransactionStatement");
        }
        return super.parseSetStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode dropNode = null;
        if (tokens.matches(DdlConstants.StatementStartPhrases.STMT_DROP_TABLE)) {
            this.markStartOfStatement(tokens);
            tokens.consume("DROP", new String[]{"TABLE"});
            String name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, "ddl:dropTableStatement");
            if (tokens.canConsume("CASCADE", new String[]{"CONSTRAINTTS"})) {
                dropNode.setProperty("ddl:dropBehavior", (Object)"CASCADE CONSTRAINTS");
            }
            if (tokens.canConsume("PURGE")) {
                AstNode optionNode = this.nodeFactory().node("ddl:dropOption", dropNode, "ddl:statementOption");
                optionNode.setProperty("ddl:value", (Object)"PURGE");
            }
            this.markEndOfStatement(tokens, dropNode);
            return dropNode;
        }
        if (tokens.matches(STMT_DROP_CLUSTER)) {
            return this.parseStatement(tokens, STMT_DROP_CLUSTER, parentNode, "oracleddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_CONTEXT)) {
            return this.parseStatement(tokens, STMT_DROP_CONTEXT, parentNode, "oracleddl:dropContextStatement");
        }
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_DATABASE, parentNode, "oracleddl:dropDatabaseStatement");
        }
        if (tokens.matches(STMT_DROP_PUBLIC_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_PUBLIC_DATABASE, parentNode, "oracleddl:dropDatabaseStatement");
        }
        if (tokens.matches(STMT_DROP_DIMENSION)) {
            return this.parseStatement(tokens, STMT_DROP_DIMENSION, parentNode, "oracleddl:dropDimensionStatement");
        }
        if (tokens.matches(STMT_DROP_DIRECTORY)) {
            return this.parseStatement(tokens, STMT_DROP_DIRECTORY, parentNode, "oracleddl:dropDirectoryStatement");
        }
        if (tokens.matches(STMT_DROP_DISKGROUP)) {
            return this.parseStatement(tokens, STMT_DROP_DISKGROUP, parentNode, "oracleddl:dropDiskgroupStatement");
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, "oracleddl:dropFunctionStatement");
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_INDEX, parentNode, "oracleddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_INDEXTYPE)) {
            return this.parseStatement(tokens, STMT_DROP_INDEXTYPE, parentNode, "oracleddl:dropIndextypeStatement");
        }
        if (tokens.matches(STMT_DROP_JAVA)) {
            return this.parseStatement(tokens, STMT_DROP_JAVA, parentNode, "oracleddl:dropJavaStatement");
        }
        if (tokens.matches(STMT_DROP_LIBRARY)) {
            return this.parseStatement(tokens, STMT_DROP_LIBRARY, parentNode, "oracleddl:dropLibraryStatement");
        }
        if (tokens.matches(STMT_DROP_MATERIALIZED)) {
            return this.parseStatement(tokens, STMT_DROP_MATERIALIZED, parentNode, "oracleddl:dropMaterializedStatement");
        }
        if (tokens.matches(STMT_DROP_OPERATOR)) {
            return this.parseStatement(tokens, STMT_DROP_OPERATOR, parentNode, "oracleddl:dropOperatorStatement");
        }
        if (tokens.matches(STMT_DROP_OUTLINE)) {
            return this.parseStatement(tokens, STMT_DROP_OUTLINE, parentNode, "oracleddl:dropOutlineStatement");
        }
        if (tokens.matches(STMT_DROP_PACKAGE)) {
            return this.parseStatement(tokens, STMT_DROP_PACKAGE, parentNode, "oracleddl:dropPackageStatement");
        }
        if (tokens.matches(STMT_DROP_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_DROP_PROCEDURE, parentNode, "oracleddl:dropProcedureStatement");
        }
        if (tokens.matches(STMT_DROP_PROFILE)) {
            return this.parseStatement(tokens, STMT_DROP_PROFILE, parentNode, "oracleddl:dropProfileStatement");
        }
        if (tokens.matches(STMT_DROP_ROLE)) {
            return this.parseStatement(tokens, STMT_DROP_ROLE, parentNode, "oracleddl:dropRoleStatement");
        }
        if (tokens.matches(STMT_DROP_ROLLBACK)) {
            return this.parseStatement(tokens, STMT_DROP_ROLLBACK, parentNode, "oracleddl:dropRollbackStatement");
        }
        if (tokens.matches(STMT_DROP_SEQUENCE)) {
            return this.parseStatement(tokens, STMT_DROP_SEQUENCE, parentNode, "oracleddl:dropSequenceStatement");
        }
        if (tokens.matches(STMT_DROP_SYNONYM)) {
            return this.parseStatement(tokens, STMT_DROP_SYNONYM, parentNode, "oracleddl:dropSynonymStatement");
        }
        if (tokens.matches(STMT_DROP_PUBLIC_SYNONYM)) {
            return this.parseStatement(tokens, STMT_DROP_PUBLIC_SYNONYM, parentNode, "oracleddl:dropSynonymStatement");
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_DROP_TABLESPACE, parentNode, "oracleddl:dropTablespaceStatement");
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, "oracleddl:dropTriggerStatement");
        }
        if (tokens.matches(STMT_DROP_TYPE)) {
            return this.parseStatement(tokens, STMT_DROP_TYPE, parentNode, "oracleddl:dropTypeStatement");
        }
        if (tokens.matches(STMT_DROP_USER)) {
            return this.parseStatement(tokens, STMT_DROP_USER, parentNode, "oracleddl:dropUserStatement");
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    private AstNode parseCreateJavaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_JAVA);
        AstNode result = this.nodeFactory().node(this.getStatementTypeName(STMT_CREATE_JAVA), parentNode, "oracleddl:createJavaStatement");
        int iParen = 0;
        while (tokens.hasNext()) {
            if (tokens.matches('{')) {
                ++iParen;
            } else if (tokens.matches('}')) {
                --iParen;
            }
            tokens.consume();
            if (!this.isTerminator(tokens) || iParen != 0) continue;
        }
        this.markEndOfStatement(tokens, result);
        return result;
    }

    protected boolean isColumnDefinitionStart(DdlTokenStream tokens, String columnMixinType) throws ParsingException {
        boolean result = this.isColumnDefinitionStart(tokens);
        if (!result && "ddl:alterColumnDefinition".equals(columnMixinType)) {
            for (String start : INLINE_COLUMN_PROPERTY_START) {
                if (!tokens.matches("any value", new String[]{start})) continue;
                return true;
            }
        }
        return result;
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, String columnMixinType) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        boolean isInParen = tokens.matches("(");
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuilder unusedTokensSB = new StringBuilder();
        do {
            if (this.isColumnDefinitionStart(localTokens, columnMixinType)) {
                this.parseColumnDefinition(localTokens, tableNode, columnMixinType);
                continue;
            }
            while (localTokens.hasNext() && !localTokens.matches(",")) {
                unusedTokensSB.append(" ").append(localTokens.consume());
            }
        } while (localTokens.canConsume(","));
        if (isInParen) {
            while (localTokens.hasNext()) {
                unusedTokensSB.append(" ").append(localTokens.consume());
            }
        }
        if (unusedTokensSB.length() > 0 && "ddl:addColumnDefinition".equals(columnMixinType)) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        this.parseColumns(tokens, tableNode, isAlterTable ? "ddl:alterColumnDefinition" : "ddl:addColumnDefinition");
    }

    protected void parseColumnDefinition(DdlTokenStream tokens, AstNode tableNode, String columnMixinType) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        boolean isAlterTable = columnMixinType != "ddl:columnDefinition";
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, columnMixinType);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        if (datatype != null) {
            this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        }
        StringBuilder unusedTokensSB = new StringBuilder();
        while (!(!tokens.hasNext() || tokens.matches(",") || isAlterTable && tokens.matchesAnyOf("ADD", new String[]{"MODIFY"}))) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                boolean parsedCollate = this.parseCollateClause(tokens, columnNode);
                boolean parsedConstraint = this.parseColumnConstraint(tokens, columnNode, isAlterTable);
                if (!parsedCollate && !parsedConstraint) {
                    unusedTokensSB.append(" ").append(tokens.consume());
                }
            }
            tokens.canConsume(32);
        }
        if (unusedTokensSB.length() == 1 && unusedTokensSB.charAt(0) == ';' || unusedTokensSB.length() > 1) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, Position.EMPTY_CONTENT_POSITION, msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected AstNode parseSlashedStatement(DdlTokenStream tokens, String[] stmt_start_phrase, AstNode parentNode, String mixinType) {
        assert (tokens != null);
        assert (stmt_start_phrase != null && stmt_start_phrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(stmt_start_phrase);
        AstNode result = this.nodeFactory().node(this.getStatementTypeName(stmt_start_phrase), parentNode, mixinType);
        this.parseUntilFwdSlash(tokens, false);
        this.consumeSlash(tokens);
        this.markEndOfStatement(tokens, result);
        return result;
    }

    private String parseUntilFwdSlash(DdlTokenStream tokens, boolean stopAtStatementStart) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        if (stopAtStatementStart) {
            while (tokens.hasNext() && !tokens.matches(128) && !tokens.matches('/')) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            while (tokens.hasNext() && !this.isFwdSlashedStatement(tokens) && !tokens.matches('/')) {
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    private boolean isFwdSlashedStatement(DdlTokenStream tokens) throws ParsingException {
        for (int i = 0; i < SLASHED_STMT_PHRASES.length; ++i) {
            if (!tokens.matches(SLASHED_STMT_PHRASES[i])) continue;
            return true;
        }
        return false;
    }

    private void consumeSlash(DdlTokenStream tokens) throws ParsingException {
        tokens.canConsume("/");
    }

    @Override
    protected String[] getValidSchemaChildTypes() {
        return VALID_SCHEMA_CHILD_STMTS;
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return OracleDdlConstants.OracleDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class OracleDataTypeParser
    extends DataTypeParser {
        OracleDataTypeParser() {
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            String typeName = null;
            if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_FLOAT)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_FLOAT);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_DOUBLE)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BINARY_DOUBLE);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_LONG)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_LONG);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_LONG_RAW)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_LONG_RAW);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_CLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_CLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NCLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NCLOB);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_BFILE)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_BFILE);
                dataType.setName(typeName);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_VARCHAR2)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_VARCHAR2);
                this.consume(tokens, dataType, false, "(");
                long length = this.parseLong(tokens, dataType);
                this.canConsume(tokens, dataType, true, "BYTE", new String[0]);
                this.canConsume(tokens, dataType, true, "CHAR", new String[0]);
                this.consume(tokens, dataType, false, ")");
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_RAW)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_RAW);
                long length = this.parseBracketedLong(tokens, dataType);
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NVARCHAR2)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NVARCHAR2);
                long length = this.parseBracketedLong(tokens, dataType);
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_NUMBER)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_NUMBER);
                int precision = 0;
                int scale = 0;
                if (tokens.matches("(")) {
                    this.consume(tokens, dataType, false, "(");
                    precision = (int)this.parseLong(tokens, dataType);
                    scale = this.canConsume(tokens, dataType, false, ",", new String[0]) ? (int)this.parseLong(tokens, dataType) : this.getDefaultScale();
                    this.consume(tokens, dataType, false, ")");
                } else {
                    precision = this.getDefaultPrecision();
                    scale = this.getDefaultScale();
                }
                dataType.setName(typeName);
                dataType.setPrecision(precision);
                dataType.setScale(scale);
            } else if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_INTERVAL_YEAR) || tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_INTERVAL_DAY)) {
                // empty if block
            }
            if (dataType == null) {
                dataType = super.parseCustomType(tokens);
            }
            return dataType;
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            if (tokens.matches(OracleDdlConstants.OracleDataTypes.DTYPE_CHAR_ORACLE)) {
                dataType = new DataType();
                String typeName = this.consume(tokens, dataType, true, OracleDdlConstants.OracleDataTypes.DTYPE_CHAR_ORACLE);
                this.consume(tokens, dataType, false, "(");
                long length = this.parseLong(tokens, dataType);
                this.canConsume(tokens, dataType, true, "BYTE", new String[0]);
                this.canConsume(tokens, dataType, true, "CHAR", new String[0]);
                this.consume(tokens, dataType, false, ")");
                dataType.setName(typeName);
                dataType.setLength(length);
            } else {
                dataType = super.parseCharStringType(tokens);
            }
            return dataType;
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmt : oracleDataTypeStrings) {
                if (!tokens.matches(stmt)) continue;
                return true;
            }
            return false;
        }
    }
}

