/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.epub;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class EpubMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceEpub() throws Exception {
        String filename = "sample.epub";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/epub/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/epub+zip"));
        Node title = sequencedNode.getNode("epub:title");
        Assert.assertThat((Object)title.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"Title"));
        Assert.assertThat((Object)title.getProperty("epub:titleType").getString(), (Matcher)Is.is((Object)"main"));
        Node titleAlternative = title.getNode("epub:alternateScript");
        Assert.assertThat((Object)titleAlternative.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"Nadpis"));
        Assert.assertThat((Object)titleAlternative.getProperty("epub:languageCode").getString(), (Matcher)Is.is((Object)"cs"));
        Node language = sequencedNode.getNode("epub:language");
        Assert.assertThat((Object)language.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"en"));
        Node identifier = sequencedNode.getNode("epub:identifier");
        Assert.assertThat((Object)identifier.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"Identifier"));
        Assert.assertThat((Object)identifier.getProperty("epub:identifierType").getString(), (Matcher)Is.is((Object)"01"));
        Assert.assertThat((Object)identifier.getProperty("epub:scheme").getString(), (Matcher)Is.is((Object)"onix:codelist5"));
        Node contributor = sequencedNode.getNode("epub:contributor");
        Assert.assertThat((Object)contributor.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"Contributor"));
        Assert.assertThat((Object)contributor.getProperty("epub:fileAs").getString(), (Matcher)Is.is((Object)"Contributor, Mr."));
        Node date = sequencedNode.getNode("epub:date");
        Assert.assertThat((Object)date.getProperty("epub:value").getString(), (Matcher)Is.is((Object)"2015-01-01"));
        Assert.assertThat((Object)sequencedNode.hasNode("epub:publisher"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.hasNode("epub:description"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.hasNode("epub:rights"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.hasNode("epub:creator"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.hasNode("epub:creator[2]"), (Matcher)Is.is((Object)true));
    }
}

