/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.epub;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.epub.EpubMetadata;
import org.modeshape.sequencer.epub.EpubMetadataProperty;

public class EpubMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("epub.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(EpubMetadata.MIME_TYPE_STRINGS);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String mimeType = binaryValue.getMimeType();
        Node sequencedNode = this.getMetadataNode(outputNode);
        this.setPropertyIfMetadataPresent(sequencedNode, "jcr:mimeType", mimeType);
        return this.processBasicMetadata(sequencedNode, binaryValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processBasicMetadata(Node sequencedNode, Binary binaryValue) {
        EpubMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new EpubMetadata(stream);
            if (!metadata.check()) return false;
            this.addEpubMetadataProperties(sequencedNode, "epub:title", metadata.getTitle());
            this.addEpubMetadataProperties(sequencedNode, "epub:creator", metadata.getCreator());
            this.addEpubMetadataProperties(sequencedNode, "epub:contributor", metadata.getContributor());
            this.addEpubMetadataProperties(sequencedNode, "epub:language", metadata.getLanguage());
            this.addEpubMetadataProperties(sequencedNode, "epub:identifier", metadata.getIdentifier());
            this.addEpubMetadataProperties(sequencedNode, "epub:description", metadata.getDescription());
            this.addEpubMetadataProperties(sequencedNode, "epub:publisher", metadata.getPublisher());
            this.addEpubMetadataProperties(sequencedNode, "epub:date", metadata.getDate());
            this.addEpubMetadataProperties(sequencedNode, "epub:rights", metadata.getRights());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Couldn't process stream.", new Object[0]);
        }
        return false;
    }

    private Node getMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("epub:metadata");
            return outputNode;
        }
        return outputNode.addNode("epub:metadata", "epub:metadata");
    }

    private void addEpubMetadataProperties(Node node, String propertyName, List<EpubMetadataProperty> values) throws RepositoryException {
        for (EpubMetadataProperty value : values) {
            Node propertyNode = node.addNode(propertyName, propertyName);
            this.setPropertyIfMetadataPresent(propertyNode, "epub:value", value.getValue());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:titleType", value.getTitleType());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:metadataAuthority", value.getMetadataAuthority());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:role", value.getRole());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:displaySeq", value.getDisplaySeq());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:fileAs", value.getFileAs());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:groupPosition", value.getGroupPosition());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:identifierType", value.getIdentifierType());
            this.setPropertyIfMetadataPresent(propertyNode, "epub:scheme", value.getScheme());
            if (value.getAlternateScript() == null) continue;
            Node alternateScriptNode = propertyNode.addNode("epub:alternateScript", "epub:alternateScript");
            this.setPropertyIfMetadataPresent(alternateScriptNode, "epub:value", value.getAlternateScript().getValue());
            this.setPropertyIfMetadataPresent(alternateScriptNode, "epub:languageCode", value.getAlternateScript().getLanguage());
        }
    }

    private void setPropertyIfMetadataPresent(Node node, String propertyName, Object value) throws RepositoryException {
        if (value != null) {
            if (value instanceof String && !StringUtil.isBlank((String)((String)value))) {
                node.setProperty(propertyName, (String)value);
            } else if (value instanceof Boolean) {
                node.setProperty(propertyName, ((Boolean)value).booleanValue());
            } else if (value instanceof Long) {
                node.setProperty(propertyName, ((Long)value).longValue());
            } else if (value instanceof Integer) {
                node.setProperty(propertyName, new Long(((Integer)value).intValue()).longValue());
            } else if (value instanceof Double) {
                node.setProperty(propertyName, ((Double)value).doubleValue());
            } else if (value instanceof Calendar) {
                node.setProperty(propertyName, (Calendar)value);
            } else if (value instanceof byte[]) {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
                javax.jcr.Binary binaryProperty = node.getSession().getValueFactory().createBinary((InputStream)is);
                node.setProperty(propertyName, binaryProperty);
            } else if (value instanceof List) {
                ValueFactory vf = node.getSession().getValueFactory();
                List<Value> values = ((List)value).stream().filter(val -> val instanceof String).map(val -> vf.createValue((String)val)).collect(Collectors.toList());
                if (!values.isEmpty()) {
                    node.setProperty(propertyName, values.toArray(new Value[values.size()]));
                }
            } else {
                this.getLogger().warn("The value of the property {0} has unknown type and couldn't be saved", new Object[]{propertyName});
            }
        }
    }
}

