/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.number.IsCloseTo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.image.ImageMetadataSequencer;

public class ImageMetadataSequencerTest {
    private ImageMetadataSequencer sequencer;
    private InputStream content;
    private MockSequencerOutput output;
    private URL cautionGif;
    private URL cautionJpg;
    private URL cautionPict;
    private URL cautionPng;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() {
        this.sequencer = new ImageMetadataSequencer();
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("image", "http://jboss.org/dna/images/1.0");
        this.output = new MockSequencerOutput(this.context);
        this.cautionGif = this.getClass().getClassLoader().getResource("caution.gif");
        this.cautionJpg = this.getClass().getClassLoader().getResource("caution.jpg");
        this.cautionPict = this.getClass().getClassLoader().getResource("caution.pict");
        this.cautionPng = this.getClass().getClassLoader().getResource("caution.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.content != null) {
            try {
                this.content.close();
            }
            finally {
                this.content = null;
            }
        }
    }

    @Test
    public void shouldGenerateMetadataForJpegImageFiles() throws IOException {
        URL url = this.cautionJpg;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "jcr:primaryType"), (Matcher)Is.is((Object)new Object[]{"image:metadata"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "jcr:mimeType"), (Matcher)Is.is((Object)new Object[]{"image/jpeg"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:formatName"), (Matcher)Is.is((Object)new Object[]{"JPEG"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:width"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:height"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:bitsPerPixel"), (Matcher)Is.is((Object)new Object[]{24}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:progressive"), (Matcher)Is.is((Object)new Object[]{false}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:numberOfImages"), (Matcher)Is.is((Object)new Object[]{1}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalWidthDpi"), (Matcher)Is.is((Object)new Object[]{72}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalHeightDpi"), (Matcher)Is.is((Object)new Object[]{72}));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalWidthInches")[0]).doubleValue(), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)0.666667, (double)1.0E-4)));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalHeightInches")[0]).doubleValue(), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)0.666667, (double)1.0E-4)));
    }

    @Test
    public void shouldGenerateMetadataForPngImageFiles() throws IOException {
        URL url = this.cautionPng;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "jcr:primaryType"), (Matcher)Is.is((Object)new Object[]{"image:metadata"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "jcr:mimeType"), (Matcher)Is.is((Object)new Object[]{"image/png"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:formatName"), (Matcher)Is.is((Object)new Object[]{"PNG"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:width"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:height"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:bitsPerPixel"), (Matcher)Is.is((Object)new Object[]{24}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:progressive"), (Matcher)Is.is((Object)new Object[]{false}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:numberOfImages"), (Matcher)Is.is((Object)new Object[]{1}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalWidthDpi"), (Matcher)Is.is((Object)new Object[]{-1}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalHeightDpi"), (Matcher)Is.is((Object)new Object[]{-1}));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalWidthInches")[0]), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalHeightInches")[0]), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
    }

    @Test
    public void shouldGenerateMetadataForGifImageFiles() throws IOException {
        URL url = this.cautionGif;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "jcr:mimeType"), (Matcher)Is.is((Object)new Object[]{"image/gif"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:formatName"), (Matcher)Is.is((Object)new Object[]{"GIF"}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:width"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:height"), (Matcher)Is.is((Object)new Object[]{48}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:bitsPerPixel"), (Matcher)Is.is((Object)new Object[]{8}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:progressive"), (Matcher)Is.is((Object)new Object[]{false}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:numberOfImages"), (Matcher)Is.is((Object)new Object[]{1}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalWidthDpi"), (Matcher)Is.is((Object)new Object[]{-1}));
        Assert.assertThat((Object)this.output.getPropertyValues("image:metadata", "image:physicalHeightDpi"), (Matcher)Is.is((Object)new Object[]{-1}));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalWidthInches")[0]), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)((Float)this.output.getPropertyValues("image:metadata", "image:physicalHeightInches")[0]), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
    }

    @Test
    public void shouldGenerateNoMetadataforPictImageFiles() throws IOException {
        URL url = this.cautionPict;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.hasProperties(), (Matcher)Is.is((Object)false));
    }
}

