/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class ImageMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldGenerateMetadataForJpegImageFiles() throws Exception {
        String filename = "caution.jpg";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getSequencedNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/jpeg", "jpeg", 48, 48, 24, false, 1, 72, 72, 0.666667, 0.666667);
        Node sequencedNodeSameLocation = this.getSequencedNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/jpeg", "jpeg", 48, 48, 24, false, 1, 72, 72, 0.666667, 0.666667);
    }

    @Test
    public void shouldGenerateMetadataForPngImageFiles() throws Exception {
        String filename = "caution.png";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getSequencedNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/png", "png", 48, 48, 24, false, 1, -1, -1, -1.0, -1.0);
        Node sequencedNodeSameLocation = this.getSequencedNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/png", "png", 48, 48, 24, false, 1, -1, -1, -1.0, -1.0);
    }

    @Test
    public void shouldGenerateMetadataForGifImageFiles() throws Exception {
        String filename = "caution.gif";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getSequencedNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/gif", "gif", 48, 48, 8, false, 1, -1, -1, -1.0, -1.0);
        Node sequencedNodeSameLocation = this.getSequencedNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/gif", "gif", 48, 48, 8, false, 1, -1, -1, -1.0, -1.0);
    }

    @Test
    public void shouldGenerateNoMetadataforPictImageFiles() throws Exception {
        String filename = "caution.pict";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Assert.assertNull((Object)this.getSequencedNode(this.rootNode, "sequenced/images/" + filename));
        Assert.assertNull((Object)this.getSequencedNode(imageNode, "image:metadata"));
    }

    private void assertMetaDataProperties(Node metadataNode, String mimeType, String format, int width, int height, int bitsPerPixel, boolean progressive, int numberOfImages, int physicalWidthDpi, int physicalHeightDpi, double physicalWidthInches, double physicalHeightInches) throws RepositoryException {
        Assert.assertNotNull((Object)metadataNode);
        Assert.assertEquals((Object)"image:metadata", (Object)metadataNode.getProperty("jcr:primaryType").getString());
        Assert.assertEquals((Object)mimeType, (Object)metadataNode.getProperty("jcr:mimetype").getString());
        Assert.assertEquals((Object)format, (Object)metadataNode.getProperty("image:formatName").getString().toLowerCase());
        Assert.assertEquals((long)width, (long)metadataNode.getProperty("image:width").getLong());
        Assert.assertEquals((long)height, (long)metadataNode.getProperty("image:height").getLong());
        Assert.assertEquals((long)bitsPerPixel, (long)metadataNode.getProperty("image:bitsPerPixel").getLong());
        Assert.assertEquals((Object)progressive, (Object)metadataNode.getProperty("image:progressive").getBoolean());
        Assert.assertEquals((long)numberOfImages, (long)metadataNode.getProperty("image:numberOfImages").getLong());
        Assert.assertEquals((long)physicalWidthDpi, (long)metadataNode.getProperty("image:physicalWidthDpi").getLong());
        Assert.assertEquals((long)physicalHeightDpi, (long)metadataNode.getProperty("image:physicalHeightDpi").getLong());
        Assert.assertEquals((double)physicalWidthInches, (double)metadataNode.getProperty("image:physicalWidthInches").getDouble(), (double)1.0E-4);
        Assert.assertEquals((double)physicalHeightInches, (double)metadataNode.getProperty("image:physicalHeightInches").getDouble(), (double)1.0E-4);
    }
}

