/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.image.ImageMetadata;

public class ImageMetadataSequencer
extends Sequencer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        InputStream stream = binaryValue.getStream();
        try {
            ImageMetadata metadata = new ImageMetadata();
            metadata.setInput(stream);
            metadata.setDetermineImageNumber(true);
            metadata.setCollectComments(true);
            if (!metadata.check()) {
                this.getLogger().info("Unknown format detected. Skipping sequencing", new Object[0]);
                boolean bl = false;
                return bl;
            }
            Node imageNode = this.getImageMetadataNode(outputNode);
            this.setImagePropertiesOnNode(imageNode, metadata);
            boolean bl = true;
            return bl;
        }
        finally {
            stream.close();
        }
    }

    private Node getImageMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("image:metadata");
            return outputNode;
        }
        return outputNode.addNode("image:metadata", "image:metadata");
    }

    private void setImagePropertiesOnNode(Node node, ImageMetadata metadata) throws Exception {
        node.setProperty("jcr:mimeType", metadata.getMimeType());
        node.setProperty("image:formatName", metadata.getFormatName());
        node.setProperty("image:width", (long)metadata.getWidth());
        node.setProperty("image:height", (long)metadata.getHeight());
        node.setProperty("image:bitsPerPixel", (long)metadata.getBitsPerPixel());
        node.setProperty("image:progressive", metadata.isProgressive());
        node.setProperty("image:numberOfImages", (long)metadata.getNumberOfImages());
        node.setProperty("image:physicalWidthDpi", (long)metadata.getPhysicalWidthDpi());
        node.setProperty("image:physicalHeightDpi", (long)metadata.getPhysicalHeightDpi());
        node.setProperty("image:physicalWidthInches", (double)metadata.getPhysicalWidthInch());
        node.setProperty("image:physicalHeightInches", (double)metadata.getPhysicalHeightInch());
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("images.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"image/jpeg", "image/bmp", "image/gif", "image/x-pcx", "image/png", "image/tiff", "image/x-cmu-raster", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/vnd.adobe.photoshop"});
    }

    public static final class MimeTypeConstants {
        public static final String BMP = "image/bmp";
        public static final String GIF = "image/gif";
        public static final String JPEG = "image/jpeg";
        public static final String PBM = "image/x-portable-bitmap";
        public static final String PGM = "image/x-portable-graymap";
        public static final String PPM = "image/x-portable-pixmap";
        public static final String PNG = "image/png";
        public static final String RAS = "image/x-cmu-raster";
        public static final String TIFF = "image/tiff";
        public static final String PHOTOSHOP = "image/vnd.adobe.photoshop";
        public static final String PCX = "image/x-pcx";
    }
}

