/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.java.JavaMetadataSequencer;

public class JavaMetadataSequencerTest {
    private JavaMetadataSequencer sequencer;
    private InputStream content;
    private MockSequencerOutput output;
    private File source;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() {
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("java", "http://jboss.org/dna/java/1.0");
        this.sequencer = new JavaMetadataSequencer();
        this.output = new MockSequencerOutput(this.context);
        this.source = new File("src/test/workspace/projectX/src/org/acme/MySource.java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.content != null) {
            try {
                this.content.close();
            }
            finally {
                this.content = null;
            }
        }
    }

    protected FileInputStream getJavaSrc(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    @Test
    public void shouldGenerateMetadataForJavaSourceFile() throws IOException {
        this.content = this.getJavaSrc(this.source);
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit", "jcr:primaryType"), (Matcher)Is.is((Object)new Object[]{"java:compilationUnit"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:package/java:packageDeclaration", "java:packageName"), (Matcher)Is.is((Object)new Object[]{"org.acme"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:import/java:importDeclaration/java:singleImport/java:singleTypeImportDeclaration[1]", "java:singleImportName"), (Matcher)Is.is((Object)new Object[]{"org.acme.annotation.MyClassAnnotation"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:import/java:importDeclaration/java:importOnDemand/java:typeImportOnDemandDeclaration[1]", "java:onDemandImportName"), (Matcher)Is.is((Object)new Object[]{"java.util"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration", "java:normalClassName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[1]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[1]", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[1]/java:primitiveVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[1]/java:primitiveVariable/java:variable[2]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"j"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[2]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[2]/java:modifier/java:modifierDeclaration[2]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"static"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[2]", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:primitiveType[2]/java:primitiveVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"a"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:parameterizedType[1]", "java:parameterizedTypeName"), (Matcher)Is.is((Object)new Object[]{"List"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:parameterizedType[2]", "java:parameterizedTypeName"), (Matcher)Is.is((Object)new Object[]{"A"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:simpleType[1]", "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"X"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:simpleType[1]/java:simpleTypeVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"x"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[1]", "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[1]/java:arrayTypeVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ia"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[2]", "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[2]/java:arrayTypeVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"oa"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[3]", "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Collection"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType/java:type/java:arrayType[3]/java:arrayTypeVariable/java:variable[1]", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ca"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[1]", "java:constructorName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]", "java:constructorName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType/java:primitiveVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[2]/java:type/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[2]/java:type/java:primitiveType/java:primitiveVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"j"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[3]/java:type/java:simpleType", "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor/java:constructorDeclaration[2]/java:parameter/java:formalParameter[3]/java:type/java:simpleType/java:simpleTypeVariable /java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"o"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[1]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[1]/java:resultType/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[1]", "java:methodName"), (Matcher)Is.is((Object)new Object[]{"getI"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[2]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[2]/java:resultType/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"void"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[2]", "java:methodName"), (Matcher)Is.is((Object)new Object[]{"setI"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[2]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[2]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType/java:primitiveVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:resultType/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"void"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]", "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[1]/java:type/java:primitiveType/java:primitiveVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"p1"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[2]/java:type/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[2]/java:type/java:primitiveType/java:primitiveVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"p2"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[3]/java:type/java:simpleType", "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[4]/java:parameter/java:formalParameter[3]/java:type/java:simpleType/java:simpleTypeVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"o"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:resultType/java:primitiveType", "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]", "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething2"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:parameter/java:formalParameter[1]/java:type/java:arrayType", "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:parameter/java:formalParameter[1]/java:type/java:arrayType/java:arrayTypeVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"oa"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:parameter/java:formalParameter[2]/java:type/java:arrayType", "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[5]/java:parameter/java:formalParameter[2]/java:type/java:arrayType/java:arrayTypeVariable/java:variable", "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ia"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[6]/java:modifier/java:modifierDeclaration[1]", "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[6]/java:resultType/java:simpleType", "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues("java:compilationUnit/java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method/java:methodDeclaration[6]", "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething3"}));
    }
}

