/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.java.JavaMetadataUtil;
import org.modeshape.sequencer.java.metadata.AnnotationMetadata;
import org.modeshape.sequencer.java.metadata.ArrayTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.ClassMetadata;
import org.modeshape.sequencer.java.metadata.ConstructorMetadata;
import org.modeshape.sequencer.java.metadata.EnumMetadata;
import org.modeshape.sequencer.java.metadata.FieldMetadata;
import org.modeshape.sequencer.java.metadata.ImportMetadata;
import org.modeshape.sequencer.java.metadata.ImportOnDemandMetadata;
import org.modeshape.sequencer.java.metadata.InterfaceMetadata;
import org.modeshape.sequencer.java.metadata.MarkerAnnotationMetadata;
import org.modeshape.sequencer.java.metadata.MethodMetadata;
import org.modeshape.sequencer.java.metadata.MethodTypeMemberMetadata;
import org.modeshape.sequencer.java.metadata.ModifierMetadata;
import org.modeshape.sequencer.java.metadata.NormalAnnotationMetadata;
import org.modeshape.sequencer.java.metadata.PackageMetadata;
import org.modeshape.sequencer.java.metadata.ParameterizedTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.PrimitiveFieldMetadata;
import org.modeshape.sequencer.java.metadata.SimpleTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.SingleImportMetadata;
import org.modeshape.sequencer.java.metadata.SingleMemberAnnotationMetadata;
import org.modeshape.sequencer.java.metadata.TypeMetadata;
import org.modeshape.sequencer.java.metadata.Variable;

public abstract class AbstractJavaMetadata {
    protected List<ImportMetadata> createImportMetadata(CompilationUnit unit) {
        ArrayList<ImportMetadata> metadata = new ArrayList<ImportMetadata>();
        List imports = unit.imports();
        if (!imports.isEmpty()) {
            for (ImportDeclaration importDeclaration : imports) {
                if (importDeclaration.isOnDemand()) {
                    ImportOnDemandMetadata onDemandMetadata = new ImportOnDemandMetadata();
                    onDemandMetadata.setName(JavaMetadataUtil.getName(importDeclaration.getName()));
                    metadata.add(onDemandMetadata);
                    continue;
                }
                SingleImportMetadata singleImportMetadata = new SingleImportMetadata();
                singleImportMetadata.setName(JavaMetadataUtil.getName(importDeclaration.getName()));
                metadata.add(singleImportMetadata);
            }
        }
        return metadata;
    }

    protected PackageMetadata createPackageMetadata(CompilationUnit unit) {
        PackageMetadata packageMetadata = null;
        List annotations = null;
        PackageDeclaration packageDeclaration = unit.getPackage();
        if (packageDeclaration != null) {
            annotations = packageDeclaration.annotations();
            packageMetadata = new PackageMetadata();
            packageMetadata.setName(JavaMetadataUtil.getName(unit.getPackage().getName()));
            if (!annotations.isEmpty()) {
                for (Annotation object : annotations) {
                    packageMetadata.getAnnotationMetada().add(this.createAnnotationMetadataFor(object));
                }
            }
        }
        return packageMetadata;
    }

    protected AnnotationMetadata createAnnotationMetadataFor(Annotation annotation) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            NormalAnnotationMetadata normalAnnotationMetadata = new NormalAnnotationMetadata();
            normalAnnotationMetadata.setName(JavaMetadataUtil.getName(normalAnnotation.getTypeName()));
            normalAnnotationMetadata.setNormal(Boolean.TRUE);
            normalAnnotationMetadata.setValues(normalAnnotation.values());
            return normalAnnotationMetadata;
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            MarkerAnnotationMetadata markerAnnotationMetadata = new MarkerAnnotationMetadata();
            markerAnnotationMetadata.setName(JavaMetadataUtil.getName(markerAnnotation.getTypeName()));
            markerAnnotationMetadata.setMarker(Boolean.TRUE);
            return markerAnnotationMetadata;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            SingleMemberAnnotationMetadata singleMemberAnnotationMetadata = new SingleMemberAnnotationMetadata();
            singleMemberAnnotationMetadata.setName(JavaMetadataUtil.getName(singleMemberAnnotation.getTypeName()));
            singleMemberAnnotationMetadata.setSingle(Boolean.TRUE);
            String value = singleMemberAnnotation.getValue().toString();
            singleMemberAnnotationMetadata.getMemberValues().put(null, value);
            return singleMemberAnnotationMetadata;
        }
        return null;
    }

    protected List<TypeMetadata> createTypeMetadata(CompilationUnit unit) {
        ArrayList<TypeMetadata> metadata = new ArrayList<TypeMetadata>();
        List topLevelType = unit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : topLevelType) {
            if (abstractTypeDeclaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
                if (typeDeclaration.isInterface()) {
                    InterfaceMetadata interfaceMetadata = new InterfaceMetadata();
                    interfaceMetadata.setName(JavaMetadataUtil.getName(typeDeclaration.getName()));
                    for (Type superInterfaceType : typeDeclaration.superInterfaceTypes()) {
                        interfaceMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                    }
                    metadata.add(interfaceMetadata);
                } else {
                    MethodDeclaration[] methodDeclarations;
                    FieldDeclaration[] fieldDeclarations;
                    ClassMetadata classMetadata = new ClassMetadata();
                    this.processModifiersOfTypDeclaration(typeDeclaration, classMetadata);
                    classMetadata.setName(JavaMetadataUtil.getName(typeDeclaration.getName()));
                    Type superClassType = typeDeclaration.getSuperclassType();
                    if (superClassType != null) {
                        classMetadata.setSuperClassName(this.getTypeName(superClassType));
                    }
                    for (Type superInterfaceType : typeDeclaration.superInterfaceTypes()) {
                        classMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                    }
                    for (FieldDeclaration fieldDeclaration : fieldDeclarations = typeDeclaration.getFields()) {
                        FieldMetadata fieldMetadata = this.getFieldMetadataFrom(fieldDeclaration);
                        classMetadata.getFields().add(fieldMetadata);
                    }
                    for (MethodDeclaration methodDeclaration : methodDeclarations = typeDeclaration.getMethods()) {
                        MethodMetadata methodMetadata = this.getMethodMetadataFrom(methodDeclaration);
                        classMetadata.getMethods().add(methodMetadata);
                    }
                    metadata.add(classMetadata);
                }
            }
            if (abstractTypeDeclaration instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)abstractTypeDeclaration;
                EnumMetadata enumMetadata = new EnumMetadata();
                this.processModifiersOfTypDeclaration(enumDeclaration, enumMetadata);
                enumMetadata.setName(JavaMetadataUtil.getName(enumDeclaration.getName()));
                List enumValues = enumDeclaration.enumConstants();
                for (EnumConstantDeclaration enumValue : enumValues) {
                    enumMetadata.getValues().add(enumValue.getName().getIdentifier());
                }
                for (Type superInterfaceType : enumDeclaration.superInterfaceTypes()) {
                    enumMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                }
                List bodyDecls = enumDeclaration.bodyDeclarations();
                for (BodyDeclaration bodyDecl : bodyDecls) {
                    if (bodyDecl instanceof FieldDeclaration) {
                        FieldMetadata fieldMetadata = this.getFieldMetadataFrom((FieldDeclaration)bodyDecl);
                        enumMetadata.getFields().add(fieldMetadata);
                        continue;
                    }
                    if (!(bodyDecl instanceof MethodDeclaration)) continue;
                    MethodMetadata methodMetadata = this.getMethodMetadataFrom((MethodDeclaration)bodyDecl);
                    enumMetadata.getMethods().add(methodMetadata);
                }
                metadata.add(enumMetadata);
            }
            if (!(abstractTypeDeclaration instanceof AnnotationTypeDeclaration)) continue;
        }
        return metadata;
    }

    protected void processModifiersOfTypDeclaration(AbstractTypeDeclaration typeDeclaration, ClassMetadata classMetadata) {
        List modifiers = typeDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            ModifierMetadata modifierMetadata = new ModifierMetadata();
            if (extendedModifier.isAnnotation()) {
                if (!(extendedModifier instanceof MarkerAnnotation)) continue;
                MarkerAnnotation marker = (MarkerAnnotation)extendedModifier;
                MarkerAnnotationMetadata markerAnnotationMetadata = new MarkerAnnotationMetadata();
                markerAnnotationMetadata.setName(JavaMetadataUtil.getName(marker.getTypeName()));
                classMetadata.getAnnotations().add(markerAnnotationMetadata);
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            modifierMetadata.setName(modifier.getKeyword().toString());
            classMetadata.getModifiers().add(modifierMetadata);
        }
    }

    protected MethodMetadata getMethodMetadataFrom(MethodDeclaration methodDeclaration) {
        if (methodDeclaration != null) {
            if (methodDeclaration.isConstructor()) {
                return this.getConstructorMetadataFrom(methodDeclaration);
            }
            return this.getMethodTypeMemberMetadataFrom(methodDeclaration);
        }
        return null;
    }

    protected MethodMetadata getMethodTypeMemberMetadataFrom(MethodDeclaration methodDeclaration) {
        MethodTypeMemberMetadata methodTypeMemberMetadata = new MethodTypeMemberMetadata();
        this.processReturnTypeOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        this.processModifiersOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        this.processParametersOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        methodTypeMemberMetadata.setName(JavaMetadataUtil.getName(methodDeclaration.getName()));
        List params = methodDeclaration.parameters();
        for (SingleVariableDeclaration singleVariableDeclaration : params) {
            singleVariableDeclaration.getName();
        }
        return methodTypeMemberMetadata;
    }

    protected void processReturnTypeOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        Type type = methodDeclaration.getReturnType2();
        if (type.isPrimitiveType()) {
            PrimitiveFieldMetadata primitive = new PrimitiveFieldMetadata();
            primitive.setType(((PrimitiveType)type).getPrimitiveTypeCode().toString());
            methodMetadata.setReturnType(primitive);
        }
        if (type.isSimpleType()) {
            SimpleTypeFieldMetadata simpleTypeFieldMetadata = new SimpleTypeFieldMetadata();
            simpleTypeFieldMetadata.setType(JavaMetadataUtil.getName(((SimpleType)type).getName()));
            methodMetadata.setReturnType(simpleTypeFieldMetadata);
        }
    }

    protected void processParametersOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        for (SingleVariableDeclaration singleVariableDeclaration : methodDeclaration.parameters()) {
            Type type = singleVariableDeclaration.getType();
            if (type.isPrimitiveType()) {
                PrimitiveFieldMetadata primitiveFieldMetadata = (PrimitiveFieldMetadata)this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(primitiveFieldMetadata);
            }
            if (type.isParameterizedType()) {
                ParameterizedTypeFieldMetadata parameterizedTypeFieldMetadata = (ParameterizedTypeFieldMetadata)this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(parameterizedTypeFieldMetadata);
            }
            if (type.isQualifiedType()) {
                // empty if block
            }
            if (type.isSimpleType()) {
                SimpleTypeFieldMetadata simpleTypeFieldMetadata = (SimpleTypeFieldMetadata)this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(simpleTypeFieldMetadata);
            }
            if (type.isArrayType()) {
                ArrayTypeFieldMetadata arrayTypeFieldMetadata = (ArrayTypeFieldMetadata)this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(arrayTypeFieldMetadata);
            }
            if (!type.isWildcardType()) continue;
        }
    }

    private FieldMetadata processVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type) {
        if (type.isPrimitiveType()) {
            PrimitiveFieldMetadata primitiveFieldMetadata = new PrimitiveFieldMetadata();
            primitiveFieldMetadata.setType(((PrimitiveType)type).getPrimitiveTypeCode().toString());
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName(singleVariableDeclaration.getName()));
            primitiveFieldMetadata.setName(variable.getName());
            primitiveFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier extendedModifier : singleVariableDeclaration.modifiers()) {
                ModifierMetadata modifierMetadata = new ModifierMetadata();
                if (extendedModifier.isAnnotation()) continue;
                Modifier modifier = (Modifier)extendedModifier;
                modifierMetadata.setName(modifier.getKeyword().toString());
                primitiveFieldMetadata.getModifiers().add(modifierMetadata);
            }
            return primitiveFieldMetadata;
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            SimpleTypeFieldMetadata simpleTypeFieldMetadata = new SimpleTypeFieldMetadata();
            simpleTypeFieldMetadata.setType(JavaMetadataUtil.getName(simpleType.getName()));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName(singleVariableDeclaration.getName()));
            simpleTypeFieldMetadata.setName(variable.getName());
            simpleTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier simpleTypeExtendedModifier : singleVariableDeclaration.modifiers()) {
                ModifierMetadata modifierMetadata = new ModifierMetadata();
                if (simpleTypeExtendedModifier.isAnnotation()) continue;
                Modifier modifier = (Modifier)simpleTypeExtendedModifier;
                modifierMetadata.setName(modifier.getKeyword().toString());
                simpleTypeFieldMetadata.getModifiers().add(modifierMetadata);
            }
            return simpleTypeFieldMetadata;
        }
        if (type.isParameterizedType()) {
            ParameterizedTypeFieldMetadata parameterizedTypeFieldMetadata = new ParameterizedTypeFieldMetadata();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            parameterizedTypeFieldMetadata.setType(this.getTypeName(parameterizedType));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName(singleVariableDeclaration.getName()));
            parameterizedTypeFieldMetadata.setName(variable.getName());
            parameterizedTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier parameterizedExtendedModifier : singleVariableDeclaration.modifiers()) {
                ModifierMetadata modifierMetadata = new ModifierMetadata();
                if (parameterizedExtendedModifier.isAnnotation()) continue;
                Modifier modifier = (Modifier)parameterizedExtendedModifier;
                modifierMetadata.setName(modifier.getKeyword().toString());
                parameterizedTypeFieldMetadata.getModifiers().add(modifierMetadata);
            }
            return parameterizedTypeFieldMetadata;
        }
        if (type.isArrayType()) {
            ArrayTypeFieldMetadata arrayTypeFieldMetadata = new ArrayTypeFieldMetadata();
            ArrayType arrayType = (ArrayType)type;
            arrayTypeFieldMetadata.setType(this.getTypeName(arrayType));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName(singleVariableDeclaration.getName()));
            arrayTypeFieldMetadata.setName(variable.getName());
            arrayTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier arrayTypeExtendedModifier : singleVariableDeclaration.modifiers()) {
                ModifierMetadata modifierMetadata = new ModifierMetadata();
                if (arrayTypeExtendedModifier.isAnnotation()) continue;
                Modifier modifier = (Modifier)arrayTypeExtendedModifier;
                modifierMetadata.setName(modifier.getKeyword().toString());
                arrayTypeFieldMetadata.getModifiers().add(modifierMetadata);
            }
            return arrayTypeFieldMetadata;
        }
        return null;
    }

    private String getTypeName(Type type) {
        CheckArg.isNotNull((Object)type, (String)"type");
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return primitiveType.getPrimitiveTypeCode().toString();
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            return JavaMetadataUtil.getName(simpleType.getName());
        }
        if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.getTypeName(parameterizedType.getType());
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            if (elementType.isPrimitiveType()) {
                return ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
            }
            if (elementType.isSimpleType()) {
                return JavaMetadataUtil.getName(((SimpleType)elementType).getName());
            }
        }
        return null;
    }

    protected MethodMetadata getConstructorMetadataFrom(MethodDeclaration methodDeclaration) {
        ConstructorMetadata constructorMetadata = new ConstructorMetadata();
        this.processModifiersOfMethodDeclaration(methodDeclaration, constructorMetadata);
        this.processParametersOfMethodDeclaration(methodDeclaration, constructorMetadata);
        constructorMetadata.setName(JavaMetadataUtil.getName(methodDeclaration.getName()));
        return constructorMetadata;
    }

    protected FieldMetadata getFieldMetadataFrom(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration != null && fieldDeclaration.getType() != null && !fieldDeclaration.fragments().isEmpty()) {
            Type type = fieldDeclaration.getType();
            if (type.isPrimitiveType()) {
                PrimitiveFieldMetadata primitiveFieldMetadata = this.processPrimitiveType(fieldDeclaration);
                return primitiveFieldMetadata;
            }
            if (type.isParameterizedType()) {
                ParameterizedTypeFieldMetadata referenceFieldMetadata = this.processParameterizedType(fieldDeclaration);
                return referenceFieldMetadata;
            }
            if (type.isSimpleType()) {
                SimpleTypeFieldMetadata simpleTypeFieldMetadata = this.processSimpleType(fieldDeclaration);
                return simpleTypeFieldMetadata;
            }
            if (type.isArrayType()) {
                ArrayTypeFieldMetadata arrayFieldMetadata = this.processArrayTypeFrom(fieldDeclaration);
                return arrayFieldMetadata;
            }
            if (type.isQualifiedType()) {
                // empty if block
            }
            if (type.isWildcardType()) {
                // empty if block
            }
        }
        return null;
    }

    protected ArrayTypeFieldMetadata processArrayTypeFrom(FieldDeclaration fieldDeclaration) {
        ArrayTypeFieldMetadata arrayTypeFieldMetadata = null;
        ArrayType arrayType = (ArrayType)fieldDeclaration.getType();
        Type type = arrayType.getElementType();
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            arrayTypeFieldMetadata = new ArrayTypeFieldMetadata();
            arrayTypeFieldMetadata.setType(primitiveType.getPrimitiveTypeCode().toString());
            this.processModifiersAndVariablesOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
            arrayTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
            return arrayTypeFieldMetadata;
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            arrayTypeFieldMetadata = new ArrayTypeFieldMetadata();
            arrayTypeFieldMetadata.setType(JavaMetadataUtil.getName(simpleType.getName()));
            this.processModifiersAndVariablesOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
            arrayTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
            return arrayTypeFieldMetadata;
        }
        return null;
    }

    private void processModifiersAndVariablesOfFieldDeclaration(FieldDeclaration fieldDeclaration, ArrayTypeFieldMetadata arrayTypeFieldMetadata) {
        this.processModifiersOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, arrayTypeFieldMetadata);
    }

    protected SimpleTypeFieldMetadata processSimpleType(FieldDeclaration fieldDeclaration) {
        SimpleType simpleType = (SimpleType)fieldDeclaration.getType();
        SimpleTypeFieldMetadata simpleTypeFieldMetadata = new SimpleTypeFieldMetadata();
        simpleTypeFieldMetadata.setType(JavaMetadataUtil.getName(simpleType.getName()));
        this.processModifiersOfFieldDeclaration(fieldDeclaration, simpleTypeFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, simpleTypeFieldMetadata);
        simpleTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        return simpleTypeFieldMetadata;
    }

    protected ParameterizedTypeFieldMetadata processParameterizedType(FieldDeclaration fieldDeclaration) {
        ParameterizedType parameterizedType = (ParameterizedType)fieldDeclaration.getType();
        Type typeOfParameterizedType = parameterizedType.getType();
        ParameterizedTypeFieldMetadata referenceFieldMetadata = (ParameterizedTypeFieldMetadata)this.createParameterizedFieldMetadataFrom(typeOfParameterizedType);
        this.processModifiersOfFieldDeclaration(fieldDeclaration, referenceFieldMetadata);
        referenceFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, referenceFieldMetadata);
        return referenceFieldMetadata;
    }

    protected String getFieldName(FieldDeclaration fieldDeclaration) {
        FieldVisitor visitor = new FieldVisitor();
        fieldDeclaration.accept(visitor);
        return visitor.name;
    }

    protected PrimitiveFieldMetadata processPrimitiveType(FieldDeclaration fieldDeclaration) {
        PrimitiveType primitiveType = (PrimitiveType)fieldDeclaration.getType();
        PrimitiveFieldMetadata primitiveFieldMetadata = new PrimitiveFieldMetadata();
        primitiveFieldMetadata.setType(primitiveType.getPrimitiveTypeCode().toString());
        primitiveFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        this.processModifiersOfFieldDeclaration(fieldDeclaration, primitiveFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, primitiveFieldMetadata);
        return primitiveFieldMetadata;
    }

    protected void processModifiersOfFieldDeclaration(FieldDeclaration fieldDeclaration, FieldMetadata fieldMetadata) {
        List extendedModifiers = fieldDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            ModifierMetadata modifierMetadata = new ModifierMetadata();
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                fieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor(annotation));
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            modifierMetadata.setName(modifier.getKeyword().toString());
            fieldMetadata.getModifiers().add(modifierMetadata);
        }
    }

    protected void processModifiersOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        List extendedModifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            ModifierMetadata modifierMetadata = new ModifierMetadata();
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                methodMetadata.getAnnotations().add(this.createAnnotationMetadataFor(annotation));
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            modifierMetadata.setName(modifier.getKeyword().toString());
            methodMetadata.getModifiers().add(modifierMetadata);
        }
    }

    protected FieldMetadata createParameterizedFieldMetadataFrom(Type type) {
        ParameterizedTypeFieldMetadata parameterizedTypeFieldMetadata = null;
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            parameterizedTypeFieldMetadata = new ParameterizedTypeFieldMetadata();
            parameterizedTypeFieldMetadata.setType(JavaMetadataUtil.getName(simpleType.getName()));
        }
        return parameterizedTypeFieldMetadata;
    }

    protected void processVariablesOfVariableDeclarationFragment(FieldDeclaration fieldDeclaration, FieldMetadata fieldMetadata) {
        List fragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            fieldMetadata.getVariables().add(new Variable(JavaMetadataUtil.getName(fragment.getName())));
        }
    }

    class FieldVisitor
    extends ASTVisitor {
        String name;

        FieldVisitor() {
        }

        @Override
        public boolean visit(VariableDeclarationFragment node) {
            this.name = node.getName().getFullyQualifiedName();
            return super.visit(node);
        }
    }
}

