/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile.metadata;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.sequencer.javafile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.javafile.metadata.ModifierMetadata;

public abstract class AbstractMetadata {
    public static final String STATIC = "static";
    public static final String FINAL = "final";
    public static final String ABSTRACT = "abstract";
    public static final String STRICT_FP = "strictfp";
    public static final String NATIVE = "native";
    public static final String SYNCRHONIZED = "synchronized";
    public static final String TRANSIENT = "transient";
    public static final String VOLATILE = "volatile";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";
    protected String name;
    private List<ModifierMetadata> modifiers = new ArrayList<ModifierMetadata>();
    private List<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public List<ModifierMetadata> getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasStaticModifier() {
        return this.hasModifierNamed(STATIC);
    }

    public boolean hasFinalModifier() {
        return this.hasModifierNamed(FINAL);
    }

    public boolean hasAbstractModifier() {
        return this.hasModifierNamed(ABSTRACT);
    }

    public boolean hasNativeModifier() {
        return this.hasModifierNamed(NATIVE);
    }

    public boolean hasSynchronizedModifier() {
        return this.hasModifierNamed(SYNCRHONIZED);
    }

    public boolean hasStrictFPModifier() {
        return this.hasModifierNamed(STRICT_FP);
    }

    public boolean hasTransientModifier() {
        return this.hasModifierNamed(TRANSIENT);
    }

    public boolean hasVolatileModifier() {
        return this.hasModifierNamed(VOLATILE);
    }

    public boolean hasPublicVisibility() {
        return this.hasModifierNamed(PUBLIC);
    }

    public boolean hasProtectedVisibility() {
        return this.hasModifierNamed(PROTECTED);
    }

    public boolean hasPrivateVisibility() {
        return this.hasModifierNamed(PRIVATE);
    }

    private boolean hasModifierNamed(String modifierName) {
        for (ModifierMetadata modifier : this.modifiers) {
            if (!modifierName.equalsIgnoreCase(modifier.getName())) continue;
            return true;
        }
        return false;
    }
}

