/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile.metadata;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.sequencer.javafile.metadata.AbstractMetadata;
import org.modeshape.sequencer.javafile.metadata.FieldMetadata;

public class MethodMetadata
extends AbstractMetadata {
    private Type type;
    private FieldMetadata returnType;
    private List<FieldMetadata> parameters = new ArrayList<FieldMetadata>();

    private MethodMetadata(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public List<FieldMetadata> getParameters() {
        return this.parameters;
    }

    public List<String> getParameterTypes() {
        ArrayList<String> params = new ArrayList<String>(this.parameters.size());
        for (FieldMetadata param : this.parameters) {
            params.add(param.getType());
        }
        return params;
    }

    public FieldMetadata getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeName() {
        return this.returnType == null ? Void.TYPE.getCanonicalName() : this.returnType.getType();
    }

    public void setReturnType(FieldMetadata returnType) {
        this.returnType = returnType;
    }

    public String getId() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getName()).append('(');
        boolean first = true;
        for (FieldMetadata parameter : this.parameters) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(this.shortNameFor(parameter.getType()).replace("[]", " array"));
        }
        buff.append(')');
        return buff.toString();
    }

    private String shortNameFor(String type) {
        assert (type != null);
        int lastDotPos = type.lastIndexOf(46);
        if (lastDotPos < 0) {
            return type;
        }
        return type.substring(lastDotPos + 1);
    }

    public Type getType() {
        return this.type;
    }

    public static MethodMetadata constructorType(String name) {
        return new MethodMetadata(name, Type.CONSTRUCTOR);
    }

    public static MethodMetadata methodMemberType(String name) {
        return new MethodMetadata(name, Type.METHOD_TYPE_MEMBER);
    }

    public static enum Type {
        CONSTRUCTOR,
        METHOD_TYPE_MEMBER;

    }
}

