/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.StaleStateException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread {
    JobExecutor jobExecutor;
    JbpmConfiguration jbpmConfiguration;
    int idleInterval;
    int maxIdleInterval;
    long maxLockTime;
    int maxHistory;
    Collection history = new ArrayList();
    int currentIdleInterval;
    boolean isActive = true;
    private static Log log = LogFactory.getLog(JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jbpmConfiguration;
        this.idleInterval = idleInterval;
        this.maxIdleInterval = maxIdleInterval;
        this.maxLockTime = maxLockTime;
        this.maxHistory = maxHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.currentIdleInterval = this.idleInterval;
            while (this.isActive) {
                try {
                    long waitPeriod;
                    Collection acquiredJobs = this.acquireJobs();
                    if (!acquiredJobs.isEmpty()) {
                        Iterator iter = acquiredJobs.iterator();
                        while (iter.hasNext() && this.isActive) {
                            Job job = (Job)iter.next();
                            this.executeJob(job);
                        }
                    } else if (this.isActive && (waitPeriod = this.getWaitPeriod()) > 0L) {
                        JobExecutor jobExecutor = this.jobExecutor;
                        synchronized (jobExecutor) {
                            this.jobExecutor.wait(waitPeriod);
                        }
                    }
                    this.currentIdleInterval = this.idleInterval;
                }
                catch (InterruptedException e) {
                    log.info((this.isActive ? "active" : "inactivated") + " job executor thread '" + this.getName() + "' got interrupted");
                }
                catch (Exception e) {
                    log.error("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds", e);
                    try {
                        JobExecutor waitPeriod = this.jobExecutor;
                        synchronized (waitPeriod) {
                            this.jobExecutor.wait(this.currentIdleInterval);
                        }
                    }
                    catch (InterruptedException e2) {
                        log.debug("delay after exception got interrupted", e2);
                    }
                    this.currentIdleInterval *= 2;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            log.info(this.getName() + " leaves cyberspace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection acquireJobs() {
        ArrayList<Job> acquiredJobs = null;
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            ArrayList<Job> jobsToLock = new ArrayList<Job>();
            log.debug("acquiring jobs for execution...");
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            try {
                try {
                    JobSession jobSession = jbpmContext.getJobSession();
                    log.debug("querying for acquirable job...");
                    Job job = jobSession.getFirstAcquirableJob(this.getName());
                    if (job != null) {
                        if (job.isExclusive()) {
                            log.debug("exclusive acquirable job found (" + job + "). querying for other exclusive jobs to lock them all in one tx...");
                            List otherExclusiveJobs = jobSession.findExclusiveJobs(this.getName(), job.getProcessInstance());
                            jobsToLock.addAll(otherExclusiveJobs);
                            log.debug("trying to obtain a process-instance exclusive locks for '" + otherExclusiveJobs + "'");
                        } else {
                            log.debug("trying to obtain a lock for '" + job + "'");
                            jobsToLock.add(job);
                        }
                        Iterator iter = jobsToLock.iterator();
                        while (iter.hasNext()) {
                            job = (Job)iter.next();
                            job.setLockOwner(this.getName());
                            job.setLockTime(new Date());
                        }
                        if (job instanceof Timer) {
                            Hibernate.initialize((Object)((Timer)job).getGraphElement());
                        }
                    } else {
                        log.debug("no acquirable jobs in job table");
                    }
                }
                finally {
                    jbpmContext.close();
                }
                acquiredJobs = jobsToLock;
                log.debug("obtained locks on following jobs: " + acquiredJobs);
            }
            catch (StaleStateException e) {
                log.debug("couldn't acquire lock on job(s): " + jobsToLock);
            }
        }
        return acquiredJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(Job job) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            job = jobSession.loadJob(job.getId());
            try {
                log.debug("executing job " + job);
                if (job.execute(jbpmContext)) {
                    jobSession.deleteJob(job);
                }
            }
            catch (Exception e) {
                log.debug("exception while executing '" + job + "'", e);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                job.setException(sw.toString());
                job.setRetries(job.getRetries() - 1);
            }
            long totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime();
            if (totalLockTimeInMillis > this.maxLockTime) {
                jbpmContext.setRollbackOnly();
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if ("org.hibernate.StaleObjectStateException".equals(e.getCause().getClass().getName())) {
                    log.info("problem committing job execution transaction: optimistic locking failed");
                    StaleObjectLogConfigurer.staleObjectExceptionsLog.error("problem committing job execution transaction: optimistic locking failed", e);
                } else {
                    log.error("problem committing job execution transaction", e);
                }
            }
            catch (RuntimeException e) {
                log.error("problem committing job execution transaction", e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Set jobIdsToIgnore = this.jobExecutor.getMonitoredJobIds();
            Job job = jobSession.getFirstDueJob(this.getName(), jobIdsToIgnore);
            if (job != null) {
                nextDueDate = job.getDueDate();
                this.jobExecutor.addMonitoredJobId(this.getName(), job.getId());
            }
        }
        finally {
            jbpmContext.close();
        }
        return nextDueDate;
    }

    protected long getWaitPeriod() {
        long interval = this.currentIdleInterval;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

