/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;

public class Timer
extends Job {
    private static final long serialVersionUID = 1L;
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    String name;
    String repeat;
    String transitionName = null;
    Action action = null;
    GraphElement graphElement = null;
    static DateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss,SSS");
    private static Log log = LogFactory.getLog(Timer.class);

    public Timer() {
    }

    public Timer(Token token) {
        super(token);
    }

    public boolean execute(JbpmContext jbpmContext) throws Exception {
        boolean deleteThisJob;
        block13: {
            deleteThisJob = true;
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTimer(this);
            if (this.taskInstance != null) {
                executionContext.setTaskInstance(this.taskInstance);
            }
            if (this.graphElement != null) {
                this.graphElement.fireAndPropagateEvent("timer", executionContext);
            }
            if (this.action != null) {
                try {
                    log.debug("executing timer '" + this + "'");
                    if (this.graphElement != null) {
                        this.graphElement.executeAction(this.action, executionContext);
                    } else {
                        this.action.execute(executionContext);
                    }
                }
                catch (Exception actionException) {
                    log.warn("timer action threw exception", actionException);
                    Exception t = actionException;
                    try {
                        if (this.graphElement != null) {
                            this.graphElement.raiseException(actionException, executionContext);
                            log.debug("timer exception got handled by '" + this.graphElement + "'");
                            t = null;
                        }
                    }
                    catch (Exception rethrowOrDelegationException) {
                        t = rethrowOrDelegationException;
                    }
                    if (t == null) break block13;
                    throw t;
                }
            }
        }
        if (this.transitionName != null && this.exception == null && this.token.getNode().hasLeavingTransition(this.transitionName)) {
            this.token.signal(this.transitionName);
        }
        jbpmContext.save(this.processInstance);
        if (this.repeat != null) {
            deleteThisJob = false;
            while (this.dueDate.getTime() <= System.currentTimeMillis()) {
                this.dueDate = businessCalendar.add(this.dueDate, new Duration(this.repeat));
            }
            log.debug("updated timer for repetition '" + this + "' in '" + (this.dueDate.getTime() - System.currentTimeMillis()) + "' millis");
        }
        return deleteThisJob;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("timer");
        if (this.name != null || this.dueDate != null) {
            buffer.append("(");
            if (this.name != null) {
                buffer.append(this.name).append(",");
            }
            if (this.dueDate != null) {
                buffer.append(dateFormat.format(this.dueDate)).append(",");
            }
            if (this.taskInstance != null) {
                buffer.append("TaskInstance: ").append(this.taskInstance.getId()).append(",");
            }
            if (this.token != null) {
                buffer.append("Token: ").append(this.token.getId());
            } else if (this.processInstance != null) {
                buffer.append("ProcessInstance: ").append(this.processInstance.getId());
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }

    public void setGraphElement(GraphElement graphElement) {
        this.graphElement = graphElement;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }
}

