/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.Token;

public class BatchSignalCommand
implements Command {
    private static final long serialVersionUID = -4330623193546102772L;
    private static Log log = LogFactory.getLog(BatchSignalCommand.class);
    private long[] tokenIds = null;
    private String processName = null;
    private String stateName = null;
    private Date inStateAtLeastSince = null;
    private long processVersion = 0L;
    private String transitionName = null;

    public Object execute(JbpmContext jbpmContext) throws Exception {
        log.debug("executing " + this);
        if (this.tokenIds != null && this.tokenIds.length > 0) {
            for (int i = 0; i < this.tokenIds.length; ++i) {
                Token token = jbpmContext.loadTokenForUpdate(this.tokenIds[i]);
                this.signalToken(token);
            }
        }
        if (this.processName != null && this.stateName != null) {
            Query query = jbpmContext.getSession().getNamedQuery("GraphSession.findTokensForProcessInNode");
            query.setString("processDefinitionName", this.processName);
            query.setString("nodeName", this.stateName);
            Iterator iter = query.list().iterator();
            while (iter.hasNext()) {
                Token t = (Token)iter.next();
                if (this.inStateAtLeastSince != null && !t.getNodeEnter().before(this.inStateAtLeastSince)) continue;
                this.signalToken(t);
            }
        }
        return null;
    }

    private void signalToken(Token token) {
        log.debug("signal token " + token);
        if (this.transitionName == null) {
            token.signal();
        } else {
            token.signal(this.transitionName);
        }
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public long getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(long processVersion) {
        this.processVersion = processVersion;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public long[] getTokenIds() {
        return this.tokenIds;
    }

    public void setTokenIds(long[] tokenIds) {
        this.tokenIds = tokenIds;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public Date getInStateAtLeastSince() {
        return this.inStateAtLeastSince;
    }

    public void setInStateAtLeastSince(Date inStateAtLeastSince) {
        this.inStateAtLeastSince = inStateAtLeastSince;
    }
}

