/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.command.GetProcessInstancesCommand;
import org.jbpm.db.JbpmSchema;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ChangeProcessInstanceVersionCommand
implements Command {
    private static final long serialVersionUID = 2277080393930008224L;
    private long processId = -1L;
    private String processName;
    private int newVersion = -1;
    private static final Log log = LogFactory.getLog(JbpmSchema.class);
    private transient JbpmContext jbpmContext = null;
    private Map nameMapping = new HashMap();
    private transient ProcessDefinition newDef;

    public ChangeProcessInstanceVersionCommand() {
    }

    public ChangeProcessInstanceVersionCommand(long processId, int newVersion) {
        this.processId = processId;
        this.newVersion = newVersion;
    }

    private ProcessDefinition getNewDef(String processName) {
        if (this.newDef == null) {
            this.newDef = this.newVersion <= 0 ? this.jbpmContext.getGraphSession().findLatestProcessDefinition(processName) : this.jbpmContext.getGraphSession().findProcessDefinition(processName, this.newVersion);
        }
        return this.newDef;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        if (this.processId > -1L) {
            ProcessInstance pi = jbpmContext.getGraphSession().loadProcessInstance(this.processId);
            this.changeProcessVersion(pi);
        }
        if (this.processName != null && this.processName.length() > 0) {
            this.changeAllProcessInstances(this.processName);
        }
        return null;
    }

    private void changeProcessVersion(ProcessInstance pi) {
        this.changeTokenVersion(this.jbpmContext, pi.getRootToken());
        ProcessDefinition oldDef = pi.getProcessDefinition();
        ProcessDefinition newDef = this.getNewDef(oldDef.getName());
        log.debug("changes process id " + pi.getId() + " from version " + pi.getProcessDefinition().getVersion() + " to new version " + newDef.getVersion());
        pi.setProcessDefinition(newDef);
        log.debug("process id " + pi.getId() + " changed to version " + pi.getProcessDefinition().getVersion());
    }

    private void changeAllProcessInstances(String processName) throws Exception {
        log.debug("changing version all processes '" + processName + "'");
        GetProcessInstancesCommand cmd = new GetProcessInstancesCommand();
        cmd.setProcessName(processName);
        cmd.setOnlyRunning(true);
        List instances = (List)cmd.execute(this.jbpmContext);
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            ProcessInstance pi = (ProcessInstance)iter.next();
            this.changeProcessVersion(pi);
        }
    }

    private void changeTokenVersion(JbpmContext jbpmContext, Token token) {
        Node oldNode = token.getNode();
        ProcessDefinition oldDef = token.getProcessInstance().getProcessDefinition();
        ProcessDefinition newDef = this.getNewDef(oldDef.getName());
        Node newNode = newDef.findNode(this.getNewNodeName(oldNode));
        if (newNode == null) {
            throw new JbpmException("node with name '" + this.getNewNodeName(oldNode) + "' not found in new process definition");
        }
        log.debug("change token id " + token.getId() + " from version " + oldDef.getVersion() + " to new version " + newDef.getVersion());
        token.setNode(newNode);
        Iterator iter = this.getTasksForToken(token).iterator();
        while (iter.hasNext()) {
            TaskInstance ti = (TaskInstance)iter.next();
            Task oldTask = ti.getTask();
            Query q = jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskForNode");
            q.setString("taskName", oldTask.getName());
            q.setLong("taskNodeId", newNode.getId());
            Task newTask = (Task)q.uniqueResult();
            if (newTask == null) {
                throw new JbpmException("node '" + newNode.getName() + "' has no Task configured! Check the new process definition");
            }
            ti.setTask(newTask);
            log.debug("change dependent task-instance with id " + oldTask.getId());
        }
        Iterator childIter = token.getChildren().values().iterator();
        while (childIter.hasNext()) {
            this.changeTokenVersion(jbpmContext, (Token)childIter.next());
        }
    }

    private String getNewNodeName(Node oldNode) {
        String oldName = oldNode.getFullyQualifiedName();
        if (this.nameMapping.containsKey(oldName)) {
            return (String)this.nameMapping.get(oldName);
        }
        return oldName;
    }

    private List getTasksForToken(Token token) {
        Query query = this.jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
        query.setLong("tokenId", token.getId());
        return query.list();
    }

    public Map getNameMapping() {
        return this.nameMapping;
    }

    public void setNameMapping(Map nameMapping) {
        this.nameMapping = nameMapping == null ? new HashMap() : nameMapping;
    }

    public int getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(int newVersion) {
        this.newVersion = newVersion;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }
}

