/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Date;
import java.util.Iterator;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractCancelCommand;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;

public class CancelProcessInstanceCommand
extends AbstractCancelCommand
implements Command {
    private static final long serialVersionUID = 7145293049356621597L;
    private long processId;
    boolean cancelSubProcesses = false;

    public CancelProcessInstanceCommand() {
    }

    public CancelProcessInstanceCommand(long processId) {
        this.processId = processId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        this.cancelProcess(this.processId);
        this.jbpmContext = null;
        return null;
    }

    protected void cancelProcess(long processIdToCancel) {
        ProcessInstance pi = this.jbpmContext.getGraphSession().loadProcessInstance(processIdToCancel);
        log.info("cancel process instance " + pi.getId());
        pi.getContextInstance().createVariable("cancelled", new Date());
        try {
            this.cancelToken(pi.getRootToken());
            this.cancelTokens(pi.getRootToken().getChildren().values());
            pi.end();
            if (this.cancelSubProcesses) {
                this.cancelSubProcesses(processIdToCancel);
            }
            log.info("finished process cancellation");
        }
        catch (RuntimeException ex) {
            log.error("problems while cancel process", ex);
            throw ex;
        }
    }

    protected void cancelSubProcesses(long processId) {
        Query q = this.jbpmContext.getSession().getNamedQuery("GraphSession.findSubProcessInstances");
        q.setLong("instanceId", processId);
        Iterator iter = q.list().iterator();
        while (iter.hasNext()) {
            ProcessInstance pi = (ProcessInstance)iter.next();
            log.info("cancel sub process instance #" + pi.getId());
            this.cancelProcess(pi.getId());
        }
    }

    public boolean isCancelSubProcesses() {
        return this.cancelSubProcesses;
    }

    public void setCancelSubProcesses(boolean cancelSubProcesses) {
        this.cancelSubProcesses = cancelSubProcesses;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }
}

