/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.JbpmException;
import org.jbpm.util.ClassLoaderUtil;

public abstract class HibernateHelper {
    static Map configurations = new HashMap();
    private static Log log = LogFactory.getLog(HibernateHelper.class);

    public static void clearConfigurationsCache() {
        configurations = new HashMap();
    }

    public static SessionFactory createSessionFactory() {
        return HibernateHelper.createSessionFactory(null, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, propertiesResource, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource, boolean isConfigLookupEnabled) {
        Configuration configuration = HibernateHelper.createConfiguration(cfgXmlResource, propertiesResource);
        return HibernateHelper.createSessionFactory(configuration, isConfigLookupEnabled);
    }

    public static SessionFactory createSessionFactory(Configuration configuration, boolean isConfigLookupEnabled) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        if (isConfigLookupEnabled) {
            configurations.put(sessionFactory, configuration);
        }
        return sessionFactory;
    }

    public static Configuration createConfiguration(String cfgXmlResource, String propertiesResource) {
        Configuration configuration = new Configuration();
        if (cfgXmlResource != null) {
            log.debug("creating hibernate configuration resource '" + cfgXmlResource + "'");
            configuration.configure(cfgXmlResource);
        } else {
            log.debug("using default hibernate configuration resource (hibernate.cfg.xml)");
            configuration.configure();
        }
        if (propertiesResource != null) {
            log.debug("using hibernate properties from resource '" + propertiesResource + "'");
            Properties properties = HibernateHelper.loadPropertiesFromResource(propertiesResource);
            configuration.setProperties(properties);
        }
        return configuration;
    }

    public static Configuration getConfiguration(SessionFactory sessionFactory) {
        return (Configuration)configurations.get(sessionFactory);
    }

    public static SchemaExport createSchemaExport(SessionFactory sessionFactory) {
        return new SchemaExport(HibernateHelper.getConfiguration(sessionFactory));
    }

    public static boolean createSchemaExportScript(SessionFactory sessionFactory) {
        boolean script = false;
        String showSql = HibernateHelper.getConfiguration(sessionFactory).getProperty("hibernate.show_sql");
        if ("true".equalsIgnoreCase(showSql)) {
            script = true;
        }
        return script;
    }

    public static void clearHibernateCache(SessionFactory sessionFactory) {
        sessionFactory.evictQueries();
        Map classMetadata = sessionFactory.getAllClassMetadata();
        Iterator iter = classMetadata.keySet().iterator();
        while (iter.hasNext()) {
            String entityName = (String)iter.next();
            log.debug("evicting entities " + entityName);
            Class entityClass = ClassLoaderUtil.loadClass(entityName);
            sessionFactory.evict(entityClass);
        }
        Map collectionMetadata = sessionFactory.getAllCollectionMetadata();
        iter = collectionMetadata.keySet().iterator();
        while (iter.hasNext()) {
            String collectionName = (String)iter.next();
            log.debug("evicting collection " + collectionName);
            sessionFactory.evictCollection(collectionName);
        }
    }

    static Properties loadPropertiesFromResource(String resource) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = ClassLoaderUtil.getStream(resource);
            properties.load(inputStream);
        }
        catch (NullPointerException e) {
            throw new JbpmException("couldn't load hibernate properties from unexisting resource '" + resource + "'", e);
        }
        catch (IOException e) {
            throw new JbpmException("couldn't load hibernate properties from resource '" + resource + "'", e);
        }
        return properties;
    }
}

