/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class NodeTypes {
    private static final Log log = LogFactory.getLog(NodeTypes.class);
    static Map nodeTypes = NodeTypes.initialiseNodeTypes();
    static Map nodeNames = NodeTypes.createInverseMapping(nodeTypes);

    public static Set getNodeTypes() {
        return nodeTypes.keySet();
    }

    public static Set getNodeNames() {
        return nodeNames.keySet();
    }

    public static Class getNodeType(String name) {
        return (Class)nodeTypes.get(name);
    }

    public static String getNodeName(Class type) {
        return (String)nodeNames.get(type);
    }

    static Map initialiseNodeTypes() {
        HashMap types = new HashMap();
        String resource = JbpmConfiguration.Configs.getString("resource.node.types");
        InputStream actionTypesStream = ClassLoaderUtil.getStream(resource);
        Element nodeTypesElement = XmlUtil.parseXmlInputStream(actionTypesStream).getDocumentElement();
        Iterator nodeTypeIterator = XmlUtil.elementIterator(nodeTypesElement, "node-type");
        while (nodeTypeIterator.hasNext()) {
            Element nodeTypeElement = (Element)nodeTypeIterator.next();
            String elementTag = nodeTypeElement.getAttribute("element");
            String className = nodeTypeElement.getAttribute("class");
            try {
                Class<?> nodeClass = ClassLoaderUtil.getClassLoader().loadClass(className);
                types.put(elementTag, nodeClass);
            }
            catch (Exception e) {
                if ("org.jboss.seam.jbpm.Page".equals(className)) continue;
                log.debug("node '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded");
            }
        }
        return types;
    }

    public static Map createInverseMapping(Map map) {
        HashMap names = new HashMap();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            names.put(entry.getValue(), entry.getKey());
        }
        return names;
    }
}

