/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.msg.MessageService;

public class DbMessageService
implements MessageService {
    private static final long serialVersionUID = 1L;
    JbpmConfiguration jbpmConfiguration;
    JobSession jobSession = null;
    Collection destinations = null;
    boolean hasProducedJobs = false;
    private static Log log = LogFactory.getLog(DbMessageService.class);

    public DbMessageService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the DbMessageService requires a current JbpmContext");
        }
        this.jbpmConfiguration = jbpmContext.getJbpmConfiguration();
        this.jobSession = jbpmContext.getJobSession();
    }

    public void send(Job job) {
        this.jobSession.saveJob(job);
        log.debug("saved job[" + job.getId() + ", " + job.getClass().getName() + "]");
        this.hasProducedJobs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JobExecutor jobExecutor = this.jbpmConfiguration.getJobExecutor();
        if (this.hasProducedJobs && jobExecutor != null) {
            log.debug("messages were produced the jobExecutor will be signalled");
            JobExecutor jobExecutor2 = jobExecutor;
            synchronized (jobExecutor2) {
                jobExecutor.notify();
            }
        }
    }
}

