/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.tag.Tag;

public abstract class AudioFileWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private AudioFileModificationListener modificationListener = null;

    /*
     * Loose catch block
     */
    public synchronized void delete(AudioFile f) throws CannotReadException, CannotWriteException {
        block24: {
            if (!f.getFile().canWrite()) {
                throw new CannotWriteException("Can't write to file \"" + f.getFile().getAbsolutePath() + "\"");
            }
            if (f.getFile().length() <= 150L) {
                throw new CannotWriteException("Less than 150 byte \"" + f.getFile().getAbsolutePath() + "\"");
            }
            RandomAccessFile raf = null;
            RandomAccessFile rafTemp = null;
            File tempF = null;
            boolean revert = false;
            tempF = File.createTempFile("entagged", ".tmp", f.getFile().getParentFile());
            rafTemp = new RandomAccessFile(tempF, "rw");
            raf = new RandomAccessFile(f.getFile(), "rw");
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(f, true);
                }
                this.deleteTag(raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(f, tempF);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
            Object var8_8 = null;
            File result = f.getFile();
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
                if (tempF.length() > 0L && !revert) {
                    f.getFile().delete();
                    tempF.renameTo(f.getFile());
                    result = tempF;
                } else {
                    tempF.delete();
                }
            }
            catch (Exception ex) {
                System.err.println("AudioFileWriter:113:\"" + f.getFile().getAbsolutePath() + "\" or \"" + tempF.getAbsolutePath() + "\" :" + ex);
            }
            if (this.modificationListener != null) {
                this.modificationListener.fileOperationFinished(result);
            }
            break block24;
            {
                catch (Exception e) {
                    revert = true;
                    throw new CannotWriteException("\"" + f.getFile().getAbsolutePath() + "\" :" + e, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                result = f.getFile();
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp != null) {
                        rafTemp.close();
                    }
                    if (tempF.length() > 0L && !revert) {
                        f.getFile().delete();
                        tempF.renameTo(f.getFile());
                        result = tempF;
                    } else {
                        tempF.delete();
                    }
                }
                catch (Exception ex) {
                    System.err.println("AudioFileWriter:113:\"" + f.getFile().getAbsolutePath() + "\" or \"" + tempF.getAbsolutePath() + "\" :" + ex);
                }
                if (this.modificationListener != null) {
                    this.modificationListener.fileOperationFinished(result);
                }
                throw throwable;
            }
        }
    }

    public synchronized void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        raf.seek(0L);
        tempRaf.seek(0L);
        this.deleteTag(raf, tempRaf);
    }

    protected abstract void deleteTag(RandomAccessFile var1, RandomAccessFile var2) throws CannotReadException, CannotWriteException, IOException;

    public synchronized void setAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationListener = listener;
    }

    /*
     * Loose catch block
     */
    public synchronized void write(AudioFile af) throws CannotWriteException {
        block27: {
            logger.info("Started writing tag data for file:" + af.getFile().getName());
            try {
                if (af.getTag().isEmpty()) {
                    this.delete(af);
                    return;
                }
            }
            catch (CannotReadException re) {
                throw new CannotWriteException("Can't write to file \"" + af.getFile().getAbsolutePath() + "\"");
            }
            if (!af.getFile().canWrite()) {
                throw new CannotWriteException("Can't write to file \"" + af.getFile().getAbsolutePath() + "\"");
            }
            if (af.getFile().length() <= 150L) {
                throw new CannotWriteException("Less than 150 byte \"" + af.getFile().getAbsolutePath() + "\"");
            }
            RandomAccessFile raf = null;
            RandomAccessFile rafTemp = null;
            File tempF = null;
            boolean cannotWrite = false;
            tempF = File.createTempFile("entagged", ".tmp", af.getFile().getParentFile());
            rafTemp = new RandomAccessFile(tempF, "rw");
            raf = new RandomAccessFile(af.getFile(), "rw");
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, false);
                }
                this.writeTag(af.getTag(), raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, tempF);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
            Object var8_9 = null;
            File result = af.getFile();
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
                if (!cannotWrite && tempF.length() > 0L) {
                    af.getFile().delete();
                    tempF.renameTo(af.getFile());
                    result = tempF;
                } else {
                    tempF.delete();
                }
            }
            catch (Exception ex) {
                System.err.println("AudioFileWriter:165:\"" + af.getFile().getAbsolutePath() + "\" or \"" + tempF.getAbsolutePath() + "\" :" + ex);
            }
            if (this.modificationListener != null) {
                this.modificationListener.fileOperationFinished(result);
            }
            break block27;
            {
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    cannotWrite = true;
                    throw new CannotWriteException("\"" + af.getFile().getAbsolutePath() + "\" :" + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                result = af.getFile();
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp != null) {
                        rafTemp.close();
                    }
                    if (!cannotWrite && tempF.length() > 0L) {
                        af.getFile().delete();
                        tempF.renameTo(af.getFile());
                        result = tempF;
                    } else {
                        tempF.delete();
                    }
                }
                catch (Exception ex) {
                    System.err.println("AudioFileWriter:165:\"" + af.getFile().getAbsolutePath() + "\" or \"" + tempF.getAbsolutePath() + "\" :" + ex);
                }
                if (this.modificationListener != null) {
                    this.modificationListener.fileOperationFinished(result);
                }
                throw throwable;
            }
        }
    }

    protected abstract void writeTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotReadException, CannotWriteException, IOException;
}

