/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v22FieldKey;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;

public class ID3v22Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_COMPRESSION = "compression";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    public static final int MASK_V22_UNSYNCHRONIZATION = 128;
    public static final int MASK_V22_COMPRESSION = 128;
    protected boolean compression = false;
    protected boolean unsynchronization = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 2;
    public static final byte REVISION = 0;

    public byte getRelease() {
        return 2;
    }

    public byte getMajorVersion() {
        return 2;
    }

    public byte getRevision() {
        return 0;
    }

    public ID3v22Tag() {
        this.frameMap = new LinkedHashMap();
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.info("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v22Tag) {
            ID3v22Tag copyObject = (ID3v22Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v23Tag) {
            ID3v23Tag copyObject = (ID3v23Tag)copyObj;
            this.compression = copyObject.compression;
            this.unsynchronization = copyObject.unsynchronization;
        } else if (copyObj instanceof ID3v24Tag) {
            ID3v24Tag copyObject = (ID3v24Tag)copyObj;
            this.compression = false;
            this.unsynchronization = copyObject.unsynchronization;
        }
    }

    protected void copyFrames(AbstractID3v2Tag copyObject) {
        logger.info("Copying Frames,there are:" + copyObject.frameMap.keySet().size());
        this.frameMap = new LinkedHashMap();
        Iterator iterator = copyObject.frameMap.keySet().iterator();
        ID3v22Frame newFrame = null;
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame;
            String id = (String)iterator.next();
            Object o = copyObject.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                if (frame.getIdentifier().equals("TDRC") && frame.getBody() instanceof FrameBodyTDRC) {
                    this.translateFrame(frame);
                    continue;
                }
                try {
                    newFrame = new ID3v22Frame(frame);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier(), ife);
                }
                continue;
            }
            if (!(o instanceof ArrayList)) continue;
            ArrayList<ID3v22Frame> multiFrame = new ArrayList<ID3v22Frame>();
            ListIterator li = ((ArrayList)o).listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                try {
                    newFrame = new ID3v22Frame(frame);
                    multiFrame.add(newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier(), ife);
                }
            }
            if (newFrame == null) continue;
            this.frameMap.put(newFrame.getIdentifier(), multiFrame);
        }
    }

    public ID3v22Tag(ID3v22Tag copyObject) {
        super(copyObject);
        logger.info("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v22Tag(AbstractTag mp3tag) {
        this.frameMap = new LinkedHashMap();
        logger.info("Creating tag from a tag of a different version");
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v23Tag) && mp3tag instanceof ID3v22Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag convertedTag = mp3tag instanceof ID3v24Tag ? (ID3v24Tag)mp3tag : new ID3v24Tag(mp3tag);
            this.copyPrimitives(convertedTag);
            this.copyFrames(convertedTag);
            logger.info("Created tag from a tag of a different version");
        }
    }

    public ID3v22Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v22Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    public int getSize() {
        int size = 10;
        return size += super.getSize();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v22Tag)) {
            return false;
        }
        ID3v22Tag object = (ID3v22Tag)obj;
        if (this.compression != object.compression) {
            return false;
        }
        if (this.unsynchronization != object.unsynchronization) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        logger.info(this.getLoggingFilename() + ":" + "Reading tag from file");
        byte flags = byteBuffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        boolean bl = this.compression = (flags & 0x80) != 0;
        if (this.unsynchronization) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v22 Tag is unsynchronized");
        }
        if (this.compression) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v22 Tag is compressed");
        }
        int size = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        ByteBuffer bufferWithoutHeader = byteBuffer.slice();
        if (this.unsynchronization) {
            bufferWithoutHeader = ID3Unsynchronization.synchronize(bufferWithoutHeader);
        }
        this.readFrames(bufferWithoutHeader, size);
        logger.info(this.getLoggingFilename() + ":" + "Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        this.frameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at:" + byteBuffer.position() + ",frames sizes and padding is:" + size);
        while (byteBuffer.position() < size) {
            try {
                logger.finest(this.getLoggingFilename() + ":" + "looking for next frame at:" + byteBuffer.position());
                ID3v22Frame next = new ID3v22Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                this.loadFrameIntoMap(id, next);
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 6;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.info(this.getLoggingFilename() + ":" + "Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame:" + ife.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
        }
    }

    protected void translateFrame(AbstractID3v2Frame frame) {
        ID3v22Frame newFrame;
        FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
        if (tmpBody.getYear().length() != 0) {
            newFrame = new ID3v22Frame("TYE");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getYear());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
        if (tmpBody.getTime().length() != 0) {
            newFrame = new ID3v22Frame("TIM");
            ((AbstractFrameBodyTextInfo)newFrame.getBody()).setText(tmpBody.getTime());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.compression = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flags = 0;
        if (this.unsynchronization) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        if (this.compression) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        headerBuffer.put(flags);
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size));
        headerBuffer.flip();
        return headerBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file, long audioStartLocation) throws IOException {
        logger.info("Writing tag to file");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() ? ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer) : false;
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        logger.info(this.getLoggingFilename() + ":Current audiostart:" + audioStartLocation);
        logger.info(this.getLoggingFilename() + ":Size including padding:" + sizeIncPadding);
        logger.info(this.getLoggingFilename() + ":Padding:" + padding);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        if ((long)sizeIncPadding > audioStartLocation) {
            logger.info(this.getLoggingFilename() + ":Adjusting Padding");
            this.adjustPadding(file, sizeIncPadding, audioStartLocation);
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "rw").getChannel();
            fc.write(headerBuffer);
            fc.write(ByteBuffer.wrap(bodyByteBuffer));
            fc.write(ByteBuffer.wrap(new byte[padding]));
            Object var10_8 = null;
            if (fc == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fc == null) throw throwable;
            fc.close();
            throw throwable;
        }
        fc.close();
    }

    public void write(WritableByteChannel channel) throws IOException {
        logger.info(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() ? ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer) : false;
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(0, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.compression);
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.unsynchronization);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    public boolean isCompression() {
        return this.compression;
    }

    protected String getArtistId() {
        return "TP1";
    }

    protected String getAlbumId() {
        return "TAL";
    }

    protected String getTitleId() {
        return "TT2";
    }

    protected String getTrackId() {
        return "TRK";
    }

    protected String getYearId() {
        return "TYE";
    }

    protected String getCommentId() {
        return "COM";
    }

    protected String getGenreId() {
        return "TCO";
    }

    public ID3v22Frame createFrame(String id) {
        return new ID3v22Frame(id);
    }

    public TagField createTagField(ID3v22FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    public String getFirst(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doGetFirst(new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId()));
    }

    public void deleteTagField(ID3v22FieldKey id3v22FieldKey) throws KeyNotFoundException {
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId()));
    }

    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(TagFieldKey genericKey) {
        ID3v22FieldKey id3v22FieldKey = ID3v22Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v22FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return new AbstractID3v2Tag.FrameAndSubId(id3v22FieldKey.getFrameId(), id3v22FieldKey.getSubId());
    }

    protected ID3Frames getID3Frames() {
        return ID3v22Frames.getInstanceOf();
    }
}

