/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.HashMapInterface;
import org.jaudiotagger.tag.datatype.NumberFixedLength;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.ChannelTypes;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTimestampTypes;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTypes;
import org.jaudiotagger.tag.id3.valuepair.GenreTypes;
import org.jaudiotagger.tag.id3.valuepair.InterpolationTypes;
import org.jaudiotagger.tag.id3.valuepair.PictureTypes;
import org.jaudiotagger.tag.id3.valuepair.ReceivedAsTypes;
import org.jaudiotagger.tag.id3.valuepair.SynchronisedLyricsContentType;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class NumberHashMap
extends NumberFixedLength
implements HashMapInterface {
    private Map keyToValue = null;
    private Map valueToKey = null;
    private boolean hasEmptyValue = false;

    public NumberHashMap(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody, size);
        if (identifier.equals("Genre")) {
            this.valueToKey = GenreTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = GenreTypes.getInstanceOf().getIdToValueMap();
            this.hasEmptyValue = true;
        } else if (identifier.equals("TextEncoding")) {
            this.valueToKey = TextEncoding.getInstanceOf().getValueToIdMap();
            this.keyToValue = TextEncoding.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("InterpolationMethod")) {
            this.valueToKey = InterpolationTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = InterpolationTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("PictureType")) {
            this.valueToKey = PictureTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = PictureTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("TypeOfEvent")) {
            this.valueToKey = EventTimingTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("TimeStampFormat")) {
            this.valueToKey = EventTimingTimestampTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = EventTimingTimestampTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("TypeOfChannel")) {
            this.valueToKey = ChannelTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ChannelTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("RecievedAs")) {
            this.valueToKey = ReceivedAsTypes.getInstanceOf().getValueToIdMap();
            this.keyToValue = ReceivedAsTypes.getInstanceOf().getIdToValueMap();
        } else if (identifier.equals("contentType")) {
            this.valueToKey = SynchronisedLyricsContentType.getInstanceOf().getValueToIdMap();
            this.keyToValue = SynchronisedLyricsContentType.getInstanceOf().getIdToValueMap();
        } else {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
    }

    public NumberHashMap(NumberHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.keyToValue = copyObject.keyToValue;
        this.valueToKey = copyObject.valueToKey;
    }

    public Map getKeyToValue() {
        return this.keyToValue;
    }

    public Map getValueToKey() {
        return this.valueToKey;
    }

    public void setValue(Object value) {
        this.value = value instanceof Byte ? Long.valueOf(((Byte)value).byteValue()) : (value instanceof Short ? Long.valueOf(((Short)value).shortValue()) : (value instanceof Integer ? Long.valueOf(((Integer)value).intValue()) : value));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NumberHashMap)) {
            return false;
        }
        NumberHashMap object = (NumberHashMap)obj;
        if (this.hasEmptyValue != object.hasEmptyValue) {
            return false;
        }
        if (this.keyToValue == null ? object.keyToValue != null : !((Object)this.keyToValue).equals(object.keyToValue)) {
            return false;
        }
        if (this.valueToKey == null ? object.valueToKey != null : !((Object)this.valueToKey).equals(object.valueToKey)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        Integer intValue;
        super.readByteArray(arr, offset);
        if (!this.hasEmptyValue && !this.keyToValue.containsKey(intValue = Integer.valueOf(((Long)this.value).intValue()))) {
            throw new InvalidDataTypeException(this.getClass().getName() + ":No key could be found with the value of:" + intValue);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value).toString();
    }
}

