/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.ogg.OggVorbisCommentTagCreator;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggCRCFactory;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private OggVorbisCommentTagCreator tc = new OggVorbisCommentTagCreator();
    private OggVorbisTagReader reader = new OggVorbisTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotReadException, CannotWriteException {
        VorbisCommentTag tag = null;
        try {
            tag = (VorbisCommentTag)this.reader.read(raf);
        }
        catch (CannotReadException e) {
            this.write(new VorbisCommentTag(), raf, tempRaf);
            return;
        }
        VorbisCommentTag emptyTag = new VorbisCommentTag();
        emptyTag.setVendor(tag.getVendor());
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        logger.info("Starting to write file:");
        logger.fine("Read identificationHeader:");
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        raf.seek(0L);
        rafTemp.getChannel().transferFrom(raf.getChannel(), 0L, pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        rafTemp.skipBytes(pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        logger.fine("Written identificationHeader:");
        logger.fine("Read 2ndpage:");
        OggPageHeader secondPageHeader = OggPageHeader.read(raf);
        long secondPageHeaderEndPos = raf.getFilePointer();
        raf.seek(0L);
        OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes = this.reader.readOggVorbisHeaderSizes(raf);
        ByteBuffer newComment = this.tc.convert(tag);
        int newCommentLength = newComment.capacity();
        int setupHeaderLength = vorbisHeaderSizes.getSetupHeaderSize();
        int oldCommentLength = vorbisHeaderSizes.getCommentHeaderSize();
        int newSecondPageLength = setupHeaderLength + newCommentLength;
        logger.fine("Old Page size: " + secondPageHeader.getPageLength());
        logger.fine("Setup Header Size: " + setupHeaderLength);
        logger.fine("Old comment: " + oldCommentLength);
        logger.fine("New comment: " + newCommentLength);
        logger.fine("New Page Size: " + newSecondPageLength);
        if (this.isCommentAndSetupHeaderFitsOnASinglePage(newCommentLength, setupHeaderLength)) {
            if (secondPageHeader.getPageLength() < 65025 && secondPageHeader.getPacketList().size() == 2 && !secondPageHeader.isLastPacketIncomplete()) {
                logger.info("Header and Setup remain on single page:");
                this.replaceSecondPageOnly(oldCommentLength, setupHeaderLength, newCommentLength, newSecondPageLength, secondPageHeader, newComment, secondPageHeaderEndPos, raf, rafTemp);
            } else {
                logger.info("Header and Setup now on single page:");
                this.replaceSecondPageAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, newSecondPageLength, secondPageHeader, newComment, raf, rafTemp);
            }
        } else {
            logger.info("Header and Setup remain on multiple page:");
            this.replacePagesAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, secondPageHeader, newComment, raf, rafTemp);
        }
    }

    private void replaceSecondPageOnly(int oldCommentLength, int setupHeaderLength, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, long secondPageHeaderEndPos, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        byte[] segmentTable = this.createSegmentTable(newCommentLength, setupHeaderLength);
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.put((byte)segmentTable.length);
        for (int i = 0; i < segmentTable.length; ++i) {
            secondPageBuffer.put(segmentTable[i]);
        }
        secondPageBuffer.put(newComment);
        raf.seek(secondPageHeaderEndPos);
        raf.skipBytes(oldCommentLength);
        raf.getChannel().read(secondPageBuffer);
        secondPageBuffer.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(secondPageBuffer.array());
        for (int i = 0; i < crc.length; ++i) {
            secondPageBuffer.put(22 + i, crc[i]);
        }
        secondPageBuffer.rewind();
        rafTemp.getChannel().write(secondPageBuffer);
        rafTemp.getChannel().transferFrom(raf.getChannel(), rafTemp.getFilePointer(), raf.length() - raf.getFilePointer());
    }

    private void replaceSecondPageAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        byte[] segmentTable = this.createSegmentTable(newCommentLength, originalHeaderSizes.getSetupHeaderSize());
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put((byte)segmentTable.length);
        for (int i = 0; i < segmentTable.length; ++i) {
            secondPageBuffer.put(segmentTable[i]);
        }
        secondPageBuffer.put(newComment);
        int pageSequence = secondPageHeader.getPageSequence();
        byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacket(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
        logger.finest(setupHeaderData.length + ":" + secondPageBuffer.position() + ":" + secondPageBuffer.capacity());
        secondPageBuffer.put(setupHeaderData);
        secondPageBuffer.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(secondPageBuffer.array());
        for (int i = 0; i < crc.length; ++i) {
            secondPageBuffer.put(22 + i, crc[i]);
        }
        secondPageBuffer.rewind();
        rafTemp.getChannel().write(secondPageBuffer);
        long startAudio = raf.getFilePointer();
        logger.finest("About to read Audio starting from:" + startAudio);
        long startAudioWritten = rafTemp.getFilePointer();
        while (raf.getFilePointer() < raf.length()) {
            OggPageHeader nextPage = OggPageHeader.read(raf);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            raf.getChannel().read(nextPageHeaderBuffer);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            nextPageHeaderBuffer.putInt(22, 0);
            crc = OggCRCFactory.computeCRC(nextPageHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                nextPageHeaderBuffer.put(22 + i, crc[i]);
            }
            nextPageHeaderBuffer.rewind();
            rafTemp.getChannel().write(nextPageHeaderBuffer);
        }
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts dont match, file not written");
        }
    }

    private void replacePagesAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        byte[] segmentTable;
        int pageSequence = secondPageHeader.getPageSequence();
        int noOfPagesNeededForComment = newCommentLength / 65025;
        logger.info("Comment requires:" + noOfPagesNeededForComment + " complete pages");
        int newCommentOffset = 0;
        for (int i = 0; i < noOfPagesNeededForComment; ++i) {
            segmentTable = this.createSegments(65025, false);
            int pageHeaderLength = 27 + segmentTable.length;
            ByteBuffer pageBuffer = ByteBuffer.allocate(pageHeaderLength + 65025);
            pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer.put((byte)segmentTable.length);
            for (int j = 0; j < segmentTable.length; ++j) {
                pageBuffer.put(segmentTable[j]);
            }
            pageBuffer.put(newComment.array(), newCommentOffset, 65025);
            pageBuffer.putInt(18, pageSequence);
            ++pageSequence;
            if (i != 0) {
                pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            }
            pageBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(pageBuffer.array());
            for (int j = 0; j < crc.length; ++j) {
                pageBuffer.put(22 + j, crc[j]);
            }
            pageBuffer.rewind();
            rafTemp.getChannel().write(pageBuffer);
            newCommentOffset += 65025;
        }
        int lastPageCommentPacketSize = newCommentLength % 65025;
        logger.fine("Last comment packet size:" + lastPageCommentPacketSize);
        if (!this.isCommentAndSetupHeaderFitsOnASinglePage(lastPageCommentPacketSize, originalHeaderSizes.getSetupHeaderSize())) {
            int i;
            logger.fine("Spread over two pages");
            byte[] commentSegmentTable = this.createSegments(lastPageCommentPacketSize, true);
            int remainingSegmentSlots = 255 - commentSegmentTable.length;
            int firstHalfOfHeaderSize = remainingSegmentSlots * 255;
            byte[] firstHalfofSegmentHeaderTable = this.createSegments(firstHalfOfHeaderSize, false);
            byte[] segmentTable2 = this.createSegmentTable(lastPageCommentPacketSize, firstHalfOfHeaderSize);
            int lastCommentHeaderLength = 27 + commentSegmentTable.length + firstHalfofSegmentHeaderTable.length;
            ByteBuffer lastCommentHeaderBuffer = ByteBuffer.allocate(lastCommentHeaderLength + lastPageCommentPacketSize + firstHalfOfHeaderSize);
            lastCommentHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastCommentHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastCommentHeaderBuffer.put((byte)segmentTable2.length);
            for (int i2 = 0; i2 < segmentTable2.length; ++i2) {
                lastCommentHeaderBuffer.put(segmentTable2[i2]);
            }
            lastCommentHeaderBuffer.put(newComment.array(), newCommentOffset, lastPageCommentPacketSize);
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacket(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            logger.finest(setupHeaderData.length + ":" + lastCommentHeaderBuffer.position() + ":" + lastCommentHeaderBuffer.capacity());
            int copyAmount = setupHeaderData.length;
            if (setupHeaderData.length > lastCommentHeaderBuffer.remaining()) {
                copyAmount = lastCommentHeaderBuffer.remaining();
                logger.finest("Copying :" + copyAmount);
            }
            lastCommentHeaderBuffer.put(setupHeaderData, 0, copyAmount);
            lastCommentHeaderBuffer.putInt(18, pageSequence);
            lastCommentHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            ++pageSequence;
            lastCommentHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(lastCommentHeaderBuffer.array());
            for (int i3 = 0; i3 < crc.length; ++i3) {
                lastCommentHeaderBuffer.put(22 + i3, crc[i3]);
            }
            lastCommentHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastCommentHeaderBuffer);
            int secondHalfOfHeaderSize = originalHeaderSizes.getSetupHeaderSize() - firstHalfOfHeaderSize;
            segmentTable2 = this.createSegmentTable(secondHalfOfHeaderSize, 0);
            int lastSetupHeaderLength = 27 + segmentTable2.length;
            ByteBuffer lastSetupHeaderBuffer = ByteBuffer.allocate(lastSetupHeaderLength + secondHalfOfHeaderSize);
            lastSetupHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastSetupHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastSetupHeaderBuffer.put((byte)segmentTable2.length);
            for (i = 0; i < segmentTable2.length; ++i) {
                lastSetupHeaderBuffer.put(segmentTable2[i]);
            }
            logger.finest(setupHeaderData.length - copyAmount + ":" + lastSetupHeaderBuffer.position() + ":" + lastSetupHeaderBuffer.capacity());
            lastSetupHeaderBuffer.put(setupHeaderData, copyAmount, setupHeaderData.length - copyAmount);
            lastSetupHeaderBuffer.putInt(18, pageSequence);
            lastSetupHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            lastSetupHeaderBuffer.putInt(22, 0);
            crc = OggCRCFactory.computeCRC(lastSetupHeaderBuffer.array());
            for (i = 0; i < crc.length; ++i) {
                lastSetupHeaderBuffer.put(22 + i, crc[i]);
            }
            lastSetupHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastSetupHeaderBuffer);
        } else {
            logger.fine("Setupheader fits on comment page");
            segmentTable = this.createSegmentTable(lastPageCommentPacketSize, originalHeaderSizes.getSetupHeaderSize());
            int lastHeaderLength = 27 + segmentTable.length;
            ByteBuffer lastCommentHeaderBuffer = ByteBuffer.allocate(lastHeaderLength + lastPageCommentPacketSize + originalHeaderSizes.getSetupHeaderSize());
            lastCommentHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastCommentHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastCommentHeaderBuffer.put((byte)segmentTable.length);
            for (int i = 0; i < segmentTable.length; ++i) {
                lastCommentHeaderBuffer.put(segmentTable[i]);
            }
            lastCommentHeaderBuffer.put(newComment.array(), newCommentOffset, lastPageCommentPacketSize);
            raf.seek(originalHeaderSizes.getSetupHeaderStartPosition());
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacket(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            lastCommentHeaderBuffer.put(setupHeaderData);
            lastCommentHeaderBuffer.putInt(18, pageSequence);
            lastCommentHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            lastCommentHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(lastCommentHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                lastCommentHeaderBuffer.put(22 + i, crc[i]);
            }
            lastCommentHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastCommentHeaderBuffer);
        }
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        logger.fine("Writing audio, audio starts in original file at :" + startAudio + ":Written to:" + startAudioWritten);
        while (raf.getFilePointer() < raf.length()) {
            logger.fine("Reading Ogg Page");
            OggPageHeader nextPage = OggPageHeader.read(raf);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            raf.getChannel().read(nextPageHeaderBuffer);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            nextPageHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(nextPageHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                nextPageHeaderBuffer.put(22 + i, crc[i]);
            }
            nextPageHeaderBuffer.rewind();
            rafTemp.getChannel().write(nextPageHeaderBuffer);
        }
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts dont macth, file not written");
        }
    }

    private byte[] createSegmentTable(int newCommentLength, int setupHeaderLength) {
        if (setupHeaderLength == 0) {
            byte[] newStart = this.createSegments(newCommentLength, false);
            return newStart;
        }
        byte[] newStart = this.createSegments(newCommentLength, true);
        byte[] restShouldBe = this.createSegments(setupHeaderLength, false);
        byte[] result = new byte[newStart.length + restShouldBe.length];
        System.arraycopy(newStart, 0, result, 0, newStart.length);
        System.arraycopy(restShouldBe, 0, result, newStart.length, restShouldBe.length);
        return result;
    }

    private byte[] createSegments(int length, boolean quitStream) {
        int i;
        byte[] result = new byte[length / 255 + (length % 255 == 0 && !quitStream ? 0 : 1)];
        for (i = 0; i < result.length - 1; ++i) {
            result[i] = -1;
        }
        result[result.length - 1] = (byte)(length - i * 255);
        return result;
    }

    private boolean isCommentAndSetupHeaderFitsOnASinglePage(int commentLength, int setupHeaderLength) {
        int additionalZeroLacingRequiredForComment = 0;
        int additionalZeroLacingRequiredForHeader = 0;
        if (commentLength % 255 == 0) {
            additionalZeroLacingRequiredForComment = 1;
        }
        if (setupHeaderLength % 255 == 0) {
            additionalZeroLacingRequiredForHeader = 1;
        }
        return commentLength / 255 + setupHeaderLength / 255 + additionalZeroLacingRequiredForComment + additionalZeroLacingRequiredForHeader <= 255;
    }
}

